/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.ShouldNeverHappenException;
import org.apache.parquet.conf.HadoopParquetConfiguration;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.parquet.thrift.ConvertedField;
import org.apache.parquet.thrift.KeepOnlyFirstPrimitiveFilter;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;

class ThriftSchemaConvertVisitor
implements ThriftType.StateVisitor<ConvertedField, State> {
    private final FieldProjectionFilter fieldProjectionFilter;
    private final boolean doProjection;
    private final boolean keepOneOfEachUnion;
    private final boolean writeThreeLevelList;

    private ThriftSchemaConvertVisitor(FieldProjectionFilter fieldProjectionFilter, boolean doProjection, boolean keepOneOfEachUnion, Configuration configuration) {
        this(fieldProjectionFilter, doProjection, keepOneOfEachUnion, (ParquetConfiguration)new HadoopParquetConfiguration(configuration));
    }

    private ThriftSchemaConvertVisitor(FieldProjectionFilter fieldProjectionFilter, boolean doProjection, boolean keepOneOfEachUnion, ParquetConfiguration configuration) {
        this.fieldProjectionFilter = Objects.requireNonNull(fieldProjectionFilter, "fieldProjectionFilter cannot be null");
        this.doProjection = doProjection;
        this.keepOneOfEachUnion = keepOneOfEachUnion;
        this.writeThreeLevelList = configuration != null ? configuration.getBoolean("parquet.thrift.write-three-level-lists", false) : false;
    }

    private ThriftSchemaConvertVisitor(FieldProjectionFilter fieldProjectionFilter, boolean doProjection, boolean keepOneOfEachUnion) {
        this(fieldProjectionFilter, doProjection, keepOneOfEachUnion, new Configuration());
    }

    @Deprecated
    public static MessageType convert(ThriftType.StructType struct, FieldProjectionFilter filter) {
        return ThriftSchemaConvertVisitor.convert(struct, filter, true, new Configuration());
    }

    public static MessageType convert(ThriftType.StructType struct, FieldProjectionFilter filter, boolean keepOneOfEachUnion, Configuration conf) {
        return ThriftSchemaConvertVisitor.convert(struct, filter, keepOneOfEachUnion, (ParquetConfiguration)new HadoopParquetConfiguration(conf));
    }

    public static MessageType convert(ThriftType.StructType struct, FieldProjectionFilter filter, boolean keepOneOfEachUnion, ParquetConfiguration conf) {
        State state = new State(new FieldsPath(), Type.Repetition.REPEATED, "ParquetSchema");
        ConvertedField converted = struct.accept(new ThriftSchemaConvertVisitor(filter, true, keepOneOfEachUnion, conf), state);
        if (!converted.isKeep()) {
            throw new ThriftProjectionException("No columns have been selected");
        }
        return new MessageType(state.name, converted.asKeep().getType().asGroupType().getFields());
    }

    @Deprecated
    public FieldProjectionFilter getFieldProjectionFilter() {
        return this.fieldProjectionFilter;
    }

    @Override
    public ConvertedField visit(ThriftType.MapType mapType, State state) {
        ConvertedField fullConvKey;
        ThriftField keyField = mapType.getKey();
        ThriftField valueField = mapType.getValue();
        State keyState = new State(state.path.push(keyField), Type.Repetition.REQUIRED, "key");
        State valueState = new State(state.path.push(valueField), Type.Repetition.OPTIONAL, "value");
        ConvertedField convertedKey = keyField.getType().accept(this, keyState);
        ConvertedField convertedValue = valueField.getType().accept(this, valueState);
        if (!convertedKey.isKeep()) {
            if (convertedValue.isKeep()) {
                throw new ThriftProjectionException("Cannot select only the values of a map, you must keep the keys as well: " + state.path);
            }
            return new ConvertedField.Drop(state.path);
        }
        if (this.doProjection && !(fullConvKey = keyField.getType().accept(new ThriftSchemaConvertVisitor(FieldProjectionFilter.ALL_COLUMNS, false, this.keepOneOfEachUnion), keyState)).asKeep().getType().equals((Object)convertedKey.asKeep().getType())) {
            throw new ThriftProjectionException("Cannot select only a subset of the fields in a map key, for path " + state.path);
        }
        if (convertedValue.isKeep()) {
            GroupType mapField = ConversionPatterns.mapType((Type.Repetition)state.repetition, (String)state.name, (Type)convertedKey.asKeep().getType(), (Type)convertedValue.asKeep().getType());
            return new ConvertedField.Keep(state.path, (Type)mapField);
        }
        ConvertedField sentinelValue = valueField.getType().accept(new ThriftSchemaConvertVisitor(new KeepOnlyFirstPrimitiveFilter(), true, this.keepOneOfEachUnion), valueState);
        GroupType mapField = ConversionPatterns.mapType((Type.Repetition)state.repetition, (String)state.name, (Type)convertedKey.asKeep().getType(), (Type)sentinelValue.asKeep().getType());
        return new ConvertedField.Keep(state.path, (Type)mapField);
    }

    private ConvertedField visitListLike(ThriftField listLike, State state, boolean isSet) {
        State childState = this.writeThreeLevelList ? new State(state.path, Type.Repetition.REQUIRED, "element") : new State(state.path, Type.Repetition.REPEATED, state.name + "_tuple");
        ConvertedField converted = listLike.getType().accept(this, childState);
        if (converted.isKeep()) {
            if (isSet && this.doProjection) {
                ConvertedField fullConv = listLike.getType().accept(new ThriftSchemaConvertVisitor(FieldProjectionFilter.ALL_COLUMNS, false, this.keepOneOfEachUnion), childState);
                if (!converted.asKeep().getType().equals((Object)fullConv.asKeep().getType())) {
                    throw new ThriftProjectionException("Cannot select only a subset of the fields in a set, for path " + state.path);
                }
            }
            if (this.writeThreeLevelList) {
                return new ConvertedField.Keep(state.path, (Type)ConversionPatterns.listOfElements((Type.Repetition)state.repetition, (String)state.name, (Type)converted.asKeep().getType()));
            }
            return new ConvertedField.Keep(state.path, (Type)ConversionPatterns.listType((Type.Repetition)state.repetition, (String)state.name, (Type)converted.asKeep().getType()));
        }
        return new ConvertedField.Drop(state.path);
    }

    @Override
    public ConvertedField visit(ThriftType.SetType setType, State state) {
        return this.visitListLike(setType.getValues(), state, true);
    }

    @Override
    public ConvertedField visit(ThriftType.ListType listType, State state) {
        return this.visitListLike(listType.getValues(), state, false);
    }

    @Override
    public ConvertedField visit(ThriftType.StructType structType, State state) {
        boolean needsToKeepOneOfEachUnion = this.keepOneOfEachUnion && ThriftSchemaConvertVisitor.isUnion(structType.getStructOrUnionType());
        boolean hasSentinelUnionColumns = false;
        boolean hasNonSentinelUnionColumns = false;
        ArrayList<Type> convertedChildren = new ArrayList<Type>();
        for (ThriftField child : structType.getChildren()) {
            State childState = new State(state.path.push(child), this.getRepetition(child), child.getName());
            ConvertedField converted = child.getType().accept(this, childState);
            if (!converted.isKeep() && needsToKeepOneOfEachUnion) {
                ConvertedField firstPrimitive = child.getType().accept(new ThriftSchemaConvertVisitor(new KeepOnlyFirstPrimitiveFilter(), true, this.keepOneOfEachUnion), childState);
                convertedChildren.add(firstPrimitive.asKeep().getType().withId((int)child.getFieldId()));
                hasSentinelUnionColumns = true;
            }
            if (converted.isSentinelUnion()) {
                if (childState.repetition != Type.Repetition.REQUIRED) continue;
                convertedChildren.add(converted.asSentinelUnion().getType().withId((int)child.getFieldId()));
                hasSentinelUnionColumns = true;
                continue;
            }
            if (!converted.isKeep()) continue;
            convertedChildren.add(converted.asKeep().getType().withId((int)child.getFieldId()));
            hasNonSentinelUnionColumns = true;
        }
        if (!hasNonSentinelUnionColumns && hasSentinelUnionColumns) {
            return new ConvertedField.SentinelUnion(state.path, (Type)new GroupType(state.repetition, state.name, convertedChildren));
        }
        if (hasNonSentinelUnionColumns) {
            return new ConvertedField.Keep(state.path, (Type)new GroupType(state.repetition, state.name, convertedChildren));
        }
        return new ConvertedField.Drop(state.path);
    }

    private ConvertedField visitPrimitiveType(PrimitiveType.PrimitiveTypeName type, State state) {
        return this.visitPrimitiveType(type, null, state);
    }

    private ConvertedField visitPrimitiveType(PrimitiveType.PrimitiveTypeName type, LogicalTypeAnnotation orig, State state) {
        Types.PrimitiveBuilder b = Types.primitive((PrimitiveType.PrimitiveTypeName)type, (Type.Repetition)state.repetition);
        if (orig != null) {
            b = (Types.PrimitiveBuilder)b.as(orig);
        }
        if (this.fieldProjectionFilter.keep(state.path)) {
            return new ConvertedField.Keep(state.path, (Type)b.named(state.name));
        }
        return new ConvertedField.Drop(state.path);
    }

    @Override
    public ConvertedField visit(ThriftType.EnumType enumType, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.enumType(), state);
    }

    @Override
    public ConvertedField visit(ThriftType.BoolType boolType, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.BOOLEAN, state);
    }

    @Override
    public ConvertedField visit(ThriftType.ByteType byteType, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true), state);
    }

    @Override
    public ConvertedField visit(ThriftType.DoubleType doubleType, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.DOUBLE, state);
    }

    @Override
    public ConvertedField visit(ThriftType.I16Type i16Type, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT32, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true), state);
    }

    @Override
    public ConvertedField visit(ThriftType.I32Type i32Type, State state) {
        return i32Type.hasLogicalTypeAnnotation() ? this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT32, i32Type.getLogicalTypeAnnotation(), state) : this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT32, state);
    }

    @Override
    public ConvertedField visit(ThriftType.I64Type i64Type, State state) {
        return i64Type.hasLogicalTypeAnnotation() ? this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT64, i64Type.getLogicalTypeAnnotation(), state) : this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.INT64, state);
    }

    @Override
    public ConvertedField visit(ThriftType.StringType stringType, State state) {
        if (stringType.isBinary()) {
            return stringType.hasLogicalTypeAnnotation() ? this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.BINARY, stringType.getLogicalTypeAnnotation(), state) : this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.BINARY, state);
        }
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.BINARY, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType(), state);
    }

    @Override
    public ConvertedField visit(ThriftType.UUIDType uuidType, State state) {
        return this.visitPrimitiveType(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType(), state);
    }

    private static boolean isUnion(ThriftType.StructType.StructOrUnionType s) {
        switch (s) {
            case STRUCT: {
                return false;
            }
            case UNION: {
                return true;
            }
            case UNKNOWN: {
                throw new ShouldNeverHappenException("Encountered UNKNOWN StructOrUnionType");
            }
        }
        throw new ShouldNeverHappenException("Unrecognized type: " + (Object)((Object)s));
    }

    private Type.Repetition getRepetition(ThriftField thriftField) {
        switch (thriftField.getRequirement()) {
            case REQUIRED: {
                return Type.Repetition.REQUIRED;
            }
            case OPTIONAL: {
                return Type.Repetition.OPTIONAL;
            }
            case DEFAULT: {
                return Type.Repetition.OPTIONAL;
            }
        }
        throw new IllegalArgumentException("unknown requirement type: " + (Object)((Object)thriftField.getRequirement()));
    }

    public static final class State {
        public final FieldsPath path;
        public final Type.Repetition repetition;
        public final String name;

        public State(FieldsPath path, Type.Repetition repetition, String name) {
            this.path = path;
            this.repetition = repetition;
            this.name = name;
        }
    }
}

