/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection;

import java.util.ArrayList;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;

public class FieldsPath {
    private final ArrayList<ThriftField> fields;

    public FieldsPath() {
        this(new ArrayList<ThriftField>());
    }

    private FieldsPath(ArrayList<ThriftField> fields) {
        this.fields = fields;
    }

    public FieldsPath push(ThriftField f) {
        ArrayList<ThriftField> copy = new ArrayList<ThriftField>(this.fields);
        copy.add(f);
        return new FieldsPath(copy);
    }

    public String toDelimitedString(String delim) {
        StringBuilder delimited = new StringBuilder();
        for (int i = 0; i < this.fields.size(); ++i) {
            ThriftField currentField = this.fields.get(i);
            if (i > 0) {
                ThriftField previousField = this.fields.get(i - 1);
                if (FieldsPath.isKeyFieldOfMap(currentField, previousField)) {
                    delimited.append("key");
                    delimited.append(delim);
                    continue;
                }
                if (FieldsPath.isValueFieldOfMap(currentField, previousField)) {
                    delimited.append("value");
                    delimited.append(delim);
                    continue;
                }
            }
            delimited.append(currentField.getName()).append(delim);
        }
        if (delimited.length() == 0) {
            return "";
        }
        return delimited.substring(0, delimited.length() - 1);
    }

    public String toString() {
        return this.toDelimitedString(".");
    }

    private static boolean isValueFieldOfMap(ThriftField currentField, ThriftField previousField) {
        ThriftType previousType = previousField.getType();
        return previousType instanceof ThriftType.MapType && ((ThriftType.MapType)previousType).getValue() == currentField;
    }

    private static boolean isKeyFieldOfMap(ThriftField currentField, ThriftField previousField) {
        ThriftType previousType = previousField.getType();
        return previousType instanceof ThriftType.MapType && ((ThriftType.MapType)previousType).getKey() == currentField;
    }
}

