/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.Log;
import org.apache.parquet.Strings;
import org.apache.parquet.glob.WildcardPath;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.projection.ThriftProjectionException;

public class StrictFieldProjectionFilter
implements FieldProjectionFilter {
    private static final Log LOG = Log.getLog(FieldProjectionFilter.class);
    private static final String GLOB_SEPARATOR = ";";
    private final List<WildcardPathStatus> columnsToKeep = new ArrayList<WildcardPathStatus>();

    static List<String> parseSemicolonDelimitedString(String columnsToKeepGlobs) {
        String[] splits = columnsToKeepGlobs.split(GLOB_SEPARATOR);
        ArrayList<String> globs = new ArrayList<String>();
        for (String s : splits) {
            if (s.isEmpty()) continue;
            globs.add(s);
        }
        if (globs.isEmpty()) {
            throw new ThriftProjectionException(String.format("Semicolon delimited string '%s' contains 0 glob strings", columnsToKeepGlobs));
        }
        return globs;
    }

    public static StrictFieldProjectionFilter fromSemicolonDelimitedString(String columnsToKeepGlobs) {
        return new StrictFieldProjectionFilter(StrictFieldProjectionFilter.parseSemicolonDelimitedString(columnsToKeepGlobs));
    }

    public StrictFieldProjectionFilter(List<String> columnsToKeepGlobs) {
        for (String glob : columnsToKeepGlobs) {
            for (WildcardPath wp : Strings.expandGlobToWildCardPaths((String)glob, (char)'.')) {
                this.columnsToKeep.add(new WildcardPathStatus(wp));
            }
        }
    }

    @Override
    public boolean keep(FieldsPath path) {
        return this.keep(path.toDelimitedString("."));
    }

    boolean keep(String path) {
        WildcardPath match = null;
        for (WildcardPathStatus wp : this.columnsToKeep) {
            if (!wp.matches(path)) continue;
            if (match != null && !match.getParentGlobPath().equals(wp.getWildcardPath().getParentGlobPath())) {
                String message = "Field path: '%s' matched more than one glob path pattern. First match: '%s' (when expanded to '%s') second match:'%s' (when expanded to '%s')";
                this.warn(String.format(message, path, match.getParentGlobPath(), match.getOriginalPattern(), wp.getWildcardPath().getParentGlobPath(), wp.getWildcardPath().getOriginalPattern()));
                continue;
            }
            match = wp.getWildcardPath();
        }
        return match != null;
    }

    protected void warn(String warning) {
        LOG.warn((Object)warning);
    }

    private List<WildcardPath> getUnmatchedPatterns() {
        ArrayList<WildcardPath> unmatched = new ArrayList<WildcardPath>();
        for (WildcardPathStatus wp : this.columnsToKeep) {
            if (wp.hasMatched()) continue;
            unmatched.add(wp.getWildcardPath());
        }
        return unmatched;
    }

    @Override
    public void assertNoUnmatchedPatterns() throws ThriftProjectionException {
        List<WildcardPath> unmatched = this.getUnmatchedPatterns();
        if (!unmatched.isEmpty()) {
            StringBuilder message = new StringBuilder("The following projection patterns did not match any columns in this schema:\n");
            for (WildcardPath wp : unmatched) {
                message.append(String.format("Pattern: '%s' (when expanded to '%s')", wp.getParentGlobPath(), wp.getOriginalPattern()));
                message.append('\n');
            }
            throw new ThriftProjectionException(message.toString());
        }
    }

    public static final class WildcardPathStatus {
        private final WildcardPath wildcardPath;
        private boolean hasMatched;

        public WildcardPathStatus(WildcardPath wildcardPath) {
            this.wildcardPath = wildcardPath;
            this.hasMatched = false;
        }

        public boolean matches(String path) {
            boolean matches = this.wildcardPath.matches(path);
            this.hasMatched = this.hasMatched || matches;
            return matches;
        }

        public WildcardPath getWildcardPath() {
            return this.wildcardPath;
        }

        public boolean hasMatched() {
            return this.hasMatched;
        }
    }
}

