/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection.deprecated;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.fs.GlobPattern;

@Deprecated
public class PathGlobPattern {
    private static final char BACKSLASH = '\\';
    private static final char PATH_SEPARATOR = '/';
    private Pattern compiled;
    private boolean hasWildcard = false;

    public PathGlobPattern(String globPattern) {
        this.set(globPattern);
    }

    public static Pattern compile(String globPattern) {
        return new GlobPattern(globPattern).compiled();
    }

    private static void error(String message, String pattern, int pos) {
        throw new PatternSyntaxException(message, pattern, pos);
    }

    public Pattern compiled() {
        return this.compiled;
    }

    public boolean matches(CharSequence s) {
        return this.compiled.matcher(s).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(String glob) {
        StringBuilder regex = new StringBuilder();
        int setOpen = 0;
        int curlyOpen = 0;
        int len = glob.length();
        this.hasWildcard = false;
        block13: for (int i = 0; i < len; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= len) {
                        PathGlobPattern.error("Missing escaped character", glob, i);
                    }
                    regex.append(c).append(glob.charAt(i));
                    continue block13;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '|': {
                    regex.append('\\');
                    break;
                }
                case '*': {
                    if (i + 1 < len && glob.charAt(i + 1) == '*') {
                        regex.append('.');
                        ++i;
                        break;
                    }
                    regex.append("[^/]");
                    this.hasWildcard = true;
                    break;
                }
                case '?': {
                    regex.append('.');
                    this.hasWildcard = true;
                    continue block13;
                }
                case '{': {
                    regex.append("(?:");
                    ++curlyOpen;
                    this.hasWildcard = true;
                    continue block13;
                }
                case ',': {
                    regex.append(curlyOpen > 0 ? (char)'|' : (char)c);
                    continue block13;
                }
                case '}': {
                    if (curlyOpen <= 0) break;
                    --curlyOpen;
                    regex.append(")");
                    continue block13;
                }
                case '[': {
                    if (setOpen > 0) {
                        PathGlobPattern.error("Unclosed character class", glob, i);
                    }
                    ++setOpen;
                    this.hasWildcard = true;
                    break;
                }
                case '^': {
                    if (setOpen != 0) break;
                    regex.append('\\');
                    break;
                }
                case '!': {
                    regex.append((char)(setOpen > 0 && '[' == glob.charAt(i - 1) ? 94 : 33));
                    continue block13;
                }
                case ']': {
                    setOpen = 0;
                }
            }
            regex.append(c);
        }
        if (setOpen > 0) {
            PathGlobPattern.error("Unclosed character class", glob, len);
        }
        if (curlyOpen > 0) {
            PathGlobPattern.error("Unclosed group", glob, len);
        }
        this.compiled = Pattern.compile(regex.toString());
    }

    public String toString() {
        return this.compiled.toString();
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }
}

