/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.struct;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.CompatibilityChecker;
import org.apache.parquet.thrift.struct.CompatibilityReport;
import org.apache.parquet.thrift.struct.ThriftType;
import shaded.parquet.org.codehaus.jackson.map.ObjectMapper;

public class CompatibilityRunner {
    public static void main(String[] args) throws Exception {
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(args));
        String operator = arguments.pollFirst();
        if (operator.equals("generate-json")) {
            CompatibilityRunner.generateJson(arguments);
        }
        if (operator.equals("compare-json")) {
            CompatibilityRunner.compareJson(arguments);
        }
    }

    private static void compareJson(LinkedList<String> arguments) throws IOException {
        String oldJsonPath = arguments.pollFirst();
        String newJsonPath = arguments.pollFirst();
        File oldJsonFile = new File(oldJsonPath);
        CompatibilityRunner.checkExist(oldJsonFile);
        File newJsonFile = new File(newJsonPath);
        CompatibilityRunner.checkExist(newJsonFile);
        ObjectMapper mapper = new ObjectMapper();
        ThriftType.StructType oldStruct = (ThriftType.StructType)mapper.readValue(oldJsonFile, ThriftType.StructType.class);
        ThriftType.StructType newStruct = (ThriftType.StructType)mapper.readValue(newJsonFile, ThriftType.StructType.class);
        CompatibilityReport report = new CompatibilityChecker().checkCompatibility(oldStruct, newStruct);
        if (!report.isCompatible) {
            System.err.println("schema not compatible");
            System.err.println(report.getMessages());
            System.exit(1);
        }
        if (report.hasEmptyStruct()) {
            System.err.println("schema contains empty struct");
            System.err.println(report.getMessages());
            System.exit(1);
        }
        System.out.println("[success] schema is compatible");
    }

    private static void checkExist(File f) {
        if (!f.exists()) {
            throw new RuntimeException("can not find file " + f);
        }
    }

    private static void generateJson(LinkedList<String> arguments) throws ClassNotFoundException, IOException {
        String catName = arguments.pollFirst();
        String className = arguments.pollFirst();
        String storedPath = arguments.pollFirst();
        File storeDir = new File(storedPath);
        ThriftType.StructType structType = ThriftSchemaConverter.toStructType(Class.forName(className));
        ObjectMapper mapper = new ObjectMapper();
        String fileName = catName + ".json";
        mapper.writerWithDefaultPrettyPrinter().writeValue(new File(storeDir, fileName), (Object)structType);
    }
}

