/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.parquet.tools.command.Command;
import org.apache.parquet.tools.command.Registry;

public class Main {
    public static final Options OPTIONS = new Options();
    public static PrintStream out;
    public static PrintStream err;
    private static final int WIDTH = 80;
    private static final int LEFT_PAD = 4;
    private static final int DESC_PAD = 2;

    public static void mergeOptionsInto(Options opt, Options opts) {
        if (opts == null) {
            return;
        }
        Collection<Option> all = opts.getOptions();
        if (all != null && !all.isEmpty()) {
            for (Option o : all) {
                opt.addOption(o);
            }
        }
    }

    public static Options mergeOptions(Options opt, Options ... opts) {
        Options results = new Options();
        Main.mergeOptionsInto(results, opt);
        for (Options o : opts) {
            Main.mergeOptionsInto(results, o);
        }
        return results;
    }

    public static void showUsage(HelpFormatter format, PrintWriter err, String name, Command command) {
        Options options = Main.mergeOptions(OPTIONS, command.getOptions());
        String[] usage = command.getUsageDescription();
        String ustr = name + " [option...]";
        if (usage != null && usage.length >= 1) {
            ustr = ustr + " " + usage[0];
        }
        format.printWrapped(err, 80, name + ":\n" + command.getCommandDescription());
        format.printUsage(err, 80, ustr);
        format.printWrapped(err, 80, 4, "where option is one of:");
        format.printOptions(err, 80, options, 4, 2);
        if (usage != null && usage.length >= 2) {
            for (int i = 1; i < usage.length; ++i) {
                format.printWrapped(err, 80, 4, usage[i]);
            }
        }
    }

    public static void showUsage(String name, Command command) {
        HelpFormatter format = new HelpFormatter();
        PrintWriter err = new PrintWriter(Main.err, true);
        Options options = command.getOptions();
        Main.showUsage(format, err, "parquet-" + name, command);
    }

    public static void showUsage() {
        HelpFormatter format = new HelpFormatter();
        PrintWriter err = new PrintWriter(Main.err, true);
        Map<String, Command> all = Registry.allCommands();
        boolean first = true;
        for (Map.Entry<String, Command> entry : all.entrySet()) {
            String name = entry.getKey();
            Command command = entry.getValue();
            if (!first) {
                err.println();
            }
            first = false;
            Main.showUsage(format, err, "parquet-tools " + name, command);
        }
    }

    public static void die(String message, boolean usage) {
        Main.die(message, usage, null, null);
    }

    public static void die(Throwable th, boolean usage) {
        Main.die(th, usage, null, null);
    }

    public static void die(String message, boolean usage, String name, Command command) {
        if (message != null) {
            err.println(message);
            err.println();
        }
        if (usage) {
            if (name == null && command == null) {
                Main.showUsage();
            } else {
                Main.showUsage(name, command);
            }
        }
        System.exit(1);
    }

    public static void die(Throwable th, boolean usage, String name, Command command) {
        Main.die(th.toString(), usage, name, command);
    }

    public static void main(String[] args) {
        Command command;
        String name;
        out = System.out;
        err = System.err;
        PrintStream VoidStream = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        System.setOut(VoidStream);
        System.setErr(VoidStream);
        if (args.length == 0) {
            Main.die("No command specified", true, null, null);
        }
        if ("-h".equals(name = args[0]) || "--help".equals(name)) {
            Main.showUsage();
            System.exit(0);
        }
        if ((command = Registry.getCommandByName(name)) == null) {
            Main.die("Unknown command: " + name, true, null, null);
        }
        boolean debug = false;
        try {
            String[] cargs = Arrays.copyOfRange(args, 1, args.length);
            Options opts = Main.mergeOptions(OPTIONS, command.getOptions());
            boolean extra = command.supportsExtraArgs();
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(opts == null ? new Options() : opts, cargs, extra);
            if (cmd.hasOption('h')) {
                Main.showUsage(name, command);
                System.exit(0);
            }
            if (cmd.hasOption("no-color")) {
                System.setProperty("DISABLE_COLORS", "true");
            }
            debug = cmd.hasOption("debug");
            command.execute(cmd);
        }
        catch (ParseException ex) {
            if (debug) {
                ex.printStackTrace(err);
            }
            Main.die("Invalid arguments: " + ex.getMessage(), true, name, command);
        }
        catch (Throwable th) {
            if (debug) {
                th.printStackTrace(err);
            }
            Main.die(th, false, name, command);
        }
    }

    static {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Show this help string");
        Option help = OptionBuilder.create('h');
        OptionBuilder.withLongOpt("no-color");
        OptionBuilder.withDescription("Disable color output even if supported");
        Option ncol = OptionBuilder.create();
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Enable debug output");
        Option debg = OptionBuilder.create();
        OPTIONS.addOption(help);
        OPTIONS.addOption(ncol);
        OPTIONS.addOption(debg);
    }
}

