/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.tools.Main;
import org.apache.parquet.tools.command.ArgsOnlyCommand;
import org.apache.parquet.tools.json.JsonRecordFormatter;
import org.apache.parquet.tools.read.SimpleReadSupport;
import org.apache.parquet.tools.read.SimpleRecord;

public class CatCommand
extends ArgsOnlyCommand {
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to print to stdout"};
    public static final Options OPTIONS = new Options();

    public CatCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Prints the content of a Parquet file. The output contains only the data, no metadata is displayed";
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        ParquetReader<SimpleRecord> reader = null;
        try {
            PrintWriter writer = new PrintWriter(Main.out, true);
            reader = ParquetReader.builder(new SimpleReadSupport(), new Path(input)).build();
            ParquetMetadata metadata = ParquetFileReader.readFooter(new Configuration(), new Path(input));
            JsonRecordFormatter.JsonGroupFormatter formatter = JsonRecordFormatter.fromSchema(metadata.getFileMetaData().getSchema());
            SimpleRecord value = reader.read();
            while (value != null) {
                if (options.hasOption('j')) {
                    writer.write(formatter.formatRecord(value));
                } else {
                    value.prettyPrint(writer);
                }
                writer.println();
                value = reader.read();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        OptionBuilder.withLongOpt("json");
        OptionBuilder.withDescription("Show records in JSON format.");
        Option help = OptionBuilder.create('j');
        OPTIONS.addOption(help);
    }
}

