/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.tools.util.PrettyPrintWriter;

class MetadataUtils {
    MetadataUtils() {
    }

    static void showDetails(PrettyPrintWriter out, ParquetMetadata meta, boolean showOriginalTypes) {
        MetadataUtils.showDetails(out, meta.getFileMetaData(), showOriginalTypes);
        long i = 1L;
        for (BlockMetaData bmeta : meta.getBlocks()) {
            out.println();
            MetadataUtils.showDetails(out, bmeta, i++);
        }
    }

    static void showDetails(PrettyPrintWriter out, FileMetaData meta, boolean showOriginalTypes) {
        out.format("creator: %s%n", meta.getCreatedBy());
        Map<String, String> extra = meta.getKeyValueMetaData();
        if (extra != null) {
            for (Map.Entry<String, String> entry : meta.getKeyValueMetaData().entrySet()) {
                out.print("extra: ");
                out.incrementTabLevel();
                out.format("%s = %s%n", entry.getKey(), entry.getValue());
                out.decrementTabLevel();
            }
        }
        out.println();
        out.format("file schema: %s%n", meta.getSchema().getName());
        out.rule('-');
        MetadataUtils.showDetails(out, meta.getSchema(), showOriginalTypes);
    }

    private static void showDetails(PrettyPrintWriter out, BlockMetaData meta, Long num) {
        long rows = meta.getRowCount();
        long tbs = meta.getTotalByteSize();
        long offset = meta.getStartingPos();
        out.format("row group%s: RC:%d TS:%d OFFSET:%d%n", num == null ? "" : " " + num, rows, tbs, offset);
        out.rule('-');
        MetadataUtils.showDetails(out, meta.getColumns());
    }

    static void showDetails(PrettyPrintWriter out, List<ColumnChunkMetaData> ccmeta) {
        LinkedHashMap<String, Object> chunks = new LinkedHashMap<String, Object>();
        for (ColumnChunkMetaData cmeta : ccmeta) {
            String[] path = cmeta.getPath().toArray();
            Map<String, Object> current = chunks;
            for (int i = 0; i < path.length - 1; ++i) {
                String next = path[i];
                if (!current.containsKey(next)) {
                    current.put(next, new LinkedHashMap());
                }
                current = (Map)current.get(next);
            }
            current.put(path[path.length - 1], cmeta);
        }
        MetadataUtils.showColumnChunkDetails(out, chunks, 0);
    }

    private static void showColumnChunkDetails(PrettyPrintWriter out, Map<String, Object> current, int depth) {
        for (Map.Entry<String, Object> entry : current.entrySet()) {
            String name = Strings.repeat(".", depth) + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                out.println(name + ": ");
                MetadataUtils.showColumnChunkDetails(out, (Map)value, depth + 1);
                continue;
            }
            out.print(name + ": ");
            MetadataUtils.showDetails(out, (ColumnChunkMetaData)value, false);
        }
    }

    private static void showDetails(PrettyPrintWriter out, ColumnChunkMetaData meta, boolean name) {
        Statistics stats;
        long doff = meta.getDictionaryPageOffset();
        long foff = meta.getFirstDataPageOffset();
        long tsize = meta.getTotalSize();
        long usize = meta.getTotalUncompressedSize();
        long count = meta.getValueCount();
        double ratio = (double)usize / (double)tsize;
        String encodings = Joiner.on(',').skipNulls().join(meta.getEncodings());
        if (name) {
            String path = Joiner.on('.').skipNulls().join(meta.getPath());
            out.format("%s: ", path);
        }
        out.format(" %s", new Object[]{meta.getType()});
        out.format(" %s", new Object[]{meta.getCodec()});
        out.format(" DO:%d", doff);
        out.format(" FPO:%d", foff);
        out.format(" SZ:%d/%d/%.2f", tsize, usize, ratio);
        out.format(" VC:%d", count);
        if (!encodings.isEmpty()) {
            out.format(" ENC:%s", encodings);
        }
        if ((stats = meta.getStatistics()) != null) {
            out.format(" ST:[%s]", stats);
        } else {
            out.format(" ST:[none]", new Object[0]);
        }
        out.println();
    }

    static void showDetails(PrettyPrintWriter out, MessageType type, boolean showOriginalTypes) {
        ArrayList<String> cpath = new ArrayList<String>();
        for (Type ftype : type.getFields()) {
            MetadataUtils.showDetails(out, ftype, 0, type, cpath, showOriginalTypes);
        }
    }

    private static void showDetails(PrettyPrintWriter out, GroupType type, int depth, MessageType container, List<String> cpath, boolean showOriginalTypes) {
        String name = Strings.repeat(".", depth) + type.getName();
        Type.Repetition rep = type.getRepetition();
        int fcount = type.getFieldCount();
        out.format("%s: %s F:%d%n", new Object[]{name, rep, fcount});
        cpath.add(type.getName());
        for (Type ftype : type.getFields()) {
            MetadataUtils.showDetails(out, ftype, depth + 1, container, cpath, showOriginalTypes);
        }
        cpath.remove(cpath.size() - 1);
    }

    private static void showDetails(PrettyPrintWriter out, PrimitiveType type, int depth, MessageType container, List<String> cpath, boolean showOriginalTypes) {
        String name = Strings.repeat(".", depth) + type.getName();
        Type.Repetition rep = type.getRepetition();
        PrimitiveType.PrimitiveTypeName ptype = type.getPrimitiveTypeName();
        out.format("%s: %s %s", new Object[]{name, rep, ptype});
        if (showOriginalTypes) {
            OriginalType otype;
            try {
                otype = type.getOriginalType();
            }
            catch (Exception e) {
                otype = null;
            }
            if (otype != null) {
                out.format(" O:%s", new Object[]{otype});
            }
        } else {
            LogicalTypeAnnotation ltype = type.getLogicalTypeAnnotation();
            if (ltype != null) {
                out.format(" L:%s", ltype);
            }
        }
        if (container != null) {
            cpath.add(type.getName());
            String[] paths = cpath.toArray(new String[cpath.size()]);
            cpath.remove(cpath.size() - 1);
            ColumnDescriptor desc = container.getColumnDescription(paths);
            int defl = desc.getMaxDefinitionLevel();
            int repl = desc.getMaxRepetitionLevel();
            out.format(" R:%d D:%d", repl, defl);
        }
        out.println();
    }

    private static void showDetails(PrettyPrintWriter out, Type type, int depth, MessageType container, List<String> cpath, boolean showOriginalTypes) {
        if (type instanceof GroupType) {
            MetadataUtils.showDetails(out, type.asGroupType(), depth, container, cpath, showOriginalTypes);
            return;
        }
        if (type instanceof PrimitiveType) {
            MetadataUtils.showDetails(out, type.asPrimitiveType(), depth, container, cpath, showOriginalTypes);
            return;
        }
    }
}

