/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.parquet.tools.command.CatCommand;
import org.apache.parquet.tools.command.ColumnIndexCommand;
import org.apache.parquet.tools.command.Command;
import org.apache.parquet.tools.command.DumpCommand;
import org.apache.parquet.tools.command.HeadCommand;
import org.apache.parquet.tools.command.MergeCommand;
import org.apache.parquet.tools.command.RowCountCommand;
import org.apache.parquet.tools.command.ShowMetaCommand;
import org.apache.parquet.tools.command.ShowSchemaCommand;
import org.apache.parquet.tools.command.SizeCommand;

public final class Registry {
    public static Map<String, Class<? extends Command>> registry = new LinkedHashMap<String, Class<? extends Command>>();

    public static Map<String, Command> allCommands() {
        LinkedHashMap<String, Command> results = new LinkedHashMap<String, Command>();
        for (Map.Entry<String, Class<? extends Command>> entry : registry.entrySet()) {
            try {
                results.put(entry.getKey(), entry.getValue().newInstance());
            }
            catch (Exception exception) {}
        }
        return results;
    }

    public static Command getCommandByName(String name) {
        Class<? extends Command> clazz = registry.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        registry.put("cat", CatCommand.class);
        registry.put("head", HeadCommand.class);
        registry.put("schema", ShowSchemaCommand.class);
        registry.put("meta", ShowMetaCommand.class);
        registry.put("dump", DumpCommand.class);
        registry.put("merge", MergeCommand.class);
        registry.put("rowcount", RowCountCommand.class);
        registry.put("size", SizeCommand.class);
        registry.put("column-index", ColumnIndexCommand.class);
    }
}

