/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.it.unimi.dsi.fastutil.bytes;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import shaded.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.AbstractByte2FloatFunction;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.Byte2FloatMap;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.Byte2FloatMaps;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.ByteIterator;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.ByteSet;
import shaded.parquet.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import shaded.parquet.it.unimi.dsi.fastutil.floats.FloatCollection;
import shaded.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.parquet.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import shaded.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;

public abstract class AbstractByte2FloatMap
extends AbstractByte2FloatFunction
implements Byte2FloatMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractByte2FloatMap() {
    }

    @Override
    public boolean containsValue(float v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(byte k) {
        Iterator i = this.byte2FloatEntrySet().iterator();
        while (i.hasNext()) {
            if (((Byte2FloatMap.Entry)i.next()).getByteKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet keySet() {
        return new AbstractByteSet(){

            @Override
            public boolean contains(byte k) {
                return AbstractByte2FloatMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractByte2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2FloatMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Byte2FloatMap.Entry> i;
                    {
                        this.i = Byte2FloatMaps.fastIterator(AbstractByte2FloatMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Byte2FloatMap.Entry)this.i.next()).getByteKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public FloatCollection values() {
        return new AbstractFloatCollection(){

            @Override
            public boolean contains(float k) {
                return AbstractByte2FloatMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractByte2FloatMap.this.size();
            }

            @Override
            public void clear() {
                AbstractByte2FloatMap.this.clear();
            }

            @Override
            public FloatIterator iterator() {
                return new FloatIterator(){
                    private final ObjectIterator<Byte2FloatMap.Entry> i;
                    {
                        this.i = Byte2FloatMaps.fastIterator(AbstractByte2FloatMap.this);
                    }

                    @Override
                    public float nextFloat() {
                        return ((Byte2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Float> m3) {
        if (m3 instanceof Byte2FloatMap) {
            ObjectIterator<Byte2FloatMap.Entry> i = Byte2FloatMaps.fastIterator((Byte2FloatMap)m3);
            while (i.hasNext()) {
                Byte2FloatMap.Entry e = (Byte2FloatMap.Entry)i.next();
                this.put(e.getByteKey(), e.getFloatValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<? extends Byte, ? extends Float>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Byte, ? extends Float> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator<Byte2FloatMap.Entry> i = Byte2FloatMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Byte2FloatMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.byte2FloatEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Byte2FloatMap.Entry> i = Byte2FloatMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Byte2FloatMap.Entry e = (Byte2FloatMap.Entry)i.next();
            s2.append(String.valueOf(e.getByteKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getFloatValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Byte2FloatMap.Entry> {
        protected final Byte2FloatMap map;

        public BasicEntrySet(Byte2FloatMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Byte2FloatMap.Entry) {
                Byte2FloatMap.Entry e = (Byte2FloatMap.Entry)o;
                byte k = e.getByteKey();
                return this.map.containsKey(k) && Float.floatToIntBits(this.map.get(k)) == Float.floatToIntBits(e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k = (Byte)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.map.containsKey(k) && Float.floatToIntBits(this.map.get(k)) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Byte2FloatMap.Entry) {
                Byte2FloatMap.Entry e = (Byte2FloatMap.Entry)o;
                return this.map.remove(e.getByteKey(), e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            byte k = (Byte)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            float v = ((Float)value).floatValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Byte2FloatMap.Entry {
        protected byte key;
        protected float value;

        public BasicEntry() {
        }

        public BasicEntry(Byte key, Float value) {
            this.key = key;
            this.value = value.floatValue();
        }

        public BasicEntry(byte key, float value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte getByteKey() {
            return this.key;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Byte2FloatMap.Entry) {
                Byte2FloatMap.Entry e = (Byte2FloatMap.Entry)o;
                return this.key == e.getByteKey() && Float.floatToIntBits(this.value) == Float.floatToIntBits(e.getFloatValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Byte)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Float)) {
                return false;
            }
            return this.key == (Byte)key && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)value).floatValue());
        }

        @Override
        public int hashCode() {
            return this.key ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

