/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import shaded.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.ByteCollection;
import shaded.parquet.it.unimi.dsi.fastutil.bytes.ByteIterator;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.AbstractDouble2ByteFunction;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleSet;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.Double2ByteMap;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.Double2ByteMaps;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import shaded.parquet.it.unimi.dsi.fastutil.doubles.DoubleSet;
import shaded.parquet.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import shaded.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;

public abstract class AbstractDouble2ByteMap
extends AbstractDouble2ByteFunction
implements Double2ByteMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2ByteMap() {
    }

    @Override
    public boolean containsValue(byte v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(double k) {
        Iterator i = this.double2ByteEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2ByteMap.Entry)i.next()).getDoubleKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k) {
                return AbstractDouble2ByteMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractDouble2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ByteMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2ByteMap.Entry> i;
                    {
                        this.i = Double2ByteMaps.fastIterator(AbstractDouble2ByteMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2ByteMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ByteCollection values() {
        return new AbstractByteCollection(){

            @Override
            public boolean contains(byte k) {
                return AbstractDouble2ByteMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractDouble2ByteMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2ByteMap.this.clear();
            }

            @Override
            public ByteIterator iterator() {
                return new ByteIterator(){
                    private final ObjectIterator<Double2ByteMap.Entry> i;
                    {
                        this.i = Double2ByteMaps.fastIterator(AbstractDouble2ByteMap.this);
                    }

                    @Override
                    public byte nextByte() {
                        return ((Double2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Byte> m3) {
        if (m3 instanceof Double2ByteMap) {
            ObjectIterator<Double2ByteMap.Entry> i = Double2ByteMaps.fastIterator((Double2ByteMap)m3);
            while (i.hasNext()) {
                Double2ByteMap.Entry e = (Double2ByteMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getByteValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<? extends Double, ? extends Byte>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Double, ? extends Byte> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator<Double2ByteMap.Entry> i = Double2ByteMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Double2ByteMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.double2ByteEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator<Double2ByteMap.Entry> i = Double2ByteMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Double2ByteMap.Entry e = (Double2ByteMap.Entry)i.next();
            s2.append(String.valueOf(e.getDoubleKey()));
            s2.append("=>");
            s2.append(String.valueOf(e.getByteValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2ByteMap.Entry> {
        protected final Double2ByteMap map;

        public BasicEntrySet(Double2ByteMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2ByteMap.Entry) {
                Double2ByteMap.Entry e = (Double2ByteMap.Entry)o;
                double k = e.getDoubleKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getByteValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Byte)value).byteValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2ByteMap.Entry) {
                Double2ByteMap.Entry e = (Double2ByteMap.Entry)o;
                return this.map.remove(e.getDoubleKey(), e.getByteValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            byte v = (Byte)value;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry
    implements Double2ByteMap.Entry {
        protected double key;
        protected byte value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Byte value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, byte value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }

        @Override
        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2ByteMap.Entry) {
                Double2ByteMap.Entry e = (Double2ByteMap.Entry)o;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e.getDoubleKey()) && this.value == e.getByteValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Byte)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == (Byte)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

