/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import shaded.parquet.it.unimi.dsi.fastutil.HashCommon;
import shaded.parquet.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import shaded.parquet.it.unimi.dsi.fastutil.longs.LongCollection;
import shaded.parquet.it.unimi.dsi.fastutil.longs.LongIterator;
import shaded.parquet.it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import shaded.parquet.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import shaded.parquet.it.unimi.dsi.fastutil.objects.Object2LongMap;
import shaded.parquet.it.unimi.dsi.fastutil.objects.Object2LongMaps;
import shaded.parquet.it.unimi.dsi.fastutil.objects.ObjectIterator;
import shaded.parquet.it.unimi.dsi.fastutil.objects.ObjectSet;

public abstract class AbstractObject2LongMap<K>
extends AbstractObject2LongFunction<K>
implements Object2LongMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2LongMap() {
    }

    @Override
    public boolean containsValue(long v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        Iterator i = this.object2LongEntrySet().iterator();
        while (i.hasNext()) {
            if (((Object2LongMap.Entry)i.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractObject2LongMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractObject2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2LongMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new ObjectIterator<K>(){
                    private final ObjectIterator<Object2LongMap.Entry<K>> i;
                    {
                        this.i = Object2LongMaps.fastIterator(AbstractObject2LongMap.this);
                    }

                    @Override
                    public K next() {
                        return ((Object2LongMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public LongCollection values() {
        return new AbstractLongCollection(){

            @Override
            public boolean contains(long k) {
                return AbstractObject2LongMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractObject2LongMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2LongMap.this.clear();
            }

            @Override
            public LongIterator iterator() {
                return new LongIterator(){
                    private final ObjectIterator<Object2LongMap.Entry<K>> i;
                    {
                        this.i = Object2LongMaps.fastIterator(AbstractObject2LongMap.this);
                    }

                    @Override
                    public long nextLong() {
                        return ((Object2LongMap.Entry)this.i.next()).getLongValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends K, ? extends Long> m3) {
        if (m3 instanceof Object2LongMap) {
            ObjectIterator i = Object2LongMaps.fastIterator((Object2LongMap)m3);
            while (i.hasNext()) {
                Object2LongMap.Entry e = (Object2LongMap.Entry)i.next();
                this.put(e.getKey(), e.getLongValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<K, Long>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<K, Long> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = Object2LongMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Object2LongMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.object2LongEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = Object2LongMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2LongMap.Entry e = (Object2LongMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getLongValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<K>
    extends AbstractObjectSet<Object2LongMap.Entry<K>> {
        protected final Object2LongMap<K> map;

        public BasicEntrySet(Object2LongMap<K> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2LongMap.Entry) {
                Object2LongMap.Entry e = (Object2LongMap.Entry)o;
                Object k = e.getKey();
                return this.map.containsKey(k) && this.map.getLong(k) == e.getLongValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.getLong(k) == ((Long)value).longValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2LongMap.Entry) {
                Object2LongMap.Entry e = (Object2LongMap.Entry)o;
                return this.map.remove(e.getKey(), e.getLongValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            long v = (Long)value;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<K>
    implements Object2LongMap.Entry<K> {
        protected K key;
        protected long value;

        public BasicEntry() {
        }

        public BasicEntry(K key, Long value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(K key, long value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public long getLongValue() {
            return this.value;
        }

        @Override
        public long setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Object2LongMap.Entry) {
                Object2LongMap.Entry e = (Object2LongMap.Entry)o;
                return Objects.equals(this.key, e.getKey()) && this.value == e.getLongValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            if (value == null || !(value instanceof Long)) {
                return false;
            }
            return Objects.equals(this.key, key) && this.value == (Long)value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ HashCommon.long2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

