/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;

public class BinaryStatistics
extends Statistics<Binary> {
    private static final PrimitiveType DEFAULT_FAKE_TYPE = (PrimitiveType)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).named("fake_binary_type");
    private Binary max;
    private Binary min;

    @Deprecated
    public BinaryStatistics() {
        this(DEFAULT_FAKE_TYPE);
    }

    BinaryStatistics(PrimitiveType type) {
        super(type);
    }

    private BinaryStatistics(BinaryStatistics other) {
        super(other.type());
        if (other.hasNonNullValue()) {
            this.initializeStats(other.min, other.max);
        }
        this.setNumNulls(other.getNumNulls());
    }

    @Override
    public void updateStats(Binary value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        BinaryStatistics binaryStats = (BinaryStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(binaryStats.getMin(), binaryStats.getMax());
        } else {
            this.updateStats(binaryStats.getMin(), binaryStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = Binary.fromReusedByteArray(maxBytes);
        this.min = Binary.fromReusedByteArray(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return this.max == null ? null : this.max.getBytes();
    }

    @Override
    public byte[] getMinBytes() {
        return this.min == null ? null : this.min.getBytes();
    }

    @Override
    String stringify(Binary value) {
        return this.stringifier.stringify(value);
    }

    @Override
    public boolean isSmallerThan(long size) {
        return !this.hasNonNullValue() || (long)(this.min.length() + this.max.length()) < size;
    }

    public boolean isSmallerThanWithTruncation(long size, int truncationLength) {
        int maxTruncateLength;
        if (!this.hasNonNullValue()) {
            return true;
        }
        int minTruncateLength = Math.min(this.min.length(), truncationLength);
        return (long)(minTruncateLength + (maxTruncateLength = Math.min(this.max.length(), truncationLength))) < size;
    }

    @Deprecated
    public void updateStats(Binary min_value, Binary max_value) {
        if (this.comparator().compare(this.min, min_value) > 0) {
            this.min = min_value.copy();
        }
        if (this.comparator().compare(this.max, max_value) < 0) {
            this.max = max_value.copy();
        }
    }

    @Deprecated
    public void initializeStats(Binary min_value, Binary max_value) {
        this.min = min_value.copy();
        this.max = max_value.copy();
        this.markAsNotEmpty();
    }

    @Override
    public Binary genericGetMin() {
        return this.min;
    }

    @Override
    public Binary genericGetMax() {
        return this.max;
    }

    @Deprecated
    public Binary getMax() {
        return this.max;
    }

    @Deprecated
    public Binary getMin() {
        return this.min;
    }

    @Deprecated
    public void setMinMax(Binary min2, Binary max) {
        this.max = max;
        this.min = min2;
        this.markAsNotEmpty();
    }

    public BinaryStatistics copy() {
        return new BinaryStatistics(this);
    }
}

