/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.parquet.tools.command.Command;

public abstract class ArgsOnlyCommand
implements Command {
    private final int min;
    private final int max;

    public ArgsOnlyCommand(int min2, int max) {
        this.min = min2;
        this.max = max;
    }

    @Override
    public Options getOptions() {
        return null;
    }

    @Override
    public boolean supportsExtraArgs() {
        return true;
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        String[] args = options.getArgs();
        if (args.length < this.min) {
            throw new MissingArgumentException("missing required arguments");
        }
        if (args.length > this.max) {
            throw new UnrecognizedOptionException("unknown extra argument \"" + args[this.max] + "\"");
        }
    }
}

