/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.tools.Main;
import org.apache.parquet.tools.command.ArgsOnlyCommand;

public class MergeCommand
extends ArgsOnlyCommand {
    public static final String[] USAGE = new String[]{"<input> [<input> ...] <output>", "where <input> is the source parquet files/directory to be merged", "   <output> is the destination parquet file"};
    private static final int MAX_FILE_NUM = 100;
    private static final long TOO_SMALL_FILE_THRESHOLD = 0x4000000L;
    private Configuration conf = new Configuration();

    public MergeCommand() {
        super(2, 101);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Merges multiple Parquet files into one. The command doesn't merge row groups, just places one after the other. When used to merge many small files, the resulting file will still contain small row groups, which usually leads to bad query performance.";
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        List<String> args = options.getArgList();
        List<Path> inputFiles = this.getInputFiles(args.subList(0, args.size() - 1));
        Path outputFile = new Path(args.get(args.size() - 1));
        FileMetaData mergedMeta = this.mergedMetadata(inputFiles);
        PrintWriter out = new PrintWriter(Main.out, true);
        ParquetFileWriter writer = new ParquetFileWriter(this.conf, mergedMeta.getSchema(), outputFile, ParquetFileWriter.Mode.CREATE);
        writer.start();
        boolean tooSmallFilesMerged = false;
        for (Path input : inputFiles) {
            if (input.getFileSystem(this.conf).getFileStatus(input).getLen() < 0x4000000L) {
                out.format("Warning: file %s is too small, length: %d\n", input, input.getFileSystem(this.conf).getFileStatus(input).getLen());
                tooSmallFilesMerged = true;
            }
            writer.appendFile(HadoopInputFile.fromPath(input, this.conf));
        }
        if (tooSmallFilesMerged) {
            out.println("Warning: you merged too small files. Although the size of the merged file is bigger, it STILL contains small row groups, thus you don't have the advantage of big row groups, which usually leads to bad query performance!");
        }
        writer.end(mergedMeta.getKeyValueMetaData());
    }

    private FileMetaData mergedMetadata(List<Path> inputFiles) throws IOException {
        return ParquetFileWriter.mergeMetadataFiles(inputFiles, this.conf).getFileMetaData();
    }

    private List<Path> getInputFiles(List<String> input) throws IOException {
        List<Path> inputFiles = null;
        if (input.size() == 1) {
            Path p = new Path(input.get(0));
            FileSystem fs = p.getFileSystem(this.conf);
            FileStatus status = fs.getFileStatus(p);
            if (status.isDir()) {
                inputFiles = this.getInputFilesFromDirectory(status);
            }
        } else {
            inputFiles = this.parseInputFiles(input);
        }
        this.checkParquetFiles(inputFiles);
        return inputFiles;
    }

    private void checkParquetFiles(List<Path> inputFiles) throws IOException {
        if (inputFiles == null || inputFiles.size() <= 1) {
            throw new IllegalArgumentException("Not enough files to merge");
        }
        for (Path inputFile : inputFiles) {
            FileSystem fs = inputFile.getFileSystem(this.conf);
            FileStatus status = fs.getFileStatus(inputFile);
            if (!status.isDir()) continue;
            throw new IllegalArgumentException("Illegal parquet file: " + inputFile.toUri());
        }
    }

    private List<Path> getInputFilesFromDirectory(FileStatus partitionDir) throws IOException {
        FileSystem fs = partitionDir.getPath().getFileSystem(this.conf);
        FileStatus[] inputFiles = fs.listStatus(partitionDir.getPath(), (PathFilter)HiddenFileFilter.INSTANCE);
        ArrayList<Path> input = new ArrayList<Path>();
        for (FileStatus f : inputFiles) {
            input.add(f.getPath());
        }
        return input;
    }

    private List<Path> parseInputFiles(List<String> input) {
        ArrayList<Path> inputFiles = new ArrayList<Path>();
        for (String name : input) {
            inputFiles.add(new Path(name));
        }
        return inputFiles;
    }
}

