/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.tools.Main;
import org.apache.parquet.tools.command.ArgsOnlyCommand;

public class RowCountCommand
extends ArgsOnlyCommand {
    private FileStatus[] inputFileStatuses;
    private Configuration conf;
    private Path inputPath;
    private PrintWriter out;
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to count rows to stdout"};
    public static final Options OPTIONS = new Options();

    public RowCountCommand() {
        super(1, 1);
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Prints the count of rows in Parquet file(s)";
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        this.out = new PrintWriter(Main.out, true);
        this.inputPath = new Path(input);
        this.conf = new Configuration();
        this.inputFileStatuses = this.inputPath.getFileSystem(this.conf).globStatus(this.inputPath);
        long rowCount = 0L;
        for (FileStatus fs : this.inputFileStatuses) {
            long fileRowCount = 0L;
            for (Footer f : ParquetFileReader.readFooters(this.conf, fs, false)) {
                for (BlockMetaData b : f.getParquetMetadata().getBlocks()) {
                    rowCount += b.getRowCount();
                    fileRowCount += b.getRowCount();
                }
            }
            if (!options.hasOption('d')) continue;
            this.out.format("%s row count: %d\n", fs.getPath().getName(), fileRowCount);
        }
        this.out.format("Total RowCount: %d", rowCount);
        this.out.println();
    }

    static {
        OptionBuilder.withLongOpt("detailed");
        OptionBuilder.withDescription("Detailed rowcount of each matching file");
        Option detailed = OptionBuilder.create('d');
        OPTIONS.addOption(detailed);
    }
}

