/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.tools.command.ArgsOnlyCommand;
import org.apache.parquet.tools.command.MetadataUtils;
import org.apache.parquet.tools.util.PrettyPrintWriter;

public class ShowMetaCommand
extends ArgsOnlyCommand {
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to print to stdout"};
    public static final Options OPTIONS = new Options();

    public ShowMetaCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Prints the metadata of Parquet file(s)";
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        boolean showOriginalTypes = options.hasOption('o');
        Configuration conf = new Configuration();
        Path inputPath = new Path(input);
        FileStatus inputFileStatus = inputPath.getFileSystem(conf).getFileStatus(inputPath);
        List<Footer> footers = ParquetFileReader.readFooters(conf, inputFileStatus, false);
        PrettyPrintWriter out = PrettyPrintWriter.stdoutPrettyPrinter().withAutoColumn().withWhitespaceHandler(PrettyPrintWriter.WhiteSpaceHandler.COLLAPSE_WHITESPACE).withColumnPadding(1).build();
        for (Footer f : footers) {
            out.format("file: %s%n", f.getFile());
            MetadataUtils.showDetails(out, f.getParquetMetadata(), showOriginalTypes);
            out.flushColumns();
        }
    }

    static {
        OptionBuilder.withLongOpt("originalType");
        OptionBuilder.withDescription("Print logical types in OriginalType representation.");
        Option originalType = OptionBuilder.create('o');
        OPTIONS.addOption(originalType);
    }
}

