/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HiddenFileFilter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.tools.Main;
import org.apache.parquet.tools.command.ArgsOnlyCommand;
import org.apache.parquet.tools.command.MetadataUtils;
import org.apache.parquet.tools.util.PrettyPrintWriter;

public class ShowSchemaCommand
extends ArgsOnlyCommand {
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file containing the schema to show"};
    public static final Options OPTIONS = new Options();

    public ShowSchemaCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Prints the schema of Parquet file(s)";
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        Path file;
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        Configuration conf = new Configuration();
        Path path = new Path(input);
        FileSystem fs = path.getFileSystem(conf);
        if (fs.isDirectory(path)) {
            FileStatus[] statuses = fs.listStatus(path, (PathFilter)HiddenFileFilter.INSTANCE);
            if (statuses.length == 0) {
                throw new RuntimeException("Directory " + path.toString() + " is empty");
            }
            file = statuses[0].getPath();
        } else {
            file = path;
        }
        ParquetMetadata metaData = ParquetFileReader.readFooter(conf, file, ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        Main.out.println(schema);
        if (options.hasOption('d')) {
            boolean showOriginalTypes = options.hasOption('o');
            PrettyPrintWriter out = PrettyPrintWriter.stdoutPrettyPrinter().build();
            MetadataUtils.showDetails(out, metaData, showOriginalTypes);
        }
    }

    static {
        OptionBuilder.withLongOpt("detailed");
        OptionBuilder.withDescription("Show detailed information about the schema.");
        Option help = OptionBuilder.create('d');
        OptionBuilder.withLongOpt("originalType");
        OptionBuilder.withDescription("Print logical types in OriginalType representation.");
        Option originalType = OptionBuilder.create('o');
        OPTIONS.addOption(help);
        OPTIONS.addOption(originalType);
    }
}

