/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.tools.Main;
import org.apache.parquet.tools.command.ArgsOnlyCommand;

public class SizeCommand
extends ArgsOnlyCommand {
    private FileStatus[] inputFileStatuses;
    private Configuration conf;
    private Path inputPath;
    private PrintWriter out;
    private static final double ONE_KB = 1024.0;
    private static final double ONE_MB = 1048576.0;
    private static final double ONE_GB = 1.073741824E9;
    private static final double ONE_TB = 1.099511627776E12;
    private static final double ONE_PB = 1.125899906842624E15;
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to get size & human readable size to stdout"};
    public static final Options OPTIONS = new Options();

    public SizeCommand() {
        super(1, 1);
    }

    @Override
    public Options getOptions() {
        return OPTIONS;
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public String getCommandDescription() {
        return "Prints the size of Parquet file(s)";
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        this.out = new PrintWriter(Main.out, true);
        this.inputPath = new Path(input);
        this.conf = new Configuration();
        this.inputFileStatuses = this.inputPath.getFileSystem(this.conf).globStatus(this.inputPath);
        long size = 0L;
        for (FileStatus fs : this.inputFileStatuses) {
            long fileSize = 0L;
            for (Footer f : ParquetFileReader.readFooters(this.conf, fs, false)) {
                for (BlockMetaData b : f.getParquetMetadata().getBlocks()) {
                    size += options.hasOption('u') ? b.getTotalByteSize() : b.getCompressedSize();
                    fileSize += options.hasOption('u') ? b.getTotalByteSize() : b.getCompressedSize();
                }
            }
            if (!options.hasOption('d')) continue;
            if (options.hasOption('p')) {
                this.out.format("%s: %s\n", fs.getPath().getName(), this.getPrettySize(fileSize));
                continue;
            }
            this.out.format("%s: %d bytes\n", fs.getPath().getName(), fileSize);
        }
        if (options.hasOption('p')) {
            this.out.format("Total Size: %s", this.getPrettySize(size));
        } else {
            this.out.format("Total Size: %d bytes", size);
        }
        this.out.println();
    }

    public String getPrettySize(long bytes) {
        if ((double)bytes / 1024.0 < 1.0) {
            return String.format("%d", bytes) + " bytes";
        }
        if ((double)bytes / 1048576.0 < 1.0) {
            return String.format("%.3f", (double)bytes / 1024.0) + " KB";
        }
        if ((double)bytes / 1.073741824E9 < 1.0) {
            return String.format("%.3f", (double)bytes / 1048576.0) + " MB";
        }
        if ((double)bytes / 1.099511627776E12 < 1.0) {
            return String.format("%.3f", (double)bytes / 1.073741824E9) + " GB";
        }
        if ((double)bytes / 1.125899906842624E15 < 1.0) {
            return String.format("%.3f", (double)bytes / 1.099511627776E12) + " TB";
        }
        return String.format("%.3f", (double)bytes / 1.125899906842624E15) + " PB";
    }

    static {
        OptionBuilder.withLongOpt("pretty");
        OptionBuilder.withDescription("Pretty size");
        Option help = OptionBuilder.create('p');
        OPTIONS.addOption(help);
        OptionBuilder.withLongOpt("uncompressed");
        OptionBuilder.withDescription("Uncompressed size");
        Option uncompressed = OptionBuilder.create('u');
        OPTIONS.addOption(uncompressed);
        OptionBuilder.withLongOpt("detailed");
        OptionBuilder.withDescription("Detailed size of each matching file");
        Option detailed = OptionBuilder.create('d');
        OPTIONS.addOption(detailed);
    }
}

