/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.tools.read.SimpleRecord;
import shaded.parquet.com.fasterxml.jackson.databind.ObjectMapper;

public abstract class JsonRecordFormatter<T> {
    private static final int SINGLE_VALUE = 0;
    protected final Type typeInfo;

    protected JsonRecordFormatter(Type type) {
        this.typeInfo = type;
    }

    protected abstract Object formatResults(List<T> var1);

    public static JsonGroupFormatter fromSchema(MessageType messageType) {
        return new JsonGroupFormatter(messageType);
    }

    public static class JsonGroupFormatter
    extends JsonRecordFormatter<SimpleRecord> {
        private final Map<String, JsonRecordFormatter> formatters;

        public JsonGroupFormatter(GroupType schema) {
            super(schema);
            this.formatters = this.buildWriters(schema);
        }

        private Map<String, JsonRecordFormatter> buildWriters(GroupType groupSchema) {
            LinkedHashMap<String, JsonRecordFormatter> writers = new LinkedHashMap<String, JsonRecordFormatter>();
            for (Type type : groupSchema.getFields()) {
                if (type.isPrimitive()) {
                    writers.put(type.getName(), new JsonPrimitiveWriter(type));
                    continue;
                }
                writers.put(type.getName(), new JsonGroupFormatter((GroupType)type));
            }
            return writers;
        }

        private Object add(SimpleRecord record) {
            return this.formatEntries(this.collateEntries(record));
        }

        private Map<String, List<Object>> collateEntries(SimpleRecord record) {
            LinkedHashMap<String, List<Object>> collatedEntries = new LinkedHashMap<String, List<Object>>();
            for (SimpleRecord.NameValue value : record.getValues()) {
                if (collatedEntries.containsKey(value.getName())) {
                    ((List)collatedEntries.get(value.getName())).add(value.getValue());
                    continue;
                }
                ArrayList<Object> newResultListForKey = new ArrayList<Object>();
                newResultListForKey.add(value.getValue());
                collatedEntries.put(value.getName(), newResultListForKey);
            }
            return collatedEntries;
        }

        private Object formatEntries(Map<String, List<Object>> entries) {
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, List<Object>> entry : entries.entrySet()) {
                JsonRecordFormatter formatter = this.formatters.get(entry.getKey());
                results.put(entry.getKey(), formatter.formatResults(entry.getValue()));
            }
            return results;
        }

        @Override
        protected Object formatResults(List<SimpleRecord> values) {
            if (this.typeInfo.getRepetition() == Type.Repetition.REPEATED) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (SimpleRecord object : values) {
                    results.add(this.add(object));
                }
                return results;
            }
            return this.add(values.get(0));
        }

        public String formatRecord(SimpleRecord value) throws IOException {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this.add(value));
        }
    }

    public static class JsonPrimitiveWriter
    extends JsonRecordFormatter<Object> {
        public JsonPrimitiveWriter(Type primitiveType) {
            super(primitiveType);
        }

        @Override
        protected Object formatResults(List<Object> listOfValues) {
            if (this.typeInfo.getRepetition() == Type.Repetition.REPEATED) {
                return listOfValues;
            }
            return listOfValues.get(0);
        }
    }
}

