/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.apache.parquet.tools.Main;

public class PrettyPrintWriter
extends PrintWriter {
    public static final String MORE = " [more]...";
    public static final String LINE_SEP;
    public static final Span DEFAULT_APPEND;
    public static final char DEFAULT_COLUMN_SEP = ':';
    public static final int DEFAULT_MAX_COLUMNS = 1;
    public static final int DEFAULT_COLUMN_PADDING = 1;
    public static final int DEFAULT_TABS = 4;
    public static final int DEFAULT_WIDTH;
    public static final int DEFAULT_COLORS;
    private static final String RESET = "\u001b[0m";
    public static final String MODE_OFF = "0";
    public static final String MODE_BOLD = "1";
    public static final String MODE_UNDER = "4";
    public static final String MODE_BLINK = "5";
    public static final String MODE_REVERSE = "7";
    public static final String MODE_CONCEALED = "8";
    public static final String FG_COLOR_BLACK = "30";
    public static final String FG_COLOR_RED = "31";
    public static final String FG_COLOR_GREEN = "32";
    public static final String FG_COLOR_YELLOW = "33";
    public static final String FG_COLOR_BLUE = "34";
    public static final String FG_COLOR_MAGENTA = "35";
    public static final String FG_COLOR_CYAN = "36";
    public static final String FG_COLOR_WHITE = "37";
    public static final String BG_COLOR_BLACK = "40";
    public static final String BG_COLOR_RED = "41";
    public static final String BG_COLOR_GREEN = "42";
    public static final String BG_COLOR_YELLOW = "43";
    public static final String BG_COLOR_BLUE = "44";
    public static final String BG_COLOR_MAGENTA = "45";
    public static final String BG_COLOR_CYAN = "46";
    public static final String BG_COLOR_WHITE = "47";
    private final StringBuilder formatString;
    private final Formatter formatter;
    private final ArrayList<Line> buffer;
    private final boolean autoColumn;
    private final boolean autoCrop;
    private final Span appendToLongLine;
    private final int consoleWidth;
    private final int tabWidth;
    private final char columnSeparator;
    private final int maxColumns;
    private final int columnPadding;
    private final long maxBufferedLines;
    private final boolean flushOnTab;
    private final WhiteSpaceHandler whiteSpaceHandler;
    private int tabLevel;
    private String colorMode;
    private String colorForeground;
    private String colorBackground;
    private String tabs;
    public boolean acceptColorModification = true;

    private PrettyPrintWriter(OutputStream out, boolean autoFlush, boolean autoColumn, boolean autoCrop, Span appendToLongLine, int consoleWidth, int tabWidth, char columnSeparator, int maxColumns, int columnPadding, long maxBufferedLines, boolean flushOnTab, WhiteSpaceHandler whiteSpaceHandler) {
        super(out, autoFlush && !autoColumn);
        this.autoColumn = autoColumn;
        this.autoCrop = autoCrop;
        this.appendToLongLine = appendToLongLine;
        this.consoleWidth = consoleWidth;
        this.tabWidth = tabWidth;
        this.columnSeparator = columnSeparator;
        this.maxColumns = maxColumns;
        this.maxBufferedLines = maxBufferedLines;
        this.columnPadding = columnPadding;
        this.flushOnTab = flushOnTab;
        this.whiteSpaceHandler = whiteSpaceHandler;
        this.buffer = new ArrayList();
        this.formatString = new StringBuilder();
        this.formatter = new Formatter(this.formatString);
        this.colorMode = null;
        this.colorForeground = null;
        this.colorBackground = null;
        this.tabLevel = 0;
        this.tabs = "";
        this.buffer.add(new Line());
    }

    public void setTabLevel(int level) {
        this.tabLevel = level;
        this.tabs = Strings.repeat(" ", this.tabWidth * level);
        if (this.flushOnTab) {
            this.flushColumns();
        }
    }

    public void incrementTabLevel() {
        this.setTabLevel(this.tabLevel + 1);
    }

    public void decrementTabLevel() {
        if (this.tabLevel == 0) {
            return;
        }
        this.setTabLevel(this.tabLevel - 1);
    }

    private int determineNumColumns() {
        int max = 0;
        for (Line line : this.buffer) {
            int num = line.countCharacter(this.columnSeparator);
            if (num <= max) continue;
            max = num;
        }
        return max > this.maxColumns ? this.maxColumns : max;
    }

    private int[] determineColumnWidths() {
        int columns = this.determineNumColumns();
        if (columns == 0) {
            return null;
        }
        int[] widths = new int[columns];
        for (Line line : this.buffer) {
            int pos;
            int last = 0;
            for (int idx = 0; last < line.length() && idx < columns && (pos = line.indexOf(this.columnSeparator, last)) >= 0; ++idx) {
                int wid = pos - last + 1 + this.columnPadding;
                if (wid > widths[idx]) {
                    widths[idx] = wid;
                }
                last = line.firstNonWhiteSpace(idx + 1);
            }
        }
        return widths;
    }

    private Line toColumns(int[] widths, Line line) throws IOException {
        int last = 0;
        for (int i = 0; i < widths.length; ++i) {
            int width = widths[i];
            int idx = line.indexOf(this.columnSeparator, last);
            if (idx < 0) break;
            if (idx + 1 <= width) {
                line.spaceOut(width - (idx + 1), idx + 1);
            }
            last = line.firstNonWhiteSpace(idx + 1);
        }
        return line;
    }

    public void flushColumns() {
        this.flushColumns(false);
    }

    private void flushColumns(boolean preserveLast) {
        int size = this.buffer.size();
        int[] widths = null;
        if (this.autoColumn) {
            widths = this.determineColumnWidths();
        }
        StringBuilder builder = new StringBuilder();
        try {
            for (int i = 0; i < size - 1; ++i) {
                Line line = this.buffer.get(i);
                if (widths != null) {
                    line = this.toColumns(widths, line);
                }
                this.fixupLine(line);
                builder.setLength(0);
                line.toString(builder);
                this.out.append(builder.toString());
                this.out.append(LINE_SEP);
            }
            if (!preserveLast) {
                Line line = this.buffer.get(size - 1);
                if (widths != null) {
                    line = this.toColumns(widths, line);
                }
                this.fixupLine(line);
                builder.setLength(0);
                line.toString(builder);
                this.out.append(builder.toString());
            }
            this.out.flush();
        }
        catch (IOException line) {
            // empty catch block
        }
        Line addback = null;
        if (preserveLast) {
            addback = this.buffer.get(size - 1);
        }
        this.buffer.clear();
        if (addback != null) {
            this.buffer.add(addback);
        } else {
            this.buffer.add(new Line());
        }
    }

    private void flushIfNeeded() {
        this.flushIfNeeded(false);
    }

    private void flushIfNeeded(boolean preserveLast) {
        if (!this.autoColumn || (long)this.buffer.size() > this.maxBufferedLines) {
            this.flushColumns(preserveLast);
        }
    }

    private void appendToCurrent(String s2) {
        int size = this.buffer.size();
        Line value = this.buffer.get(size - 1);
        if (value.isEmpty()) {
            value.append(this.tabs());
        }
        value.append(this.span(s2));
    }

    private void fixupLine(Line line) {
        if (this.autoCrop) {
            line.trimTo(this.consoleWidth, this.appendToLongLine);
        }
    }

    private void print(String s2, boolean mayHaveNewlines) {
        if (s2 == null) {
            this.appendToCurrent("null");
            return;
        }
        if (s2.isEmpty()) {
            return;
        }
        if (LINE_SEP.equals(s2)) {
            this.buffer.add(new Line());
            this.flushIfNeeded();
            return;
        }
        if (this.whiteSpaceHandler != null) {
            boolean endswith = s2.endsWith(LINE_SEP);
            switch (this.whiteSpaceHandler) {
                case ELIMINATE_NEWLINES: {
                    s2 = s2.replaceAll("\\r\\n|\\r|\\n", " ");
                    break;
                }
                case COLLAPSE_WHITESPACE: {
                    s2 = s2.replaceAll("\\s+", " ");
                }
            }
            mayHaveNewlines = endswith;
            if (endswith) {
                s2 = s2 + LINE_SEP;
            }
        }
        if (!mayHaveNewlines) {
            this.appendToCurrent(s2);
            return;
        }
        String[] lines = s2.split("\\r?\\n", -1);
        this.appendToCurrent(lines[0]);
        for (int i = 1; i < lines.length; ++i) {
            String value = lines[i];
            if (value.isEmpty()) {
                this.buffer.add(new Line());
                continue;
            }
            Line line = new Line();
            line.append(this.tabs());
            line.append(this.span(value, true));
            this.buffer.add(line);
        }
        this.resetColor();
        this.flushIfNeeded(true);
    }

    @Override
    public void print(String s2) {
        this.print(s2, true);
    }

    @Override
    public void println() {
        this.print(LINE_SEP, true);
        this.flushIfNeeded();
    }

    @Override
    public void println(String x) {
        this.print(x);
        this.println();
    }

    @Override
    public void print(boolean b) {
        this.print(String.valueOf(b), false);
    }

    @Override
    public void print(char c) {
        this.print(String.valueOf(c), false);
    }

    @Override
    public void print(int i) {
        this.print(String.valueOf(i), false);
    }

    @Override
    public void print(long l) {
        this.print(String.valueOf(l), false);
    }

    @Override
    public void print(float f) {
        this.print(String.valueOf(f), false);
    }

    @Override
    public void print(double d) {
        this.print(String.valueOf(d), false);
    }

    @Override
    public void print(char[] s2) {
        this.print(String.valueOf(s2), true);
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj), true);
    }

    @Override
    public PrintWriter printf(String format, Object ... args) {
        return this.printf(this.formatter.locale(), format, args);
    }

    @Override
    public PrintWriter printf(Locale l, String format, Object ... args) {
        this.formatter.format(l, format, args);
        String results = this.formatString.toString();
        this.formatString.setLength(0);
        this.print(results);
        this.flushIfNeeded();
        return this;
    }

    @Override
    public PrintWriter format(String format, Object ... args) {
        return this.printf(format, args);
    }

    @Override
    public PrintWriter format(Locale l, String format, Object ... args) {
        return this.printf(l, format, args);
    }

    @Override
    public PrintWriter append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            this.print("null");
            return this;
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public PrintWriter append(CharSequence csq, int start, int end) {
        if (csq == null) {
            this.print("null");
            return this;
        }
        this.print(csq.subSequence(start, end).toString());
        return this;
    }

    @Override
    public void println(boolean x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(int x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(long x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(float x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(double x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(char[] x) {
        this.print(x);
        this.println();
    }

    @Override
    public void println(Object x) {
        this.print(x);
        this.println();
    }

    public void rule(char c) {
        if (this.tabs.length() >= this.consoleWidth) {
            return;
        }
        int width = this.consoleWidth;
        if (width == Integer.MAX_VALUE) {
            width = 100;
        }
        this.println(Strings.repeat(String.valueOf(c), width - this.tabs.length()));
    }

    public PrettyPrintWriter iff(boolean predicate) {
        if (!predicate && this.acceptColorModification) {
            this.resetColor();
        } else {
            this.acceptColorModification = false;
        }
        return this;
    }

    public PrettyPrintWriter otherwise() {
        this.acceptColorModification = false;
        return this;
    }

    public PrettyPrintWriter black() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_BLACK;
        return this;
    }

    public PrettyPrintWriter red() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_RED;
        return this;
    }

    public PrettyPrintWriter green() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_GREEN;
        return this;
    }

    public PrettyPrintWriter yellow() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_YELLOW;
        return this;
    }

    public PrettyPrintWriter blue() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_BLUE;
        return this;
    }

    public PrettyPrintWriter magenta() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_MAGENTA;
        return this;
    }

    public PrettyPrintWriter cyan() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_CYAN;
        return this;
    }

    public PrettyPrintWriter white() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorForeground = FG_COLOR_WHITE;
        return this;
    }

    public PrettyPrintWriter bgblack() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_BLACK;
        return this;
    }

    public PrettyPrintWriter bgred() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_RED;
        return this;
    }

    public PrettyPrintWriter bggreen() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_GREEN;
        return this;
    }

    public PrettyPrintWriter bgyellow() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_YELLOW;
        return this;
    }

    public PrettyPrintWriter bgblue() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_BLUE;
        return this;
    }

    public PrettyPrintWriter bgmagenta() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_MAGENTA;
        return this;
    }

    public PrettyPrintWriter bgcyan() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_CYAN;
        return this;
    }

    public PrettyPrintWriter bgwhite() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorBackground = BG_COLOR_WHITE;
        return this;
    }

    public PrettyPrintWriter bold() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_BOLD;
        return this;
    }

    public PrettyPrintWriter blink() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_BLINK;
        return this;
    }

    public PrettyPrintWriter concealed() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_CONCEALED;
        return this;
    }

    public PrettyPrintWriter off() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_OFF;
        return this;
    }

    public PrettyPrintWriter underscore() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_UNDER;
        return this;
    }

    public PrettyPrintWriter reverse() {
        if (!this.acceptColorModification) {
            return this;
        }
        this.colorMode = MODE_REVERSE;
        return this;
    }

    public static Builder stdoutPrettyPrinter() {
        return new Builder(Main.out).withAutoFlush();
    }

    public static Builder stderrPrettyPrinter() {
        return new Builder(Main.err).withAutoFlush();
    }

    public static Builder newPrettyPrinter(OutputStream out) {
        return new Builder(out);
    }

    private Span tabs() {
        return new Span(this.tabs);
    }

    private Span span(String span) {
        return this.span(span, false);
    }

    private void resetColor() {
        this.acceptColorModification = true;
        this.colorMode = null;
        this.colorForeground = null;
        this.colorBackground = null;
    }

    public static Span mkspan(String span) {
        return new Span(span);
    }

    public static Span mkspan(String span, String color) {
        return PrettyPrintWriter.mkspan(span, null, color, null);
    }

    public static Span mkspan(String span, String colorMode, String colorForeground, String colorBackground) {
        if (DEFAULT_COLORS > 0 && (colorMode != null || colorForeground != null || colorBackground != null)) {
            String color = "\u001b[" + Joiner.on(';').skipNulls().join(colorMode, colorForeground, colorBackground) + "m";
            return new Span(span, color);
        }
        return PrettyPrintWriter.mkspan(span);
    }

    private Span span(String span, boolean keepColor) {
        Span result = DEFAULT_COLORS > 0 && (this.colorMode != null || this.colorForeground != null || this.colorBackground != null) ? PrettyPrintWriter.mkspan(span, this.colorMode, this.colorForeground, this.colorBackground) : PrettyPrintWriter.mkspan(span);
        if (!keepColor) {
            this.resetColor();
        }
        return result;
    }

    static {
        String termout;
        String colors;
        LINE_SEP = System.getProperty("line.separator");
        int consoleWidth = 80;
        int numColors = 0;
        String columns = System.getenv("COLUMNS");
        if (columns != null && !columns.isEmpty()) {
            try {
                consoleWidth = Integer.parseInt(columns);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((colors = System.getenv("COLORS")) != null && !colors.isEmpty()) {
            try {
                numColors = Integer.parseInt(colors);
                if (numColors < 0) {
                    numColors = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!((termout = System.getenv("TERMOUT")) == null || termout.isEmpty() || "y".equalsIgnoreCase(termout) || "yes".equalsIgnoreCase(termout) || "t".equalsIgnoreCase(termout) || "true".equalsIgnoreCase(termout) || "on".equalsIgnoreCase(termout))) {
            consoleWidth = Integer.MAX_VALUE;
            numColors = 0;
        }
        if (System.getProperty("DISABLE_COLORS", null) != null) {
            numColors = 0;
        }
        DEFAULT_WIDTH = consoleWidth;
        DEFAULT_COLORS = numColors;
        DEFAULT_APPEND = numColors > 0 ? PrettyPrintWriter.mkspan(MORE, null, FG_COLOR_RED, null) : PrettyPrintWriter.mkspan(MORE);
    }

    public static final class Span {
        private String span;
        private final String color;

        public Span(String span) {
            this(span, null);
        }

        public Span(String span, String color) {
            this.span = span;
            this.color = color;
        }

        public int length() {
            return this.span.length();
        }

        public boolean isEmpty() {
            return this.span.isEmpty();
        }

        public int indexOf(char ch, int start) {
            return this.span.indexOf(ch, start);
        }

        public void spaceOut(int width, int start) {
            int removeTo;
            for (removeTo = start; removeTo < this.span.length() && Character.isWhitespace(this.span.charAt(removeTo)); ++removeTo) {
            }
            this.span = this.span.substring(0, start) + Strings.repeat(" ", width) + this.span.substring(removeTo);
        }

        public int countCharacter(char ch) {
            int result = 0;
            for (int i = 0; i < this.span.length(); ++i) {
                if (this.span.charAt(i) != ch) continue;
                ++result;
            }
            return result;
        }

        public void trimTo(int width, Span appendToLongLine) {
            if (appendToLongLine != null && !appendToLongLine.isEmpty()) {
                int shortten = appendToLongLine.length();
                if (shortten > width) {
                    shortten = width;
                }
                this.span = this.span.substring(0, width - shortten) + appendToLongLine;
            } else {
                this.span = this.span.substring(0, width + 1);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder);
            return builder.toString();
        }

        public void toString(StringBuilder builder) {
            if (this.color != null) {
                builder.append(this.color);
            }
            builder.append(this.span);
            if (this.color != null) {
                builder.append(PrettyPrintWriter.RESET);
            }
        }

        public void append(Span other) {
            this.span = this.span + other.span;
        }

        public boolean canAppend(Span other) {
            if (this.color == null && other == null) {
                return true;
            }
            if (this.color == null && other != null) {
                return false;
            }
            return this.color.equals(other);
        }
    }

    public static final class Line {
        private List<Span> spans = new ArrayList<Span>();
        private int length;

        public void append(Span span) {
            this.length += span.length();
            if (this.spans.isEmpty()) {
                this.spans.add(span);
                return;
            }
            Span last = this.spans.get(this.spans.size() - 1);
            if (last.canAppend(span)) {
                last.append(span);
            } else {
                this.spans.add(span);
            }
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public int length() {
            return this.length;
        }

        public int indexOf(char ch, int start) {
            int offset = 0;
            for (Span span : this.spans) {
                if (start > span.length()) {
                    start -= span.length();
                    continue;
                }
                int idx = span.indexOf(ch, start);
                if (idx >= 0) {
                    return offset + idx;
                }
                offset += span.length() - start;
                start = 0;
            }
            return -1;
        }

        public void spaceOut(int width, int start) {
            for (Span span : this.spans) {
                if (start > span.length()) {
                    start -= span.length();
                    continue;
                }
                span.spaceOut(width, start);
                return;
            }
        }

        public int firstNonWhiteSpace(int start) {
            return start;
        }

        public int countCharacter(char ch) {
            int result = 0;
            for (Span span : this.spans) {
                result += span.countCharacter(ch);
            }
            return result;
        }

        public void trimTo(int width, Span appendToLongLine) {
            int i = 0;
            int remaining = width;
            for (i = 0; i < this.spans.size(); ++i) {
                Span next = this.spans.get(i);
                if (next.length() > remaining) {
                    ++i;
                    next.trimTo(remaining, appendToLongLine);
                    break;
                }
                remaining -= next.length();
            }
            while (i < this.spans.size()) {
                this.spans.remove(i);
                ++i;
            }
        }

        public void toString(StringBuilder builder) {
            for (Span span : this.spans) {
                span.toString(builder);
            }
        }
    }

    public static final class Builder {
        private final OutputStream out;
        private boolean autoFlush;
        private boolean autoColumn;
        private char columnSeparator;
        private int maxColumns;
        private int columnPadding;
        private long maxBufferedLines;
        private boolean autoCrop;
        private int consoleWidth;
        private Span appendToLongLine;
        private int tabWidth;
        private boolean flushOnTab;
        private WhiteSpaceHandler whiteSpaceHandler;

        public Builder(OutputStream out) {
            this.out = out;
            this.autoFlush = false;
            this.autoColumn = false;
            this.flushOnTab = false;
            this.columnSeparator = (char)58;
            this.maxColumns = 1;
            this.columnPadding = 1;
            this.autoCrop = false;
            this.consoleWidth = DEFAULT_WIDTH;
            this.appendToLongLine = null;
            this.tabWidth = 4;
            this.whiteSpaceHandler = null;
            this.maxBufferedLines = Long.MAX_VALUE;
        }

        public Builder withAutoFlush() {
            this.autoFlush = true;
            return this;
        }

        public Builder withAutoCrop() {
            return this.withAutoCrop(DEFAULT_WIDTH);
        }

        public Builder withAutoCrop(int consoleWidth) {
            return this.withAutoCrop(consoleWidth, DEFAULT_APPEND);
        }

        public Builder withAutoCrop(int consoleWidth, String appendToLong) {
            return this.withAutoCrop(consoleWidth, PrettyPrintWriter.mkspan(appendToLong));
        }

        public Builder withAutoCrop(int consoleWidth, Span appendToLong) {
            this.consoleWidth = consoleWidth;
            this.appendToLongLine = appendToLong;
            this.autoCrop = true;
            return this;
        }

        public Builder withTabSize(int tabWidth) {
            this.tabWidth = tabWidth;
            return this;
        }

        public Builder withAutoColumn() {
            return this.withAutoColumn(':');
        }

        public Builder withAutoColumn(char columnSeparator) {
            return this.withAutoColumn(columnSeparator, 1);
        }

        public Builder withAutoColumn(char columnSeparator, int maxColumns) {
            this.autoColumn = true;
            this.columnSeparator = columnSeparator;
            this.maxColumns = maxColumns;
            return this;
        }

        public Builder withColumnPadding(int columnPadding) {
            this.columnPadding = columnPadding;
            return this;
        }

        public Builder withWhitespaceHandler(WhiteSpaceHandler whiteSpaceHandler) {
            this.whiteSpaceHandler = whiteSpaceHandler;
            return this;
        }

        public Builder withMaxBufferedLines(long maxBufferedLines) {
            this.maxBufferedLines = maxBufferedLines;
            return this;
        }

        public Builder withFlushOnTab() {
            this.flushOnTab = true;
            return this;
        }

        public PrettyPrintWriter build() {
            return new PrettyPrintWriter(this.out, this.autoFlush, this.autoColumn, this.autoCrop, this.appendToLongLine, this.consoleWidth, this.tabWidth, this.columnSeparator, this.maxColumns, this.columnPadding, this.maxBufferedLines, this.flushOnTab, this.whiteSpaceHandler);
        }
    }

    public static enum WhiteSpaceHandler {
        ELIMINATE_NEWLINES,
        COLLAPSE_WHITESPACE;

    }
}

