/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int i;
        IndexToLocationTable loc = ttf.getIndexToLocation();
        long[] offsets = loc.getOffsets();
        int numGlyphs = ttf.getNumberOfGlyphs();
        long endOfGlyphs = offsets[numGlyphs];
        long offset = this.getOffset();
        this.glyphs = new GlyphData[numGlyphs];
        for (i = 0; i < numGlyphs && endOfGlyphs != offsets[i]; ++i) {
            if (offsets[i] == offsets[i + 1]) continue;
            this.glyphs[i] = new GlyphData();
            data.seek(offset + offsets[i]);
            this.glyphs[i].initData(this, data);
        }
        for (i = 0; i < numGlyphs; ++i) {
            GlyphData glyph = this.glyphs[i];
            if (glyph == null || !glyph.getDescription().isComposite()) continue;
            glyph.getDescription().resolve();
        }
        this.initialized = true;
    }

    public GlyphData[] getGlyphs() {
        return this.glyphs;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }
}

