/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="imagetopdf", header={"Creates a PDF document from images"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class ImageToPDF
implements Callable<Integer> {
    private PDRectangle mediaBox = PDRectangle.LETTER;
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-autoOrientation"}, description={"set orientation depending of image proportion"})
    private boolean autoOrientation = false;
    @CommandLine.Option(names={"-landscape"}, description={"set orientation to landscape"})
    private boolean landscape = false;
    @CommandLine.Option(names={"-pageSize"}, description={"the page size to use: Letter, Legal, A0, A1, A2, A3, A4, A5, A6 (default: ${DEFAULT-VALUE})"})
    private String pageSize = "Letter";
    @CommandLine.Option(names={"-resize"}, description={"resize to page size"})
    private boolean resize = false;
    @CommandLine.Option(names={"-i", "--input"}, description={"the image files to convert"}, paramLabel="image-file", required=true)
    private File[] infiles;
    @CommandLine.Option(names={"-o", "--output"}, description={"the generated PDF file"}, required=true)
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new ImageToPDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        this.setMediaBox(ImageToPDF.createRectangle(this.pageSize));
        try (PDDocument doc = new PDDocument();){
            for (File imageFile : this.infiles) {
                PDImageXObject pdImage = PDImageXObject.createFromFile(imageFile.getAbsolutePath(), doc);
                PDRectangle actualMediaBox = this.mediaBox;
                if (this.autoOrientation && pdImage.getWidth() > pdImage.getHeight() || this.landscape) {
                    actualMediaBox = new PDRectangle(this.mediaBox.getHeight(), this.mediaBox.getWidth());
                }
                PDPage page = new PDPage(actualMediaBox);
                doc.addPage(page);
                try (PDPageContentStream contents = new PDPageContentStream(doc, page);){
                    if (this.resize) {
                        contents.drawImage(pdImage, 0.0f, 0.0f, actualMediaBox.getWidth(), actualMediaBox.getHeight());
                        continue;
                    }
                    contents.drawImage(pdImage, 0.0f, 0.0f, (float)pdImage.getWidth(), (float)pdImage.getHeight());
                }
            }
            doc.save(this.outfile);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error converting image to PDF [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }

    private static PDRectangle createRectangle(String paperSize) {
        if ("letter".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LETTER;
        }
        if ("legal".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LEGAL;
        }
        if ("A0".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A0;
        }
        if ("A1".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A1;
        }
        if ("A2".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A2;
        }
        if ("A3".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A3;
        }
        if ("A4".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A4;
        }
        if ("A5".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A5;
        }
        if ("A6".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A6;
        }
        return PDRectangle.LETTER;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public boolean isAutoOrientation() {
        return this.autoOrientation;
    }

    public void setAutoOrientation(boolean autoOrientation) {
        this.autoOrientation = autoOrientation;
    }
}

