/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.Component;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.pdfbox.debugger.ui.MenuBase;

public final class ZoomMenu
extends MenuBase {
    public static final String ZOOM_100_PERCENT = "100%";
    private static final int[] ZOOMS = new int[]{25, 50, 100, 200, 400};
    private static ZoomMenu instance;
    private final JMenu menu = new JMenu("Zoom");

    private ZoomMenu() {
        ButtonGroup bg = new ButtonGroup();
        for (int zoom : ZOOMS) {
            ZoomMenuItem zoomItem = new ZoomMenuItem(zoom + "%", zoom);
            bg.add(zoomItem);
            this.menu.add(zoomItem);
        }
        this.setMenu(this.menu);
    }

    public static ZoomMenu getInstance() {
        if (instance == null) {
            instance = new ZoomMenu();
        }
        return instance;
    }

    public void setZoomSelection(String selection) {
        for (Component comp : this.menu.getMenuComponents()) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)comp;
            if (!menuItem.getText().equals(selection)) continue;
            menuItem.setSelected(true);
            return;
        }
        throw new IllegalArgumentException("no zoom menu item found for: " + selection);
    }

    public static boolean isZoomMenu(String actionCommand) {
        if (!actionCommand.matches("^\\d+%$")) {
            return false;
        }
        int zoom = Integer.parseInt(actionCommand.substring(0, actionCommand.length() - 1));
        return Arrays.binarySearch(ZOOMS, zoom) >= 0;
    }

    public static float getZoomScale() {
        for (Component comp : ZoomMenu.instance.menu.getMenuComponents()) {
            ZoomMenuItem menuItem = (ZoomMenuItem)comp;
            if (!menuItem.isSelected()) continue;
            return (float)menuItem.zoom / 100.0f;
        }
        throw new IllegalStateException("no zoom menu item is selected");
    }

    private static class ZoomMenuItem
    extends JRadioButtonMenuItem {
        private final int zoom;

        ZoomMenuItem(String text, int zoom) {
            super(text);
            this.zoom = zoom;
        }
    }
}

