/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateConverter {
    private static final SimpleDateFormat[] POTENTIAL_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEEE, dd MMM yyyy hh:mm:ss a"), new SimpleDateFormat("EEEE, MMM dd, yyyy hh:mm:ss a"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz")};

    protected DateConverter() {
    }

    public static Calendar toCalendar(String date) throws IOException {
        GregorianCalendar retval;
        block26: {
            retval = null;
            if (date != null && date.trim().length() > 0) {
                int year = 0;
                int month = 1;
                int day = 1;
                int hour = 0;
                int minute = 0;
                int second = 0;
                try {
                    SimpleTimeZone zone = null;
                    if (date.startsWith("D:")) {
                        date = date.substring(2, date.length());
                    }
                    if ((date = date.replaceAll("[-:T]", "")).length() < 4) {
                        throw new IOException("Error: Invalid date format '" + date + "'");
                    }
                    year = Integer.parseInt(date.substring(0, 4));
                    if (date.length() >= 6) {
                        month = Integer.parseInt(date.substring(4, 6));
                    }
                    if (date.length() >= 8) {
                        day = Integer.parseInt(date.substring(6, 8));
                    }
                    if (date.length() >= 10) {
                        hour = Integer.parseInt(date.substring(8, 10));
                    }
                    if (date.length() >= 12) {
                        minute = Integer.parseInt(date.substring(10, 12));
                    }
                    int timeZonePos = 12;
                    if (date.length() - 12 > 5 || date.length() - 12 == 3 && date.endsWith("Z")) {
                        if (date.length() >= 14) {
                            second = Integer.parseInt(date.substring(12, 14));
                        }
                        timeZonePos = 14;
                    } else {
                        second = 0;
                    }
                    if (date.length() >= timeZonePos + 1) {
                        char sign = date.charAt(timeZonePos);
                        if (sign == 'Z') {
                            zone = new SimpleTimeZone(0, "Unknown");
                        } else {
                            int hours = 0;
                            int minutes = 0;
                            if (date.length() >= timeZonePos + 3) {
                                hours = sign == '+' ? Integer.parseInt(date.substring(timeZonePos + 1, timeZonePos + 3)) : -Integer.parseInt(date.substring(timeZonePos, timeZonePos + 2));
                            }
                            if (sign == '+') {
                                if (date.length() >= timeZonePos + 5) {
                                    minutes = Integer.parseInt(date.substring(timeZonePos + 3, timeZonePos + 5));
                                }
                            } else if (date.length() >= timeZonePos + 4) {
                                minutes = Integer.parseInt(date.substring(timeZonePos + 2, timeZonePos + 4));
                            }
                            zone = new SimpleTimeZone(hours * 60 * 60 * 1000 + minutes * 60 * 1000, "Unknown");
                        }
                    }
                    if (zone == null) {
                        retval = new GregorianCalendar();
                    } else {
                        DateConverter.updateZoneId(zone);
                        retval = new GregorianCalendar(zone);
                    }
                    retval.clear();
                    retval.set(year, month - 1, day, hour, minute, second);
                }
                catch (NumberFormatException e) {
                    if (date.substring(date.length() - 3, date.length() - 2).equals(":") && (date.substring(date.length() - 6, date.length() - 5).equals("+") || date.substring(date.length() - 6, date.length() - 5).equals("-"))) {
                        date = date.substring(0, date.length() - 3) + date.substring(date.length() - 2);
                    }
                    for (int i = 0; retval == null && i < POTENTIAL_FORMATS.length; ++i) {
                        try {
                            Date utilDate = POTENTIAL_FORMATS[i].parse(date);
                            retval = new GregorianCalendar();
                            retval.setTime(utilDate);
                            continue;
                        }
                        catch (ParseException pe) {
                            // empty catch block
                        }
                    }
                    if (retval != null) break block26;
                    IOException ioe = new IOException("Error converting date:" + date);
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
        return retval;
    }

    private static void updateZoneId(TimeZone tz) {
        int offset = tz.getRawOffset();
        int pm = 43;
        if (offset < 0) {
            pm = 45;
            offset = -offset;
        }
        int hh = offset / 3600000;
        int mm = offset % 3600000 / 60000;
        if (offset == 0) {
            tz.setID("GMT");
        } else if (pm == 43 && hh <= 12) {
            tz.setID(String.format("GMT+%02d:%02d", hh, mm));
        } else if (pm == 45 && hh <= 14) {
            tz.setID(String.format("GMT-%02d:%02d", hh, mm));
        } else {
            tz.setID("unknown");
        }
    }

    private static void zeroAppend(StringBuffer out, int number) {
        if (number < 10) {
            out.append("0");
        }
        out.append(number);
    }

    public static String toISO8601(Calendar cal) {
        StringBuffer retval = new StringBuffer();
        retval.append(cal.get(1));
        retval.append("-");
        DateConverter.zeroAppend(retval, cal.get(2) + 1);
        retval.append("-");
        DateConverter.zeroAppend(retval, cal.get(5));
        retval.append("T");
        DateConverter.zeroAppend(retval, cal.get(11));
        retval.append(":");
        DateConverter.zeroAppend(retval, cal.get(12));
        retval.append(":");
        DateConverter.zeroAppend(retval, cal.get(13));
        int timeZone = cal.get(15) + cal.get(16);
        if (timeZone < 0) {
            retval.append("-");
        } else {
            retval.append("+");
        }
        timeZone = Math.abs(timeZone);
        int hours = timeZone / 1000 / 60 / 60;
        int minutes = (timeZone - hours * 1000 * 60 * 60) / 1000 / 1000;
        if (hours < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(hours));
        retval.append(":");
        if (minutes < 10) {
            retval.append("0");
        }
        retval.append(Integer.toString(minutes));
        return retval.toString();
    }
}

