/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$;
import org.apache.pekko.cluster.sharding.internal.LeastShardAllocationStrategy$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q<aa\u0003\u0007\t\u0002IAbA\u0002\u000e\r\u0011\u0003\u00112\u0004C\u0003#\u0003\u0011\u0005A\u0005C\u0004&\u0003\t\u0007I\u0011\u0002\u0014\t\r\r\u000b\u0001\u0015!\u0003(\r\u0015QB\u0002\u0001\nM\u0011!\u0001VA!A!\u0002\u0013\t\u0006\u0002\u0003+\u0006\u0005\u0003\u0005\u000b\u0011B+\t\u000b\t*A\u0011\u0001-\t\u000bq+A\u0011I/\t\u000be,A\u0011\t>\u000291+\u0017m\u001d;TQ\u0006\u0014H-\u00117m_\u000e\fG/[8o'R\u0014\u0018\r^3hs*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\tg\"\f'\u000fZ5oO*\u0011\u0011CE\u0001\bG2,8\u000f^3s\u0015\t\u0019B#A\u0003qK.\\wN\u0003\u0002\u0016-\u00051\u0011\r]1dQ\u0016T\u0011aF\u0001\u0004_J<\u0007CA\r\u0002\u001b\u0005a!\u0001\b'fCN$8\u000b[1sI\u0006cGn\\2bi&|gn\u0015;sCR,w-_\n\u0003\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003a\tA#Z7qif\u0014VMY1mC:\u001cWMU3tk2$X#A\u0014\u0011\u0007!ZS&D\u0001*\u0015\tQc$\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0015\u0003\r\u0019+H/\u001e:f!\rq3'N\u0007\u0002_)\u0011\u0001'M\u0001\nS6lW\u000f^1cY\u0016T!A\r\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00025_\t\u00191+\u001a;\u0011\u0005Y\u0002eBA\u001c?\u001d\tATH\u0004\u0002:y9\u0011!hO\u0007\u0002)%\u00111\u0003F\u0005\u0003#II!a\u0004\t\n\u0005}r\u0011aC*iCJ$'+Z4j_:L!!\u0011\"\u0003\u000fMC\u0017M\u001d3JI*\u0011qHD\u0001\u0016K6\u0004H/\u001f*fE\u0006d\u0017M\\2f%\u0016\u001cX\u000f\u001c;!Q\t\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002I%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005);%aC%oi\u0016\u0014h.\u00197Ba&D#\u0001A#\u0014\u0005\u0015i\u0005CA\rO\u0013\tyEB\u0001\u0013BEN$(/Y2u\u0019\u0016\f7\u000f^*iCJ$\u0017\t\u001c7pG\u0006$\u0018n\u001c8TiJ\fG/Z4z\u00035\t'm]8mkR,G*[7jiB\u0011QDU\u0005\u0003'z\u00111!\u00138u\u00035\u0011X\r\\1uSZ,G*[7jiB\u0011QDV\u0005\u0003/z\u0011a\u0001R8vE2,GcA-[7B\u0011\u0011$\u0002\u0005\u0006!\"\u0001\r!\u0015\u0005\u0006)\"\u0001\r!V\u0001\ne\u0016\u0014\u0017\r\\1oG\u0016$2AX5x!\rA3f\u0018\t\u0004A\u001e,dBA1f!\t\u0011g$D\u0001d\u0015\t!7%\u0001\u0004=e>|GOP\u0005\u0003Mz\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001bi\u0015\t1g\u0004C\u0003k\u0013\u0001\u00071.A\fdkJ\u0014XM\u001c;TQ\u0006\u0014H-\u00117m_\u000e\fG/[8ogB!\u0001\r\u001c8u\u0013\ti\u0007NA\u0002NCB\u0004\"a\u001c:\u000e\u0003AT!!\u001d\n\u0002\u000b\u0005\u001cGo\u001c:\n\u0005M\u0004(\u0001C!di>\u0014(+\u001a4\u0011\u00079*X'\u0003\u0002w_\tQ\u0011J\u001c3fq\u0016$7+Z9\t\u000baL\u0001\u0019A0\u0002'I,'-\u00197b]\u000e,\u0017J\u001c)s_\u001e\u0014Xm]:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u000e\u0015\u0003\u000b\u0015\u0003")
@InternalApi
public class LeastShardAllocationStrategy
extends AbstractLeastShardAllocationStrategy {
    private final int absoluteLimit;
    private final double relativeLimit;

    @Override
    public Future<Set<String>> rebalance(Map<ActorRef, IndexedSeq<String>> currentShardAllocations, Set<String> rebalanceInProgress) {
        if (rebalanceInProgress.nonEmpty()) {
            return LeastShardAllocationStrategy$.MODULE$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        }
        Vector sortedRegionEntries = (Vector)this.regionEntriesFor(currentShardAllocations).toVector().sorted((Ordering)AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$.MODULE$);
        if (!this.isAGoodTimeToRebalance((Iterable<AbstractLeastShardAllocationStrategy.RegionEntry>)sortedRegionEntries)) {
            return LeastShardAllocationStrategy$.MODULE$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        }
        int numberOfShards = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)sortedRegionEntries.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LeastShardAllocationStrategy.$anonfun$rebalance$4(x$1)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int numberOfRegions = sortedRegionEntries.size();
        if (numberOfRegions == 0 || numberOfShards == 0) {
            return LeastShardAllocationStrategy$.MODULE$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        }
        int optimalPerRegion = numberOfShards / numberOfRegions + (numberOfShards % numberOfRegions == 0 ? 0 : 1);
        Set result1 = this.rebalancePhase1$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
        if (result1.nonEmpty()) {
            return Future$.MODULE$.successful((Object)result1);
        }
        return this.rebalancePhase2$1(numberOfShards, optimalPerRegion, (Iterable)sortedRegionEntries);
    }

    public String toString() {
        return new StringBuilder(31).append("LeastShardAllocationStrategy(").append(this.absoluteLimit).append(",").append(this.relativeLimit).append(")").toString();
    }

    private final int limit$1(int numberOfShards) {
        return package$.MODULE$.max(1, package$.MODULE$.min((int)(this.relativeLimit * (double)numberOfShards), this.absoluteLimit));
    }

    private final Set rebalancePhase1$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
        sortedEntries.foreach((Function1 & Serializable)x0$1 -> {
            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x0$1;
            if (regionEntry != null) {
                IndexedSeq<String> shardIds = regionEntry.shardIds();
                if (shardIds.size() > optimalPerRegion) {
                    return selected.$plus$plus$eq((IterableOnce)shardIds.take(shardIds.size() - optimalPerRegion));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)regionEntry);
        });
        Vector result = (Vector)selected.result();
        return result.take(this.limit$1(numberOfShards)).toSet();
    }

    private final Future rebalancePhase2$1(int numberOfShards, int optimalPerRegion, Iterable sortedEntries) {
        int countBelowOptimal = BoxesRunTime.unboxToInt((Object)sortedEntries.iterator().map((Function1 & Serializable)entry -> BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, optimalPerRegion - 1 - entry.shardIds().size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (countBelowOptimal == 0) {
            return LeastShardAllocationStrategy$.MODULE$.org$apache$pekko$cluster$sharding$internal$LeastShardAllocationStrategy$$emptyRebalanceResult();
        }
        ReusableBuilder selected = scala.package$.MODULE$.Vector().newBuilder();
        sortedEntries.foreach((Function1 & Serializable)x0$1 -> {
            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x0$1;
            if (regionEntry != null) {
                IndexedSeq<String> shardIds = regionEntry.shardIds();
                if (shardIds.size() >= optimalPerRegion) {
                    return selected.$plus$eq(shardIds.head());
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)regionEntry);
        });
        Set result = ((Vector)selected.result()).take(package$.MODULE$.min(countBelowOptimal, this.limit$1(numberOfShards))).toSet();
        return Future$.MODULE$.successful((Object)result);
    }

    public static final /* synthetic */ int $anonfun$rebalance$4(AbstractLeastShardAllocationStrategy.RegionEntry x$1) {
        return x$1.shardIds().size();
    }

    public LeastShardAllocationStrategy(int absoluteLimit, double relativeLimit) {
        this.absoluteLimit = absoluteLimit;
        this.relativeLimit = relativeLimit;
    }
}

