/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u000514Qa\u0003\u0007\u0003%aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003=\u0001\u0011\u0005Q\bC\u0004C\u0001\t\u0007I\u0011B\"\t\r)\u0003\u0001\u0015!\u0003E\u0011\u001dY\u0005A1A\u0005\u00021Ca!\u0014\u0001!\u0002\u0013y\u0002\"\u0002(\u0001\t\u0003z\u0005\"B2\u0001\t\u0003\"'\u0001H\"vgR|Wn\u0015;bi\u0016\u001cFo\u001c:f\u001b>$W\r\u0015:pm&$WM\u001d\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\t\u0001b\u001d5be\u0012Lgn\u001a\u0006\u0003#I\tqa\u00197vgR,'O\u0003\u0002\u0014)\u0005)\u0001/Z6l_*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"\u0001\u0007\n\u0005\tb!\u0001\u0007*f[\u0016l'-\u001a:F]RLG/[3t!J|g/\u001b3fe\u0006AA/\u001f9f\u001d\u0006lWm\u0001\u0001\u0011\u0005\u0019jcBA\u0014,!\tA3$D\u0001*\u0015\tQC%\u0001\u0004=e>|GOP\u0005\u0003Ym\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011AfG\u0001\u0007gf\u001cH/Z7\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0012\u0012!B1di>\u0014\u0018B\u0001\u001c4\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u0011M,G\u000f^5oON\u0004\"!\u000f\u001e\u000e\u00039I!a\u000f\b\u0003/\rcWo\u001d;feNC\u0017M\u001d3j]\u001e\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005C\u0001\u0011\u0001\u0011\u0015\u0019C\u00011\u0001&\u0011\u0015\u0001D\u00011\u00012\u0011\u00159D\u00011\u00019\u0003\rawnZ\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\u0011qIE\u0001\u0006KZ,g\u000e^\u0005\u0003\u0013\u001a\u0013a\u0002T8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013aC2vgR|Wn\u0015;pe\u0016,\u0012aH\u0001\rGV\u001cHo\\7Ti>\u0014X\rI\u0001\u0010g\"\f'\u000fZ*u_J,\u0007K]8qgR\u0011\u0001k\u0015\t\u0003eEK!AU\u001a\u0003\u000bA\u0013x\u000e]:\t\u000bQK\u0001\u0019A+\u0002\u000fMD\u0017M\u001d3JIB\u0011a\u000b\u0019\b\u0003/zs!\u0001W/\u000f\u0005ecfB\u0001.\\\u001b\u0005!\u0012BA\n\u0015\u0013\t\t\"#\u0003\u0002\u0010!%\u0011qLD\u0001\f'\"\f'\u000f\u001a*fO&|g.\u0003\u0002bE\n91\u000b[1sI&#'BA0\u000f\u0003U\u0019wn\u001c:eS:\fGo\u001c:Ti>\u0014X\r\u0015:paN$\u0012\u0001\u0015\u0015\u0003\u0001\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002lQ\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public final class CustomStateStoreModeProvider
implements RememberEntitiesProvider {
    private final LoggingAdapter log;
    private final RememberEntitiesProvider customStore;

    private LoggingAdapter log() {
        return this.log;
    }

    public RememberEntitiesProvider customStore() {
        return this.customStore;
    }

    @Override
    public Props shardStoreProps(String shardId) {
        return this.customStore().shardStoreProps(shardId);
    }

    @Override
    public Props coordinatorStoreProps() {
        return this.customStore().coordinatorStoreProps();
    }

    public CustomStateStoreModeProvider(String typeName, ActorSystem system, ClusterShardingSettings settings) {
        this.log = Logging$.MODULE$.apply(system, CustomStateStoreModeProvider.class, LogSource$.MODULE$.fromClass());
        this.log().warning("Using custom remember entities store for [{}], not intended for production use.", (Object)typeName);
        if (!system.settings().config().hasPath("pekko.cluster.sharding.remember-entities-custom-store")) {
            this.log().error("Missing custom store class configuration for CustomStateStoreModeProvider");
            throw new RuntimeException("Missing custom store class configuration");
        }
        String customClassName = system.settings().config().getString("pekko.cluster.sharding.remember-entities-custom-store");
        Try store = ((ExtendedActorSystem)system).dynamicAccess().createInstanceFor(customClassName, (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(ClusterShardingSettings.class, (Object)settings), new Tuple2(String.class, (Object)typeName)})), ClassTag$.MODULE$.apply(RememberEntitiesProvider.class));
        this.log().debug("Will use custom remember entities store provider [{}]", (Object)store);
        this.customStore = (RememberEntitiesProvider)store.get();
    }
}

