/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.sharding.ClusterSharding$;
import org.apache.pekko.cluster.sharding.ClusterShardingGuardian;
import org.apache.pekko.cluster.sharding.ClusterShardingGuardian$Start$;
import org.apache.pekko.cluster.sharding.ClusterShardingGuardian$StartProxy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$ShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class ClusterSharding
implements Extension {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClusterSharding.class.getDeclaredField("guardian$lzy1"));
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private final ConcurrentHashMap<String, ActorRef> proxies;
    private volatile Object guardian$lzy1;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.apply(classicActorSystemProvider);
    }

    public static ClusterSharding createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterSharding$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterSharding get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return ClusterSharding$.MODULE$.get(actorSystem);
    }

    public static ClusterSharding get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return ClusterSharding$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return ClusterSharding$.MODULE$.lookup();
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterSharding.class, LogSource$.MODULE$.fromAnyClass());
        this.cluster = (Cluster)Cluster$.MODULE$.apply((ActorSystem)system);
        this.regions = new ConcurrentHashMap();
        this.proxies = new ConcurrentHashMap();
    }

    private ActorRef guardian() {
        Object object = this.guardian$lzy1;
        if (object instanceof ActorRef) {
            return (ActorRef)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ActorRef)this.guardian$lzyINIT1();
    }

    private Object guardian$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.guardian$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ActorRef actorRef = null;
                    try {
                        String guardianName = this.system.settings().config().getString("pekko.cluster.sharding.guardian-name");
                        String dispatcher = this.system.settings().config().getString("pekko.cluster.sharding.use-dispatcher");
                        actorRef = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                        object2 = actorRef == null ? LazyVals.NullValue$.MODULE$ : actorRef;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.guardian$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.guardian$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return actorRef;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable)_$1 -> entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    @InternalApi
    public ActorRef internalStart(String typeName, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        String string = settings.stateStoreMode();
        String string2 = ClusterShardingSettings$.MODULE$.StateStoreModePersistence();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log.warning("Cluster Sharding has been set to use the deprecated `persistence` state store mode.");
        }
        if (settings.shouldHostShard(this.cluster)) {
            ActorRef actorRef = this.regions.get(typeName);
            if (actorRef == null) {
                Timeout timeout = this.system.settings().CreationTimeout();
                ClusterShardingGuardian.Start startMsg = ClusterShardingGuardian$Start$.MODULE$.apply(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
                ActorRef actorRef2 = package$.MODULE$.ask(this.guardian());
                ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(actorRef2, (Object)startMsg, timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef2, (Object)startMsg)).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
                this.regions.put(typeName, shardRegion);
                return shardRegion;
            }
            ActorRef ref = actorRef;
            return ref;
        }
        this.log.debug("Starting Shard Region Proxy [{}] (no actors will be hosted on this node)...", (Object)typeName);
        return this.startProxy(typeName, settings.role(), (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable)_$2 -> entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new Serializable(messageExtractor){
            private final ShardRegion.MessageExtractor messageExtractor$1;
            {
                this.messageExtractor$1 = messageExtractor$5;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                Object msg = object;
                return this.messageExtractor$1.entityId(msg) != null;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                Object msg = object;
                if (this.messageExtractor$1.entityId(msg) != null) {
                    return Tuple2$.MODULE$.apply((Object)this.messageExtractor$1.entityId(msg), this.messageExtractor$1.entityMessage(msg));
                }
                return function1.apply(x);
            }
        }, (Function1<Object, String>)(Function1 & Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, (Object)PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ShardRegion.MessageExtractor messageExtractor) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.startProxy(typeName, role, (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef startProxy(String typeName, Option<String> role, Option<String> dataCenter, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef actorRef = this.proxies.get(this.proxyName(typeName, dataCenter));
        if (actorRef == null) {
            Timeout timeout = this.system.settings().CreationTimeout();
            ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
            ClusterShardingGuardian.StartProxy startMsg = ClusterShardingGuardian$StartProxy$.MODULE$.apply(typeName, dataCenter, settings, extractEntityId, extractShardId);
            ActorRef actorRef2 = package$.MODULE$.ask(this.guardian());
            ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(actorRef2, (Object)startMsg, timeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef2, (Object)startMsg)).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
            this.proxies.put(this.proxyName(typeName, dataCenter), shardRegion);
            return shardRegion;
        }
        ActorRef ref = actorRef;
        return ref;
    }

    private String proxyName(String typeName, Option<String> dataCenter) {
        Option<String> option = dataCenter;
        if (None$.MODULE$.equals(option)) {
            return new StringBuilder(5).append(typeName).append("Proxy").toString();
        }
        if (option instanceof Some) {
            String t = (String)((Some)option).value();
            return new StringBuilder(6).append(typeName).append("Proxy").append("-").append(t).toString();
        }
        throw new MatchError(option);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, role, Optional.empty(), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, Optional<String> dataCenter, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (Option<String>)Option$.MODULE$.apply(dataCenter.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new Serializable(messageExtractor){
            private final ShardRegion.MessageExtractor messageExtractor$3;
            {
                this.messageExtractor$3 = messageExtractor$6;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                Object msg = object;
                return this.messageExtractor$3.entityId(msg) != null;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                Object msg = object;
                if (this.messageExtractor$3.entityId(msg) != null) {
                    return Tuple2$.MODULE$.apply((Object)this.messageExtractor$3.entityId(msg), this.messageExtractor$3.entityMessage(msg));
                }
                return function1.apply(x);
            }
        }, (Function1<Object, String>)(Function1 & Serializable)msg -> messageExtractor.shardId(msg));
    }

    public scala.collection.immutable.Set<String> shardTypeNames() {
        return package.JavaConverters$.MODULE$.SetHasAsScala(this.regions.keySet()).asScala().toSet();
    }

    public Set<String> getShardTypeNames() {
        return this.regions.keySet();
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef = this.regions.get(typeName);
        if (actorRef == null) {
            ActorRef actorRef2 = this.proxies.get(this.proxyName(typeName, (Option<String>)None$.MODULE$));
            if (actorRef2 == null) {
                throw new IllegalStateException(new StringBuilder(54).append("Shard type [").append(typeName).append("] must be started first. Started ").append(this.regions.keySet()).append(" proxies ").append(this.proxies.keySet()).toString());
            }
            ActorRef ref = actorRef2;
            return ref;
        }
        ActorRef ref = actorRef;
        return ref;
    }

    public ActorRef shardRegionProxy(String typeName, String dataCenter) {
        ActorRef actorRef = this.proxies.get(this.proxyName(typeName, (Option<String>)Some$.MODULE$.apply((Object)dataCenter)));
        if (actorRef == null) {
            throw new IllegalStateException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
        }
        ActorRef ref = actorRef;
        return ref;
    }

    public ShardCoordinator.ShardAllocationStrategy defaultShardAllocationStrategy(ClusterShardingSettings settings) {
        if (settings.tuningParameters().leastShardAllocationAbsoluteLimit() > 0) {
            int absoluteLimit = settings.tuningParameters().leastShardAllocationAbsoluteLimit();
            double relativeLimit = settings.tuningParameters().leastShardAllocationRelativeLimit();
            return ShardCoordinator$ShardAllocationStrategy$.MODULE$.leastShardAllocationStrategy(absoluteLimit, relativeLimit);
        }
        int threshold = settings.tuningParameters().leastShardAllocationRebalanceThreshold();
        int maxSimultaneousRebalance = settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance();
        return new ShardCoordinator.LeastShardAllocationStrategy(threshold, maxSimultaneousRebalance);
    }
}

