/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.cluster.sharding.ClusterSharding;
import org.apache.pekko.cluster.sharding.ClusterSharding$;
import org.apache.pekko.cluster.sharding.ClusterShardingHealthCheck$;
import org.apache.pekko.cluster.sharding.ClusterShardingHealthCheckSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingHealthCheckSettings$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.cluster.sharding.ShardRegion$GetShardRegionStatus$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

@ApiMayChange
public final class ClusterShardingHealthCheck
implements Function0<Future<Object>> {
    public final ClusterShardingHealthCheckSettings org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$settings;
    private final Function1<String, ActorRef> shardRegion;
    public final LoggingAdapter org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log;
    private final Timeout timeout;
    private final ExecutionContext ec;
    private volatile boolean registered;

    public static Future<Object> Success() {
        return ClusterShardingHealthCheck$.MODULE$.Success();
    }

    public ClusterShardingHealthCheck(ActorSystem system, ClusterShardingHealthCheckSettings settings, Function1<String, ActorRef> shardRegion) {
        this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$settings = settings;
        this.shardRegion = shardRegion;
        this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log = Logging$.MODULE$.apply(system, ClusterShardingHealthCheck.class, LogSource$.MODULE$.fromAnyClass());
        this.timeout = Timeout$.MODULE$.durationToTimeout(settings.timeout());
        this.ec = system.dispatchers().internalDispatcher();
        this.registered = false;
    }

    public ClusterShardingHealthCheck(ActorSystem system) {
        this(system, ClusterShardingHealthCheckSettings$.MODULE$.apply(system.settings().config().getConfig("pekko.cluster.sharding.healthcheck")), ClusterShardingHealthCheck.ClusterShardingHealthCheck$superArg$1(system));
    }

    public Future<Object> apply() {
        if (this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$settings.names().isEmpty() || this.registered) {
            return ClusterShardingHealthCheck$.MODULE$.Success();
        }
        return Future$.MODULE$.traverse(this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$settings.names(), (Function1 & Serializable)name -> {
            ActorRef actorRef = package$.MODULE$.ask((ActorRef)this.shardRegion.apply(name));
            ShardRegion$GetShardRegionStatus$ shardRegion$GetShardRegionStatus$ = ShardRegion$GetShardRegionStatus$.MODULE$;
            return AskableActorRef$.MODULE$.ask$extension(actorRef, (Object)shardRegion$GetShardRegionStatus$, this.timeout, AskableActorRef$.MODULE$.ask$default$3$extension(actorRef, (Object)shardRegion$GetShardRegionStatus$)).mapTo(ClassTag$.MODULE$.apply(ShardRegion.ShardRegionStatus.class));
        }, BuildFrom$.MODULE$.buildFromIterableOps(), this.ec).map((Function1 & Serializable)allResponses -> {
            boolean allRegistered = allResponses.forall((Function1 & Serializable)_$1 -> _$1.registeredWithCoordinator());
            if (!allRegistered && this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log.isInfoEnabled()) {
                this.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log.info("Not all shard regions have registered with coordinator. Still to register: [{}]", (Object)((IterableOnceOps)allResponses.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(ShardRegion.ShardRegionStatus x) {
                        ShardRegion.ShardRegionStatus shardRegionStatus = x;
                        ShardRegion.ShardRegionStatus response = shardRegionStatus;
                        return !response.registeredWithCoordinator();
                    }

                    public final Object applyOrElse(ShardRegion.ShardRegionStatus x, Function1 function1) {
                        ShardRegion.ShardRegionStatus shardRegionStatus = x;
                        ShardRegion.ShardRegionStatus response = shardRegionStatus;
                        if (!response.registeredWithCoordinator()) {
                            return response.typeName();
                        }
                        return function1.apply((Object)x);
                    }
                })).mkString(","));
            }
            if (allRegistered) {
                this.registered = true;
            }
            return allRegistered;
        }, this.ec).recover((PartialFunction)new Serializable(this){
            private final /* synthetic */ ClusterShardingHealthCheck $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof AskTimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof AskTimeoutException) {
                    if (this.$outer.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log.isDebugEnabled()) {
                        this.$outer.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$log.debug("Shard regions [{}] did not respond in time. Failing health check.", (Object)this.$outer.org$apache$pekko$cluster$sharding$ClusterShardingHealthCheck$$settings.names().mkString(","));
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                }
                return function1.apply((Object)x);
            }
        }, this.ec);
    }

    private static Function1<String, ActorRef> ClusterShardingHealthCheck$superArg$1(ActorSystem system) {
        return (Function1 & Serializable)name -> ((ClusterSharding)ClusterSharding$.MODULE$.apply(system)).shardRegion((String)name);
    }
}

