/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$CompositePassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$IdlePassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$NoPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings$;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.ModuleSerializationProxy;

public final class ClusterShardingSettings$
implements Serializable {
    private static final String StateStoreModePersistence;
    private static final String StateStoreModeDData;
    @InternalApi
    private static final String RememberEntitiesStoreCustom;
    @InternalApi
    private static final String RememberEntitiesStoreDData;
    @InternalApi
    private static final String RememberEntitiesStoreEventsourced;
    @ApiMayChange
    public static final ClusterShardingSettings$PassivationStrategySettings$ PassivationStrategySettings;
    @InternalApi
    public static final ClusterShardingSettings$NoPassivationStrategy$ NoPassivationStrategy;
    @InternalApi
    public static final ClusterShardingSettings$IdlePassivationStrategy$ IdlePassivationStrategy;
    @InternalApi
    public static final ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$ LeastRecentlyUsedPassivationStrategy;
    public static final ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$ MostRecentlyUsedPassivationStrategy;
    @InternalApi
    public static final ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$ LeastFrequentlyUsedPassivationStrategy;
    @InternalApi
    public static final ClusterShardingSettings$CompositePassivationStrategy$ CompositePassivationStrategy;
    @InternalApi
    public static final ClusterShardingSettings$PassivationStrategy$ PassivationStrategy;
    public static final ClusterShardingSettings$ MODULE$;

    private ClusterShardingSettings$() {
    }

    static {
        MODULE$ = new ClusterShardingSettings$();
        StateStoreModePersistence = "persistence";
        StateStoreModeDData = "ddata";
        RememberEntitiesStoreCustom = "custom";
        RememberEntitiesStoreDData = "ddata";
        RememberEntitiesStoreEventsourced = "eventsourced";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ClusterShardingSettings$.class);
    }

    public String StateStoreModePersistence() {
        return StateStoreModePersistence;
    }

    public String StateStoreModeDData() {
        return StateStoreModeDData;
    }

    public String RememberEntitiesStoreCustom() {
        return RememberEntitiesStoreCustom;
    }

    public String RememberEntitiesStoreDData() {
        return RememberEntitiesStoreDData;
    }

    public String RememberEntitiesStoreEventsourced() {
        return RememberEntitiesStoreEventsourced;
    }

    public ClusterShardingSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("pekko.cluster.sharding"));
    }

    public ClusterShardingSettings apply(Config config) {
        None$ none$;
        ClusterShardingSettings.TuningParameters tuningParameters = new ClusterShardingSettings.TuningParameters(new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("coordinator-failure-backoff", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("retry-interval", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("buffer-size"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("handoff-timeout", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-start-timeout", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-failure-backoff", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("entity-restart-backoff", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("rebalance-interval", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("snapshot-after"), config.getInt("keep-nr-of-batches"), config.getInt("least-shard-allocation-strategy.rebalance-threshold"), config.getInt("least-shard-allocation-strategy.max-simultaneous-rebalance"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("waiting-for-state-timeout", package$.MODULE$.MILLISECONDS()))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("updating-state-timeout", package$.MODULE$.MILLISECONDS()))).millis(), config.getString("entity-recovery-strategy"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("entity-recovery-constant-rate-strategy.frequency", package$.MODULE$.MILLISECONDS()))).millis(), config.getInt("entity-recovery-constant-rate-strategy.number-of-entities"), this.configMajorityPlus$1(config, "coordinator-state.write-majority-plus"), this.configMajorityPlus$1(config, "coordinator-state.read-majority-plus"), config.getInt("least-shard-allocation-strategy.rebalance-absolute-limit"), config.getDouble("least-shard-allocation-strategy.rebalance-relative-limit"));
        ClusterSingletonManagerSettings coordinatorSingletonSettings = ClusterSingletonManagerSettings$.MODULE$.apply(config.getConfig("coordinator-singleton"));
        ClusterShardingSettings.PassivationStrategySettings passivationStrategySettings = ClusterShardingSettings$PassivationStrategySettings$.MODULE$.fromSharding(config);
        String string = config.getString("use-lease");
        String s = string;
        if (s.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String other = string;
            none$ = Some$.MODULE$.apply((Object)new LeaseUsageSettings(other, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("lease-retry-interval")))));
        }
        None$ lease = none$;
        return new ClusterShardingSettings(this.roleOption(config.getString("role")), config.getBoolean("remember-entities"), config.getString("journal-plugin-id"), config.getString("snapshot-plugin-id"), config.getString("state-store-mode"), config.getString("remember-entities-store"), passivationStrategySettings, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-region-query-timeout", package$.MODULE$.MILLISECONDS()))).millis(), tuningParameters, config.getBoolean("coordinator-singleton-role-override"), coordinatorSingletonSettings, (Option<LeaseUsageSettings>)lease);
    }

    public ClusterShardingSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public ClusterShardingSettings create(Config config) {
        return this.apply(config);
    }

    public Option<String> roleOption(String role) {
        String string = role;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)role);
    }

    private final int configMajorityPlus$1(Config config$1, String p) {
        String string = Helpers$.MODULE$.toRootLowerCase(config$1.getString(p));
        if ("all".equals(string)) {
            return Integer.MAX_VALUE;
        }
        return config$1.getInt(p);
    }
}

