/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.List;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$CompositePassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$CompositePassivationStrategy$AdmissionFilter$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$CompositePassivationStrategy$AdmissionOptimizer$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$IdlePassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$FilterSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$WindowSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$IdleSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$LeastFrequentlyUsedSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$SegmentedSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$MostRecentlyUsedSettings$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$PolicySettings$;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import org.apache.pekko.japi.Util$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ClusterShardingSettings
implements NoSerializationVerificationNeeded {
    private final Option role;
    private final boolean rememberEntities;
    private final String journalPluginId;
    private final String snapshotPluginId;
    private final String stateStoreMode;
    private final String rememberEntitiesStore;
    private final PassivationStrategySettings passivationStrategySettings;
    private final FiniteDuration shardRegionQueryTimeout;
    private final TuningParameters tuningParameters;
    private final boolean coordinatorSingletonOverrideRole;
    private final ClusterSingletonManagerSettings coordinatorSingletonSettings;
    private final Option leaseSettings;
    @InternalApi
    private final PassivationStrategy passivationStrategy;

    public static String RememberEntitiesStoreCustom() {
        return ClusterShardingSettings$.MODULE$.RememberEntitiesStoreCustom();
    }

    public static String RememberEntitiesStoreDData() {
        return ClusterShardingSettings$.MODULE$.RememberEntitiesStoreDData();
    }

    public static String RememberEntitiesStoreEventsourced() {
        return ClusterShardingSettings$.MODULE$.RememberEntitiesStoreEventsourced();
    }

    public static String StateStoreModeDData() {
        return ClusterShardingSettings$.MODULE$.StateStoreModeDData();
    }

    public static String StateStoreModePersistence() {
        return ClusterShardingSettings$.MODULE$.StateStoreModePersistence();
    }

    public static ClusterShardingSettings apply(ActorSystem actorSystem) {
        return ClusterShardingSettings$.MODULE$.apply(actorSystem);
    }

    public static ClusterShardingSettings apply(Config config) {
        return ClusterShardingSettings$.MODULE$.apply(config);
    }

    public static ClusterShardingSettings create(ActorSystem actorSystem) {
        return ClusterShardingSettings$.MODULE$.create(actorSystem);
    }

    public static ClusterShardingSettings create(Config config) {
        return ClusterShardingSettings$.MODULE$.create(config);
    }

    public static Option<String> roleOption(String string) {
        return ClusterShardingSettings$.MODULE$.roleOption(string);
    }

    /*
     * Unable to fully structure code
     */
    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, String rememberEntitiesStore, PassivationStrategySettings passivationStrategySettings, FiniteDuration shardRegionQueryTimeout, TuningParameters tuningParameters, boolean coordinatorSingletonOverrideRole, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        this.role = role;
        this.rememberEntities = rememberEntities;
        this.journalPluginId = journalPluginId;
        this.snapshotPluginId = snapshotPluginId;
        this.stateStoreMode = stateStoreMode;
        this.rememberEntitiesStore = rememberEntitiesStore;
        this.passivationStrategySettings = passivationStrategySettings;
        this.shardRegionQueryTimeout = shardRegionQueryTimeout;
        this.tuningParameters = tuningParameters;
        this.coordinatorSingletonOverrideRole = coordinatorSingletonOverrideRole;
        this.coordinatorSingletonSettings = coordinatorSingletonSettings;
        this.leaseSettings = leaseSettings;
        super();
        v0 = stateStoreMode;
        var13_13 = ClusterShardingSettings$.MODULE$.StateStoreModePersistence();
        if (!(v0 == null ? var13_13 != null : v0.equals(var13_13) == false)) ** GOTO lbl-1000
        v1 = stateStoreMode;
        var14_14 = ClusterShardingSettings$.MODULE$.StateStoreModeDData();
        if (!(v1 == null ? var14_14 != null : v1.equals(var14_14) == false)) ** GOTO lbl-1000
        v2 = stateStoreMode;
        var15_15 = ClusterShardingSettings$.MODULE$.RememberEntitiesStoreCustom();
        if (!(v2 != null ? v2.equals(var15_15) == false : var15_15 != null)) lbl-1000:
        // 3 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        Predef$.MODULE$.require(v3, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$1(java.lang.String ), ()Ljava/lang/Object;)((String)stateStoreMode));
        this.passivationStrategy = ClusterShardingSettings$PassivationStrategy$.MODULE$.apply(this);
    }

    public Option<String> role() {
        return this.role;
    }

    public boolean rememberEntities() {
        return this.rememberEntities;
    }

    public String journalPluginId() {
        return this.journalPluginId;
    }

    public String snapshotPluginId() {
        return this.snapshotPluginId;
    }

    public String stateStoreMode() {
        return this.stateStoreMode;
    }

    public String rememberEntitiesStore() {
        return this.rememberEntitiesStore;
    }

    public PassivationStrategySettings passivationStrategySettings() {
        return this.passivationStrategySettings;
    }

    public FiniteDuration shardRegionQueryTimeout() {
        return this.shardRegionQueryTimeout;
    }

    public TuningParameters tuningParameters() {
        return this.tuningParameters;
    }

    public boolean coordinatorSingletonOverrideRole() {
        return this.coordinatorSingletonOverrideRole;
    }

    public ClusterSingletonManagerSettings coordinatorSingletonSettings() {
        return this.coordinatorSingletonSettings;
    }

    public Option<LeaseUsageSettings> leaseSettings() {
        return this.leaseSettings;
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, String rememberEntitiesStore, PassivationStrategySettings passivationStrategySettings, FiniteDuration shardRegionQueryTimeout, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, rememberEntitiesStore, passivationStrategySettings, shardRegionQueryTimeout, tuningParameters, true, coordinatorSingletonSettings, leaseSettings);
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, String rememberEntitiesStore, FiniteDuration passivateIdleEntityAfter, FiniteDuration shardRegionQueryTimeout, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, rememberEntitiesStore, ClusterShardingSettings$PassivationStrategySettings$.MODULE$.oldDefault(passivateIdleEntityAfter), shardRegionQueryTimeout, tuningParameters, true, coordinatorSingletonSettings, leaseSettings);
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, FiniteDuration passivateIdleEntityAfter, FiniteDuration shardRegionQueryTimeout, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, "ddata", passivateIdleEntityAfter, shardRegionQueryTimeout, tuningParameters, coordinatorSingletonSettings, leaseSettings);
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, FiniteDuration passivateIdleEntityAfter, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, passivateIdleEntityAfter, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), tuningParameters, coordinatorSingletonSettings, leaseSettings);
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, FiniteDuration passivateIdleEntityAfter, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, passivateIdleEntityAfter, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), tuningParameters, coordinatorSingletonSettings, (Option<LeaseUsageSettings>)None$.MODULE$);
    }

    public ClusterShardingSettings(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, TuningParameters tuningParameters, ClusterSingletonManagerSettings coordinatorSingletonSettings) {
        this(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, Duration$.MODULE$.Zero(), tuningParameters, coordinatorSingletonSettings);
    }

    @InternalApi
    public boolean shouldHostShard(Cluster cluster) {
        Set set = cluster.selfMember().roles();
        return this.role().forall((Function1 & Serializable)elem -> set.contains(elem));
    }

    public PassivationStrategy passivationStrategy() {
        return this.passivationStrategy;
    }

    public ClusterShardingSettings withRole(String role) {
        return this.copy(ClusterShardingSettings$.MODULE$.roleOption(role), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withRole(Option<String> role) {
        return this.copy(role, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withRememberEntities(boolean rememberEntities) {
        return this.copy(this.copy$default$1(), rememberEntities, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withJournalPluginId(String journalPluginId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), journalPluginId, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withSnapshotPluginId(String snapshotPluginId) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), snapshotPluginId, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withTuningParameters(TuningParameters tuningParameters) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), tuningParameters, this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withStateStoreMode(String stateStoreMode) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), stateStoreMode, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public FiniteDuration passivateIdleEntityAfter() {
        return (FiniteDuration)this.passivationStrategySettings().idleEntitySettings().fold(ClusterShardingSettings::passivateIdleEntityAfter$$anonfun$1, (Function1 & Serializable)_$9 -> _$9.timeout());
    }

    public ClusterShardingSettings withPassivateIdleAfter(FiniteDuration duration) {
        PassivationStrategySettings passivationStrategySettings = this.passivationStrategySettings().withOldIdleStrategy(duration);
        Option<String> option = this.copy$default$1();
        boolean bl = this.copy$default$2();
        String string = this.copy$default$3();
        String string2 = this.copy$default$4();
        String string3 = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$7();
        TuningParameters tuningParameters = this.copy$default$8();
        boolean bl2 = this.copy$default$9();
        ClusterSingletonManagerSettings clusterSingletonManagerSettings = this.copy$default$10();
        Option<LeaseUsageSettings> option2 = this.copy$default$11();
        return this.copy(option, bl, string, string2, string3, passivationStrategySettings, finiteDuration, tuningParameters, bl2, clusterSingletonManagerSettings, option2);
    }

    public ClusterShardingSettings withPassivateIdleAfter(Duration duration) {
        PassivationStrategySettings passivationStrategySettings = this.passivationStrategySettings().withOldIdleStrategy(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(duration)));
        Option<String> option = this.copy$default$1();
        boolean bl = this.copy$default$2();
        String string = this.copy$default$3();
        String string2 = this.copy$default$4();
        String string3 = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$7();
        TuningParameters tuningParameters = this.copy$default$8();
        boolean bl2 = this.copy$default$9();
        ClusterSingletonManagerSettings clusterSingletonManagerSettings = this.copy$default$10();
        Option<LeaseUsageSettings> option2 = this.copy$default$11();
        return this.copy(option, bl, string, string2, string3, passivationStrategySettings, finiteDuration, tuningParameters, bl2, clusterSingletonManagerSettings, option2);
    }

    @ApiMayChange
    public ClusterShardingSettings withPassivationStrategy(PassivationStrategySettings settings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), settings, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withNoPassivationStrategy() {
        PassivationStrategySettings passivationStrategySettings = ClusterShardingSettings$PassivationStrategySettings$.MODULE$.disabled();
        Option<String> option = this.copy$default$1();
        boolean bl = this.copy$default$2();
        String string = this.copy$default$3();
        String string2 = this.copy$default$4();
        String string3 = this.copy$default$5();
        FiniteDuration finiteDuration = this.copy$default$7();
        TuningParameters tuningParameters = this.copy$default$8();
        boolean bl2 = this.copy$default$9();
        ClusterSingletonManagerSettings clusterSingletonManagerSettings = this.copy$default$10();
        Option<LeaseUsageSettings> option2 = this.copy$default$11();
        return this.copy(option, bl, string, string2, string3, passivationStrategySettings, finiteDuration, tuningParameters, bl2, clusterSingletonManagerSettings, option2);
    }

    public ClusterShardingSettings withShardRegionQueryTimeout(FiniteDuration duration) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), duration, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
    }

    public ClusterShardingSettings withShardRegionQueryTimeout(Duration duration) {
        FiniteDuration finiteDuration = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(duration));
        Option<String> option = this.copy$default$1();
        boolean bl = this.copy$default$2();
        String string = this.copy$default$3();
        String string2 = this.copy$default$4();
        String string3 = this.copy$default$5();
        PassivationStrategySettings passivationStrategySettings = this.copy$default$6();
        TuningParameters tuningParameters = this.copy$default$8();
        boolean bl2 = this.copy$default$9();
        ClusterSingletonManagerSettings clusterSingletonManagerSettings = this.copy$default$10();
        Option<LeaseUsageSettings> option2 = this.copy$default$11();
        return this.copy(option, bl, string, string2, string3, passivationStrategySettings, finiteDuration, tuningParameters, bl2, clusterSingletonManagerSettings, option2);
    }

    public ClusterShardingSettings withLeaseSettings(LeaseUsageSettings leaseSettings) {
        Some some = Some$.MODULE$.apply((Object)leaseSettings);
        Option<String> option = this.copy$default$1();
        boolean bl = this.copy$default$2();
        String string = this.copy$default$3();
        String string2 = this.copy$default$4();
        String string3 = this.copy$default$5();
        PassivationStrategySettings passivationStrategySettings = this.copy$default$6();
        FiniteDuration finiteDuration = this.copy$default$7();
        TuningParameters tuningParameters = this.copy$default$8();
        boolean bl2 = this.copy$default$9();
        ClusterSingletonManagerSettings clusterSingletonManagerSettings = this.copy$default$10();
        return this.copy(option, bl, string, string2, string3, passivationStrategySettings, finiteDuration, tuningParameters, bl2, clusterSingletonManagerSettings, (Option<LeaseUsageSettings>)some);
    }

    public ClusterShardingSettings withCoordinatorSingletonSettings(ClusterSingletonManagerSettings coordinatorSingletonSettings) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), coordinatorSingletonSettings, this.copy$default$11());
    }

    private ClusterShardingSettings copy(Option<String> role, boolean rememberEntities, String journalPluginId, String snapshotPluginId, String stateStoreMode, PassivationStrategySettings passivationStrategySettings, FiniteDuration shardRegionQueryTimeout, TuningParameters tuningParameters, boolean coordinatorSingletonOverrideRole, ClusterSingletonManagerSettings coordinatorSingletonSettings, Option<LeaseUsageSettings> leaseSettings) {
        return new ClusterShardingSettings(role, rememberEntities, journalPluginId, snapshotPluginId, stateStoreMode, this.rememberEntitiesStore(), passivationStrategySettings, shardRegionQueryTimeout, tuningParameters, coordinatorSingletonOverrideRole, coordinatorSingletonSettings, leaseSettings);
    }

    private Option<String> copy$default$1() {
        return this.role();
    }

    private boolean copy$default$2() {
        return this.rememberEntities();
    }

    private String copy$default$3() {
        return this.journalPluginId();
    }

    private String copy$default$4() {
        return this.snapshotPluginId();
    }

    private String copy$default$5() {
        return this.stateStoreMode();
    }

    private PassivationStrategySettings copy$default$6() {
        return this.passivationStrategySettings();
    }

    private FiniteDuration copy$default$7() {
        return this.shardRegionQueryTimeout();
    }

    private TuningParameters copy$default$8() {
        return this.tuningParameters();
    }

    private boolean copy$default$9() {
        return this.coordinatorSingletonOverrideRole();
    }

    private ClusterSingletonManagerSettings copy$default$10() {
        return this.coordinatorSingletonSettings();
    }

    private Option<LeaseUsageSettings> copy$default$11() {
        return this.leaseSettings();
    }

    private static final Object $init$$$anonfun$1(String stateStoreMode$6) {
        return new StringBuilder(56).append("Unknown 'state-store-mode' [").append(stateStoreMode$6).append("], valid values are '").append(ClusterShardingSettings$.MODULE$.StateStoreModeDData()).append("' or '").append(ClusterShardingSettings$.MODULE$.StateStoreModePersistence()).append("'").toString();
    }

    private static final FiniteDuration passivateIdleEntityAfter$$anonfun$1() {
        return Duration$.MODULE$.Zero();
    }

    @InternalApi
    public static class CompositePassivationStrategy
    implements PassivationStrategy,
    Product,
    Serializable {
        private final int limit;
        private final PassivationStrategy mainStrategy;
        private final PassivationStrategy windowStrategy;
        private final double initialWindowProportion;
        private final double minimumWindowProportion;
        private final double maximumWindowProportion;
        private final AdmissionOptimizer windowOptimizer;
        private final AdmissionFilter admissionFilter;
        private final Option idle;

        public static CompositePassivationStrategy apply(int n, Option<PassivationStrategySettings.PolicySettings> option, PassivationStrategySettings.AdmissionSettings admissionSettings, Option<IdlePassivationStrategy> option2) {
            return ClusterShardingSettings$CompositePassivationStrategy$.MODULE$.apply(n, option, admissionSettings, option2);
        }

        public static CompositePassivationStrategy apply(int n, PassivationStrategy passivationStrategy, PassivationStrategy passivationStrategy2, double d, double d2, double d3, AdmissionOptimizer admissionOptimizer, AdmissionFilter admissionFilter, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$CompositePassivationStrategy$.MODULE$.apply(n, passivationStrategy, passivationStrategy2, d, d2, d3, admissionOptimizer, admissionFilter, option);
        }

        public static CompositePassivationStrategy fromProduct(Product product) {
            return ClusterShardingSettings$CompositePassivationStrategy$.MODULE$.fromProduct(product);
        }

        public static CompositePassivationStrategy unapply(CompositePassivationStrategy compositePassivationStrategy) {
            return ClusterShardingSettings$CompositePassivationStrategy$.MODULE$.unapply(compositePassivationStrategy);
        }

        public CompositePassivationStrategy(int limit, PassivationStrategy mainStrategy, PassivationStrategy windowStrategy, double initialWindowProportion, double minimumWindowProportion, double maximumWindowProportion, AdmissionOptimizer windowOptimizer, AdmissionFilter admissionFilter, Option<IdlePassivationStrategy> idle) {
            this.limit = limit;
            this.mainStrategy = mainStrategy;
            this.windowStrategy = windowStrategy;
            this.initialWindowProportion = initialWindowProportion;
            this.minimumWindowProportion = minimumWindowProportion;
            this.maximumWindowProportion = maximumWindowProportion;
            this.windowOptimizer = windowOptimizer;
            this.admissionFilter = admissionFilter;
            this.idle = idle;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.limit());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.mainStrategy()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.windowStrategy()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.initialWindowProportion()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minimumWindowProportion()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maximumWindowProportion()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.windowOptimizer()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.admissionFilter()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idle()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompositePassivationStrategy)) return false;
            CompositePassivationStrategy compositePassivationStrategy = (CompositePassivationStrategy)object;
            if (this.limit() != compositePassivationStrategy.limit()) return false;
            if (this.initialWindowProportion() != compositePassivationStrategy.initialWindowProportion()) return false;
            if (this.minimumWindowProportion() != compositePassivationStrategy.minimumWindowProportion()) return false;
            if (this.maximumWindowProportion() != compositePassivationStrategy.maximumWindowProportion()) return false;
            PassivationStrategy passivationStrategy = this.mainStrategy();
            PassivationStrategy passivationStrategy2 = compositePassivationStrategy.mainStrategy();
            if (passivationStrategy == null) {
                if (passivationStrategy2 != null) {
                    return false;
                }
            } else if (!passivationStrategy.equals(passivationStrategy2)) return false;
            PassivationStrategy passivationStrategy3 = this.windowStrategy();
            PassivationStrategy passivationStrategy4 = compositePassivationStrategy.windowStrategy();
            if (passivationStrategy3 == null) {
                if (passivationStrategy4 != null) {
                    return false;
                }
            } else if (!passivationStrategy3.equals(passivationStrategy4)) return false;
            AdmissionOptimizer admissionOptimizer = this.windowOptimizer();
            AdmissionOptimizer admissionOptimizer2 = compositePassivationStrategy.windowOptimizer();
            if (admissionOptimizer == null) {
                if (admissionOptimizer2 != null) {
                    return false;
                }
            } else if (!admissionOptimizer.equals(admissionOptimizer2)) return false;
            AdmissionFilter admissionFilter = this.admissionFilter();
            AdmissionFilter admissionFilter2 = compositePassivationStrategy.admissionFilter();
            if (admissionFilter == null) {
                if (admissionFilter2 != null) {
                    return false;
                }
            } else if (!admissionFilter.equals(admissionFilter2)) return false;
            Option<IdlePassivationStrategy> option = this.idle();
            Option<IdlePassivationStrategy> option2 = compositePassivationStrategy.idle();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!compositePassivationStrategy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompositePassivationStrategy;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "CompositePassivationStrategy";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToDouble((double)this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "limit";
                }
                case 1: {
                    return "mainStrategy";
                }
                case 2: {
                    return "windowStrategy";
                }
                case 3: {
                    return "initialWindowProportion";
                }
                case 4: {
                    return "minimumWindowProportion";
                }
                case 5: {
                    return "maximumWindowProportion";
                }
                case 6: {
                    return "windowOptimizer";
                }
                case 7: {
                    return "admissionFilter";
                }
                case 8: {
                    return "idle";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int limit() {
            return this.limit;
        }

        public PassivationStrategy mainStrategy() {
            return this.mainStrategy;
        }

        public PassivationStrategy windowStrategy() {
            return this.windowStrategy;
        }

        public double initialWindowProportion() {
            return this.initialWindowProportion;
        }

        public double minimumWindowProportion() {
            return this.minimumWindowProportion;
        }

        public double maximumWindowProportion() {
            return this.maximumWindowProportion;
        }

        public AdmissionOptimizer windowOptimizer() {
            return this.windowOptimizer;
        }

        public AdmissionFilter admissionFilter() {
            return this.admissionFilter;
        }

        public Option<IdlePassivationStrategy> idle() {
            return this.idle;
        }

        public CompositePassivationStrategy copy(int limit, PassivationStrategy mainStrategy, PassivationStrategy windowStrategy, double initialWindowProportion, double minimumWindowProportion, double maximumWindowProportion, AdmissionOptimizer windowOptimizer, AdmissionFilter admissionFilter, Option<IdlePassivationStrategy> idle) {
            return new CompositePassivationStrategy(limit, mainStrategy, windowStrategy, initialWindowProportion, minimumWindowProportion, maximumWindowProportion, windowOptimizer, admissionFilter, idle);
        }

        public int copy$default$1() {
            return this.limit();
        }

        public PassivationStrategy copy$default$2() {
            return this.mainStrategy();
        }

        public PassivationStrategy copy$default$3() {
            return this.windowStrategy();
        }

        public double copy$default$4() {
            return this.initialWindowProportion();
        }

        public double copy$default$5() {
            return this.minimumWindowProportion();
        }

        public double copy$default$6() {
            return this.maximumWindowProportion();
        }

        public AdmissionOptimizer copy$default$7() {
            return this.windowOptimizer();
        }

        public AdmissionFilter copy$default$8() {
            return this.admissionFilter();
        }

        public Option<IdlePassivationStrategy> copy$default$9() {
            return this.idle();
        }

        public int _1() {
            return this.limit();
        }

        public PassivationStrategy _2() {
            return this.mainStrategy();
        }

        public PassivationStrategy _3() {
            return this.windowStrategy();
        }

        public double _4() {
            return this.initialWindowProportion();
        }

        public double _5() {
            return this.minimumWindowProportion();
        }

        public double _6() {
            return this.maximumWindowProportion();
        }

        public AdmissionOptimizer _7() {
            return this.windowOptimizer();
        }

        public AdmissionFilter _8() {
            return this.admissionFilter();
        }

        public Option<IdlePassivationStrategy> _9() {
            return this.idle();
        }

        public static interface AdmissionFilter {
            public static AdmissionFilter apply(Option<PassivationStrategySettings.AdmissionSettings.FilterSettings> option) {
                return ClusterShardingSettings$CompositePassivationStrategy$AdmissionFilter$.MODULE$.apply(option);
            }

            public static int ordinal(AdmissionFilter admissionFilter) {
                return ClusterShardingSettings$CompositePassivationStrategy$AdmissionFilter$.MODULE$.ordinal(admissionFilter);
            }
        }

        public static interface AdmissionOptimizer {
            public static AdmissionOptimizer apply(Option<PassivationStrategySettings.AdmissionSettings.OptimizerSettings> option) {
                return ClusterShardingSettings$CompositePassivationStrategy$AdmissionOptimizer$.MODULE$.apply(option);
            }

            public static int ordinal(AdmissionOptimizer admissionOptimizer) {
                return ClusterShardingSettings$CompositePassivationStrategy$AdmissionOptimizer$.MODULE$.ordinal(admissionOptimizer);
            }
        }
    }

    @InternalApi
    public static class IdlePassivationStrategy
    implements PassivationStrategy,
    Product,
    Serializable {
        private final FiniteDuration timeout;
        private final FiniteDuration interval;

        public static IdlePassivationStrategy apply(FiniteDuration finiteDuration, FiniteDuration finiteDuration2) {
            return ClusterShardingSettings$IdlePassivationStrategy$.MODULE$.apply(finiteDuration, finiteDuration2);
        }

        public static IdlePassivationStrategy apply(PassivationStrategySettings.IdleSettings idleSettings) {
            return ClusterShardingSettings$IdlePassivationStrategy$.MODULE$.apply(idleSettings);
        }

        public static IdlePassivationStrategy fromProduct(Product product) {
            return ClusterShardingSettings$IdlePassivationStrategy$.MODULE$.fromProduct(product);
        }

        public static IdlePassivationStrategy unapply(IdlePassivationStrategy idlePassivationStrategy) {
            return ClusterShardingSettings$IdlePassivationStrategy$.MODULE$.unapply(idlePassivationStrategy);
        }

        public IdlePassivationStrategy(FiniteDuration timeout, FiniteDuration interval) {
            this.timeout = timeout;
            this.interval = interval;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IdlePassivationStrategy)) return false;
            IdlePassivationStrategy idlePassivationStrategy = (IdlePassivationStrategy)object;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = idlePassivationStrategy.timeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.interval();
            FiniteDuration finiteDuration4 = idlePassivationStrategy.interval();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!finiteDuration3.equals(finiteDuration4)) return false;
            if (!idlePassivationStrategy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof IdlePassivationStrategy;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "IdlePassivationStrategy";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            if (1 == n2) {
                return "interval";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public FiniteDuration interval() {
            return this.interval;
        }

        public IdlePassivationStrategy copy(FiniteDuration timeout, FiniteDuration interval) {
            return new IdlePassivationStrategy(timeout, interval);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public FiniteDuration copy$default$2() {
            return this.interval();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }

        public FiniteDuration _2() {
            return this.interval();
        }
    }

    @InternalApi
    public static class LeastFrequentlyUsedPassivationStrategy
    implements PassivationStrategy,
    Product,
    Serializable {
        private final int limit;
        private final boolean dynamicAging;
        private final Option idle;

        public static LeastFrequentlyUsedPassivationStrategy apply(int n, boolean bl, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$.MODULE$.apply(n, bl, option);
        }

        public static LeastFrequentlyUsedPassivationStrategy apply(PassivationStrategySettings.LeastFrequentlyUsedSettings leastFrequentlyUsedSettings, int n, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$.MODULE$.apply(leastFrequentlyUsedSettings, n, option);
        }

        public static LeastFrequentlyUsedPassivationStrategy fromProduct(Product product) {
            return ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$.MODULE$.fromProduct(product);
        }

        public static LeastFrequentlyUsedPassivationStrategy unapply(LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy) {
            return ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$.MODULE$.unapply(leastFrequentlyUsedPassivationStrategy);
        }

        public LeastFrequentlyUsedPassivationStrategy(int limit, boolean dynamicAging, Option<IdlePassivationStrategy> idle) {
            this.limit = limit;
            this.dynamicAging = dynamicAging;
            this.idle = idle;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.limit());
            n = Statics.mix((int)n, (int)(this.dynamicAging() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idle()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LeastFrequentlyUsedPassivationStrategy)) return false;
            LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = (LeastFrequentlyUsedPassivationStrategy)object;
            if (this.limit() != leastFrequentlyUsedPassivationStrategy.limit()) return false;
            if (this.dynamicAging() != leastFrequentlyUsedPassivationStrategy.dynamicAging()) return false;
            Option<IdlePassivationStrategy> option = this.idle();
            Option<IdlePassivationStrategy> option2 = leastFrequentlyUsedPassivationStrategy.idle();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!leastFrequentlyUsedPassivationStrategy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LeastFrequentlyUsedPassivationStrategy;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "LeastFrequentlyUsedPassivationStrategy";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "limit";
                }
                case 1: {
                    return "dynamicAging";
                }
                case 2: {
                    return "idle";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int limit() {
            return this.limit;
        }

        public boolean dynamicAging() {
            return this.dynamicAging;
        }

        public Option<IdlePassivationStrategy> idle() {
            return this.idle;
        }

        public LeastFrequentlyUsedPassivationStrategy copy(int limit, boolean dynamicAging, Option<IdlePassivationStrategy> idle) {
            return new LeastFrequentlyUsedPassivationStrategy(limit, dynamicAging, idle);
        }

        public int copy$default$1() {
            return this.limit();
        }

        public boolean copy$default$2() {
            return this.dynamicAging();
        }

        public Option<IdlePassivationStrategy> copy$default$3() {
            return this.idle();
        }

        public int _1() {
            return this.limit();
        }

        public boolean _2() {
            return this.dynamicAging();
        }

        public Option<IdlePassivationStrategy> _3() {
            return this.idle();
        }
    }

    @InternalApi
    public static class LeastRecentlyUsedPassivationStrategy
    implements PassivationStrategy,
    Product,
    Serializable {
        private final int limit;
        private final Seq segmented;
        private final Option idle;

        public static LeastRecentlyUsedPassivationStrategy apply(int n, Seq<Object> seq, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$.MODULE$.apply(n, seq, option);
        }

        public static LeastRecentlyUsedPassivationStrategy apply(PassivationStrategySettings.LeastRecentlyUsedSettings leastRecentlyUsedSettings, int n, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$.MODULE$.apply(leastRecentlyUsedSettings, n, option);
        }

        public static LeastRecentlyUsedPassivationStrategy fromProduct(Product product) {
            return ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$.MODULE$.fromProduct(product);
        }

        public static LeastRecentlyUsedPassivationStrategy unapply(LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy) {
            return ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$.MODULE$.unapply(leastRecentlyUsedPassivationStrategy);
        }

        public LeastRecentlyUsedPassivationStrategy(int limit, Seq<Object> segmented, Option<IdlePassivationStrategy> idle) {
            this.limit = limit;
            this.segmented = segmented;
            this.idle = idle;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.limit());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.segmented()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idle()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LeastRecentlyUsedPassivationStrategy)) return false;
            LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = (LeastRecentlyUsedPassivationStrategy)object;
            if (this.limit() != leastRecentlyUsedPassivationStrategy.limit()) return false;
            Seq<Object> seq = this.segmented();
            Seq<Object> seq2 = leastRecentlyUsedPassivationStrategy.segmented();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<IdlePassivationStrategy> option = this.idle();
            Option<IdlePassivationStrategy> option2 = leastRecentlyUsedPassivationStrategy.idle();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!leastRecentlyUsedPassivationStrategy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LeastRecentlyUsedPassivationStrategy;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "LeastRecentlyUsedPassivationStrategy";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "limit";
                }
                case 1: {
                    return "segmented";
                }
                case 2: {
                    return "idle";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int limit() {
            return this.limit;
        }

        public Seq<Object> segmented() {
            return this.segmented;
        }

        public Option<IdlePassivationStrategy> idle() {
            return this.idle;
        }

        public LeastRecentlyUsedPassivationStrategy copy(int limit, Seq<Object> segmented, Option<IdlePassivationStrategy> idle) {
            return new LeastRecentlyUsedPassivationStrategy(limit, segmented, idle);
        }

        public int copy$default$1() {
            return this.limit();
        }

        public Seq<Object> copy$default$2() {
            return this.segmented();
        }

        public Option<IdlePassivationStrategy> copy$default$3() {
            return this.idle();
        }

        public int _1() {
            return this.limit();
        }

        public Seq<Object> _2() {
            return this.segmented();
        }

        public Option<IdlePassivationStrategy> _3() {
            return this.idle();
        }
    }

    @InternalApi
    public static class MostRecentlyUsedPassivationStrategy
    implements PassivationStrategy,
    Product,
    Serializable {
        private final int limit;
        private final Option idle;

        public static MostRecentlyUsedPassivationStrategy apply(int n, Option<IdlePassivationStrategy> option) {
            return ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$.MODULE$.apply(n, option);
        }

        public static MostRecentlyUsedPassivationStrategy fromProduct(Product product) {
            return ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$.MODULE$.fromProduct(product);
        }

        public static MostRecentlyUsedPassivationStrategy unapply(MostRecentlyUsedPassivationStrategy mostRecentlyUsedPassivationStrategy) {
            return ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$.MODULE$.unapply(mostRecentlyUsedPassivationStrategy);
        }

        public MostRecentlyUsedPassivationStrategy(int limit, Option<IdlePassivationStrategy> idle) {
            this.limit = limit;
            this.idle = idle;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.limit());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.idle()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MostRecentlyUsedPassivationStrategy)) return false;
            MostRecentlyUsedPassivationStrategy mostRecentlyUsedPassivationStrategy = (MostRecentlyUsedPassivationStrategy)object;
            if (this.limit() != mostRecentlyUsedPassivationStrategy.limit()) return false;
            Option<IdlePassivationStrategy> option = this.idle();
            Option<IdlePassivationStrategy> option2 = mostRecentlyUsedPassivationStrategy.idle();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mostRecentlyUsedPassivationStrategy.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MostRecentlyUsedPassivationStrategy;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MostRecentlyUsedPassivationStrategy";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "limit";
            }
            if (1 == n2) {
                return "idle";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int limit() {
            return this.limit;
        }

        public Option<IdlePassivationStrategy> idle() {
            return this.idle;
        }

        public MostRecentlyUsedPassivationStrategy copy(int limit, Option<IdlePassivationStrategy> idle) {
            return new MostRecentlyUsedPassivationStrategy(limit, idle);
        }

        public int copy$default$1() {
            return this.limit();
        }

        public Option<IdlePassivationStrategy> copy$default$2() {
            return this.idle();
        }

        public int _1() {
            return this.limit();
        }

        public Option<IdlePassivationStrategy> _2() {
            return this.idle();
        }
    }

    @InternalApi
    public static interface PassivationStrategy {
        public static PassivationStrategy apply(ClusterShardingSettings clusterShardingSettings) {
            return ClusterShardingSettings$PassivationStrategy$.MODULE$.apply(clusterShardingSettings);
        }

        public static PassivationStrategy apply(Option<PassivationStrategySettings.PolicySettings> option, int n, Option<IdlePassivationStrategy> option2) {
            return ClusterShardingSettings$PassivationStrategy$.MODULE$.apply(option, n, option2);
        }

        public static String describe(PassivationStrategy passivationStrategy) {
            return ClusterShardingSettings$PassivationStrategy$.MODULE$.describe(passivationStrategy);
        }

        public static int ordinal(PassivationStrategy passivationStrategy) {
            return ClusterShardingSettings$PassivationStrategy$.MODULE$.ordinal(passivationStrategy);
        }
    }

    @ApiMayChange
    public static final class PassivationStrategySettings {
        private final Option idleEntitySettings;
        private final Option activeEntityLimit;
        private final Option replacementPolicySettings;
        private final Option admissionSettings;
        private final boolean oldSettingUsed;

        @ApiMayChange
        public static PassivationStrategySettings apply(Config config) {
            return ClusterShardingSettings$PassivationStrategySettings$.MODULE$.apply(config);
        }

        public static PassivationStrategySettings defaults() {
            return ClusterShardingSettings$PassivationStrategySettings$.MODULE$.defaults();
        }

        public static PassivationStrategySettings disabled() {
            return ClusterShardingSettings$PassivationStrategySettings$.MODULE$.disabled();
        }

        public static PassivationStrategySettings fromSharding(Config config) {
            return ClusterShardingSettings$PassivationStrategySettings$.MODULE$.fromSharding(config);
        }

        public static PassivationStrategySettings oldDefault(FiniteDuration finiteDuration) {
            return ClusterShardingSettings$PassivationStrategySettings$.MODULE$.oldDefault(finiteDuration);
        }

        public PassivationStrategySettings(Option<IdleSettings> idleEntitySettings, Option<Object> activeEntityLimit, Option<PolicySettings> replacementPolicySettings, Option<AdmissionSettings> admissionSettings, boolean oldSettingUsed) {
            this.idleEntitySettings = idleEntitySettings;
            this.activeEntityLimit = activeEntityLimit;
            this.replacementPolicySettings = replacementPolicySettings;
            this.admissionSettings = admissionSettings;
            this.oldSettingUsed = oldSettingUsed;
        }

        public Option<IdleSettings> idleEntitySettings() {
            return this.idleEntitySettings;
        }

        public Option<Object> activeEntityLimit() {
            return this.activeEntityLimit;
        }

        public Option<PolicySettings> replacementPolicySettings() {
            return this.replacementPolicySettings;
        }

        public Option<AdmissionSettings> admissionSettings() {
            return this.admissionSettings;
        }

        public boolean oldSettingUsed() {
            return this.oldSettingUsed;
        }

        public PassivationStrategySettings(Option<IdleSettings> idleEntitySettings, Option<Object> activeEntityLimit, Option<PolicySettings> replacementPolicySettings, boolean oldSettingUsed) {
            this(idleEntitySettings, activeEntityLimit, replacementPolicySettings, (Option<AdmissionSettings>)None$.MODULE$, oldSettingUsed);
        }

        public PassivationStrategySettings(Option<IdleSettings> idleEntitySettings, Option<Object> activeEntityLimit, Option<PolicySettings> replacementPolicySettings, Option<AdmissionSettings> admissionSettings) {
            this(idleEntitySettings, activeEntityLimit, replacementPolicySettings, admissionSettings, false);
        }

        public PassivationStrategySettings(Option<IdleSettings> idleEntitySettings, Option<Object> activeEntityLimit, Option<PolicySettings> replacementPolicySettings) {
            this(idleEntitySettings, activeEntityLimit, replacementPolicySettings, (Option<AdmissionSettings>)None$.MODULE$, false);
        }

        public PassivationStrategySettings withIdleEntityPassivation(IdleSettings settings) {
            Some some = Some$.MODULE$.apply((Object)settings);
            Option<Object> option = this.copy$default$2();
            Option<PolicySettings> option2 = this.copy$default$3();
            Option<AdmissionSettings> option3 = this.copy$default$4();
            return this.copy((Option<IdleSettings>)some, option, option2, option3, false);
        }

        public PassivationStrategySettings withIdleEntityPassivation(FiniteDuration timeout) {
            return this.withIdleEntityPassivation(ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.defaults().withTimeout(timeout));
        }

        public PassivationStrategySettings withIdleEntityPassivation(FiniteDuration timeout, FiniteDuration interval) {
            return this.withIdleEntityPassivation(ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.defaults().withTimeout(timeout).withInterval(interval));
        }

        public PassivationStrategySettings withIdleEntityPassivation(Duration timeout) {
            return this.withIdleEntityPassivation(ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.defaults().withTimeout(timeout));
        }

        public PassivationStrategySettings withIdleEntityPassivation(Duration timeout, Duration interval) {
            return this.withIdleEntityPassivation(ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.defaults().withTimeout(timeout).withInterval(interval));
        }

        public PassivationStrategySettings withActiveEntityLimit(int limit) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)limit));
            Option<IdleSettings> option = this.copy$default$1();
            Option<PolicySettings> option2 = this.copy$default$3();
            Option<AdmissionSettings> option3 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            return this.copy(option, (Option<Object>)some, option2, option3, bl);
        }

        public PassivationStrategySettings withReplacementPolicy(PolicySettings settings) {
            Some some = Some$.MODULE$.apply((Object)settings);
            Option<IdleSettings> option = this.copy$default$1();
            Option<Object> option2 = this.copy$default$2();
            Option<AdmissionSettings> option3 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            return this.copy(option, option2, (Option<PolicySettings>)some, option3, bl);
        }

        public PassivationStrategySettings withLeastRecentlyUsedReplacement() {
            return this.withReplacementPolicy(ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$.MODULE$.defaults());
        }

        public PassivationStrategySettings withMostRecentlyUsedReplacement() {
            return this.withReplacementPolicy(ClusterShardingSettings$PassivationStrategySettings$MostRecentlyUsedSettings$.MODULE$.defaults());
        }

        public PassivationStrategySettings withLeastFrequentlyUsedReplacement() {
            return this.withReplacementPolicy(ClusterShardingSettings$PassivationStrategySettings$LeastFrequentlyUsedSettings$.MODULE$.defaults());
        }

        public PassivationStrategySettings withAdmission(AdmissionSettings settings) {
            Some some = Some$.MODULE$.apply((Object)settings);
            Option<IdleSettings> option = this.copy$default$1();
            Option<Object> option2 = this.copy$default$2();
            Option<PolicySettings> option3 = this.copy$default$3();
            boolean bl = this.copy$default$5();
            return this.copy(option, option2, option3, (Option<AdmissionSettings>)some, bl);
        }

        public PassivationStrategySettings withOldIdleStrategy(FiniteDuration timeout) {
            return this.copy((Option<IdleSettings>)Some$.MODULE$.apply((Object)new IdleSettings(timeout, (Option<FiniteDuration>)None$.MODULE$)), (Option<Object>)None$.MODULE$, (Option<PolicySettings>)None$.MODULE$, (Option<AdmissionSettings>)None$.MODULE$, true);
        }

        private PassivationStrategySettings copy(Option<IdleSettings> idleEntitySettings, Option<Object> activeEntityLimit, Option<PolicySettings> replacementPolicySettings, Option<AdmissionSettings> admissionSettings, boolean oldSettingUsed) {
            return new PassivationStrategySettings(idleEntitySettings, activeEntityLimit, replacementPolicySettings, admissionSettings, oldSettingUsed);
        }

        private Option<IdleSettings> copy$default$1() {
            return this.idleEntitySettings();
        }

        private Option<Object> copy$default$2() {
            return this.activeEntityLimit();
        }

        private Option<PolicySettings> copy$default$3() {
            return this.replacementPolicySettings();
        }

        private Option<AdmissionSettings> copy$default$4() {
            return this.admissionSettings();
        }

        private boolean copy$default$5() {
            return this.oldSettingUsed();
        }

        public static final class AdmissionSettings {
            private final Option filter;
            private final Option window;

            public static AdmissionSettings defaults() {
                return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$.MODULE$.defaults();
            }

            public static Option<AdmissionSettings> optional(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$.MODULE$.optional(config);
            }

            public AdmissionSettings(Option<FilterSettings> filter, Option<WindowSettings> window) {
                this.filter = filter;
                this.window = window;
            }

            public Option<FilterSettings> filter() {
                return this.filter;
            }

            public Option<WindowSettings> window() {
                return this.window;
            }

            public AdmissionSettings withFilter(FilterSettings settings) {
                return this.copy((Option<FilterSettings>)Some$.MODULE$.apply((Object)settings), this.copy$default$2());
            }

            public AdmissionSettings withWindow(WindowSettings settings) {
                Some some = Some$.MODULE$.apply((Object)settings);
                Option<FilterSettings> option = this.copy$default$1();
                return this.copy(option, (Option<WindowSettings>)some);
            }

            private AdmissionSettings copy(Option<FilterSettings> filter, Option<WindowSettings> window) {
                return new AdmissionSettings(filter, window);
            }

            private Option<FilterSettings> copy$default$1() {
                return this.filter();
            }

            private Option<WindowSettings> copy$default$2() {
                return this.window();
            }

            public static interface FilterSettings {
                public static Option<FilterSettings> optional(Config config) {
                    return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$FilterSettings$.MODULE$.optional(config);
                }
            }

            public static final class WindowSettings {
                private final double initialProportion;
                private final double minimumProportion;
                private final double maximumProportion;
                private final Option optimizer;
                private final Option policy;

                public static WindowSettings apply(Config config) {
                    return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$WindowSettings$.MODULE$.apply(config);
                }

                public static WindowSettings defaults() {
                    return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$WindowSettings$.MODULE$.defaults();
                }

                public static Option<WindowSettings> optional(Config config) {
                    return ClusterShardingSettings$PassivationStrategySettings$AdmissionSettings$WindowSettings$.MODULE$.optional(config);
                }

                public WindowSettings(double initialProportion, double minimumProportion, double maximumProportion, Option<OptimizerSettings> optimizer, Option<PolicySettings> policy) {
                    this.initialProportion = initialProportion;
                    this.minimumProportion = minimumProportion;
                    this.maximumProportion = maximumProportion;
                    this.optimizer = optimizer;
                    this.policy = policy;
                }

                public double initialProportion() {
                    return this.initialProportion;
                }

                public double minimumProportion() {
                    return this.minimumProportion;
                }

                public double maximumProportion() {
                    return this.maximumProportion;
                }

                public Option<OptimizerSettings> optimizer() {
                    return this.optimizer;
                }

                public Option<PolicySettings> policy() {
                    return this.policy;
                }

                public WindowSettings withInitialProportion(double proportion) {
                    return this.copy(proportion, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
                }

                public WindowSettings withMinimumProportion(double proportion) {
                    return this.copy(this.copy$default$1(), proportion, this.copy$default$3(), this.copy$default$4(), this.copy$default$5());
                }

                public WindowSettings withMaximumProportion(double proportion) {
                    return this.copy(this.copy$default$1(), this.copy$default$2(), proportion, this.copy$default$4(), this.copy$default$5());
                }

                public WindowSettings withOptimizer(OptimizerSettings settings) {
                    Some some = Some$.MODULE$.apply((Object)settings);
                    double d = this.copy$default$1();
                    double d2 = this.copy$default$2();
                    double d3 = this.copy$default$3();
                    Option<PolicySettings> option = this.copy$default$5();
                    return this.copy(d, d2, d3, (Option<OptimizerSettings>)some, option);
                }

                public WindowSettings withPolicy(PolicySettings settings) {
                    Some some = Some$.MODULE$.apply((Object)settings);
                    double d = this.copy$default$1();
                    double d2 = this.copy$default$2();
                    double d3 = this.copy$default$3();
                    Option<OptimizerSettings> option = this.copy$default$4();
                    return this.copy(d, d2, d3, option, (Option<PolicySettings>)some);
                }

                private WindowSettings copy(double initialProportion, double minimumProportion, double maximumProportion, Option<OptimizerSettings> optimizer, Option<PolicySettings> policy) {
                    return new WindowSettings(initialProportion, minimumProportion, maximumProportion, optimizer, policy);
                }

                private double copy$default$1() {
                    return this.initialProportion();
                }

                private double copy$default$2() {
                    return this.minimumProportion();
                }

                private double copy$default$3() {
                    return this.maximumProportion();
                }

                private Option<OptimizerSettings> copy$default$4() {
                    return this.optimizer();
                }

                private Option<PolicySettings> copy$default$5() {
                    return this.policy();
                }
            }
        }

        public static final class IdleSettings {
            private final FiniteDuration timeout;
            private final Option interval;

            public static IdleSettings apply(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.apply(config);
            }

            public static IdleSettings defaults() {
                return ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.defaults();
            }

            public static Option<IdleSettings> optional(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$IdleSettings$.MODULE$.optional(config);
            }

            public IdleSettings(FiniteDuration timeout, Option<FiniteDuration> interval) {
                this.timeout = timeout;
                this.interval = interval;
            }

            public FiniteDuration timeout() {
                return this.timeout;
            }

            public Option<FiniteDuration> interval() {
                return this.interval;
            }

            public IdleSettings withTimeout(FiniteDuration timeout) {
                return this.copy(timeout, this.copy$default$2());
            }

            public IdleSettings withTimeout(Duration timeout) {
                return this.withTimeout(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
            }

            public IdleSettings withInterval(FiniteDuration interval) {
                Some some = Some$.MODULE$.apply((Object)interval);
                FiniteDuration finiteDuration = this.copy$default$1();
                return this.copy(finiteDuration, (Option<FiniteDuration>)some);
            }

            public IdleSettings withInterval(Duration interval) {
                return this.withInterval(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
            }

            private IdleSettings copy(FiniteDuration timeout, Option<FiniteDuration> interval) {
                return new IdleSettings(timeout, interval);
            }

            private FiniteDuration copy$default$1() {
                return this.timeout();
            }

            private Option<FiniteDuration> copy$default$2() {
                return this.interval();
            }
        }

        public static final class LeastFrequentlyUsedSettings
        implements PolicySettings {
            private final boolean dynamicAging;

            public static LeastFrequentlyUsedSettings apply(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$LeastFrequentlyUsedSettings$.MODULE$.apply(config);
            }

            public static LeastFrequentlyUsedSettings defaults() {
                return ClusterShardingSettings$PassivationStrategySettings$LeastFrequentlyUsedSettings$.MODULE$.defaults();
            }

            public LeastFrequentlyUsedSettings(boolean dynamicAging) {
                this.dynamicAging = dynamicAging;
            }

            public boolean dynamicAging() {
                return this.dynamicAging;
            }

            public LeastFrequentlyUsedSettings withDynamicAging() {
                return this.withDynamicAging(true);
            }

            public LeastFrequentlyUsedSettings withDynamicAging(boolean enabled) {
                return this.copy(enabled);
            }

            private LeastFrequentlyUsedSettings copy(boolean dynamicAging) {
                return new LeastFrequentlyUsedSettings(dynamicAging);
            }
        }

        public static final class LeastRecentlyUsedSettings
        implements PolicySettings {
            private final Option segmentedSettings;

            public static LeastRecentlyUsedSettings apply(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$.MODULE$.apply(config);
            }

            public static LeastRecentlyUsedSettings defaults() {
                return ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$.MODULE$.defaults();
            }

            public LeastRecentlyUsedSettings(Option<SegmentedSettings> segmentedSettings) {
                this.segmentedSettings = segmentedSettings;
            }

            public Option<SegmentedSettings> segmentedSettings() {
                return this.segmentedSettings;
            }

            public LeastRecentlyUsedSettings withSegmented(int levels) {
                return this.copy((Option<SegmentedSettings>)Some$.MODULE$.apply((Object)new SegmentedSettings(levels, (Seq<Object>)package$.MODULE$.Nil())));
            }

            public LeastRecentlyUsedSettings withSegmented(Seq<Object> proportions) {
                return this.copy((Option<SegmentedSettings>)Some$.MODULE$.apply((Object)new SegmentedSettings(proportions.size(), proportions)));
            }

            public LeastRecentlyUsedSettings withSegmentedProportions(List<Double> proportions) {
                return this.withSegmented((Seq<Object>)((Seq)Util$.MODULE$.immutableSeq(proportions).map((Function1 & Serializable)_$3 -> Predef$.MODULE$.Double2double(_$3))));
            }

            private LeastRecentlyUsedSettings copy(Option<SegmentedSettings> segmentedSettings) {
                return new LeastRecentlyUsedSettings(segmentedSettings);
            }

            public static final class SegmentedSettings {
                private final int levels;
                private final Seq proportions;

                public static SegmentedSettings apply(Config config) {
                    return ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$SegmentedSettings$.MODULE$.apply(config);
                }

                public static Option<SegmentedSettings> optional(Config config) {
                    return ClusterShardingSettings$PassivationStrategySettings$LeastRecentlyUsedSettings$SegmentedSettings$.MODULE$.optional(config);
                }

                public SegmentedSettings(int levels, Seq<Object> proportions) {
                    this.levels = levels;
                    this.proportions = proportions;
                }

                public int levels() {
                    return this.levels;
                }

                public Seq<Object> proportions() {
                    return this.proportions;
                }

                public SegmentedSettings withLevels(int levels) {
                    return this.copy(levels, this.copy$default$2());
                }

                public SegmentedSettings withProportions(Seq<Object> proportions) {
                    return this.copy(this.copy$default$1(), proportions);
                }

                public SegmentedSettings withProportions(List<Double> proportions) {
                    Seq seq = (Seq)Util$.MODULE$.immutableSeq(proportions).map((Function1 & Serializable)_$2 -> Predef$.MODULE$.Double2double(_$2));
                    int n = this.copy$default$1();
                    return this.copy(n, (Seq<Object>)seq);
                }

                private SegmentedSettings copy(int levels, Seq<Object> proportions) {
                    return new SegmentedSettings(levels, proportions);
                }

                private int copy$default$1() {
                    return this.levels();
                }

                private Seq<Object> copy$default$2() {
                    return this.proportions();
                }
            }
        }

        public static final class MostRecentlyUsedSettings
        implements PolicySettings {
            public static MostRecentlyUsedSettings apply(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$MostRecentlyUsedSettings$.MODULE$.apply(config);
            }

            public static MostRecentlyUsedSettings defaults() {
                return ClusterShardingSettings$PassivationStrategySettings$MostRecentlyUsedSettings$.MODULE$.defaults();
            }
        }

        public static interface PolicySettings {
            public static PolicySettings apply(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$PolicySettings$.MODULE$.apply(config);
            }

            public static Option<PolicySettings> optional(Config config) {
                return ClusterShardingSettings$PassivationStrategySettings$PolicySettings$.MODULE$.optional(config);
            }
        }
    }

    public static class TuningParameters {
        private final FiniteDuration coordinatorFailureBackoff;
        private final FiniteDuration retryInterval;
        private final int bufferSize;
        private final FiniteDuration handOffTimeout;
        private final FiniteDuration shardStartTimeout;
        private final FiniteDuration shardFailureBackoff;
        private final FiniteDuration entityRestartBackoff;
        private final FiniteDuration rebalanceInterval;
        private final int snapshotAfter;
        private final int keepNrOfBatches;
        private final int leastShardAllocationRebalanceThreshold;
        private final int leastShardAllocationMaxSimultaneousRebalance;
        private final FiniteDuration waitingForStateTimeout;
        private final FiniteDuration updatingStateTimeout;
        private final String entityRecoveryStrategy;
        private final FiniteDuration entityRecoveryConstantRateStrategyFrequency;
        private final int entityRecoveryConstantRateStrategyNumberOfEntities;
        private final int coordinatorStateWriteMajorityPlus;
        private final int coordinatorStateReadMajorityPlus;
        private final int leastShardAllocationAbsoluteLimit;
        private final double leastShardAllocationRelativeLimit;

        /*
         * Unable to fully structure code
         */
        public TuningParameters(FiniteDuration coordinatorFailureBackoff, FiniteDuration retryInterval, int bufferSize, FiniteDuration handOffTimeout, FiniteDuration shardStartTimeout, FiniteDuration shardFailureBackoff, FiniteDuration entityRestartBackoff, FiniteDuration rebalanceInterval, int snapshotAfter, int keepNrOfBatches, int leastShardAllocationRebalanceThreshold, int leastShardAllocationMaxSimultaneousRebalance, FiniteDuration waitingForStateTimeout, FiniteDuration updatingStateTimeout, String entityRecoveryStrategy, FiniteDuration entityRecoveryConstantRateStrategyFrequency, int entityRecoveryConstantRateStrategyNumberOfEntities, int coordinatorStateWriteMajorityPlus, int coordinatorStateReadMajorityPlus, int leastShardAllocationAbsoluteLimit, double leastShardAllocationRelativeLimit) {
            this.coordinatorFailureBackoff = coordinatorFailureBackoff;
            this.retryInterval = retryInterval;
            this.bufferSize = bufferSize;
            this.handOffTimeout = handOffTimeout;
            this.shardStartTimeout = shardStartTimeout;
            this.shardFailureBackoff = shardFailureBackoff;
            this.entityRestartBackoff = entityRestartBackoff;
            this.rebalanceInterval = rebalanceInterval;
            this.snapshotAfter = snapshotAfter;
            this.keepNrOfBatches = keepNrOfBatches;
            this.leastShardAllocationRebalanceThreshold = leastShardAllocationRebalanceThreshold;
            this.leastShardAllocationMaxSimultaneousRebalance = leastShardAllocationMaxSimultaneousRebalance;
            this.waitingForStateTimeout = waitingForStateTimeout;
            this.updatingStateTimeout = updatingStateTimeout;
            this.entityRecoveryStrategy = entityRecoveryStrategy;
            this.entityRecoveryConstantRateStrategyFrequency = entityRecoveryConstantRateStrategyFrequency;
            this.entityRecoveryConstantRateStrategyNumberOfEntities = entityRecoveryConstantRateStrategyNumberOfEntities;
            this.coordinatorStateWriteMajorityPlus = coordinatorStateWriteMajorityPlus;
            this.coordinatorStateReadMajorityPlus = coordinatorStateReadMajorityPlus;
            this.leastShardAllocationAbsoluteLimit = leastShardAllocationAbsoluteLimit;
            this.leastShardAllocationRelativeLimit = leastShardAllocationRelativeLimit;
            super();
            v0 = entityRecoveryStrategy;
            var23_22 = "all";
            if (!(v0 == null ? var23_22 != null : v0.equals(var23_22) == false)) ** GOTO lbl-1000
            v1 = entityRecoveryStrategy;
            var24_23 = "constant";
            if (!(v1 != null ? v1.equals(var24_23) == false : var24_23 != null)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Predef$.MODULE$.require(v2, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$2(java.lang.String ), ()Ljava/lang/Object;)((TuningParameters)this, (String)entityRecoveryStrategy));
        }

        public FiniteDuration coordinatorFailureBackoff() {
            return this.coordinatorFailureBackoff;
        }

        public FiniteDuration retryInterval() {
            return this.retryInterval;
        }

        public int bufferSize() {
            return this.bufferSize;
        }

        public FiniteDuration handOffTimeout() {
            return this.handOffTimeout;
        }

        public FiniteDuration shardStartTimeout() {
            return this.shardStartTimeout;
        }

        public FiniteDuration shardFailureBackoff() {
            return this.shardFailureBackoff;
        }

        public FiniteDuration entityRestartBackoff() {
            return this.entityRestartBackoff;
        }

        public FiniteDuration rebalanceInterval() {
            return this.rebalanceInterval;
        }

        public int snapshotAfter() {
            return this.snapshotAfter;
        }

        public int keepNrOfBatches() {
            return this.keepNrOfBatches;
        }

        public int leastShardAllocationRebalanceThreshold() {
            return this.leastShardAllocationRebalanceThreshold;
        }

        public int leastShardAllocationMaxSimultaneousRebalance() {
            return this.leastShardAllocationMaxSimultaneousRebalance;
        }

        public FiniteDuration waitingForStateTimeout() {
            return this.waitingForStateTimeout;
        }

        public FiniteDuration updatingStateTimeout() {
            return this.updatingStateTimeout;
        }

        public String entityRecoveryStrategy() {
            return this.entityRecoveryStrategy;
        }

        public FiniteDuration entityRecoveryConstantRateStrategyFrequency() {
            return this.entityRecoveryConstantRateStrategyFrequency;
        }

        public int entityRecoveryConstantRateStrategyNumberOfEntities() {
            return this.entityRecoveryConstantRateStrategyNumberOfEntities;
        }

        public int coordinatorStateWriteMajorityPlus() {
            return this.coordinatorStateWriteMajorityPlus;
        }

        public int coordinatorStateReadMajorityPlus() {
            return this.coordinatorStateReadMajorityPlus;
        }

        public int leastShardAllocationAbsoluteLimit() {
            return this.leastShardAllocationAbsoluteLimit;
        }

        public double leastShardAllocationRelativeLimit() {
            return this.leastShardAllocationRelativeLimit;
        }

        public TuningParameters(FiniteDuration coordinatorFailureBackoff, FiniteDuration retryInterval, int bufferSize, FiniteDuration handOffTimeout, FiniteDuration shardStartTimeout, FiniteDuration shardFailureBackoff, FiniteDuration entityRestartBackoff, FiniteDuration rebalanceInterval, int snapshotAfter, int keepNrOfBatches, int leastShardAllocationRebalanceThreshold, int leastShardAllocationMaxSimultaneousRebalance, FiniteDuration waitingForStateTimeout, FiniteDuration updatingStateTimeout, String entityRecoveryStrategy, FiniteDuration entityRecoveryConstantRateStrategyFrequency, int entityRecoveryConstantRateStrategyNumberOfEntities, int coordinatorStateWriteMajorityPlus, int coordinatorStateReadMajorityPlus) {
            this(coordinatorFailureBackoff, retryInterval, bufferSize, handOffTimeout, shardStartTimeout, shardFailureBackoff, entityRestartBackoff, rebalanceInterval, snapshotAfter, keepNrOfBatches, leastShardAllocationRebalanceThreshold, leastShardAllocationMaxSimultaneousRebalance, waitingForStateTimeout, updatingStateTimeout, entityRecoveryStrategy, entityRecoveryConstantRateStrategyFrequency, entityRecoveryConstantRateStrategyNumberOfEntities, coordinatorStateWriteMajorityPlus, coordinatorStateReadMajorityPlus, 100, 0.1);
        }

        public TuningParameters(FiniteDuration coordinatorFailureBackoff, FiniteDuration retryInterval, int bufferSize, FiniteDuration handOffTimeout, FiniteDuration shardStartTimeout, FiniteDuration shardFailureBackoff, FiniteDuration entityRestartBackoff, FiniteDuration rebalanceInterval, int snapshotAfter, int keepNrOfBatches, int leastShardAllocationRebalanceThreshold, int leastShardAllocationMaxSimultaneousRebalance, FiniteDuration waitingForStateTimeout, FiniteDuration updatingStateTimeout, String entityRecoveryStrategy, FiniteDuration entityRecoveryConstantRateStrategyFrequency, int entityRecoveryConstantRateStrategyNumberOfEntities) {
            this(coordinatorFailureBackoff, retryInterval, bufferSize, handOffTimeout, shardStartTimeout, shardFailureBackoff, entityRestartBackoff, rebalanceInterval, snapshotAfter, keepNrOfBatches, leastShardAllocationRebalanceThreshold, leastShardAllocationMaxSimultaneousRebalance, waitingForStateTimeout, updatingStateTimeout, entityRecoveryStrategy, entityRecoveryConstantRateStrategyFrequency, entityRecoveryConstantRateStrategyNumberOfEntities, 5, 5);
        }

        public TuningParameters(FiniteDuration coordinatorFailureBackoff, FiniteDuration retryInterval, int bufferSize, FiniteDuration handOffTimeout, FiniteDuration shardStartTimeout, FiniteDuration shardFailureBackoff, FiniteDuration entityRestartBackoff, FiniteDuration rebalanceInterval, int snapshotAfter, int leastShardAllocationRebalanceThreshold, int leastShardAllocationMaxSimultaneousRebalance, FiniteDuration waitingForStateTimeout, FiniteDuration updatingStateTimeout, String entityRecoveryStrategy, FiniteDuration entityRecoveryConstantRateStrategyFrequency, int entityRecoveryConstantRateStrategyNumberOfEntities) {
            this(coordinatorFailureBackoff, retryInterval, bufferSize, handOffTimeout, shardStartTimeout, shardFailureBackoff, entityRestartBackoff, rebalanceInterval, snapshotAfter, 2, leastShardAllocationRebalanceThreshold, leastShardAllocationMaxSimultaneousRebalance, waitingForStateTimeout, updatingStateTimeout, entityRecoveryStrategy, entityRecoveryConstantRateStrategyFrequency, entityRecoveryConstantRateStrategyNumberOfEntities);
        }

        public TuningParameters(FiniteDuration coordinatorFailureBackoff, FiniteDuration retryInterval, int bufferSize, FiniteDuration handOffTimeout, FiniteDuration shardStartTimeout, FiniteDuration shardFailureBackoff, FiniteDuration entityRestartBackoff, FiniteDuration rebalanceInterval, int snapshotAfter, int leastShardAllocationRebalanceThreshold, int leastShardAllocationMaxSimultaneousRebalance, FiniteDuration waitingForStateTimeout, FiniteDuration updatingStateTimeout) {
            this(coordinatorFailureBackoff, retryInterval, bufferSize, handOffTimeout, shardStartTimeout, shardFailureBackoff, entityRestartBackoff, rebalanceInterval, snapshotAfter, leastShardAllocationRebalanceThreshold, leastShardAllocationMaxSimultaneousRebalance, waitingForStateTimeout, updatingStateTimeout, "all", new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).milliseconds(), 5);
        }

        private final Object $init$$$anonfun$2(String entityRecoveryStrategy$1) {
            return new StringBuilder(75).append("Unknown 'entity-recovery-strategy' [").append(entityRecoveryStrategy$1).append("], valid values are 'all' or 'constant'").toString();
        }
    }
}

