/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.LWWRegister;
import org.apache.pekko.cluster.ddata.LWWRegister$;
import org.apache.pekko.cluster.ddata.LWWRegisterKey;
import org.apache.pekko.cluster.ddata.LWWRegisterKey$;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.DDataShardCoordinator$;
import org.apache.pekko.cluster.sharding.DDataShardCoordinator$RememberEntitiesLoadTimeout$;
import org.apache.pekko.cluster.sharding.DDataShardCoordinator$RememberEntitiesStoreStopped$;
import org.apache.pekko.cluster.sharding.DDataShardCoordinator$RememberEntitiesTimeout$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$GetShardHome$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$Register$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegisterProxy$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$State$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$StateInitialized$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$Terminate$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore$AddShard$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore$GetShards$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore$RememberedShards$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore$UpdateDone$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesCoordinatorStore$UpdateFailed$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public class DDataShardCoordinator
extends ShardCoordinator
implements StashSupport,
UnrestrictedStash,
Stash,
Actor {
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private final String typeName;
    public final ClusterShardingSettings org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings;
    private final ActorRef replicator;
    public final boolean org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug;
    public final Replicator.ReadConsistency org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency;
    public final Replicator.WriteConsistency org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateWriteConsistency;
    private final Cluster node;
    private final SelfUniqueAddress selfUniqueAddress;
    public final LWWRegisterKey<ShardCoordinator.Internal.State> org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
    private final ShardCoordinator.Internal.State initEmptyState;
    public boolean org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating;
    private scala.collection.immutable.Set<Tuple2<ActorRef, ShardCoordinator.Internal.GetShardHome>> getShardHomeRequests;
    public int org$apache$pekko$cluster$sharding$DDataShardCoordinator$$initialStateRetries;
    public int org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries;
    private final Option<ActorRef> rememberEntitiesStore;
    private final boolean rememberEntities;

    public DDataShardCoordinator(String typeName, ClusterShardingSettings settings, ShardCoordinator.ShardAllocationStrategy allocationStrategy, ActorRef replicator, int majorityMinCap, Option<RememberEntitiesProvider> rememberEntitiesStoreProvider) {
        Replicator.WriteAll writeAll;
        Replicator.ReadAll readAll;
        this.typeName = typeName;
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings = settings;
        this.replicator = replicator;
        super(settings, allocationStrategy);
        StashSupport.$init$((StashSupport)this);
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug = this.context().system().settings().config().getBoolean("pekko.cluster.sharding.verbose-debug-logging");
        int n = settings.tuningParameters().coordinatorStateReadMajorityPlus();
        if (Integer.MAX_VALUE == n) {
            readAll = Replicator.ReadAll$.MODULE$.apply(settings.tuningParameters().waitingForStateTimeout());
        } else {
            int additional = n;
            readAll = Replicator.ReadMajorityPlus$.MODULE$.apply(settings.tuningParameters().waitingForStateTimeout(), additional, majorityMinCap);
        }
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency = (Replicator.ReadConsistency)readAll;
        int n2 = settings.tuningParameters().coordinatorStateWriteMajorityPlus();
        if (Integer.MAX_VALUE == n2) {
            writeAll = Replicator.WriteAll$.MODULE$.apply(settings.tuningParameters().updatingStateTimeout());
        } else {
            int additional = n2;
            writeAll = Replicator.WriteMajorityPlus$.MODULE$.apply(settings.tuningParameters().updatingStateTimeout(), additional, majorityMinCap);
        }
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateWriteConsistency = (Replicator.WriteConsistency)writeAll;
        this.node = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfUniqueAddress = SelfUniqueAddress$.MODULE$.apply(this.node().selfUniqueAddress());
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey = LWWRegisterKey$.MODULE$.apply(new StringBuilder(16).append(typeName).append("CoordinatorState").toString());
        this.initEmptyState = ShardCoordinator$Internal$State$.MODULE$.empty().withRememberEntities(settings.rememberEntities());
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating = false;
        this.getShardHomeRequests = Predef$.MODULE$.Set().empty();
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$initialStateRetries = 0;
        this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries = 0;
        this.rememberEntitiesStore = rememberEntitiesStoreProvider.map((Function1 & Serializable)provider -> {
            this.log().debug("{}: Starting remember entities store from provider {}", (Object)typeName, provider);
            return this.context().watchWith(this.context().actorOf(provider.coordinatorStoreProps(), "RememberEntitiesStore"), (Object)DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$);
        });
        this.rememberEntities = this.rememberEntitiesStore.isDefined();
        this.node().subscribe(this.self(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.ClusterShuttingDown$.MODULE$.getClass()}));
        this.getCoordinatorState();
        if (settings.rememberEntities()) {
            this.getAllRememberedShards();
        }
        Statics.releaseFence();
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        super.postStop();
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    public Cluster node() {
        return this.node;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.waitingForInitialState((scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
    }

    public PartialFunction<Object, BoxedUnit> waitingForInitialState(scala.collection.immutable.Set<String> rememberedShards) {
        return new Serializable(rememberedShards, this){
            private final scala.collection.immutable.Set rememberedShards$1;
            private final /* synthetic */ DDataShardCoordinator $outer;
            {
                this.rememberedShards$1 = rememberedShards$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Replicator.GetSuccess) {
                    Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                    Replicator.GetSuccess getSuccess2 = Replicator.GetSuccess$.MODULE$.unapply(getSuccess);
                    Key key = getSuccess2._1();
                    Option option = getSuccess2._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key2 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key2) : key2 != null)) {
                        Replicator.GetSuccess g = getSuccess;
                        return true;
                    }
                }
                if (object instanceof Replicator.GetFailure) {
                    Replicator.GetFailure getFailure = Replicator.GetFailure$.MODULE$.unapply((Replicator.GetFailure)object);
                    Key key = getFailure._1();
                    Option option = getFailure._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key3 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key3) : key3 != null)) {
                        return true;
                    }
                }
                if (object instanceof Replicator.NotFound) {
                    Replicator.NotFound notFound = Replicator.NotFound$.MODULE$.unapply((Replicator.NotFound)object);
                    Key key = notFound._1();
                    Option option = notFound._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key4 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key4) : key4 != null)) {
                        return true;
                    }
                }
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> shardIds = set = rememberedShards._1();
                    return true;
                }
                if (DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object)) {
                    return true;
                }
                if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.Register) {
                    ActorRef actorRef;
                    ShardCoordinator.Internal.Register register = ShardCoordinator$Internal$Register$.MODULE$.unapply((ShardCoordinator.Internal.Register)object);
                    ActorRef region = actorRef = register._1();
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.RegisterProxy) {
                    ActorRef actorRef;
                    ShardCoordinator.Internal.RegisterProxy registerProxy = ShardCoordinator$Internal$RegisterProxy$.MODULE$.unapply((ShardCoordinator.Internal.RegisterProxy)object);
                    ActorRef region = actorRef = registerProxy._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Replicator.GetSuccess) {
                    Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                    Replicator.GetSuccess getSuccess2 = Replicator.GetSuccess$.MODULE$.unapply(getSuccess);
                    Key key = getSuccess2._1();
                    Option option = getSuccess2._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key2 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key2) : key2 != null)) {
                        Replicator.GetSuccess g = getSuccess;
                        ShardCoordinator.Internal.State existingState = ((ShardCoordinator.Internal.State)((LWWRegister)g.get(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey)).value()).withRememberEntities(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings.rememberEntities());
                        if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug) {
                            this.$outer.log().debug("{}: Received initial coordinator state [{}]", (Object)this.$outer.typeName(), (Object)existingState);
                        } else {
                            this.$outer.log().debug("{}: Received initial coordinator state with [{}] shards", (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToInteger((int)(existingState.shards().size() + existingState.unallocatedShards().size())));
                        }
                        this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$onInitialState(existingState, (scala.collection.immutable.Set<String>)this.rememberedShards$1);
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.GetFailure) {
                    Replicator.GetFailure getFailure = Replicator.GetFailure$.MODULE$.unapply((Replicator.GetFailure)object);
                    Key key = getFailure._1();
                    Option option = getFailure._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key3 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key3) : key3 != null)) {
                        ++this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$initialStateRetries;
                        String template = "{}: The ShardCoordinator was unable to get an initial state within 'waiting-for-state-timeout': {} millis (retrying). Has ClusterSharding been started on all nodes?";
                        if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$initialStateRetries == 1) {
                            this.$outer.log().info(template, (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency.timeout().toMillis()));
                        } else if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$initialStateRetries < 5) {
                            this.$outer.log().warning(template, (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency.timeout().toMillis()));
                        } else {
                            this.$outer.log().error(template, (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency.timeout().toMillis()));
                        }
                        this.$outer.getCoordinatorState();
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.NotFound) {
                    Replicator.NotFound notFound = Replicator.NotFound$.MODULE$.unapply((Replicator.NotFound)object);
                    Key key = notFound._1();
                    Option option = notFound._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key4 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key4) : key4 != null)) {
                        this.$outer.log().debug("{}: Initial coordinator is empty.", (Object)this.$outer.typeName());
                        this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$onInitialState(this.$outer.state(), (scala.collection.immutable.Set<String>)this.rememberedShards$1);
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> shardIds = set = rememberedShards._1();
                    this.$outer.log().debug("{}: Received [{}] remembered shard ids (when waitingForInitialState)", (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToInteger((int)shardIds.size()));
                    this.$outer.context().become(this.$outer.waitingForInitialState(shardIds));
                    this.$outer.timers().cancel((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey);
                    return BoxedUnit.UNIT;
                }
                if (DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object)) {
                    this.$outer.getAllRememberedShards();
                    return BoxedUnit.UNIT;
                }
                if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    this.$outer.log().debug("{}: Received termination message while waiting for state", (Object)this.$outer.typeName());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardCoordinator.Internal.Register) {
                    ActorRef actorRef;
                    ShardCoordinator.Internal.Register register = ShardCoordinator$Internal$Register$.MODULE$.unapply((ShardCoordinator.Internal.Register)object);
                    ActorRef region = actorRef = register._1();
                    this.$outer.log().debug("{}: ShardRegion tried to register but ShardCoordinator not initialized yet: [{}]", (Object)this.$outer.typeName(), (Object)region);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardCoordinator.Internal.RegisterProxy) {
                    ActorRef actorRef;
                    ShardCoordinator.Internal.RegisterProxy registerProxy = ShardCoordinator$Internal$RegisterProxy$.MODULE$.unapply((ShardCoordinator.Internal.RegisterProxy)object);
                    ActorRef region = actorRef = registerProxy._1();
                    this.$outer.log().debug("{}: ShardRegion proxy tried to register but ShardCoordinator not initialized yet: [{}]", (Object)this.$outer.typeName(), (Object)region);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        }.orElse(this.receiveTerminated());
    }

    public void org$apache$pekko$cluster$sharding$DDataShardCoordinator$$onInitialState(ShardCoordinator.Internal.State loadedState, scala.collection.immutable.Set<String> rememberedShards) {
        ShardCoordinator.Internal.State state;
        if (this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings.rememberEntities() && rememberedShards.nonEmpty()) {
            scala.collection.immutable.Set newUnallocatedShards = (scala.collection.immutable.Set)this.state().unallocatedShards().union((Set)rememberedShards.diff((Set)this.state().shards().keySet()));
            state = loadedState.copy(loadedState.copy$default$1(), loadedState.copy$default$2(), loadedState.copy$default$3(), (scala.collection.immutable.Set<String>)newUnallocatedShards, loadedState.copy$default$5());
        } else {
            state = loadedState;
        }
        this.state_$eq(state);
        if (this.state().isEmpty()) {
            this.activate();
            return;
        }
        this.context().become(this.waitingForStateInitialized());
        this.watchStateActors();
    }

    public PartialFunction<Object, BoxedUnit> waitingForStateInitialized() {
        return new Serializable(this){
            private final /* synthetic */ DDataShardCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ShardCoordinator$Internal$StateInitialized$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.GetShardHome) {
                    ShardCoordinator.Internal.GetShardHome g = (ShardCoordinator.Internal.GetShardHome)object;
                    return true;
                }
                if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> rememberedShards2 = set = rememberedShards._1();
                    return true;
                }
                if (DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object)) {
                    return true;
                }
                if (DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object)) {
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ShardCoordinator$Internal$StateInitialized$.MODULE$.equals(object)) {
                    this.$outer.unstashOneGetShardHomeRequest();
                    this.$outer.unstashAll();
                    this.$outer.stateInitialized();
                    this.$outer.activate();
                } else if (object instanceof ShardCoordinator.Internal.GetShardHome) {
                    ShardCoordinator.Internal.GetShardHome g = (ShardCoordinator.Internal.GetShardHome)object;
                    this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stashGetShardHomeRequest(this.$outer.sender(), g);
                } else if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    this.$outer.log().debug("{}: Received termination message while waiting for state initialized", (Object)this.$outer.typeName());
                    this.$outer.context().stop(this.$outer.self());
                } else if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> rememberedShards2 = set = rememberedShards._1();
                    this.$outer.log().debug("{}: Received [{}] remembered shard ids (when waitingForStateInitialized)", (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToInteger((int)rememberedShards2.size()));
                    scala.collection.immutable.Set newUnallocatedShards = (scala.collection.immutable.Set)this.$outer.state().unallocatedShards().union((Set)rememberedShards2.diff((Set)this.$outer.state().shards().keySet()));
                    ShardCoordinator.Internal.State state = this.$outer.state();
                    state.copy(state.copy$default$1(), state.copy$default$2(), state.copy$default$3(), (scala.collection.immutable.Set<String>)newUnallocatedShards, state.copy$default$5());
                    this.$outer.timers().cancel((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey);
                } else if (DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object)) {
                    this.$outer.getAllRememberedShards();
                } else if (DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object)) {
                    this.$outer.onRememberEntitiesStoreStopped();
                } else {
                    this.$outer.stash();
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public <E extends ShardCoordinator.Internal.DomainEvent> PartialFunction<Object, BoxedUnit> waitingForUpdate(E evt, Option<String> shardId, boolean waitingForStateWrite, boolean waitingForRememberShard, Function1<E, BoxedUnit> afterUpdateCallback) {
        return new Serializable(evt, shardId, waitingForStateWrite, waitingForRememberShard, afterUpdateCallback, this){
            private final ShardCoordinator.Internal.DomainEvent evt$1;
            private final Option shardId$1;
            private final boolean waitingForStateWrite$1;
            private final boolean waitingForRememberShard$1;
            private final Function1 afterUpdateCallback$1;
            private final /* synthetic */ DDataShardCoordinator $outer;
            {
                this.evt$1 = evt$2;
                this.shardId$1 = shardId$2;
                this.waitingForStateWrite$1 = waitingForStateWrite$2;
                this.waitingForRememberShard$1 = waitingForRememberShard$2;
                this.afterUpdateCallback$1 = afterUpdateCallback$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Replicator.UpdateSuccess) {
                    Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                    Key key = updateSuccess._1();
                    Option option = updateSuccess._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key2 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key2) : key2 != null) && option instanceof Some) {
                        ShardCoordinator.Internal.DomainEvent domainEvent = this.evt$1;
                        Object object2 = ((Some)option).value();
                        if (!(domainEvent != null ? !domainEvent.equals(object2) : object2 != null)) {
                            return true;
                        }
                    }
                }
                if (object instanceof Replicator.UpdateTimeout) {
                    Replicator.UpdateTimeout updateTimeout = Replicator.UpdateTimeout$.MODULE$.unapply((Replicator.UpdateTimeout)object);
                    Key key = updateTimeout._1();
                    Option option = updateTimeout._2();
                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                    Key key3 = key;
                    if (!(lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key3) : key3 != null) && option instanceof Some) {
                        ShardCoordinator.Internal.DomainEvent domainEvent = this.evt$1;
                        Object object3 = ((Some)option).value();
                        if (!(domainEvent != null ? !domainEvent.equals(object3) : object3 != null)) {
                            return true;
                        }
                    }
                }
                if (object instanceof Replicator.ModifyFailure) {
                    Replicator.ModifyFailure modifyFailure = Replicator.ModifyFailure$.MODULE$.unapply((Replicator.ModifyFailure)object);
                    Key key = modifyFailure._1();
                    String string = modifyFailure._2();
                    Throwable throwable = modifyFailure._3();
                    Option option = modifyFailure._4();
                    Key key4 = key;
                    String error = string;
                    Throwable cause = throwable;
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.GetShardHome) {
                    String string;
                    ShardCoordinator.Internal.GetShardHome getShardHome = (ShardCoordinator.Internal.GetShardHome)object;
                    ShardCoordinator.Internal.GetShardHome getShardHome2 = ShardCoordinator$Internal$GetShardHome$.MODULE$.unapply(getShardHome);
                    String shard = string = getShardHome2._1();
                    ShardCoordinator.Internal.GetShardHome g = getShardHome;
                    return true;
                }
                if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RememberEntitiesCoordinatorStore.UpdateDone) {
                    String string;
                    RememberEntitiesCoordinatorStore.UpdateDone updateDone = RememberEntitiesCoordinatorStore$UpdateDone$.MODULE$.unapply((RememberEntitiesCoordinatorStore.UpdateDone)object);
                    String shard = string = updateDone._1();
                    return true;
                }
                if (object instanceof RememberEntitiesCoordinatorStore.UpdateFailed) {
                    String string;
                    RememberEntitiesCoordinatorStore.UpdateFailed updateFailed = RememberEntitiesCoordinatorStore$UpdateFailed$.MODULE$.unapply((RememberEntitiesCoordinatorStore.UpdateFailed)object);
                    String shard = string = updateFailed._1();
                    return true;
                }
                if (object instanceof RememberEntitiesTimeout) {
                    String string;
                    RememberEntitiesTimeout rememberEntitiesTimeout = DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.unapply((RememberEntitiesTimeout)object);
                    String shard = string = rememberEntitiesTimeout._1();
                    return true;
                }
                if (DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block31: {
                    Object object;
                    block35: {
                        String string;
                        block33: {
                            Throwable cause;
                            block34: {
                                block32: {
                                    block30: {
                                        object = x;
                                        if (!(object instanceof Replicator.UpdateSuccess)) break block30;
                                        Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                                        Key key = updateSuccess._1();
                                        Option option = updateSuccess._2();
                                        LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                                        Key key2 = key;
                                        if ((lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key2) : key2 != null) || !(option instanceof Some)) break block30;
                                        ShardCoordinator.Internal.DomainEvent domainEvent = this.evt$1;
                                        Object object2 = ((Some)option).value();
                                        if (domainEvent != null ? !domainEvent.equals(object2) : object2 != null) break block30;
                                        this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries = 0;
                                        if (!this.waitingForRememberShard$1) {
                                            this.$outer.log().debug("{}: The coordinator state was successfully updated with {}", (Object)this.$outer.typeName(), (Object)this.evt$1);
                                            if (this.shardId$1.isDefined()) {
                                                this.$outer.timers().cancel((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey);
                                            }
                                            this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$unbecomeAfterUpdate(this.evt$1, this.afterUpdateCallback$1);
                                        } else {
                                            this.$outer.log().debug("{}: The coordinator state was successfully updated with {}, waiting for remember shard update", (Object)this.$outer.typeName(), (Object)this.evt$1);
                                            this.$outer.context().become(this.$outer.waitingForUpdate(this.evt$1, (Option<String>)this.shardId$1, false, true, this.afterUpdateCallback$1));
                                        }
                                        break block31;
                                    }
                                    if (!(object instanceof Replicator.UpdateTimeout)) break block32;
                                    Replicator.UpdateTimeout updateTimeout = Replicator.UpdateTimeout$.MODULE$.unapply((Replicator.UpdateTimeout)object);
                                    Key key = updateTimeout._1();
                                    Option option = updateTimeout._2();
                                    LWWRegisterKey<ShardCoordinator.Internal.State> lWWRegisterKey = this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey;
                                    Key key3 = key;
                                    if ((lWWRegisterKey != null ? !lWWRegisterKey.equals((Object)key3) : key3 != null) || !(option instanceof Some)) break block32;
                                    ShardCoordinator.Internal.DomainEvent domainEvent = this.evt$1;
                                    Object object3 = ((Some)option).value();
                                    if (domainEvent != null ? !domainEvent.equals(object3) : object3 != null) break block32;
                                    ++this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries;
                                    String template = new StringBuilder(119).append(this.$outer.typeName()).append(": The ShardCoordinator was unable to update a distributed state within 'updating-state-timeout': ").append(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateWriteConsistency.timeout().toMillis()).append(" millis (").append(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating ? "terminating" : "retrying").append("). Attempt ").append(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries).append(". ").append(new StringBuilder(71).append("Perhaps the ShardRegion has not started on all active nodes yet? event=").append(this.evt$1).toString()).toString();
                                    if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$updateStateRetries < 5) {
                                        this.$outer.log().warning(template);
                                        if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating) {
                                            this.$outer.context().stop(this.$outer.self());
                                        } else {
                                            this.$outer.sendCoordinatorStateUpdate(this.evt$1);
                                        }
                                    } else {
                                        this.$outer.log().error(template);
                                        if (this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating) {
                                            this.$outer.context().stop(this.$outer.self());
                                        } else {
                                            this.$outer.sendCoordinatorStateUpdate(this.evt$1);
                                        }
                                    }
                                    break block31;
                                }
                                if (!(object instanceof Replicator.ModifyFailure)) break block33;
                                Replicator.ModifyFailure modifyFailure = Replicator.ModifyFailure$.MODULE$.unapply((Replicator.ModifyFailure)object);
                                Key key = modifyFailure._1();
                                String string2 = modifyFailure._2();
                                Throwable throwable = modifyFailure._3();
                                Option option = modifyFailure._4();
                                Key key4 = key;
                                String error = string2;
                                cause = throwable;
                                this.$outer.log().error(cause, new StringBuilder(97).append(this.$outer.typeName()).append(": The ShardCoordinator was unable to update a distributed state {} with error {} and event {}. {}").toString(), (Object)key4, (Object)error, (Object)this.evt$1, (Object)(this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating ? "Coordinator will be terminated due to Terminate message received" : "Coordinator will be restarted"));
                                if (!this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating) break block34;
                                this.$outer.context().stop(this.$outer.self());
                                break block31;
                            }
                            throw cause;
                        }
                        if (!(object instanceof ShardCoordinator.Internal.GetShardHome)) break block35;
                        ShardCoordinator.Internal.GetShardHome getShardHome = (ShardCoordinator.Internal.GetShardHome)object;
                        ShardCoordinator.Internal.GetShardHome getShardHome2 = ShardCoordinator$Internal$GetShardHome$.MODULE$.unapply(getShardHome);
                        String shard = string = getShardHome2._1();
                        ShardCoordinator.Internal.GetShardHome g = getShardHome;
                        if (this.$outer.handleGetShardHome(shard)) break block31;
                        this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stashGetShardHomeRequest(this.$outer.sender(), g);
                        break block31;
                    }
                    if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                        this.$outer.log().debug("{}: The ShardCoordinator received termination message while waiting for update", (Object)this.$outer.typeName());
                        this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating = true;
                        this.$outer.stash();
                    } else if (object instanceof RememberEntitiesCoordinatorStore.UpdateDone) {
                        RememberEntitiesCoordinatorStore.UpdateDone updateDone = RememberEntitiesCoordinatorStore$UpdateDone$.MODULE$.unapply((RememberEntitiesCoordinatorStore.UpdateDone)object);
                        String string = updateDone._1();
                        String shard = string;
                        if (!this.shardId$1.contains((Object)shard)) {
                            this.$outer.log().warning("{}: Saw remember entities update complete for shard id [{}], while waiting for [{}]", (Object)this.$outer.typeName(), (Object)shard, this.shardId$1.getOrElse(DDataShardCoordinator::org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$10));
                        } else if (!this.waitingForStateWrite$1) {
                            this.$outer.log().debug("{}: The ShardCoordinator saw remember shard start successfully written {}", (Object)this.$outer.typeName(), (Object)this.evt$1);
                            if (this.shardId$1.isDefined()) {
                                this.$outer.timers().cancel((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey);
                            }
                            this.$outer.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$unbecomeAfterUpdate(this.evt$1, this.afterUpdateCallback$1);
                        } else {
                            this.$outer.log().debug("{}: The ShardCoordinator saw remember shard start successfully written {}, waiting for state update", (Object)this.$outer.typeName(), (Object)this.evt$1);
                            this.$outer.context().become(this.$outer.waitingForUpdate(this.evt$1, (Option<String>)this.shardId$1, true, false, this.afterUpdateCallback$1));
                        }
                    } else if (object instanceof RememberEntitiesCoordinatorStore.UpdateFailed) {
                        RememberEntitiesCoordinatorStore.UpdateFailed updateFailed = RememberEntitiesCoordinatorStore$UpdateFailed$.MODULE$.unapply((RememberEntitiesCoordinatorStore.UpdateFailed)object);
                        String string = updateFailed._1();
                        String shard = string;
                        if (this.shardId$1.contains((Object)shard)) {
                            this.$outer.onRememberEntitiesUpdateFailed(shard);
                        } else {
                            this.$outer.log().warning("{}: Got an remember entities update failed for [{}] while waiting for [{}], ignoring", (Object)this.$outer.typeName(), (Object)shard, this.shardId$1.getOrElse(DDataShardCoordinator::org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$11));
                        }
                    } else if (object instanceof RememberEntitiesTimeout) {
                        RememberEntitiesTimeout rememberEntitiesTimeout = DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.unapply((RememberEntitiesTimeout)object);
                        String string = rememberEntitiesTimeout._1();
                        String shard = string;
                        if (this.shardId$1.contains((Object)shard)) {
                            this.$outer.onRememberEntitiesUpdateFailed(shard);
                        } else {
                            this.$outer.log().warning("{}: Got an remember entities update timeout for [{}] while waiting for [{}], ignoring", (Object)this.$outer.typeName(), (Object)shard, this.shardId$1.getOrElse(DDataShardCoordinator::org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$12));
                        }
                    } else if (DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object)) {
                        this.$outer.onRememberEntitiesStoreStopped();
                    } else if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                        this.$outer.log().debug("{}: Late arrival of remembered shards while waiting for update, stashing", (Object)this.$outer.typeName());
                        this.$outer.stash();
                    } else {
                        this.$outer.stash();
                    }
                }
                return BoxedUnit.UNIT;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$10(), org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$11(), org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$12()}, serializedLambda);
            }
        };
    }

    public <E extends ShardCoordinator.Internal.DomainEvent> void org$apache$pekko$cluster$sharding$DDataShardCoordinator$$unbecomeAfterUpdate(E evt, Function1<E, BoxedUnit> afterUpdateCallback) {
        this.context().unbecome();
        afterUpdateCallback.apply(evt);
        if (this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug) {
            this.log().debug("{}: New coordinator state after [{}]: [{}]", (Object)this.typeName(), evt, (Object)this.state());
        }
        this.unstashOneGetShardHomeRequest();
        this.unstashAll();
    }

    public void org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stashGetShardHomeRequest(ActorRef sender, ShardCoordinator.Internal.GetShardHome request) {
        this.log().debug("{}: GetShardHome [{}] request from [{}] stashed, because waiting for initial state or update of state. It will be handled afterwards.", (Object)this.typeName(), (Object)request.shard(), (Object)sender);
        ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)sender);
        this.getShardHomeRequests = (scala.collection.immutable.Set)this.getShardHomeRequests.$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)request));
    }

    @Override
    public void unstashOneGetShardHomeRequest() {
        if (this.getShardHomeRequests.nonEmpty()) {
            Tuple2 requestTuple = (Tuple2)this.getShardHomeRequests.head();
            Tuple2 tuple2 = requestTuple;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ActorRef originalSender = (ActorRef)tuple2._1();
            ShardCoordinator.Internal.GetShardHome request = (ShardCoordinator.Internal.GetShardHome)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)originalSender, (Object)request);
            ActorRef originalSender2 = (ActorRef)tuple22._1();
            ShardCoordinator.Internal.GetShardHome request2 = (ShardCoordinator.Internal.GetShardHome)tuple22._2();
            this.self().tell((Object)request2, originalSender2);
            this.getShardHomeRequests = (scala.collection.immutable.Set)this.getShardHomeRequests.$minus((Object)requestTuple);
            return;
        }
    }

    public void activate() {
        this.context().become(this.active().orElse(this.receiveLateRememberedEntities()));
        this.log().info("{}: ShardCoordinator was moved to the active state with [{}] shards", (Object)this.typeName(), (Object)BoxesRunTime.boxToInteger((int)this.state().shards().size()));
        if (this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug) {
            this.log().debug("{}: Full ShardCoordinator initial state {}", (Object)this.typeName(), (Object)this.state());
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receiveLateRememberedEntities() {
        return new Serializable(this){
            private final /* synthetic */ DDataShardCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> shardIds = set = rememberedShards._1();
                    return true;
                }
                return DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof RememberEntitiesCoordinatorStore.RememberedShards) {
                    scala.collection.immutable.Set<String> set;
                    RememberEntitiesCoordinatorStore.RememberedShards rememberedShards = RememberEntitiesCoordinatorStore$RememberedShards$.MODULE$.unapply((RememberEntitiesCoordinatorStore.RememberedShards)object);
                    scala.collection.immutable.Set<String> shardIds = set = rememberedShards._1();
                    this.$outer.log().debug("{}: Received [{}] remembered shard ids (after state initialized)", (Object)this.$outer.typeName(), (Object)BoxesRunTime.boxToInteger((int)shardIds.size()));
                    if (shardIds.nonEmpty()) {
                        scala.collection.immutable.Set newUnallocatedShards = (scala.collection.immutable.Set)this.$outer.state().unallocatedShards().union((Set)shardIds.diff((Set)this.$outer.state().shards().keySet()));
                        ShardCoordinator.Internal.State state = this.$outer.state();
                        this.$outer.state_$eq(state.copy(state.copy$default$1(), state.copy$default$2(), state.copy$default$3(), (scala.collection.immutable.Set<String>)newUnallocatedShards, state.copy$default$5()));
                        this.$outer.allocateShardHomesForRememberEntities();
                    }
                    this.$outer.timers().cancel((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey);
                    return BoxedUnit.UNIT;
                }
                if (DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$.equals(object)) {
                    this.$outer.getAllRememberedShards();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <E extends ShardCoordinator.Internal.DomainEvent> void update(E evt, Function1<E, BoxedUnit> f) {
        this.sendCoordinatorStateUpdate(evt);
        var4_3 = evt;
        if (!(var4_3 instanceof ShardCoordinator.Internal.ShardHomeAllocated)) ** GOTO lbl-1000
        s = (ShardCoordinator.Internal.ShardHomeAllocated)var4_3;
        if (this.rememberEntities && !this.state().shards().contains((Object)s.shard())) {
            this.rememberShardAllocated(s.shard());
            v0 = this.waitingForUpdate(evt, (Option<String>)Some$.MODULE$.apply((Object)s.shard()), true, true, f);
        } else lbl-1000:
        // 2 sources

        {
            v0 = this.waitingForUpdate(evt, (Option<String>)None$.MODULE$, true, false, f);
        }
        waitingReceive = v0;
        this.context().become(waitingReceive, false);
    }

    public void getCoordinatorState() {
        this.replicator.$bang((Object)Replicator.Get$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey, this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateReadConsistency, Replicator.Get$.MODULE$.$lessinit$greater$default$3()), this.self());
    }

    public void getAllRememberedShards() {
        this.timers().startSingleTimer((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey, (Object)DDataShardCoordinator$RememberEntitiesLoadTimeout$.MODULE$, this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings.tuningParameters().waitingForStateTimeout());
        this.rememberEntitiesStore.foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.$bang((Object)RememberEntitiesCoordinatorStore$GetShards$.MODULE$, this.self()));
    }

    public void sendCoordinatorStateUpdate(ShardCoordinator.Internal.DomainEvent evt) {
        ShardCoordinator.Internal.State s = this.state().updated(evt);
        if (this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$verboseDebug) {
            this.log().debug("{}: Storing new coordinator state [{}]", (Object)this.typeName(), (Object)this.state());
        }
        this.replicator.$bang((Object)Replicator.Update$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$CoordinatorStateKey, (ReplicatedData)LWWRegister$.MODULE$.apply(this.selfUniqueAddress, (Object)this.initEmptyState), this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$stateWriteConsistency, (Option)Some$.MODULE$.apply((Object)evt), (Function1 & Serializable)reg -> reg.withValueOf((Object)s, this.selfUniqueAddress, reg.withValueOf$default$3((Object)s))), this.self());
    }

    public void rememberShardAllocated(String newShard) {
        this.log().debug("{}: Remembering shard allocation [{}]", (Object)this.typeName(), (Object)newShard);
        this.rememberEntitiesStore.foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.$bang((Object)RememberEntitiesCoordinatorStore$AddShard$.MODULE$.apply(newShard), this.self()));
        this.timers().startSingleTimer((Object)DDataShardCoordinator$.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$$RememberEntitiesTimeoutKey, (Object)DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.apply(newShard), this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings.tuningParameters().updatingStateTimeout());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receiveTerminated() {
        return super.receiveTerminated().orElse((PartialFunction)new Serializable(this){
            private final /* synthetic */ DDataShardCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (DDataShardCoordinator$RememberEntitiesStoreStopped$.MODULE$.equals(object)) {
                    this.$outer.onRememberEntitiesStoreStopped();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        });
    }

    public void onRememberEntitiesUpdateFailed(String shardId) {
        this.log().error("{}: The ShardCoordinator was unable to update remembered shard [{}] within 'updating-state-timeout': {} millis, {}", (Object)this.typeName(), (Object)shardId, (Object)BoxesRunTime.boxToLong((long)this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$settings.tuningParameters().updatingStateTimeout().toMillis()), (Object)(this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating ? "terminating" : "retrying"));
        if (this.org$apache$pekko$cluster$sharding$DDataShardCoordinator$$terminating) {
            this.context().stop(this.self());
            return;
        }
        this.rememberShardAllocated(shardId);
    }

    public void onRememberEntitiesStoreStopped() {
        this.log().error("{}: The ShardCoordinator stopping because the remember entities store stopped", (Object)this.typeName());
        this.context().stop(this.self());
    }

    public static final String org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$10() {
        return "";
    }

    public static final String org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$11() {
        return "";
    }

    public static final String org$apache$pekko$cluster$sharding$DDataShardCoordinator$$anon$15$$_$applyOrElse$$anonfun$12() {
        return "";
    }

    public static class RememberEntitiesTimeout
    implements Product,
    Serializable {
        private final String shardId;

        public static RememberEntitiesTimeout apply(String string) {
            return DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.apply(string);
        }

        public static RememberEntitiesTimeout fromProduct(Product product) {
            return DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.fromProduct(product);
        }

        public static RememberEntitiesTimeout unapply(RememberEntitiesTimeout rememberEntitiesTimeout) {
            return DDataShardCoordinator$RememberEntitiesTimeout$.MODULE$.unapply(rememberEntitiesTimeout);
        }

        public RememberEntitiesTimeout(String shardId) {
            this.shardId = shardId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RememberEntitiesTimeout)) return false;
            RememberEntitiesTimeout rememberEntitiesTimeout = (RememberEntitiesTimeout)object;
            String string = this.shardId();
            String string2 = rememberEntitiesTimeout.shardId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!rememberEntitiesTimeout.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RememberEntitiesTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RememberEntitiesTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public RememberEntitiesTimeout copy(String shardId) {
            return new RememberEntitiesTimeout(shardId);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public String _1() {
            return this.shardId();
        }
    }
}

