/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.sharding.ClusterShardingSerializable;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.NoOpShardingFlightRecorder$;
import org.apache.pekko.cluster.sharding.Shard$;
import org.apache.pekko.cluster.sharding.Shard$Active$;
import org.apache.pekko.cluster.sharding.Shard$CurrentShardState$;
import org.apache.pekko.cluster.sharding.Shard$EntitiesMovedToOtherShard$;
import org.apache.pekko.cluster.sharding.Shard$EntityTerminated$;
import org.apache.pekko.cluster.sharding.Shard$GetCurrentShardState$;
import org.apache.pekko.cluster.sharding.Shard$GetShardStats$;
import org.apache.pekko.cluster.sharding.Shard$LeaseAcquireResult$;
import org.apache.pekko.cluster.sharding.Shard$LeaseLost$;
import org.apache.pekko.cluster.sharding.Shard$LeaseRetry$;
import org.apache.pekko.cluster.sharding.Shard$NoState$;
import org.apache.pekko.cluster.sharding.Shard$PassivateIntervalTick$;
import org.apache.pekko.cluster.sharding.Shard$Passivating$;
import org.apache.pekko.cluster.sharding.Shard$RememberEntityStoreCrashed$;
import org.apache.pekko.cluster.sharding.Shard$RememberEntityTimeout$;
import org.apache.pekko.cluster.sharding.Shard$RememberedButNotCreated$;
import org.apache.pekko.cluster.sharding.Shard$RememberedEntityIds$;
import org.apache.pekko.cluster.sharding.Shard$RememberingStart$;
import org.apache.pekko.cluster.sharding.Shard$RememberingStop$;
import org.apache.pekko.cluster.sharding.Shard$RestartTerminatedEntity$;
import org.apache.pekko.cluster.sharding.Shard$ShardStats$;
import org.apache.pekko.cluster.sharding.Shard$WaitingForRestart$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$HandOff$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardStopped$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.cluster.sharding.ShardRegion$HandOffStopper$;
import org.apache.pekko.cluster.sharding.ShardRegion$Passivate$;
import org.apache.pekko.cluster.sharding.ShardRegion$ShardInitialized$;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntity$;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntityAck$;
import org.apache.pekko.cluster.sharding.ShardingFlightRecorder;
import org.apache.pekko.cluster.sharding.ShardingFlightRecorder$;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$GetEntities$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$RememberedEntities$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$Update$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$UpdateDone$;
import org.apache.pekko.cluster.sharding.internal.RememberEntityStarter$;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import org.apache.pekko.coordination.lease.scaladsl.LeaseProvider;
import org.apache.pekko.coordination.lease.scaladsl.LeaseProvider$;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.MessageBuffer;
import org.apache.pekko.util.MessageBufferMap;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

@InternalStableApi
public class Shard
implements Actor,
ActorLogging,
StashSupport,
UnrestrictedStash,
Stash,
Timers {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    public final String org$apache$pekko$cluster$sharding$Shard$$typeName;
    public final String org$apache$pekko$cluster$sharding$Shard$$shardId;
    private final Function1<String, Props> entityProps;
    public final ClusterShardingSettings org$apache$pekko$cluster$sharding$Shard$$settings;
    public final PartialFunction<Object, Tuple2<String, Object>> org$apache$pekko$cluster$sharding$Shard$$extractEntityId;
    private final Object handOffStopMessage;
    public final boolean org$apache$pekko$cluster$sharding$Shard$$verboseDebug;
    private final Option<ActorRef> rememberEntitiesStore;
    private final boolean rememberEntities;
    public final ShardingFlightRecorder org$apache$pekko$cluster$sharding$Shard$$flightRecorder;
    @InternalStableApi
    public final Entities org$apache$pekko$cluster$sharding$Shard$$entities;
    private final MessageBufferMap<String> messageBuffers;
    private Option<ActorRef> handOffStopper;
    private boolean preparingForShutdown;
    private final EntityPassivationStrategy passivationStrategy;
    private final Option<Cancellable> passivateIntervalTask;
    public final Option<Lease> org$apache$pekko$cluster$sharding$Shard$$lease;
    public final FiniteDuration org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval;

    public static Props props(String string, String string2, Function1<String, Props> function1, ClusterShardingSettings clusterShardingSettings, PartialFunction<Object, Tuple2<String, Object>> partialFunction, Function1<Object, String> function12, Object object, Option<RememberEntitiesProvider> option) {
        return Shard$.MODULE$.props(string, string2, function1, clusterShardingSettings, partialFunction, function12, object, option);
    }

    public Shard(String typeName, String shardId, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, Object handOffStopMessage, Option<RememberEntitiesProvider> rememberEntitiesProvider) {
        FiniteDuration finiteDuration;
        this.org$apache$pekko$cluster$sharding$Shard$$typeName = typeName;
        this.org$apache$pekko$cluster$sharding$Shard$$shardId = shardId;
        this.entityProps = entityProps;
        this.org$apache$pekko$cluster$sharding$Shard$$settings = settings;
        this.org$apache$pekko$cluster$sharding$Shard$$extractEntityId = extractEntityId;
        this.handOffStopMessage = handOffStopMessage;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        StashSupport.$init$((StashSupport)this);
        Timers.$init$((Timers)this);
        this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug = this.context().system().settings().config().getBoolean("pekko.cluster.sharding.verbose-debug-logging");
        this.rememberEntitiesStore = rememberEntitiesProvider.map((Function1 & Serializable)provider -> {
            ActorRef store = this.context().actorOf(provider.shardStoreProps(shardId).withDeploy(Deploy$.MODULE$.local()), "RememberEntitiesStore");
            this.context().watchWith(store, (Object)Shard$RememberEntityStoreCrashed$.MODULE$.apply(store));
            return store;
        });
        this.rememberEntities = rememberEntitiesProvider.isDefined();
        this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder = (ShardingFlightRecorder)ShardingFlightRecorder$.MODULE$.apply(this.context().system());
        boolean failOnInvalidStateTransition = this.context().system().settings().config().getBoolean("pekko.cluster.sharding.fail-on-invalid-entity-state-transition");
        this.org$apache$pekko$cluster$sharding$Shard$$entities = new Entities(this.log(), settings.rememberEntities(), this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug, failOnInvalidStateTransition);
        this.messageBuffers = new MessageBufferMap();
        this.handOffStopper = None$.MODULE$;
        this.preparingForShutdown = false;
        this.passivationStrategy = EntityPassivationStrategy$.MODULE$.apply(settings);
        this.passivateIntervalTask = this.passivationStrategy.scheduledInterval().map((Function1 & Serializable)interval -> this.context().system().scheduler().scheduleWithFixedDelay(interval, interval, this.self(), (Object)Shard$PassivateIntervalTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
        this.org$apache$pekko$cluster$sharding$Shard$$lease = settings.leaseSettings().map((Function1 & Serializable)ls -> ((LeaseProvider)LeaseProvider$.MODULE$.apply(this.context().system())).getLease(new StringBuilder(8).append(this.context().system().name()).append("-shard-").append(typeName).append("-").append(shardId).toString(), ls.leaseImplementation(), ((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().hostPort()));
        Option<LeaseUsageSettings> option = settings.leaseSettings();
        if (option instanceof Some) {
            LeaseUsageSettings l = (LeaseUsageSettings)((Some)option).value();
            finiteDuration = l.leaseRetryInterval();
        } else if (None$.MODULE$.equals(option)) {
            finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
        } else {
            throw new MatchError(option);
        }
        this.org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval = finiteDuration;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                throw new IllegalStateException("Default receive never expected to actually be used");
            }
        };
    }

    public void preStart() {
        ((Cluster)Cluster$.MODULE$.apply(this.context().system())).subscribe(this.self(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberPreparingForShutdown.class, ClusterEvent.MemberReadyForShutdown.class}));
        this.acquireLeaseIfNeeded();
    }

    public void acquireLeaseIfNeeded() {
        Option<Lease> option = this.org$apache$pekko$cluster$sharding$Shard$$lease;
        if (option instanceof Some) {
            Lease l = (Lease)((Some)option).value();
            this.org$apache$pekko$cluster$sharding$Shard$$tryGetLease(l);
            this.context().become(this.awaitingLease());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.tryLoadRememberedEntities();
            return;
        }
        throw new MatchError(option);
    }

    private PartialFunction<Object, BoxedUnit> awaitingLease() {
        return new Serializable(this){
            private final /* synthetic */ Shard $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof LeaseAcquireResult) {
                    LeaseAcquireResult leaseAcquireResult = Shard$LeaseAcquireResult$.MODULE$.unapply((LeaseAcquireResult)object);
                    boolean bl = leaseAcquireResult._1();
                    Option<Throwable> option = leaseAcquireResult._2();
                    if (bl) {
                        return true;
                    }
                    if (!bl) {
                        if (None$.MODULE$.equals(option)) {
                            return true;
                        }
                        if (option instanceof Some) {
                            Throwable t = (Throwable)((Some)option).value();
                            return true;
                        }
                    }
                }
                if (Shard$LeaseRetry$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof LeaseLost) {
                    LeaseLost ll = (LeaseLost)object;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                Object msg = object;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof LeaseAcquireResult) {
                    LeaseAcquireResult leaseAcquireResult = Shard$LeaseAcquireResult$.MODULE$.unapply((LeaseAcquireResult)object);
                    boolean bl = leaseAcquireResult._1();
                    Option<Throwable> option = leaseAcquireResult._2();
                    if (bl) {
                        this.$outer.log().debug("{}: Lease acquired", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName);
                        this.$outer.tryLoadRememberedEntities();
                        return BoxedUnit.UNIT;
                    }
                    if (!bl) {
                        if (None$.MODULE$.equals(option)) {
                            this.$outer.log().error("{}: Failed to get lease for shard id [{}]. Retry in {}", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$shardId, (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval)));
                            this.$outer.timers().startSingleTimer((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$LeaseRetryTimer, (Object)Shard$LeaseRetry$.MODULE$, this.$outer.org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval);
                            return BoxedUnit.UNIT;
                        }
                        if (option instanceof Some) {
                            Throwable t = (Throwable)((Some)option).value();
                            this.$outer.log().error(t, "{}: Failed to get lease for shard id [{}]. Retry in {}", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$shardId, (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval);
                            this.$outer.timers().startSingleTimer((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$LeaseRetryTimer, (Object)Shard$LeaseRetry$.MODULE$, this.$outer.org$apache$pekko$cluster$sharding$Shard$$leaseRetryInterval);
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                if (Shard$LeaseRetry$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$tryGetLease((Lease)this.$outer.org$apache$pekko$cluster$sharding$Shard$$lease.get());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof LeaseLost) {
                    LeaseLost ll = (LeaseLost)object;
                    this.$outer.receiveLeaseLost(ll);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveMemberEvent(me);
                    return BoxedUnit.UNIT;
                }
                Object msg = object;
                if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.$outer.log().debug("{}: Got msg of type [{}] from [{}] while waiting for lease, stashing", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg.getClass().getName(), (Object)this.$outer.sender());
                }
                this.$outer.stash();
                return BoxedUnit.UNIT;
            }
        };
    }

    public void org$apache$pekko$cluster$sharding$Shard$$receiveMemberEvent(ClusterEvent.MemberEvent event) {
        ClusterEvent.MemberEvent memberEvent = event;
        if (memberEvent instanceof ClusterEvent.MemberReadyForShutdown || memberEvent instanceof ClusterEvent.MemberPreparingForShutdown) {
            if (!this.preparingForShutdown) {
                this.log().info("{}: Preparing for shutdown", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName);
                this.preparingForShutdown = true;
                return;
            }
            return;
        }
    }

    public void org$apache$pekko$cluster$sharding$Shard$$tryGetLease(Lease l) {
        this.log().info("{}: Acquiring lease {}", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)l.settings());
        org.apache.pekko.pattern.package$.MODULE$.pipe(l.acquire((Function1)(JProcedure1 & Serializable)reason -> this.self().$bang((Object)Shard$LeaseLost$.MODULE$.apply((Option<Throwable>)reason), this.self())).map((Function1 & Serializable)r -> Shard$LeaseAcquireResult$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)r), (Option<Throwable>)None$.MODULE$), (ExecutionContext)this.context().dispatcher()).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable t = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable t = throwable = x;
                return Shard$LeaseAcquireResult$.MODULE$.apply(false, (Option<Throwable>)Some$.MODULE$.apply((Object)t));
            }
        }, (ExecutionContext)this.context().dispatcher()), (ExecutionContext)this.context().dispatcher()).to(this.self());
    }

    public void tryLoadRememberedEntities() {
        Option<ActorRef> option = this.rememberEntitiesStore;
        if (option instanceof Some) {
            ActorRef store = (ActorRef)((Some)option).value();
            this.log().debug("{}: Waiting for load of entity ids using [{}] to complete", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)store);
            store.$bang((Object)RememberEntitiesShardStore$GetEntities$.MODULE$, this.self());
            this.timers().startSingleTimer((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$RememberEntityTimeoutKey, (Object)Shard$RememberEntityTimeout$.MODULE$.apply(RememberEntitiesShardStore$GetEntities$.MODULE$), this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().waitingForStateTimeout());
            this.context().become(this.awaitingRememberedEntities());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.shardInitialized();
            return;
        }
        throw new MatchError(option);
    }

    public PartialFunction<Object, BoxedUnit> awaitingRememberedEntities() {
        return new Serializable(this){
            private final /* synthetic */ Shard $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                RememberEntityTimeout rememberEntityTimeout;
                RememberEntitiesShardStore.Command command;
                Object object = x;
                if (object instanceof RememberEntitiesShardStore.RememberedEntities) {
                    Set<String> set;
                    RememberEntitiesShardStore.RememberedEntities rememberedEntities = RememberEntitiesShardStore$RememberedEntities$.MODULE$.unapply((RememberEntitiesShardStore.RememberedEntities)object);
                    Set<String> entityIds = set = rememberedEntities._1();
                    return true;
                }
                if (object instanceof RememberEntityTimeout && RememberEntitiesShardStore$GetEntities$.MODULE$.equals(command = (rememberEntityTimeout = Shard$RememberEntityTimeout$.MODULE$.unapply((RememberEntityTimeout)object))._1())) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                Object msg = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                RememberEntityTimeout rememberEntityTimeout;
                RememberEntitiesShardStore.Command command;
                Object object = x;
                if (object instanceof RememberEntitiesShardStore.RememberedEntities) {
                    Set<String> set;
                    RememberEntitiesShardStore.RememberedEntities rememberedEntities = RememberEntitiesShardStore$RememberedEntities$.MODULE$.unapply((RememberEntitiesShardStore.RememberedEntities)object);
                    Set<String> entityIds = set = rememberedEntities._1();
                    this.$outer.timers().cancel((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$RememberEntityTimeoutKey);
                    this.$outer.onEntitiesRemembered(entityIds);
                } else if (object instanceof RememberEntityTimeout && RememberEntitiesShardStore$GetEntities$.MODULE$.equals(command = (rememberEntityTimeout = Shard$RememberEntityTimeout$.MODULE$.unapply((RememberEntityTimeout)object))._1())) {
                    this.$outer.loadingEntityIdsFailed();
                } else if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveMemberEvent(me);
                } else {
                    Object msg = object;
                    if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                        this.$outer.log().debug("{}: Got msg of type [{}] from [{}] while waiting for remember entities, stashing", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg.getClass().getName(), (Object)this.$outer.sender());
                    }
                    this.$outer.stash();
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void loadingEntityIdsFailed() {
        this.log().error("{}: Failed to load initial entity ids from remember entities store within [{}], stopping shard for backoff and restart", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().waitingForStateTimeout())));
        this.context().stop(this.self());
    }

    public void onEntitiesRemembered(Set<String> ids) {
        if (ids.nonEmpty()) {
            this.org$apache$pekko$cluster$sharding$Shard$$entities.alreadyRemembered(ids);
            this.log().debug("{}: Restarting set of [{}] entities", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)BoxesRunTime.boxToInteger((int)ids.size()));
            this.context().actorOf(RememberEntityStarter$.MODULE$.props(this.context().parent(), this.self(), this.org$apache$pekko$cluster$sharding$Shard$$shardId, ids, this.org$apache$pekko$cluster$sharding$Shard$$settings), "RememberEntitiesStarter");
        }
        this.shardInitialized();
    }

    private void shardInitialized() {
        this.log().debug("{}: Shard initialized", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName);
        this.context().parent().$bang((Object)ShardRegion$ShardInitialized$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self());
        this.context().become(this.idle());
        this.unstashAll();
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return new Serializable(this){
            private final /* synthetic */ Shard $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                if (object instanceof EntityTerminated) {
                    ActorRef actorRef;
                    EntityTerminated entityTerminated = Shard$EntityTerminated$.MODULE$.unapply((EntityTerminated)object);
                    ActorRef ref = actorRef = entityTerminated._1();
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                    ShardCoordinator.Internal.CoordinatorMessage msg = (ShardCoordinator.Internal.CoordinatorMessage)object;
                    return true;
                }
                if (object instanceof RememberEntityCommand) {
                    RememberEntityCommand msg = (RememberEntityCommand)object;
                    return true;
                }
                if (object instanceof ShardRegion.StartEntity) {
                    ShardRegion.StartEntity msg = (ShardRegion.StartEntity)object;
                    return true;
                }
                if (object instanceof ShardRegion.SetActiveEntityLimit) {
                    ShardRegion.SetActiveEntityLimit msg = (ShardRegion.SetActiveEntityLimit)object;
                    return true;
                }
                if (object instanceof ShardRegion.ShardsUpdated) {
                    ShardRegion.ShardsUpdated msg = (ShardRegion.ShardsUpdated)object;
                    return true;
                }
                if (object instanceof ShardRegion.Passivate) {
                    Object object2;
                    ShardRegion.Passivate passivate = ShardRegion$Passivate$.MODULE$.unapply((ShardRegion.Passivate)object);
                    Object stopMessage = object2 = passivate._1();
                    return true;
                }
                if (Shard$PassivateIntervalTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ShardQuery) {
                    ShardQuery msg = (ShardQuery)object;
                    return true;
                }
                if (object instanceof LeaseLost) {
                    LeaseLost msg = (LeaseLost)object;
                    return true;
                }
                if (object instanceof RememberEntityStoreCrashed) {
                    RememberEntityStoreCrashed msg = (RememberEntityStoreCrashed)object;
                    return true;
                }
                Object msg = object;
                return this.$outer.org$apache$pekko$cluster$sharding$Shard$$extractEntityId.isDefinedAt(msg);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveTerminated(ref);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveMemberEvent(me);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof EntityTerminated) {
                    ActorRef actorRef;
                    EntityTerminated entityTerminated = Shard$EntityTerminated$.MODULE$.unapply((EntityTerminated)object);
                    ActorRef ref = actorRef = entityTerminated._1();
                    this.$outer.entityTerminated(ref);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                    ShardCoordinator.Internal.CoordinatorMessage msg = (ShardCoordinator.Internal.CoordinatorMessage)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveCoordinatorMessage(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RememberEntityCommand) {
                    RememberEntityCommand msg = (RememberEntityCommand)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveRememberEntityCommand(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.StartEntity) {
                    ShardRegion.StartEntity msg = (ShardRegion.StartEntity)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$startEntity(msg.entityId(), (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()));
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.SetActiveEntityLimit) {
                    ShardRegion.SetActiveEntityLimit msg = (ShardRegion.SetActiveEntityLimit)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$activeEntityLimitUpdated(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.ShardsUpdated) {
                    ShardRegion.ShardsUpdated msg = (ShardRegion.ShardsUpdated)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$shardsUpdated(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.Passivate) {
                    Object object2;
                    ShardRegion.Passivate passivate = ShardRegion$Passivate$.MODULE$.unapply((ShardRegion.Passivate)object);
                    Object stopMessage = object2 = passivate._1();
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$passivate(this.$outer.sender(), stopMessage);
                    return BoxedUnit.UNIT;
                }
                if (Shard$PassivateIntervalTick$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$passivateEntitiesAfterInterval();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardQuery) {
                    ShardQuery msg = (ShardQuery)object;
                    this.$outer.receiveShardQuery(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof LeaseLost) {
                    LeaseLost msg = (LeaseLost)object;
                    this.$outer.receiveLeaseLost(msg);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RememberEntityStoreCrashed) {
                    RememberEntityStoreCrashed msg = (RememberEntityStoreCrashed)object;
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$rememberEntityStoreCrashed(msg);
                    return BoxedUnit.UNIT;
                }
                Object msg = object;
                if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$extractEntityId.isDefinedAt(msg)) {
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$deliverMessage(msg, this.$outer.sender());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void rememberUpdate(Set<String> add, Set<String> remove) {
        Option<ActorRef> option = this.rememberEntitiesStore;
        if (None$.MODULE$.equals(option)) {
            this.onUpdateDone(add, remove);
            return;
        }
        if (option instanceof Some) {
            ActorRef store = (ActorRef)((Some)option).value();
            this.sendToRememberStore(store, add, remove);
            return;
        }
        throw new MatchError(option);
    }

    public Set<String> rememberUpdate$default$1() {
        return Set$.MODULE$.empty();
    }

    public Set<String> rememberUpdate$default$2() {
        return Set$.MODULE$.empty();
    }

    public void sendToRememberStore(ActorRef store, Set<String> storingStarts, Set<String> storingStops) {
        if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
            this.log().debug("{}: Remember update [{}] and stops [{}] triggered", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)storingStarts.mkString(", "), (Object)storingStops.mkString(", "));
        }
        ShardingFlightRecorder shardingFlightRecorder = this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder;
        NoOpShardingFlightRecorder$ noOpShardingFlightRecorder$ = NoOpShardingFlightRecorder$.MODULE$;
        if (shardingFlightRecorder == null ? noOpShardingFlightRecorder$ != null : !shardingFlightRecorder.equals(noOpShardingFlightRecorder$)) {
            storingStarts.foreach((Function1)(JProcedure1 & Serializable)entityId -> this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder.rememberEntityAdd((String)entityId));
            storingStops.foreach((Function1)(JProcedure1 & Serializable)id -> this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder.rememberEntityRemove((String)id));
        }
        long startTimeNanos = System.nanoTime();
        RememberEntitiesShardStore.Update update = RememberEntitiesShardStore$Update$.MODULE$.apply(storingStarts, storingStops);
        store.$bang((Object)update, this.self());
        this.timers().startSingleTimer((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$RememberEntityTimeoutKey, (Object)Shard$RememberEntityTimeout$.MODULE$.apply(update), this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().updatingStateTimeout());
        this.context().become(this.waitingForRememberEntitiesStore(update, startTimeNanos));
    }

    private PartialFunction<Object, BoxedUnit> waitingForRememberEntitiesStore(RememberEntitiesShardStore.Update update, long startTimeNanos) {
        return new Serializable(update, startTimeNanos, this){
            private final RememberEntitiesShardStore.Update update$1;
            private final long startTimeNanos$1;
            private final /* synthetic */ Shard $outer;
            {
                this.update$1 = update$2;
                this.startTimeNanos$1 = startTimeNanos$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof RememberEntitiesShardStore.UpdateDone) {
                    RememberEntitiesShardStore.UpdateDone updateDone = RememberEntitiesShardStore$UpdateDone$.MODULE$.unapply((RememberEntitiesShardStore.UpdateDone)object);
                    Set<String> set = updateDone._1();
                    Set<String> set2 = updateDone._2();
                    Set<String> storedStarts = set;
                    Set<String> storedStops = set2;
                    return true;
                }
                if (object instanceof RememberEntityTimeout) {
                    RememberEntityTimeout rememberEntityTimeout = Shard$RememberEntityTimeout$.MODULE$.unapply((RememberEntityTimeout)object);
                    RememberEntitiesShardStore.Command command = rememberEntityTimeout._1();
                    RememberEntitiesShardStore.Update update = this.update$1;
                    RememberEntitiesShardStore.Command command2 = command;
                    if (!(update != null ? !((Object)update).equals(command2) : command2 != null)) {
                        return true;
                    }
                }
                if (object instanceof ShardRegion.StartEntity) {
                    String string;
                    ShardRegion.StartEntity startEntity = ShardRegion$StartEntity$.MODULE$.unapply((ShardRegion.StartEntity)object);
                    String entityId = string = startEntity._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof EntityTerminated) {
                    ActorRef actorRef;
                    EntityTerminated entityTerminated = Shard$EntityTerminated$.MODULE$.unapply((EntityTerminated)object);
                    ActorRef ref = actorRef = entityTerminated._1();
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                    return true;
                }
                if (object instanceof RememberEntityCommand) {
                    RememberEntityCommand cmd = (RememberEntityCommand)object;
                    return true;
                }
                if (object instanceof LeaseLost) {
                    LeaseLost l = (LeaseLost)object;
                    return true;
                }
                if (object instanceof ShardRegion.Passivate) {
                    Object object2;
                    ShardRegion.Passivate passivate = ShardRegion$Passivate$.MODULE$.unapply((ShardRegion.Passivate)object);
                    Object stopMessage = object2 = passivate._1();
                    return true;
                }
                if (object instanceof ShardQuery) {
                    ShardQuery msg = (ShardQuery)object;
                    return true;
                }
                if (Shard$PassivateIntervalTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RememberEntityStoreCrashed) {
                    RememberEntityStoreCrashed msg = (RememberEntityStoreCrashed)object;
                    return true;
                }
                if (object instanceof ShardRegion.ShardsUpdated) {
                    ShardRegion.ShardsUpdated msg = (ShardRegion.ShardsUpdated)object;
                    return true;
                }
                Object msg = object;
                if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$extractEntityId.isDefinedAt(msg)) {
                    return true;
                }
                Object msg2 = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof RememberEntitiesShardStore.UpdateDone) {
                    RememberEntitiesShardStore.UpdateDone updateDone = RememberEntitiesShardStore$UpdateDone$.MODULE$.unapply((RememberEntitiesShardStore.UpdateDone)object);
                    Set<String> set = updateDone._1();
                    Set<String> set2 = updateDone._2();
                    Set<String> storedStarts = set;
                    Set<String> storedStops = set2;
                    long duration = System.nanoTime() - this.startTimeNanos$1;
                    if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                        this.$outer.log().debug("{}: Update done for ids, started [{}], stopped [{}]. Duration {} ms", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)storedStarts.mkString(", "), (Object)storedStops.mkString(", "), (Object)BoxesRunTime.boxToLong((long)new package.DurationLong(package$.MODULE$.DurationLong(duration)).nanos().toMillis()));
                    }
                    this.$outer.org$apache$pekko$cluster$sharding$Shard$$flightRecorder.rememberEntityOperation(duration);
                    this.$outer.timers().cancel((Object)Shard$.org$apache$pekko$cluster$sharding$Shard$$$RememberEntityTimeoutKey);
                    this.$outer.onUpdateDone(storedStarts, storedStops);
                } else {
                    if (object instanceof RememberEntityTimeout) {
                        RememberEntityTimeout rememberEntityTimeout = Shard$RememberEntityTimeout$.MODULE$.unapply((RememberEntityTimeout)object);
                        RememberEntitiesShardStore.Command command = rememberEntityTimeout._1();
                        RememberEntitiesShardStore.Update update = this.update$1;
                        RememberEntitiesShardStore.Command command2 = command;
                        if (!(update != null ? !((Object)update).equals(command2) : command2 != null)) {
                            this.$outer.log().error("{}: Remember entity store did not respond, restarting shard", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName);
                            throw new RuntimeException(new StringBuilder(28).append("Async write timed out after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().updatingStateTimeout()))).toString());
                        }
                    }
                    if (object instanceof ShardRegion.StartEntity) {
                        String string;
                        ShardRegion.StartEntity startEntity = ShardRegion$StartEntity$.MODULE$.unapply((ShardRegion.StartEntity)object);
                        String entityId = string = startEntity._1();
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$startEntity(entityId, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()));
                    } else if (object instanceof ClusterEvent.MemberEvent) {
                        ClusterEvent.MemberEvent me = (ClusterEvent.MemberEvent)object;
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveMemberEvent(me);
                    } else if (object instanceof Terminated) {
                        ActorRef actorRef;
                        Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                        ActorRef ref = actorRef = terminated._1();
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveTerminated(ref);
                    } else if (object instanceof EntityTerminated) {
                        ActorRef actorRef;
                        EntityTerminated entityTerminated = Shard$EntityTerminated$.MODULE$.unapply((EntityTerminated)object);
                        ActorRef ref = actorRef = entityTerminated._1();
                        this.$outer.entityTerminated(ref);
                    } else if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                        this.$outer.stash();
                    } else if (object instanceof RememberEntityCommand) {
                        RememberEntityCommand cmd = (RememberEntityCommand)object;
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveRememberEntityCommand(cmd);
                    } else if (object instanceof LeaseLost) {
                        LeaseLost l = (LeaseLost)object;
                        this.$outer.receiveLeaseLost(l);
                    } else if (object instanceof ShardRegion.Passivate) {
                        Object object2;
                        ShardRegion.Passivate passivate = ShardRegion$Passivate$.MODULE$.unapply((ShardRegion.Passivate)object);
                        Object stopMessage = object2 = passivate._1();
                        if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                            String string = this.$outer.org$apache$pekko$cluster$sharding$Shard$$entities.entityId(this.$outer.sender());
                            this.$outer.log().debug("{}: Passivation of [{}] arrived while updating", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, OptionVal$.MODULE$.getOrElse$extension((Object)string, (Object)new StringBuilder(14).append("Unknown actor ").append(this.$outer.sender()).toString()));
                        }
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$passivate(this.$outer.sender(), stopMessage);
                    } else if (object instanceof ShardQuery) {
                        ShardQuery msg = (ShardQuery)object;
                        this.$outer.receiveShardQuery(msg);
                    } else if (Shard$PassivateIntervalTick$.MODULE$.equals(object)) {
                        this.$outer.stash();
                    } else if (object instanceof RememberEntityStoreCrashed) {
                        RememberEntityStoreCrashed msg = (RememberEntityStoreCrashed)object;
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$rememberEntityStoreCrashed(msg);
                    } else if (object instanceof ShardRegion.ShardsUpdated) {
                        ShardRegion.ShardsUpdated msg = (ShardRegion.ShardsUpdated)object;
                        this.$outer.org$apache$pekko$cluster$sharding$Shard$$shardsUpdated(msg);
                    } else {
                        Object msg = object;
                        if (this.$outer.org$apache$pekko$cluster$sharding$Shard$$extractEntityId.isDefinedAt(msg)) {
                            this.$outer.org$apache$pekko$cluster$sharding$Shard$$deliverMessage(msg, this.$outer.sender());
                        } else {
                            Object msg2 = object;
                            this.$outer.log().warning("{}: Stashing unexpected message [{}] while waiting for remember entities update of starts [{}], stops [{}]", (Object)this.$outer.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg2.getClass().getName(), (Object)this.update$1.started().mkString(", "), (Object)this.update$1.stopped().mkString(", "));
                            this.$outer.stash();
                        }
                    }
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void onUpdateDone(Set<String> starts, Set<String> stops) {
        starts.foreach((Function1)(JProcedure1 & Serializable)entityId -> {
            EntityState stateBeforeStart = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState((String)entityId);
            this.getOrCreateEntity((String)entityId);
            this.sendMsgBuffer((String)entityId);
            EntityState entityState = stateBeforeStart;
            if (entityState instanceof RememberingStart) {
                Set<ActorRef> set;
                RememberingStart rememberingStart = Shard$RememberingStart$.MODULE$.unapply((RememberingStart)entityState);
                Set<ActorRef> ackTo = set = rememberingStart._1();
                ackTo.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.$bang((Object)ShardRegion$StartEntityAck$.MODULE$.apply((String)entityId, this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self()));
                return;
            }
        });
        stops.foreach((Function1)(JProcedure1 & Serializable)entityId -> {
            EntityState entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState((String)entityId);
            if (Shard$RememberingStop$.MODULE$.equals(entityState)) {
                this.passivateCompleted((String)entityId);
                return;
            }
            EntityState state = entityState;
            throw new IllegalStateException(new StringBuilder(64).append("Unexpected state [").append(state).append("] when storing stop completed for entity id [").append((String)entityId).append("]").toString());
        });
        Tuple2<scala.collection.immutable.Map<String, RememberingStart>, Set<String>> tuple2 = this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberEntities();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map pendingStarts = (scala.collection.immutable.Map)tuple2._1();
        Set pendingStops = (Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)pendingStarts, (Object)pendingStops);
        scala.collection.immutable.Map pendingStarts2 = (scala.collection.immutable.Map)tuple22._1();
        Set pendingStops2 = (Set)tuple22._2();
        if (pendingStarts2.isEmpty() && pendingStops2.isEmpty()) {
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: Update complete, no pending updates, going to idle", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName);
            }
            this.unstashAll();
            this.context().become(this.idle());
            return;
        }
        Set pendingStartIds = pendingStarts2.keySet();
        if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
            this.log().debug("{}: Update complete, pending updates, doing another write. Starts [{}], stops [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)pendingStartIds.mkString(", "), (Object)pendingStops2.mkString(", "));
        }
        this.rememberUpdate((Set<String>)pendingStartIds, (Set<String>)pendingStops2);
    }

    public void receiveLeaseLost(LeaseLost msg) {
        String string;
        LoggingAdapter loggingAdapter = this.log();
        Integer n = BoxesRunTime.boxToInteger((int)this.org$apache$pekko$cluster$sharding$Shard$$entities.size());
        Option<Throwable> option = msg.reason();
        if (option instanceof Some) {
            Throwable reason = (Throwable)((Some)option).value();
            string = new StringBuilder(26).append(" Reason for losing lease: ").append(reason).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        loggingAdapter.error("{}: Shard id [{}] lease lost, stopping shard and killing [{}] entities.{}", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId, (Object)n, (Object)string);
        this.context().stop(this.self());
    }

    public void org$apache$pekko$cluster$sharding$Shard$$receiveRememberEntityCommand(RememberEntityCommand msg) {
        RememberEntityCommand rememberEntityCommand = msg;
        if (rememberEntityCommand instanceof RestartTerminatedEntity) {
            RestartTerminatedEntity restartTerminatedEntity = Shard$RestartTerminatedEntity$.MODULE$.unapply((RestartTerminatedEntity)rememberEntityCommand);
            String string = restartTerminatedEntity._1();
            String entityId2 = string;
            EntityState entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState(entityId2);
            if (Shard$WaitingForRestart$.MODULE$.equals(entityState)) {
                if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.log().debug("{}: Restarting entity unexpectedly terminated entity [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId2);
                }
                this.getOrCreateEntity(entityId2);
                return;
            }
            if (entityState instanceof Active) {
                Active active = Shard$Active$.MODULE$.unapply((Active)entityState);
                ActorRef actorRef = active._1();
                if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.log().debug("{}: Got RestartTerminatedEntity for [{}] but it is already running", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId2);
                    return;
                }
                return;
            }
            EntityState other = entityState;
            throw new IllegalStateException(new StringBuilder(64).append("Unexpected state for [").append(entityId2).append("] when getting RestartTerminatedEntity: [").append(other).append("]").toString());
        }
        if (rememberEntityCommand instanceof EntitiesMovedToOtherShard) {
            Set<String> set;
            EntitiesMovedToOtherShard entitiesMovedToOtherShard = Shard$EntitiesMovedToOtherShard$.MODULE$.unapply((EntitiesMovedToOtherShard)rememberEntityCommand);
            Set<String> movedEntityIds = set = entitiesMovedToOtherShard._1();
            this.log().info("{}: Clearing [{}] remembered entities started elsewhere because of changed shard id extractor", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)BoxesRunTime.boxToInteger((int)movedEntityIds.size()));
            movedEntityIds.foreach((Function1)(JProcedure1 & Serializable)entityId -> {
                EntityState entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState((String)entityId);
                if (Shard$RememberedButNotCreated$.MODULE$.equals(entityState)) {
                    this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStop((String)entityId);
                    return;
                }
                EntityState other = entityState;
                throw new IllegalStateException(new StringBuilder(54).append("Unexpected state for [").append((String)entityId).append("] when getting ShardIdsMoved: [").append(other).append("]").toString());
            });
            this.rememberUpdate(this.rememberUpdate$default$1(), movedEntityIds);
            return;
        }
        throw new MatchError((Object)rememberEntityCommand);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$startEntity(String entityId, Option<ActorRef> ackTo) {
        EntityState entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState(entityId);
        if (entityState instanceof Active) {
            Active active = Shard$Active$.MODULE$.unapply((Active)entityState);
            ActorRef actorRef = active._1();
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: Request to start entity [{}] (Already started)", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
            }
            ackTo.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.$bang((Object)ShardRegion$StartEntityAck$.MODULE$.apply(entityId, this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self()));
            return;
        }
        if (entityState instanceof RememberingStart) {
            this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, ackTo);
            return;
        }
        if (Shard$RememberedButNotCreated$.MODULE$.equals(entityState) || Shard$WaitingForRestart$.MODULE$.equals(entityState)) {
            Mirror.Singleton state = (Mirror.Singleton)entityState;
            this.log().debug("{}: Request to start entity [{}] (in state [{}])", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId, (Object)state);
            this.getOrCreateEntity(entityId);
            ackTo.foreach((Function1)(JProcedure1 & Serializable)_$3 -> _$3.$bang((Object)ShardRegion$StartEntityAck$.MODULE$.apply(entityId, this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self()));
            return;
        }
        if (entityState instanceof Passivating) {
            Passivating passivating = Shard$Passivating$.MODULE$.unapply((Passivating)entityState);
            ActorRef actorRef = passivating._1();
            this.messageBuffers.append((Object)entityId, (Object)ShardRegion$StartEntity$.MODULE$.apply(entityId), (ActorRef)ackTo.getOrElse(Shard::startEntity$$anonfun$3));
            return;
        }
        if (Shard$RememberingStop$.MODULE$.equals(entityState)) {
            this.stash();
            return;
        }
        if (Shard$NoState$.MODULE$.equals(entityState)) {
            this.log().debug("{}: Request to start entity [{}] and ack to [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId, ackTo);
            this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, ackTo);
            this.rememberUpdate((Set<String>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{entityId}))), this.rememberUpdate$default$2());
            return;
        }
        throw new MatchError((Object)entityState);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$receiveCoordinatorMessage(ShardCoordinator.Internal.CoordinatorMessage msg) {
        ShardCoordinator.Internal.CoordinatorMessage coordinatorMessage = msg;
        if (coordinatorMessage instanceof ShardCoordinator.Internal.HandOff) {
            ShardCoordinator.Internal.HandOff handOff = ShardCoordinator$Internal$HandOff$.MODULE$.unapply((ShardCoordinator.Internal.HandOff)coordinatorMessage);
            String string = handOff._1();
            String string2 = this.org$apache$pekko$cluster$sharding$Shard$$shardId;
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                this.handOff(this.sender());
                return;
            }
            String shard = string;
            this.log().warning("{}: Shard [{}] can not hand off for another Shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId, (Object)shard);
            return;
        }
        this.unhandled(msg);
    }

    public void receiveShardQuery(ShardQuery msg) {
        ShardQuery shardQuery = msg;
        if (Shard$GetCurrentShardState$.MODULE$.equals(shardQuery)) {
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: GetCurrentShardState, full state: [{}], active: [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$entities, this.org$apache$pekko$cluster$sharding$Shard$$entities.activeEntityIds());
            }
            this.sender().$bang((Object)Shard$CurrentShardState$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$Shard$$shardId, this.org$apache$pekko$cluster$sharding$Shard$$entities.activeEntityIds()), this.self());
            return;
        }
        if (Shard$GetShardStats$.MODULE$.equals(shardQuery)) {
            this.sender().$bang((Object)Shard$ShardStats$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$Shard$$shardId, this.org$apache$pekko$cluster$sharding$Shard$$entities.size()), this.self());
            return;
        }
        throw new MatchError((Object)shardQuery);
    }

    private void handOff(ActorRef replyTo) {
        Option<ActorRef> option = this.handOffStopper;
        if (option instanceof Some) {
            this.log().warning("{}: HandOff shard [{}] received during existing handOff", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().debug("{}: HandOff shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId);
            Set<ActorRef> activeEntities = this.org$apache$pekko$cluster$sharding$Shard$$entities.activeEntities();
            if (this.preparingForShutdown) {
                this.log().info("{}: HandOff shard [{}] while preparing for shutdown. Stopping right away.", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId);
                activeEntities.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.$bang(this.handOffStopMessage, this.self()));
                replyTo.$bang((Object)ShardCoordinator$Internal$ShardStopped$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self());
                this.context().stop(this.self());
                return;
            }
            if (activeEntities.nonEmpty() && !this.preparingForShutdown) {
                FiniteDuration entityHandOffTimeout = this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().handOffTimeout().$minus(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds()).max(new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
                this.log().debug("{}: Starting HandOffStopper for shard [{}] to terminate [{}] entities.", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId, (Object)BoxesRunTime.boxToInteger((int)activeEntities.size()));
                activeEntities.foreach((Function1 & Serializable)subject -> this.context().unwatch(subject));
                this.handOffStopper = Some$.MODULE$.apply((Object)this.context().watch(this.context().actorOf(ShardRegion$HandOffStopper$.MODULE$.props(this.org$apache$pekko$cluster$sharding$Shard$$typeName, this.org$apache$pekko$cluster$sharding$Shard$$shardId, replyTo, activeEntities, this.handOffStopMessage, entityHandOffTimeout), "HandOffStopper")));
                this.context().become((PartialFunction)new Serializable(this){
                    private final /* synthetic */ Shard $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof Terminated) {
                            ActorRef actorRef;
                            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                            ActorRef ref = actorRef = terminated._1();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof Terminated) {
                            ActorRef actorRef;
                            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                            ActorRef ref = actorRef = terminated._1();
                            this.$outer.org$apache$pekko$cluster$sharding$Shard$$receiveTerminated(ref);
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply(x);
                    }
                });
                return;
            }
            replyTo.$bang((Object)ShardCoordinator$Internal$ShardStopped$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$Shard$$shardId), this.self());
            this.context().stop(this.self());
            return;
        }
        throw new MatchError(option);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$receiveTerminated(ActorRef ref) {
        if (this.handOffStopper.contains((Object)ref)) {
            this.context().stop(this.self());
            return;
        }
    }

    @InternalStableApi
    public void entityTerminated(ActorRef ref) {
        String string = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityId(ref);
        String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
            String string3;
            String entityId = string3 = (String)OptionVal$.MODULE$.get$extension((Object)string2);
            this.passivationStrategy.entityTerminated(entityId);
            EntityState entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState(entityId);
            if (Shard$RememberingStop$.MODULE$.equals(entityState)) {
                if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.log().debug("{}: Stop of [{}] arrived, already is among the pending stops", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                    return;
                }
                return;
            }
            if (entityState instanceof Active) {
                Active active = Shard$Active$.MODULE$.unapply((Active)entityState);
                ActorRef actorRef = active._1();
                if (this.rememberEntitiesStore.isDefined()) {
                    this.log().debug("{}: Entity [{}] stopped without passivating, will restart after backoff", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                    this.org$apache$pekko$cluster$sharding$Shard$$entities.waitingForRestart(entityId);
                    RestartTerminatedEntity msg = Shard$RestartTerminatedEntity$.MODULE$.apply(entityId);
                    this.timers().startSingleTimer((Object)msg, (Object)msg, this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().entityRestartBackoff());
                    return;
                }
                this.log().debug("{}: Entity [{}] terminated", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                this.org$apache$pekko$cluster$sharding$Shard$$entities.removeEntity(entityId);
                return;
            }
            if (entityState instanceof Passivating) {
                Passivating passivating = Shard$Passivating$.MODULE$.unapply((Passivating)entityState);
                ActorRef actorRef = passivating._1();
                if (this.rememberEntitiesStore.isDefined()) {
                    if (this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberedEntitiesExist()) {
                        if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                            this.log().debug("{}: [{}] terminated after passivating, arrived while updating, adding it to batch of pending stops", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                        }
                        this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStop(entityId);
                        return;
                    }
                    this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStop(entityId);
                    Set set = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{entityId}));
                    Set<String> set2 = this.rememberUpdate$default$1();
                    this.rememberUpdate(set2, (Set<String>)set);
                    return;
                }
                if (this.messageBuffers.getOrEmpty((Object)entityId).nonEmpty()) {
                    if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                        this.log().debug("{}: [{}] terminated after passivating, buffered messages found, restarting", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                    }
                    this.org$apache$pekko$cluster$sharding$Shard$$entities.removeEntity(entityId);
                    this.getOrCreateEntity(entityId);
                    this.sendMsgBuffer(entityId);
                    return;
                }
                if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.log().debug("{}: [{}] terminated after passivating", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
                }
                this.org$apache$pekko$cluster$sharding$Shard$$entities.removeEntity(entityId);
                return;
            }
            EntityState unexpected = entityState;
            ActorRef ref2 = this.org$apache$pekko$cluster$sharding$Shard$$entities.entity(entityId);
            this.log().warning("{}: Got a terminated for [{}], entityId [{}] which is in unexpected state [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)new OptionVal((Object)ref2), (Object)entityId, (Object)unexpected);
            return;
        }
        this.log().warning("{}: Unexpected entity terminated: {}", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)ref);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$passivate(ActorRef entity, Object stopMessage) {
        String string = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityId(entity);
        String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
            String string3 = (String)OptionVal$.MODULE$.get$extension((Object)string2);
            String id = string3;
            if (this.org$apache$pekko$cluster$sharding$Shard$$entities.isPassivating(id)) {
                this.log().debug("{}: Passivation already in progress for [{}]. Not sending stopMessage back to entity", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)id);
                return;
            }
            if (this.messageBuffers.getOrEmpty((Object)id).nonEmpty()) {
                this.log().debug("{}: Passivation when there are buffered messages for [{}], ignoring passivation", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)id);
                return;
            }
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: Passivation started for [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)id);
            }
            this.org$apache$pekko$cluster$sharding$Shard$$entities.entityPassivating(id);
            entity.$bang(stopMessage, this.self());
            this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder.entityPassivate(id);
            return;
        }
        this.log().debug("{}: Unknown entity passivating [{}]. Not sending stopMessage back to entity", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entity);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$activeEntityLimitUpdated(ShardRegion.SetActiveEntityLimit updated) {
        Seq<String> entitiesToPassivate = this.passivationStrategy.limitUpdated(updated.perRegionLimit());
        this.passivateEntities(entitiesToPassivate);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$shardsUpdated(ShardRegion.ShardsUpdated updated) {
        Seq<String> entitiesToPassivate = this.passivationStrategy.shardsUpdated(updated.activeShards());
        this.passivateEntities(entitiesToPassivate);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$passivateEntitiesAfterInterval() {
        Seq<String> entitiesToPassivate = this.passivationStrategy.intervalPassed();
        this.passivateEntities(entitiesToPassivate);
    }

    private void passivateEntities(Seq<String> entitiesToPassivate) {
        if (entitiesToPassivate.nonEmpty()) {
            Seq refsToPassivate = (Seq)entitiesToPassivate.collect((PartialFunction)new Serializable(this){
                private final /* synthetic */ Shard $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(String x) {
                    String string = x;
                    String entityId = string;
                    ActorRef actorRef = this.$outer.org$apache$pekko$cluster$sharding$Shard$$entities.entity(entityId);
                    return OptionVal$.MODULE$.isDefined$extension((Object)actorRef);
                }

                public final Object applyOrElse(String x, Function1 function1) {
                    String string = x;
                    String entityId = string;
                    ActorRef actorRef = this.$outer.org$apache$pekko$cluster$sharding$Shard$$entities.entity(entityId);
                    if (OptionVal$.MODULE$.isDefined$extension((Object)actorRef)) {
                        ActorRef actorRef2 = this.$outer.org$apache$pekko$cluster$sharding$Shard$$entities.entity(entityId);
                        return (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
                    }
                    return function1.apply((Object)x);
                }
            });
            if (refsToPassivate.nonEmpty()) {
                this.log().debug("{}: Passivating [{}] entities", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)BoxesRunTime.boxToInteger((int)refsToPassivate.size()));
                refsToPassivate.foreach((Function1)(JProcedure1 & Serializable)_$5 -> this.org$apache$pekko$cluster$sharding$Shard$$passivate((ActorRef)_$5, this.handOffStopMessage));
                return;
            }
            return;
        }
    }

    public void passivateCompleted(String entityId) {
        boolean hasBufferedMessages = this.messageBuffers.getOrEmpty((Object)entityId).nonEmpty();
        this.org$apache$pekko$cluster$sharding$Shard$$entities.removeEntity(entityId);
        if (hasBufferedMessages) {
            this.log().debug("{}: Entity stopped after passivation [{}], but will be started again due to buffered messages", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
            this.org$apache$pekko$cluster$sharding$Shard$$flightRecorder.entityPassivateRestart(entityId);
            if (this.rememberEntities) {
                this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, (Option<ActorRef>)None$.MODULE$);
                if (!this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberedEntitiesExist()) {
                    this.rememberUpdate((Set<String>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{entityId}))), this.rememberUpdate$default$2());
                    return;
                }
                return;
            }
            this.getOrCreateEntity(entityId);
            this.sendMsgBuffer(entityId);
            return;
        }
        this.log().debug("{}: Entity stopped after passivation [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId);
    }

    public void org$apache$pekko$cluster$sharding$Shard$$deliverMessage(Object msg, ActorRef snd) {
        EntityState entityState;
        Object payload;
        String entityId;
        block24: {
            block23: {
                block22: {
                    block21: {
                        block20: {
                            Tuple2 tuple2 = (Tuple2)this.org$apache$pekko$cluster$sharding$Shard$$extractEntityId.apply(msg);
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String entityId2 = (String)tuple2._1();
                            Object payload2 = tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)entityId2, payload2);
                            entityId = (String)tuple22._1();
                            payload = tuple22._2();
                            if (entityId == null) break block20;
                            String string = entityId;
                            String string2 = "";
                            if (string != null ? !string.equals(string2) : string2 != null) break block21;
                        }
                        this.log().warning("{}: Id must not be empty, dropping message [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg.getClass().getName());
                        this.context().system().deadLetters().$bang((Object)Dropped$.MODULE$.apply(msg, "No recipient entity id", snd, this.self()), this.self());
                        return;
                    }
                    Object object = payload;
                    if (object instanceof ShardRegion.StartEntity) {
                        ShardRegion.StartEntity start = (ShardRegion.StartEntity)object;
                        if (this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberedEntitiesExist()) {
                            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                                this.log().debug("{}: StartEntity({}) from [{}], adding to batch", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)start.entityId(), (Object)snd);
                            }
                            this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, (Option<ActorRef>)Some$.MODULE$.apply((Object)snd));
                            return;
                        }
                        if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                            this.log().debug("{}: StartEntity({}) from [{}], starting", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)start.entityId(), (Object)snd);
                        }
                        this.org$apache$pekko$cluster$sharding$Shard$$startEntity(start.entityId(), (Option<ActorRef>)Some$.MODULE$.apply((Object)snd));
                        return;
                    }
                    entityState = this.org$apache$pekko$cluster$sharding$Shard$$entities.entityState(entityId);
                    if (entityState instanceof Active) {
                        ActorRef actorRef;
                        Active active = Shard$Active$.MODULE$.unapply((Active)entityState);
                        ActorRef ref = actorRef = active._1();
                        if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                            this.log().debug("{}: Delivering message of type [{}] to [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)payload.getClass().getName(), (Object)entityId);
                        }
                        Seq<String> entitiesToPassivate = this.passivationStrategy.entityTouched(entityId);
                        ref.tell(payload, snd);
                        this.passivateEntities(entitiesToPassivate);
                        return;
                    }
                    if (!(entityState instanceof RememberingStart)) break block22;
                    RememberingStart rememberingStart = Shard$RememberingStart$.MODULE$.unapply((RememberingStart)entityState);
                    Set<ActorRef> set = rememberingStart._1();
                    break block23;
                }
                if (Shard$RememberingStop$.MODULE$.equals(entityState)) break block23;
                if (!(entityState instanceof Passivating)) break block24;
                Passivating passivating = Shard$Passivating$.MODULE$.unapply((Passivating)entityState);
                ActorRef actorRef = passivating._1();
            }
            this.appendToMessageBuffer(entityId, msg, snd);
            return;
        }
        if (Shard$WaitingForRestart$.MODULE$.equals(entityState) || Shard$RememberedButNotCreated$.MODULE$.equals(entityState)) {
            Mirror.Singleton state = (Mirror.Singleton)entityState;
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: Delivering message of type [{}] to [{}] (starting because [{}])", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)payload.getClass().getName(), (Object)entityId, (Object)state);
            }
            this.getOrCreateEntity(entityId).tell(payload, snd);
            return;
        }
        if (Shard$NoState$.MODULE$.equals(entityState)) {
            if (!this.rememberEntities) {
                ActorRef ref = this.getOrCreateEntity(entityId);
                Seq<String> entitiesToPassivate = this.passivationStrategy.entityTouched(entityId);
                ref.tell(payload, snd);
                this.passivateEntities(entitiesToPassivate);
                return;
            }
            if (this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberedEntitiesExist()) {
                if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                    this.log().debug("{}: Buffer message [{}] to [{}] (which is not started) because of write in progress for [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)payload.getClass().getName(), (Object)entityId, this.org$apache$pekko$cluster$sharding$Shard$$entities.pendingRememberEntities());
                }
                this.appendToMessageBuffer(entityId, msg, snd);
                this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, (Option<ActorRef>)None$.MODULE$);
                return;
            }
            if (this.org$apache$pekko$cluster$sharding$Shard$$verboseDebug) {
                this.log().debug("{}: Buffering message [{}] to [{}] and starting actor", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)payload.getClass().getName(), (Object)entityId);
            }
            this.appendToMessageBuffer(entityId, msg, snd);
            this.org$apache$pekko$cluster$sharding$Shard$$entities.rememberingStart(entityId, (Option<ActorRef>)None$.MODULE$);
            this.rememberUpdate((Set<String>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{entityId}))), this.rememberUpdate$default$2());
            return;
        }
        throw new MatchError((Object)entityState);
    }

    @InternalStableApi
    public ActorRef getOrCreateEntity(String id) {
        ActorRef actorRef = this.org$apache$pekko$cluster$sharding$Shard$$entities.entity(id);
        ActorRef actorRef2 = (ActorRef)OptionVal.Some$.MODULE$.unapply((Object)actorRef);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)actorRef2)) {
            ActorRef actorRef3;
            ActorRef child = actorRef3 = (ActorRef)OptionVal$.MODULE$.get$extension((Object)actorRef2);
            return child;
        }
        String name = URLEncoder.encode(id, "utf-8");
        ActorRef a = this.context().actorOf((Props)this.entityProps.apply((Object)id), name);
        this.context().watchWith(a, (Object)Shard$EntityTerminated$.MODULE$.apply(a));
        this.log().debug("{}: Started entity [{}] with entity id [{}] in shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)a, (Object)id, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId);
        this.org$apache$pekko$cluster$sharding$Shard$$entities.addEntity(id, a);
        this.entityCreated(id);
        return a;
    }

    @InternalStableApi
    public int entityCreated(String id) {
        return this.org$apache$pekko$cluster$sharding$Shard$$entities.nrActiveEntities();
    }

    public void appendToMessageBuffer(String id, Object msg, ActorRef snd) {
        if (this.messageBuffers.totalSize() >= this.org$apache$pekko$cluster$sharding$Shard$$settings.tuningParameters().bufferSize()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("{}: Buffer is full, dropping message of type [{}] for entity [{}]", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg.getClass().getName(), (Object)id);
            }
            this.context().system().deadLetters().$bang((Object)Dropped$.MODULE$.apply(msg, new StringBuilder(21).append("Buffer for [").append(id).append("] is full").toString(), snd, this.self()), this.self());
            return;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("{}: Message of type [{}] for entity [{}] buffered", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)msg.getClass().getName(), (Object)id);
        }
        this.messageBuffers.append((Object)id, msg, snd);
    }

    public void sendMsgBuffer(String entityId) {
        MessageBuffer messages = this.messageBuffers.getOrEmpty((Object)entityId);
        this.messageBuffers.remove((Object)entityId);
        if (messages.nonEmpty()) {
            this.getOrCreateEntity(entityId);
            this.log().debug("{}: Sending message buffer for entity [{}] ([{}] messages)", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)entityId, (Object)BoxesRunTime.boxToInteger((int)messages.size()));
            messages.foreach((Function2)(JProcedure2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Object object = tuple2._1();
                    ActorRef actorRef = (ActorRef)tuple2._2();
                    if (object instanceof ShardRegion.StartEntity) {
                        String string;
                        ShardRegion.StartEntity startEntity = ShardRegion$StartEntity$.MODULE$.unapply((ShardRegion.StartEntity)object);
                        String entityId = string = startEntity._1();
                        ActorRef snd = actorRef;
                        this.org$apache$pekko$cluster$sharding$Shard$$startEntity(entityId, (Option<ActorRef>)Some$.MODULE$.apply((Object)snd));
                        return;
                    }
                    Object msg = object;
                    ActorRef snd = actorRef;
                    this.org$apache$pekko$cluster$sharding$Shard$$deliverMessage(msg, snd);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public void dropBufferFor(String entityId, String reason) {
        int count = this.messageBuffers.drop((Object)entityId, reason, this.context().system().deadLetters());
        if (this.log().isDebugEnabled() && count > 0) {
            this.log().debug("{}: Dropping [{}] buffered messages for [{}] because {}", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)BoxesRunTime.boxToInteger((int)count), (Object)entityId, (Object)reason);
            return;
        }
    }

    public void org$apache$pekko$cluster$sharding$Shard$$rememberEntityStoreCrashed(RememberEntityStoreCrashed msg) {
        throw new RuntimeException(new StringBuilder(34).append("Remember entities store [").append(msg.store()).append("] crashed").toString());
    }

    public void postStop() {
        this.passivateIntervalTask.foreach((Function1 & Serializable)_$6 -> _$6.cancel());
        this.log().debug("{}: Shard [{}] shutting down", (Object)this.org$apache$pekko$cluster$sharding$Shard$$typeName, (Object)this.org$apache$pekko$cluster$sharding$Shard$$shardId);
    }

    private static final ActorRef startEntity$$anonfun$3() {
        return ActorRef$.MODULE$.noSender();
    }

    public static final class Active
    implements EntityState,
    WithRef,
    Product,
    Serializable {
        private final ActorRef ref;

        public static Active apply(ActorRef actorRef) {
            return Shard$Active$.MODULE$.apply(actorRef);
        }

        public static Active fromProduct(Product product) {
            return Shard$Active$.MODULE$.fromProduct(product);
        }

        public static Active unapply(Active active) {
            return Shard$Active$.MODULE$.unapply(active);
        }

        public Active(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Active)) return false;
            Active active = (Active)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = active.ref();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Active;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Active";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ref";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ActorRef ref() {
            return this.ref;
        }

        @Override
        public EntityState transition(EntityState newState, Entities entities) {
            EntityState entityState = newState;
            if (entityState instanceof Passivating) {
                Passivating passivating = (Passivating)entityState;
                return passivating;
            }
            if (Shard$WaitingForRestart$.MODULE$.equals(entityState)) {
                return Shard$WaitingForRestart$.MODULE$;
            }
            if (Shard$NoState$.MODULE$.equals(entityState) && !entities.rememberingEntities()) {
                return Shard$NoState$.MODULE$;
            }
            return this.invalidTransition(newState, entities);
        }

        public Active copy(ActorRef ref) {
            return new Active(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }

    public static final class CurrentShardState
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String shardId;
        private final Set entityIds;

        public static CurrentShardState apply(String string, Set<String> set) {
            return Shard$CurrentShardState$.MODULE$.apply(string, set);
        }

        public static CurrentShardState fromProduct(Product product) {
            return Shard$CurrentShardState$.MODULE$.fromProduct(product);
        }

        public static CurrentShardState unapply(CurrentShardState currentShardState) {
            return Shard$CurrentShardState$.MODULE$.unapply(currentShardState);
        }

        public CurrentShardState(String shardId, Set<String> entityIds) {
            this.shardId = shardId;
            this.entityIds = entityIds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentShardState)) return false;
            CurrentShardState currentShardState = (CurrentShardState)object;
            String string = this.shardId();
            String string2 = currentShardState.shardId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Set<String> set = this.entityIds();
            Set<String> set2 = currentShardState.entityIds();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentShardState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CurrentShardState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            if (1 == n2) {
                return "entityIds";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public Set<String> entityIds() {
            return this.entityIds;
        }

        public CurrentShardState copy(String shardId, Set<String> entityIds) {
            return new CurrentShardState(shardId, entityIds);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public Set<String> copy$default$2() {
            return this.entityIds();
        }

        public String _1() {
            return this.shardId();
        }

        public Set<String> _2() {
            return this.entityIds();
        }
    }

    public static final class Entities {
        private final LoggingAdapter log;
        private final boolean rememberingEntities;
        private final boolean verboseDebug;
        private final boolean failOnIllegalTransition;
        private final Map<String, EntityState> entities;
        private final HashMap<ActorRef, String> byRef;
        private final HashSet<String> remembering;

        public Entities(LoggingAdapter log, boolean rememberingEntities, boolean verboseDebug, boolean failOnIllegalTransition) {
            this.log = log;
            this.rememberingEntities = rememberingEntities;
            this.verboseDebug = verboseDebug;
            this.failOnIllegalTransition = failOnIllegalTransition;
            this.entities = new HashMap<String, EntityState>();
            this.byRef = new HashMap();
            this.remembering = new HashSet();
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public boolean rememberingEntities() {
            return this.rememberingEntities;
        }

        public boolean failOnIllegalTransition() {
            return this.failOnIllegalTransition;
        }

        public void alreadyRemembered(Set<String> set) {
            set.foreach((Function1 & Serializable)entityId -> {
                EntityState state = this.entityState((String)entityId).transition(Shard$RememberedButNotCreated$.MODULE$, this);
                return this.entities.put((String)entityId, state);
            });
        }

        public void rememberingStart(String entityId, Option<ActorRef> ackTo) {
            RememberingStart newState = Shard$RememberingStart$.MODULE$.apply(ackTo);
            EntityState state = this.entityState(entityId).transition(newState, this);
            this.entities.put(entityId, state);
            if (this.rememberingEntities()) {
                this.remembering.add(entityId);
                return;
            }
        }

        public void rememberingStop(String entityId) {
            EntityState state = this.entityState(entityId);
            this.removeRefIfThereIsOne(state);
            this.entities.put(entityId, state.transition(Shard$RememberingStop$.MODULE$, this));
            if (this.rememberingEntities()) {
                this.remembering.add(entityId);
                return;
            }
        }

        public void waitingForRestart(String id) {
            EntityState entityState;
            EntityState entityState2 = this.entities.get(id);
            if (entityState2 instanceof WithRef) {
                WithRef wr = (WithRef)entityState2;
                this.byRef.remove(wr.ref());
                entityState = wr;
            } else if (entityState2 == null) {
                entityState = Shard$NoState$.MODULE$;
            } else {
                EntityState other = entityState2;
                entityState = other;
            }
            Shard$NoState$ state = entityState;
            this.entities.put(id, state.transition(Shard$WaitingForRestart$.MODULE$, this));
        }

        public void removeEntity(String entityId) {
            EntityState state = this.entityState(entityId);
            state.transition(Shard$NoState$.MODULE$, this);
            this.removeRefIfThereIsOne(state);
            this.entities.remove(entityId);
            if (this.rememberingEntities()) {
                this.remembering.remove(entityId);
                return;
            }
        }

        public void addEntity(String entityId, ActorRef ref) {
            EntityState state = this.entityState(entityId).transition(Shard$Active$.MODULE$.apply(ref), this);
            this.entities.put(entityId, state);
            this.byRef.put(ref, entityId);
            if (this.rememberingEntities()) {
                this.remembering.remove(entityId);
                return;
            }
        }

        public ActorRef entity(String entityId) {
            EntityState entityState = this.entities.get(entityId);
            if (entityState instanceof WithRef) {
                WithRef wr = (WithRef)entityState;
                return (ActorRef)OptionVal.Some$.MODULE$.apply((Object)wr.ref());
            }
            OptionVal$.MODULE$.None();
            return null;
        }

        public EntityState entityState(String id) {
            EntityState entityState = this.entities.get(id);
            if (entityState == null) {
                return Shard$NoState$.MODULE$;
            }
            EntityState state = entityState;
            return state;
        }

        public String entityId(ActorRef ref) {
            return (String)OptionVal$.MODULE$.apply((Object)this.byRef.get(ref));
        }

        public boolean isPassivating(String id) {
            EntityState entityState = this.entities.get(id);
            return entityState instanceof Passivating;
        }

        public void entityPassivating(String entityId) {
            EntityState entityState;
            if (this.verboseDebug) {
                this.log().debug("[{}] passivating", (Object)entityId);
            }
            if ((entityState = this.entities.get(entityId)) instanceof WithRef) {
                WithRef wf = (WithRef)entityState;
                EntityState state = this.entityState(entityId).transition(Shard$Passivating$.MODULE$.apply(wf.ref()), this);
                this.entities.put(entityId, state);
                return;
            }
            EntityState other = entityState;
            throw new IllegalStateException(new StringBuilder(63).append("Tried to passivate entity without an actor ref ").append(entityId).append(". Current state ").append(other).toString());
        }

        private void removeRefIfThereIsOne(EntityState state) {
            EntityState entityState = state;
            if (entityState instanceof WithRef) {
                WithRef wr = (WithRef)entityState;
                this.byRef.remove(wr.ref());
                return;
            }
        }

        public Set<ActorRef> activeEntities() {
            return package.JavaConverters$.MODULE$.SetHasAsScala(this.byRef.keySet()).asScala().toSet();
        }

        public int nrActiveEntities() {
            return this.byRef.size();
        }

        public Set<String> activeEntityIds() {
            return package.JavaConverters$.MODULE$.CollectionHasAsScala(this.byRef.values()).asScala().toSet();
        }

        public Tuple2<scala.collection.immutable.Map<String, RememberingStart>, Set<String>> pendingRememberEntities() {
            if (this.remembering.isEmpty()) {
                return Tuple2$.MODULE$.apply((Object)Predef$.MODULE$.Map().empty(), (Object)Set$.MODULE$.empty());
            }
            Builder starts = Predef$.MODULE$.Map().newBuilder();
            Builder stops = Set$.MODULE$.newBuilder();
            this.remembering.forEach(entityId -> {
                EntityState entityState = this.entityState((String)entityId);
                if (entityState instanceof RememberingStart) {
                    RememberingStart r = (RememberingStart)entityState;
                    String string = (String)Predef$.MODULE$.ArrowAssoc(entityId);
                    starts.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)r));
                    return;
                }
                if (Shard$RememberingStop$.MODULE$.equals(entityState)) {
                    stops.$plus$eq(entityId);
                    return;
                }
                EntityState wat = entityState;
                throw new IllegalStateException(new StringBuilder(42).append((String)entityId).append(" was in the remembering set but has state ").append(wat).toString());
            });
            return Tuple2$.MODULE$.apply(starts.result(), stops.result());
        }

        public boolean pendingRememberedEntitiesExist() {
            return !this.remembering.isEmpty();
        }

        public boolean entityIdExists(String id) {
            return this.entities.get(id) != null;
        }

        @InternalStableApi
        public int size() {
            return this.entities.size();
        }

        public String toString() {
            return this.entities.toString();
        }
    }

    public static final class EntitiesMovedToOtherShard
    implements RememberEntityCommand,
    Product,
    Serializable {
        private final Set ids;

        public static EntitiesMovedToOtherShard apply(Set<String> set) {
            return Shard$EntitiesMovedToOtherShard$.MODULE$.apply(set);
        }

        public static EntitiesMovedToOtherShard fromProduct(Product product) {
            return Shard$EntitiesMovedToOtherShard$.MODULE$.fromProduct(product);
        }

        public static EntitiesMovedToOtherShard unapply(EntitiesMovedToOtherShard entitiesMovedToOtherShard) {
            return Shard$EntitiesMovedToOtherShard$.MODULE$.unapply(entitiesMovedToOtherShard);
        }

        public EntitiesMovedToOtherShard(Set<String> ids) {
            this.ids = ids;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EntitiesMovedToOtherShard)) return false;
            EntitiesMovedToOtherShard entitiesMovedToOtherShard = (EntitiesMovedToOtherShard)object;
            Set<String> set = this.ids();
            Set<String> set2 = entitiesMovedToOtherShard.ids();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EntitiesMovedToOtherShard;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EntitiesMovedToOtherShard";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ids";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> ids() {
            return this.ids;
        }

        public EntitiesMovedToOtherShard copy(Set<String> ids) {
            return new EntitiesMovedToOtherShard(ids);
        }

        public Set<String> copy$default$1() {
            return this.ids();
        }

        public Set<String> _1() {
            return this.ids();
        }
    }

    public static interface EntityState {
        public EntityState transition(EntityState var1, Entities var2);

        public static EntityState invalidTransition$(EntityState $this, EntityState to, Entities entities) {
            return $this.invalidTransition(to, entities);
        }

        default public EntityState invalidTransition(EntityState to, Entities entities) {
            IllegalArgumentException exception = new IllegalArgumentException(new StringBuilder(53).append("Transition from ").append(this).append(" to ").append(to).append(" not allowed, remember entities: ").append(entities.rememberingEntities()).toString());
            if (entities.failOnIllegalTransition()) {
                throw exception;
            }
            entities.log().error((Throwable)exception, "Ignoring illegal state transition in shard");
            return to;
        }
    }

    public static final class EntityTerminated
    implements Product,
    Serializable {
        private final ActorRef ref;

        public static EntityTerminated apply(ActorRef actorRef) {
            return Shard$EntityTerminated$.MODULE$.apply(actorRef);
        }

        public static EntityTerminated fromProduct(Product product) {
            return Shard$EntityTerminated$.MODULE$.fromProduct(product);
        }

        public static EntityTerminated unapply(EntityTerminated entityTerminated) {
            return Shard$EntityTerminated$.MODULE$.unapply(entityTerminated);
        }

        public EntityTerminated(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EntityTerminated)) return false;
            EntityTerminated entityTerminated = (EntityTerminated)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = entityTerminated.ref();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EntityTerminated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EntityTerminated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ref";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef ref() {
            return this.ref;
        }

        public EntityTerminated copy(ActorRef ref) {
            return new EntityTerminated(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }

    public static final class LeaseAcquireResult
    implements DeadLetterSuppression,
    Product,
    Serializable {
        private final boolean acquired;
        private final Option reason;

        public static LeaseAcquireResult apply(boolean bl, Option<Throwable> option) {
            return Shard$LeaseAcquireResult$.MODULE$.apply(bl, option);
        }

        public static LeaseAcquireResult fromProduct(Product product) {
            return Shard$LeaseAcquireResult$.MODULE$.fromProduct(product);
        }

        public static LeaseAcquireResult unapply(LeaseAcquireResult leaseAcquireResult) {
            return Shard$LeaseAcquireResult$.MODULE$.unapply(leaseAcquireResult);
        }

        public LeaseAcquireResult(boolean acquired, Option<Throwable> reason) {
            this.acquired = acquired;
            this.reason = reason;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.acquired() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.reason()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LeaseAcquireResult)) return false;
            LeaseAcquireResult leaseAcquireResult = (LeaseAcquireResult)object;
            if (this.acquired() != leaseAcquireResult.acquired()) return false;
            Option<Throwable> option = this.reason();
            Option<Throwable> option2 = leaseAcquireResult.reason();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LeaseAcquireResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LeaseAcquireResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "acquired";
            }
            if (1 == n2) {
                return "reason";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean acquired() {
            return this.acquired;
        }

        public Option<Throwable> reason() {
            return this.reason;
        }

        public LeaseAcquireResult copy(boolean acquired, Option<Throwable> reason) {
            return new LeaseAcquireResult(acquired, reason);
        }

        public boolean copy$default$1() {
            return this.acquired();
        }

        public Option<Throwable> copy$default$2() {
            return this.reason();
        }

        public boolean _1() {
            return this.acquired();
        }

        public Option<Throwable> _2() {
            return this.reason();
        }
    }

    public static final class LeaseLost
    implements DeadLetterSuppression,
    Product,
    Serializable {
        private final Option reason;

        public static LeaseLost apply(Option<Throwable> option) {
            return Shard$LeaseLost$.MODULE$.apply(option);
        }

        public static LeaseLost fromProduct(Product product) {
            return Shard$LeaseLost$.MODULE$.fromProduct(product);
        }

        public static LeaseLost unapply(LeaseLost leaseLost) {
            return Shard$LeaseLost$.MODULE$.unapply(leaseLost);
        }

        public LeaseLost(Option<Throwable> reason) {
            this.reason = reason;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LeaseLost)) return false;
            LeaseLost leaseLost = (LeaseLost)object;
            Option<Throwable> option = this.reason();
            Option<Throwable> option2 = leaseLost.reason();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LeaseLost;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LeaseLost";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "reason";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Throwable> reason() {
            return this.reason;
        }

        public LeaseLost copy(Option<Throwable> reason) {
            return new LeaseLost(reason);
        }

        public Option<Throwable> copy$default$1() {
            return this.reason();
        }

        public Option<Throwable> _1() {
            return this.reason();
        }
    }

    public static final class Passivating
    implements EntityState,
    WithRef,
    Product,
    Serializable {
        private final ActorRef ref;

        public static Passivating apply(ActorRef actorRef) {
            return Shard$Passivating$.MODULE$.apply(actorRef);
        }

        public static Passivating fromProduct(Product product) {
            return Shard$Passivating$.MODULE$.fromProduct(product);
        }

        public static Passivating unapply(Passivating passivating) {
            return Shard$Passivating$.MODULE$.unapply(passivating);
        }

        public Passivating(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Passivating)) return false;
            Passivating passivating = (Passivating)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = passivating.ref();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Passivating;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Passivating";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ref";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ActorRef ref() {
            return this.ref;
        }

        @Override
        public EntityState transition(EntityState newState, Entities entities) {
            EntityState entityState = newState;
            if (Shard$RememberingStop$.MODULE$.equals(entityState)) {
                return Shard$RememberingStop$.MODULE$;
            }
            if (Shard$NoState$.MODULE$.equals(entityState) && !entities.rememberingEntities()) {
                return Shard$NoState$.MODULE$;
            }
            return this.invalidTransition(newState, entities);
        }

        public Passivating copy(ActorRef ref) {
            return new Passivating(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }

    public static interface RememberEntityCommand {
    }

    public static final class RememberEntityStoreCrashed
    implements Product,
    Serializable {
        private final ActorRef store;

        public static RememberEntityStoreCrashed apply(ActorRef actorRef) {
            return Shard$RememberEntityStoreCrashed$.MODULE$.apply(actorRef);
        }

        public static RememberEntityStoreCrashed fromProduct(Product product) {
            return Shard$RememberEntityStoreCrashed$.MODULE$.fromProduct(product);
        }

        public static RememberEntityStoreCrashed unapply(RememberEntityStoreCrashed rememberEntityStoreCrashed) {
            return Shard$RememberEntityStoreCrashed$.MODULE$.unapply(rememberEntityStoreCrashed);
        }

        public RememberEntityStoreCrashed(ActorRef store) {
            this.store = store;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RememberEntityStoreCrashed)) return false;
            RememberEntityStoreCrashed rememberEntityStoreCrashed = (RememberEntityStoreCrashed)object;
            ActorRef actorRef = this.store();
            ActorRef actorRef2 = rememberEntityStoreCrashed.store();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RememberEntityStoreCrashed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RememberEntityStoreCrashed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "store";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef store() {
            return this.store;
        }

        public RememberEntityStoreCrashed copy(ActorRef store) {
            return new RememberEntityStoreCrashed(store);
        }

        public ActorRef copy$default$1() {
            return this.store();
        }

        public ActorRef _1() {
            return this.store();
        }
    }

    public static final class RememberEntityTimeout
    implements Product,
    Serializable {
        private final RememberEntitiesShardStore.Command operation;

        public static RememberEntityTimeout apply(RememberEntitiesShardStore.Command command) {
            return Shard$RememberEntityTimeout$.MODULE$.apply(command);
        }

        public static RememberEntityTimeout fromProduct(Product product) {
            return Shard$RememberEntityTimeout$.MODULE$.fromProduct(product);
        }

        public static RememberEntityTimeout unapply(RememberEntityTimeout rememberEntityTimeout) {
            return Shard$RememberEntityTimeout$.MODULE$.unapply(rememberEntityTimeout);
        }

        public RememberEntityTimeout(RememberEntitiesShardStore.Command operation) {
            this.operation = operation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RememberEntityTimeout)) return false;
            RememberEntityTimeout rememberEntityTimeout = (RememberEntityTimeout)object;
            RememberEntitiesShardStore.Command command = this.operation();
            RememberEntitiesShardStore.Command command2 = rememberEntityTimeout.operation();
            if (command != null) {
                if (!command.equals(command2)) return false;
                return true;
            }
            if (command2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RememberEntityTimeout;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RememberEntityTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "operation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RememberEntitiesShardStore.Command operation() {
            return this.operation;
        }

        public RememberEntityTimeout copy(RememberEntitiesShardStore.Command operation) {
            return new RememberEntityTimeout(operation);
        }

        public RememberEntitiesShardStore.Command copy$default$1() {
            return this.operation();
        }

        public RememberEntitiesShardStore.Command _1() {
            return this.operation();
        }
    }

    public static final class RememberedEntityIds
    implements Product,
    Serializable {
        private final Set ids;

        public static RememberedEntityIds apply(Set<String> set) {
            return Shard$RememberedEntityIds$.MODULE$.apply(set);
        }

        public static RememberedEntityIds fromProduct(Product product) {
            return Shard$RememberedEntityIds$.MODULE$.fromProduct(product);
        }

        public static RememberedEntityIds unapply(RememberedEntityIds rememberedEntityIds) {
            return Shard$RememberedEntityIds$.MODULE$.unapply(rememberedEntityIds);
        }

        public RememberedEntityIds(Set<String> ids) {
            this.ids = ids;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RememberedEntityIds)) return false;
            RememberedEntityIds rememberedEntityIds = (RememberedEntityIds)object;
            Set<String> set = this.ids();
            Set<String> set2 = rememberedEntityIds.ids();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RememberedEntityIds;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RememberedEntityIds";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ids";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> ids() {
            return this.ids;
        }

        public RememberedEntityIds copy(Set<String> ids) {
            return new RememberedEntityIds(ids);
        }

        public Set<String> copy$default$1() {
            return this.ids();
        }

        public Set<String> _1() {
            return this.ids();
        }
    }

    public static final class RememberingStart
    implements EntityState,
    Product,
    Serializable {
        private final Set ackTo;

        public static RememberingStart apply(Option<ActorRef> option) {
            return Shard$RememberingStart$.MODULE$.apply(option);
        }

        public static RememberingStart apply(Set<ActorRef> set) {
            return Shard$RememberingStart$.MODULE$.apply(set);
        }

        public static RememberingStart empty() {
            return Shard$RememberingStart$.MODULE$.empty();
        }

        public static RememberingStart fromProduct(Product product) {
            return Shard$RememberingStart$.MODULE$.fromProduct(product);
        }

        public static RememberingStart unapply(RememberingStart rememberingStart) {
            return Shard$RememberingStart$.MODULE$.unapply(rememberingStart);
        }

        public RememberingStart(Set<ActorRef> ackTo) {
            this.ackTo = ackTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RememberingStart)) return false;
            RememberingStart rememberingStart = (RememberingStart)object;
            Set<ActorRef> set = this.ackTo();
            Set<ActorRef> set2 = rememberingStart.ackTo();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RememberingStart;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RememberingStart";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ackTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<ActorRef> ackTo() {
            return this.ackTo;
        }

        @Override
        public EntityState transition(EntityState newState, Entities entities) {
            EntityState entityState = newState;
            if (entityState instanceof Active) {
                Active active = (Active)entityState;
                return active;
            }
            if (entityState instanceof RememberingStart) {
                RememberingStart r = (RememberingStart)entityState;
                if (this.ackTo().isEmpty()) {
                    if (r.ackTo().isEmpty()) {
                        return Shard$RememberingStart$.MODULE$.empty();
                    }
                    return newState;
                }
                if (r.ackTo().isEmpty()) {
                    return this;
                }
                return Shard$RememberingStart$.MODULE$.apply((Set<ActorRef>)((Set)this.ackTo().union(r.ackTo())));
            }
            return this.invalidTransition(newState, entities);
        }

        public RememberingStart copy(Set<ActorRef> ackTo) {
            return new RememberingStart(ackTo);
        }

        public Set<ActorRef> copy$default$1() {
            return this.ackTo();
        }

        public Set<ActorRef> _1() {
            return this.ackTo();
        }
    }

    public static final class RestartTerminatedEntity
    implements RememberEntityCommand,
    Product,
    Serializable {
        private final String entity;

        public static RestartTerminatedEntity apply(String string) {
            return Shard$RestartTerminatedEntity$.MODULE$.apply(string);
        }

        public static RestartTerminatedEntity fromProduct(Product product) {
            return Shard$RestartTerminatedEntity$.MODULE$.fromProduct(product);
        }

        public static RestartTerminatedEntity unapply(RestartTerminatedEntity restartTerminatedEntity) {
            return Shard$RestartTerminatedEntity$.MODULE$.unapply(restartTerminatedEntity);
        }

        public RestartTerminatedEntity(String entity) {
            this.entity = entity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RestartTerminatedEntity)) return false;
            RestartTerminatedEntity restartTerminatedEntity = (RestartTerminatedEntity)object;
            String string = this.entity();
            String string2 = restartTerminatedEntity.entity();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RestartTerminatedEntity;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RestartTerminatedEntity";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "entity";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String entity() {
            return this.entity;
        }

        public RestartTerminatedEntity copy(String entity) {
            return new RestartTerminatedEntity(entity);
        }

        public String copy$default$1() {
            return this.entity();
        }

        public String _1() {
            return this.entity();
        }
    }

    public static interface ShardQuery {
    }

    public static final class ShardStats
    implements ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final String shardId;
        private final int entityCount;

        public static ShardStats apply(String string, int n) {
            return Shard$ShardStats$.MODULE$.apply(string, n);
        }

        public static ShardStats fromProduct(Product product) {
            return Shard$ShardStats$.MODULE$.fromProduct(product);
        }

        public static ShardStats unapply(ShardStats shardStats) {
            return Shard$ShardStats$.MODULE$.unapply(shardStats);
        }

        public ShardStats(String shardId, int entityCount) {
            this.shardId = shardId;
            this.entityCount = entityCount;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shardId()));
            n = Statics.mix((int)n, (int)this.entityCount());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardStats)) return false;
            ShardStats shardStats = (ShardStats)object;
            if (this.entityCount() != shardStats.entityCount()) return false;
            String string = this.shardId();
            String string2 = shardStats.shardId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardStats;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ShardStats";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            if (1 == n2) {
                return "entityCount";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public int entityCount() {
            return this.entityCount;
        }

        public ShardStats copy(String shardId, int entityCount) {
            return new ShardStats(shardId, entityCount);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public int copy$default$2() {
            return this.entityCount();
        }

        public String _1() {
            return this.shardId();
        }

        public int _2() {
            return this.entityCount();
        }
    }

    public static interface WithRef
    extends EntityState {
        public ActorRef ref();
    }
}

