/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Set;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$AllocateShardResult$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$DelayedShardRegionTerminated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$BeginHandOff$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$BeginHandOffAck$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$GetShardHome$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$GracefulShutdownReq$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$HandOff$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$HostShard$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegionStopped$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$Register$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegisterAck$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegisterProxy$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHome$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHomeAllocated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHomeDeallocated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHomes$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionProxyRegistered$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionProxyTerminated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionRegistered$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionTerminated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardStarted$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardStopped$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$State$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$StateInitialized$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$Terminate$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$RebalanceDone$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$RebalanceResult$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$RebalanceTick$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$RebalanceWorker$ShardRegionTerminated$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$ResendShardHost$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$ShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.cluster.sharding.ShardRegion$ClusterShardingStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$CurrentRegions$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetClusterShardingStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetCurrentRegions$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetShardRegionStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$GracefulShutdown$;
import org.apache.pekko.cluster.sharding.ShardingLogMarker$;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$RegionEntry$;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;

public abstract class ShardCoordinator
implements Actor,
Timers {
    private ActorContext context;
    private ActorRef self;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    public final ClusterShardingSettings org$apache$pekko$cluster$sharding$ShardCoordinator$$settings;
    public final ShardAllocationStrategy org$apache$pekko$cluster$sharding$ShardCoordinator$$allocationStrategy;
    private final MarkerLoggingAdapter log;
    public final boolean org$apache$pekko$cluster$sharding$ShardCoordinator$$verboseDebug;
    public final ActorRef org$apache$pekko$cluster$sharding$ShardCoordinator$$ignoreRef;
    private final Cluster cluster;
    private final FiniteDuration removalMargin;
    private final int minMembers;
    private boolean allRegionsRegistered;
    private Internal.State state;
    private boolean preparingForShutdown;
    private scala.collection.immutable.Map rebalanceInProgress;
    private scala.collection.immutable.Set rebalanceWorkers;
    private scala.collection.immutable.Map unAckedHostShards;
    private scala.collection.immutable.Set gracefulShutdownInProgress;
    private boolean waitingForLocalRegionToTerminate;
    private scala.collection.immutable.Set aliveRegions;
    private scala.collection.immutable.Set regionTerminationInProgress;

    public static ShardAllocationStrategy leastShardAllocationStrategy(int n, double d) {
        return ShardCoordinator$.MODULE$.leastShardAllocationStrategy(n, d);
    }

    public static Props props(String string, ClusterShardingSettings clusterShardingSettings, ShardAllocationStrategy shardAllocationStrategy) {
        return ShardCoordinator$.MODULE$.props(string, clusterShardingSettings, shardAllocationStrategy);
    }

    @InternalStableApi
    public static Props props(String string, ClusterShardingSettings clusterShardingSettings, ShardAllocationStrategy shardAllocationStrategy, ActorRef actorRef, int n, Option<RememberEntitiesProvider> option) {
        return ShardCoordinator$.MODULE$.props(string, clusterShardingSettings, shardAllocationStrategy, actorRef, n, option);
    }

    public static Props rebalanceWorkerProps(String string, String string2, ActorRef actorRef, FiniteDuration finiteDuration, scala.collection.immutable.Set<ActorRef> set, boolean bl) {
        return ShardCoordinator$.MODULE$.rebalanceWorkerProps(string, string2, actorRef, finiteDuration, set, bl);
    }

    public ShardCoordinator(ClusterShardingSettings settings, ShardAllocationStrategy allocationStrategy) {
        int n;
        this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings = settings;
        this.org$apache$pekko$cluster$sharding$ShardCoordinator$$allocationStrategy = allocationStrategy;
        Actor.$init$((Actor)this);
        Timers.$init$((Timers)this);
        this.log = Logging$.MODULE$.withMarker(this.context().system(), (Object)this, LogSource$.MODULE$.fromActor());
        this.org$apache$pekko$cluster$sharding$ShardCoordinator$$verboseDebug = this.context().system().settings().config().getBoolean("pekko.cluster.sharding.verbose-debug-logging");
        this.org$apache$pekko$cluster$sharding$ShardCoordinator$$ignoreRef = ((ExtendedActorSystem)this.context().system()).provider().ignoreRef();
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.removalMargin = this.cluster().downingProvider().downRemovalMargin();
        Option<String> option = settings.role();
        if (None$.MODULE$.equals(option)) {
            n = this.cluster().settings().MinNrOfMembers();
        } else if (option instanceof Some) {
            String r = (String)((Some)option).value();
            n = BoxesRunTime.unboxToInt((Object)this.cluster().settings().MinNrOfMembersOfRole().getOrElse((Object)r, ShardCoordinator::$init$$$anonfun$1));
        } else {
            throw new MatchError(option);
        }
        this.minMembers = n;
        this.allRegionsRegistered = false;
        this.state = ShardCoordinator$Internal$State$.MODULE$.empty().withRememberEntities(settings.rememberEntities());
        this.preparingForShutdown = false;
        this.rebalanceInProgress = Predef$.MODULE$.Map().empty();
        this.rebalanceWorkers = Predef$.MODULE$.Set().empty();
        this.unAckedHostShards = Predef$.MODULE$.Map().empty();
        this.gracefulShutdownInProgress = Predef$.MODULE$.Set().empty();
        this.waitingForLocalRegionToTerminate = false;
        this.aliveRegions = Predef$.MODULE$.Set().empty();
        this.regionTerminationInProgress = Predef$.MODULE$.Set().empty();
        this.cluster().subscribe(this.self(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.ClusterShuttingDown$.MODULE$.getClass(), ClusterEvent.MemberReadyForShutdown.class, ClusterEvent.MemberPreparingForShutdown.class}));
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public FiniteDuration removalMargin() {
        return this.removalMargin;
    }

    public int minMembers() {
        return this.minMembers;
    }

    public boolean allRegionsRegistered() {
        return this.allRegionsRegistered;
    }

    public void allRegionsRegistered_$eq(boolean x$1) {
        this.allRegionsRegistered = x$1;
    }

    public Internal.State state() {
        return this.state;
    }

    public void state_$eq(Internal.State x$1) {
        this.state = x$1;
    }

    public boolean preparingForShutdown() {
        return this.preparingForShutdown;
    }

    public void preparingForShutdown_$eq(boolean x$1) {
        this.preparingForShutdown = x$1;
    }

    public scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>> rebalanceInProgress() {
        return this.rebalanceInProgress;
    }

    public void rebalanceInProgress_$eq(scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>> x$1) {
        this.rebalanceInProgress = x$1;
    }

    public scala.collection.immutable.Set<ActorRef> rebalanceWorkers() {
        return this.rebalanceWorkers;
    }

    public void rebalanceWorkers_$eq(scala.collection.immutable.Set<ActorRef> x$1) {
        this.rebalanceWorkers = x$1;
    }

    public scala.collection.immutable.Map<String, Cancellable> unAckedHostShards() {
        return this.unAckedHostShards;
    }

    public void unAckedHostShards_$eq(scala.collection.immutable.Map<String, Cancellable> x$1) {
        this.unAckedHostShards = x$1;
    }

    public scala.collection.immutable.Set<ActorRef> gracefulShutdownInProgress() {
        return this.gracefulShutdownInProgress;
    }

    public void gracefulShutdownInProgress_$eq(scala.collection.immutable.Set<ActorRef> x$1) {
        this.gracefulShutdownInProgress = x$1;
    }

    public boolean waitingForLocalRegionToTerminate() {
        return this.waitingForLocalRegionToTerminate;
    }

    public void waitingForLocalRegionToTerminate_$eq(boolean x$1) {
        this.waitingForLocalRegionToTerminate = x$1;
    }

    public scala.collection.immutable.Set<ActorRef> aliveRegions() {
        return this.aliveRegions;
    }

    public void aliveRegions_$eq(scala.collection.immutable.Set<ActorRef> x$1) {
        this.aliveRegions = x$1;
    }

    public scala.collection.immutable.Set<ActorRef> regionTerminationInProgress() {
        return this.regionTerminationInProgress;
    }

    public void regionTerminationInProgress_$eq(scala.collection.immutable.Set<ActorRef> x$1) {
        this.regionTerminationInProgress = x$1;
    }

    public abstract String typeName();

    public void preStart() {
        this.timers().startTimerWithFixedDelay((Object)ShardCoordinator$RebalanceTick$.MODULE$, (Object)ShardCoordinator$RebalanceTick$.MODULE$, this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.tuningParameters().rebalanceInterval());
        ShardAllocationStrategy shardAllocationStrategy = this.org$apache$pekko$cluster$sharding$ShardCoordinator$$allocationStrategy;
        if (shardAllocationStrategy instanceof StartableAllocationStrategy) {
            StartableAllocationStrategy strategy = (StartableAllocationStrategy)shardAllocationStrategy;
            strategy.start();
            return;
        }
        if (shardAllocationStrategy instanceof ActorSystemDependentAllocationStrategy) {
            ActorSystemDependentAllocationStrategy strategy = (ActorSystemDependentAllocationStrategy)shardAllocationStrategy;
            strategy.start(this.context().system());
            return;
        }
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.cluster().unsubscribe(this.self());
    }

    public boolean isMember(ActorRef region) {
        Address regionAddress;
        Address address = regionAddress = region.path().address();
        Address address2 = this.self().path().address();
        return !(address == null ? address2 != null : !address.equals(address2)) || this.cluster().state().isMemberUp(regionAddress);
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private final /* synthetic */ ShardCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Internal.Register) {
                    ActorRef actorRef;
                    Internal.Register register = ShardCoordinator$Internal$Register$.MODULE$.unapply((Internal.Register)object);
                    ActorRef region = actorRef = register._1();
                    return true;
                }
                if (object instanceof Internal.RegisterProxy) {
                    ActorRef actorRef;
                    Internal.RegisterProxy registerProxy = ShardCoordinator$Internal$RegisterProxy$.MODULE$.unapply((Internal.RegisterProxy)object);
                    ActorRef proxy = actorRef = registerProxy._1();
                    return true;
                }
                if (object instanceof Internal.GetShardHome) {
                    String string;
                    Internal.GetShardHome getShardHome = ShardCoordinator$Internal$GetShardHome$.MODULE$.unapply((Internal.GetShardHome)object);
                    String shard = string = getShardHome._1();
                    return true;
                }
                if (object instanceof AllocateShardResult) {
                    AllocateShardResult allocateShardResult = ShardCoordinator$AllocateShardResult$.MODULE$.unapply((AllocateShardResult)object);
                    String string = allocateShardResult._1();
                    Option<ActorRef> option = allocateShardResult._2();
                    ActorRef actorRef = allocateShardResult._3();
                    String shard = string;
                    if (None$.MODULE$.equals(option)) {
                        return true;
                    }
                    String shard2 = string;
                    if (option instanceof Some) {
                        ActorRef region = (ActorRef)((Some)option).value();
                        ActorRef getShardHomeSender = actorRef;
                        return true;
                    }
                }
                if (object instanceof Internal.ShardStarted) {
                    String string;
                    Internal.ShardStarted shardStarted = ShardCoordinator$Internal$ShardStarted$.MODULE$.unapply((Internal.ShardStarted)object);
                    String shard = string = shardStarted._1();
                    return true;
                }
                if (object instanceof ResendShardHost) {
                    ResendShardHost resendShardHost = ShardCoordinator$ResendShardHost$.MODULE$.unapply((ResendShardHost)object);
                    String string = resendShardHost._1();
                    ActorRef actorRef = resendShardHost._2();
                    String shard = string;
                    ActorRef region = actorRef;
                    return true;
                }
                if (ShardCoordinator$RebalanceTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RebalanceResult) {
                    scala.collection.immutable.Set<String> set;
                    RebalanceResult rebalanceResult = ShardCoordinator$RebalanceResult$.MODULE$.unapply((RebalanceResult)object);
                    scala.collection.immutable.Set<String> shards = set = rebalanceResult._1();
                    return true;
                }
                if (object instanceof RebalanceDone) {
                    RebalanceDone rebalanceDone = ShardCoordinator$RebalanceDone$.MODULE$.unapply((RebalanceDone)object);
                    String string = rebalanceDone._1();
                    boolean bl = rebalanceDone._2();
                    String shard = string;
                    boolean ok = bl;
                    return true;
                }
                if (object instanceof Internal.GracefulShutdownReq) {
                    ActorRef actorRef;
                    Internal.GracefulShutdownReq gracefulShutdownReq = ShardCoordinator$Internal$GracefulShutdownReq$.MODULE$.unapply((Internal.GracefulShutdownReq)object);
                    ActorRef region = actorRef = gracefulShutdownReq._1();
                    return true;
                }
                if (object instanceof ShardRegion.GetClusterShardingStats) {
                    FiniteDuration finiteDuration;
                    ShardRegion.GetClusterShardingStats getClusterShardingStats = ShardRegion$GetClusterShardingStats$.MODULE$.unapply((ShardRegion.GetClusterShardingStats)object);
                    FiniteDuration waitMax = finiteDuration = getClusterShardingStats._1();
                    return true;
                }
                if (ClusterEvent.ClusterShuttingDown$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberPreparingForShutdown || object instanceof ClusterEvent.MemberReadyForShutdown) {
                    return true;
                }
                if (ShardRegion$GetCurrentRegions$.MODULE$.equals(object)) {
                    return true;
                }
                return ShardCoordinator$Internal$Terminate$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Internal.Register) {
                    Internal.Register register = ShardCoordinator$Internal$Register$.MODULE$.unapply((Internal.Register)object);
                    ActorRef actorRef = register._1();
                    ActorRef region2 = actorRef;
                    if (this.$outer.isMember(region2)) {
                        this.$outer.log().debug("{}: ShardRegion registered: [{}]", (Object)this.$outer.typeName(), (Object)region2);
                        this.$outer.aliveRegions_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.aliveRegions().$plus((Object)region2)));
                        if (this.$outer.state().regions().contains((Object)region2)) {
                            region2.$bang((Object)ShardCoordinator$Internal$RegisterAck$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                            this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$informAboutCurrentShards(region2);
                            this.$outer.allocateShardHomesForRememberEntities();
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.gracefulShutdownInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.gracefulShutdownInProgress().$minus((Object)region2)));
                        this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$informAboutCurrentShards(region2);
                        this.$outer.update(ShardCoordinator$Internal$ShardRegionRegistered$.MODULE$.apply(region2), (JProcedure1 & Serializable)evt -> {
                            this.$outer.state_$eq(this.$outer.state().updated((Internal.DomainEvent)evt));
                            this.$outer.context().watch(region2);
                            region2.$bang((Object)ShardCoordinator$Internal$RegisterAck$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                            this.$outer.allocateShardHomesForRememberEntities();
                        });
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.log().debug("{}: ShardRegion [{}] was not registered since the coordinator currently does not know about a node of that region", (Object)this.$outer.typeName(), (Object)region2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.RegisterProxy) {
                    Internal.RegisterProxy registerProxy = ShardCoordinator$Internal$RegisterProxy$.MODULE$.unapply((Internal.RegisterProxy)object);
                    ActorRef actorRef = registerProxy._1();
                    ActorRef proxy = actorRef;
                    if (this.$outer.isMember(proxy)) {
                        this.$outer.log().debug("{}: ShardRegion proxy registered: [{}]", (Object)this.$outer.typeName(), (Object)proxy);
                        this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$informAboutCurrentShards(proxy);
                        if (this.$outer.state().regionProxies().contains((Object)proxy)) {
                            proxy.$bang((Object)ShardCoordinator$Internal$RegisterAck$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.update(ShardCoordinator$Internal$ShardRegionProxyRegistered$.MODULE$.apply(proxy), (JProcedure1 & Serializable)evt -> {
                            this.$outer.state_$eq(this.$outer.state().updated((Internal.DomainEvent)evt));
                            this.$outer.context().watch(proxy);
                            proxy.$bang((Object)ShardCoordinator$Internal$RegisterAck$.MODULE$.apply(this.$outer.self()), this.$outer.self());
                        });
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.GetShardHome) {
                    Internal.GetShardHome getShardHome = ShardCoordinator$Internal$GetShardHome$.MODULE$.unapply((Internal.GetShardHome)object);
                    String string = getShardHome._1();
                    String shard = string;
                    if (!this.$outer.handleGetShardHome(shard)) {
                        scala.collection.immutable.Map activeRegions = (scala.collection.immutable.Map)this.$outer.state().regions().$minus$minus(this.$outer.gracefulShutdownInProgress()).$minus$minus(this.$outer.regionTerminationInProgress());
                        if (activeRegions.nonEmpty()) {
                            Try try_;
                            ActorRef getShardHomeSender = this.$outer.sender();
                            Future<ActorRef> regionFuture = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$allocationStrategy.allocateShard(getShardHomeSender, shard, (scala.collection.immutable.Map<ActorRef, IndexedSeq<String>>)activeRegions);
                            Option option = regionFuture.value();
                            if (option instanceof Some && (try_ = (Try)((Some)option).value()) instanceof Success) {
                                ActorRef region3 = (ActorRef)((Success)try_).value();
                                this.$outer.continueGetShardHome(shard, region3, getShardHomeSender);
                            } else {
                                org.apache.pekko.pattern.package$.MODULE$.pipe(regionFuture.map(arg_0 -> ShardCoordinator.org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$3(shard, getShardHomeSender, arg_0), (ExecutionContext)this.$outer.context().dispatcher()).recover((PartialFunction)new Serializable(shard, getShardHomeSender, this){
                                    private final String shard$2;
                                    private final ActorRef getShardHomeSender$2;
                                    private final /* synthetic */ $anon$1 $outer;
                                    {
                                        this.shard$2 = shard$11;
                                        this.getShardHomeSender$2 = getShardHomeSender$4;
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }

                                    public final boolean isDefinedAt(Throwable x) {
                                        Throwable throwable;
                                        Throwable t = throwable = x;
                                        return true;
                                    }

                                    public final Object applyOrElse(Throwable x, Function1 function1) {
                                        Throwable throwable;
                                        Throwable t = throwable = x;
                                        this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$_$$anon$$$outer().log().error(t, "{}: Shard [{}] allocation failed.", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$_$$anon$$$outer().typeName(), (Object)this.shard$2);
                                        return ShardCoordinator$AllocateShardResult$.MODULE$.apply(this.shard$2, (Option<ActorRef>)None$.MODULE$, this.getShardHomeSender$2);
                                    }
                                }, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.self(), this.$outer.self());
                            }
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof AllocateShardResult) {
                    AllocateShardResult allocateShardResult = ShardCoordinator$AllocateShardResult$.MODULE$.unapply((AllocateShardResult)object);
                    String string = allocateShardResult._1();
                    Option<ActorRef> option = allocateShardResult._2();
                    ActorRef actorRef = allocateShardResult._3();
                    String shard = string;
                    if (None$.MODULE$.equals(option)) {
                        this.$outer.log().debug("{}: Shard [{}] allocation failed. It will be retried.", (Object)this.$outer.typeName(), (Object)shard);
                        return BoxedUnit.UNIT;
                    }
                    String shard2 = string;
                    if (option instanceof Some) {
                        ActorRef region4 = (ActorRef)((Some)option).value();
                        ActorRef getShardHomeSender = actorRef;
                        this.$outer.continueGetShardHome(shard2, region4, getShardHomeSender);
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Internal.ShardStarted) {
                    String string;
                    Internal.ShardStarted shardStarted = ShardCoordinator$Internal$ShardStarted$.MODULE$.unapply((Internal.ShardStarted)object);
                    String shard = string = shardStarted._1();
                    Option option = this.$outer.unAckedHostShards().get((Object)shard);
                    if (option instanceof Some) {
                        Cancellable cancel = (Cancellable)((Some)option).value();
                        cancel.cancel();
                        this.$outer.unAckedHostShards_$eq((scala.collection.immutable.Map<String, Cancellable>)((scala.collection.immutable.Map)this.$outer.unAckedHostShards().$minus((Object)shard)));
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ResendShardHost) {
                    ResendShardHost resendShardHost = ShardCoordinator$ResendShardHost$.MODULE$.unapply((ResendShardHost)object);
                    String string = resendShardHost._1();
                    ActorRef actorRef = resendShardHost._2();
                    String shard = string;
                    ActorRef region5 = actorRef;
                    Option option = this.$outer.state().shards().get((Object)shard);
                    if (option instanceof Some) {
                        ActorRef actorRef2 = region5;
                        Object object2 = ((Some)option).value();
                        if (!(actorRef2 != null ? !actorRef2.equals(object2) : object2 != null)) {
                            this.$outer.sendHostShardMsg(shard, region5);
                        }
                    }
                    return BoxedUnit.UNIT;
                }
                if (ShardCoordinator$RebalanceTick$.MODULE$.equals(object)) {
                    if (this.$outer.state().regions().nonEmpty() && !this.$outer.preparingForShutdown()) {
                        Try try_;
                        Future<scala.collection.immutable.Set<String>> shardsFuture = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$allocationStrategy.rebalance(this.$outer.state().regions(), (scala.collection.immutable.Set<String>)this.$outer.rebalanceInProgress().keySet());
                        Option option = shardsFuture.value();
                        if (option instanceof Some && (try_ = (Try)((Some)option).value()) instanceof Success) {
                            scala.collection.immutable.Set shards = (scala.collection.immutable.Set)((Success)try_).value();
                            this.$outer.continueRebalance((scala.collection.immutable.Set<String>)shards);
                        } else {
                            org.apache.pekko.pattern.package$.MODULE$.pipe(shardsFuture.map(ShardCoordinator::org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$4, (ExecutionContext)this.$outer.context().dispatcher()).recover((PartialFunction)new Serializable(){

                                public final boolean isDefinedAt(Throwable x) {
                                    Throwable throwable = x;
                                    return true;
                                }

                                public final Object applyOrElse(Throwable x, Function1 function1) {
                                    Throwable throwable = x;
                                    return ShardCoordinator$RebalanceResult$.MODULE$.apply((scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
                                }
                            }, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.self(), this.$outer.self());
                        }
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RebalanceResult) {
                    scala.collection.immutable.Set<String> set;
                    RebalanceResult rebalanceResult = ShardCoordinator$RebalanceResult$.MODULE$.unapply((RebalanceResult)object);
                    scala.collection.immutable.Set<String> shards = set = rebalanceResult._1();
                    this.$outer.continueRebalance(shards);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RebalanceDone) {
                    RebalanceDone rebalanceDone = ShardCoordinator$RebalanceDone$.MODULE$.unapply((RebalanceDone)object);
                    String string = rebalanceDone._1();
                    boolean bl = rebalanceDone._2();
                    String shard = string;
                    boolean ok = bl;
                    this.$outer.rebalanceWorkers_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.rebalanceWorkers().$minus((Object)this.$outer.sender())));
                    if (ok) {
                        this.$outer.log().debug("{}: Shard [{}] deallocation completed successfully.", (Object)this.$outer.typeName(), (Object)shard);
                        if (this.$outer.state().shards().contains((Object)shard)) {
                            this.$outer.update(ShardCoordinator$Internal$ShardHomeDeallocated$.MODULE$.apply(shard), (JProcedure1 & Serializable)evt -> {
                                this.$outer.log().debug("{}: Shard [{}] deallocated after", (Object)this.$outer.typeName(), (Object)shard);
                                this.$outer.state_$eq(this.$outer.state().updated((Internal.DomainEvent)evt));
                                this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$clearRebalanceInProgress(shard);
                                this.$outer.allocateShardHomesForRememberEntities();
                                this.$outer.self().tell((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply(shard), this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$ignoreRef);
                            });
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$clearRebalanceInProgress(shard);
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.log().warning("{}: Shard [{}] deallocation didn't complete within [{}].", (Object)this.$outer.typeName(), (Object)shard, (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.tuningParameters().handOffTimeout())));
                    this.$outer.state().shards().get((Object)shard).foreach((Function1)(JProcedure1 & Serializable)region -> this.$outer.gracefulShutdownInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.gracefulShutdownInProgress().$minus(region))));
                    this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$clearRebalanceInProgress(shard);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.GracefulShutdownReq) {
                    ActorRef actorRef;
                    Internal.GracefulShutdownReq gracefulShutdownReq = ShardCoordinator$Internal$GracefulShutdownReq$.MODULE$.unapply((Internal.GracefulShutdownReq)object);
                    ActorRef region6 = actorRef = gracefulShutdownReq._1();
                    if (!this.$outer.gracefulShutdownInProgress().apply((Object)region6)) {
                        Option option = this.$outer.state().regions().get((Object)region6);
                        if (option instanceof Some) {
                            Vector shards = (Vector)((Some)option).value();
                            if (this.$outer.log().isDebugEnabled()) {
                                if (this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$verboseDebug) {
                                    this.$outer.log().debug("{}: Graceful shutdown of {} region [{}] with [{}] shards [{}] started", Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.typeName(), region6.path().address().hasLocalScope() ? "local" : "", region6, BoxesRunTime.boxToInteger((int)shards.size()), shards.mkString(", ")}), ClassTag$.MODULE$.apply(Object.class)));
                                } else {
                                    this.$outer.log().debug("{}: Graceful shutdown of region [{}] with [{}] shards", (Object)this.$outer.typeName(), (Object)region6, (Object)BoxesRunTime.boxToInteger((int)shards.size()));
                                }
                            }
                            this.$outer.gracefulShutdownInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.gracefulShutdownInProgress().$plus((Object)region6)));
                            this.$outer.shutdownShards(region6, (scala.collection.immutable.Set<String>)shards.toSet());
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.log().debug("{}: Unknown region requested graceful shutdown [{}]", (Object)this.$outer.typeName(), (Object)region6);
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ShardRegion.GetClusterShardingStats) {
                    FiniteDuration finiteDuration;
                    ShardRegion.GetClusterShardingStats getClusterShardingStats = ShardRegion$GetClusterShardingStats$.MODULE$.unapply((ShardRegion.GetClusterShardingStats)object);
                    FiniteDuration waitMax = finiteDuration = getClusterShardingStats._1();
                    Timeout timeout = Timeout$.MODULE$.durationToTimeout(waitMax);
                    org.apache.pekko.pattern.package$.MODULE$.pipe(Future$.MODULE$.sequence((IterableOnce)this.$outer.aliveRegions().map((Function1 & Serializable)regionActor -> AskableActorRef$.MODULE$.$qmark$extension(org.apache.pekko.pattern.package$.MODULE$.ask(regionActor), (Object)ShardRegion$GetShardRegionStats$.MODULE$, timeout, this.$outer.self()).mapTo(ClassTag$.MODULE$.apply(ShardRegion.ShardRegionStats.class)).map(arg_0 -> ShardCoordinator.org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$7$$anonfun$1(regionActor, arg_0), (ExecutionContext)this.$outer.context().dispatcher())), BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.$outer.context().dispatcher()).map((Function1 & Serializable)allRegionStats -> ShardRegion$ClusterShardingStats$.MODULE$.apply((scala.collection.immutable.Map<Address, ShardRegion.ShardRegionStats>)((IterableOnceOps)allRegionStats.map(this::applyOrElse$$anonfun$8$$anonfun$1)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (ExecutionContext)this.$outer.context().dispatcher()).recover((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            return throwable instanceof AskTimeoutException;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            if (throwable instanceof AskTimeoutException) {
                                return ShardRegion$ClusterShardingStats$.MODULE$.apply((scala.collection.immutable.Map<Address, ShardRegion.ShardRegionStats>)Predef$.MODULE$.Map().empty());
                            }
                            return function1.apply((Object)x);
                        }
                    }, (ExecutionContext)this.$outer.context().dispatcher()), (ExecutionContext)this.$outer.context().dispatcher()).pipeTo(this.$outer.sender(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ClusterEvent.ClusterShuttingDown$.MODULE$.equals(object)) {
                    this.$outer.log().debug("{}: Shutting down ShardCoordinator", (Object)this.$outer.typeName());
                    this.$outer.context().become(this.$outer.shuttingDown());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberPreparingForShutdown || object instanceof ClusterEvent.MemberReadyForShutdown) {
                    if (!this.$outer.preparingForShutdown()) {
                        this.$outer.log().info("{}: Shard coordinator detected prepare for full cluster shutdown. No new rebalances will take place.", (Object)this.$outer.typeName());
                        this.$outer.timers().cancel((Object)ShardCoordinator$RebalanceTick$.MODULE$);
                        this.$outer.preparingForShutdown_$eq(true);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ShardRegion$GetCurrentRegions$.MODULE$.equals(object)) {
                    ShardRegion.CurrentRegions reply = ShardRegion$CurrentRegions$.MODULE$.apply((scala.collection.immutable.Set<Address>)((scala.collection.immutable.Set)this.$outer.state().regions().keySet().map((Function1 & Serializable)ref -> {
                        if (ref.path().address().host().isEmpty()) {
                            return this.$outer.cluster().selfAddress();
                        }
                        return ref.path().address();
                    })));
                    this.$outer.sender().$bang((Object)reply, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (ShardCoordinator$Internal$Terminate$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$$terminate();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            public final /* synthetic */ ShardCoordinator org$apache$pekko$cluster$sharding$ShardCoordinator$_$$anon$$$outer() {
                return this.$outer;
            }

            /*
             * Unable to fully structure code
             */
            private final /* synthetic */ Tuple2 applyOrElse$$anonfun$8$$anonfun$1(Tuple2 x$1) {
                block2: {
                    var2_2 = x$1;
                    if (var2_2 == null) break block2;
                    region = (ActorRef)var2_2._1();
                    stats = (ShardRegion.ShardRegionStats)var2_2._2();
                    regionAddress = region.path().address();
                    if (!regionAddress.hasLocalScope()) ** GOTO lbl-1000
                    v0 = regionAddress.system();
                    var7_6 = this.$outer.cluster().selfAddress().system();
                    if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                        v1 = this.$outer.cluster().selfAddress();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = regionAddress;
                    }
                    address = v1;
                    var8_8 = (Address)Predef$.MODULE$.ArrowAssoc((Object)address);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)var8_8, (Object)stats);
                }
                throw new MatchError((Object)var2_2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.actor.ActorRef org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionRegistered ), applyOrElse$$anonfun$2(org.apache.pekko.actor.ActorRef org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardRegionProxyRegistered ), org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$3(java.lang.String org.apache.pekko.actor.ActorRef org.apache.pekko.actor.ActorRef ), org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$4(scala.collection.immutable.Set ), applyOrElse$$anonfun$5(java.lang.String org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHomeDeallocated ), applyOrElse$$anonfun$6(org.apache.pekko.actor.ActorRef ), applyOrElse$$anonfun$7(org.apache.pekko.util.Timeout org.apache.pekko.actor.ActorRef ), applyOrElse$$anonfun$8(scala.collection.immutable.Set ), $anonfun$1(org.apache.pekko.actor.ActorRef ), org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$7$$anonfun$1(org.apache.pekko.actor.ActorRef org.apache.pekko.cluster.sharding.ShardRegion$ShardRegionStats ), applyOrElse$$anonfun$8$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        }.orElse(this.receiveTerminated());
    }

    public void org$apache$pekko$cluster$sharding$ShardCoordinator$$terminate() {
        if (this.aliveRegions().exists((Function1 & Serializable)_$4 -> _$4.path().address().hasLocalScope()) || this.gracefulShutdownInProgress().exists((Function1 & Serializable)_$5 -> _$5.path().address().hasLocalScope())) {
            this.aliveRegions().find((Function1 & Serializable)_$6 -> _$6.path().address().hasLocalScope()).foreach((Function1)(JProcedure1 & Serializable)region -> region.$bang((Object)ShardRegion$GracefulShutdown$.MODULE$, this.self()));
            this.log().debug("{}: Deferring coordinator termination until local region has terminated", (Object)this.typeName());
            this.waitingForLocalRegionToTerminate_$eq(true);
            return;
        }
        if (this.rebalanceInProgress().isEmpty()) {
            this.log().debug("{}: Received termination message.", (Object)this.typeName());
        } else if (this.log().isDebugEnabled()) {
            if (this.org$apache$pekko$cluster$sharding$ShardCoordinator$$verboseDebug) {
                this.log().debug("{}: Received termination message. Rebalance in progress of [{}] shards [{}].", (Object)this.typeName(), (Object)BoxesRunTime.boxToInteger((int)this.rebalanceInProgress().size()), (Object)this.rebalanceInProgress().keySet().mkString(", "));
            } else {
                this.log().debug("{}: Received termination message. Rebalance in progress of [{}] shards.", (Object)this.typeName(), (Object)BoxesRunTime.boxToInteger((int)this.rebalanceInProgress().size()));
            }
        }
        this.context().stop(this.self());
    }

    public void org$apache$pekko$cluster$sharding$ShardCoordinator$$clearRebalanceInProgress(String shard) {
        Option option = this.rebalanceInProgress().get((Object)shard);
        if (option instanceof Some) {
            scala.collection.immutable.Set pendingGetShardHome = (scala.collection.immutable.Set)((Some)option).value();
            Internal.GetShardHome msg = ShardCoordinator$Internal$GetShardHome$.MODULE$.apply(shard);
            pendingGetShardHome.foreach((Function1)(JProcedure1 & Serializable)getShardHomeSender -> this.self().tell((Object)msg, getShardHomeSender));
            this.rebalanceInProgress_$eq((scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>>)((scala.collection.immutable.Map)this.rebalanceInProgress().$minus((Object)shard)));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError((Object)option);
    }

    private void deferGetShardHomeRequest(String shard, ActorRef from) {
        this.log().debug("{}: GetShardHome [{}] request from [{}] deferred, because rebalance is in progress for this shard. It will be handled when rebalance is done.", (Object)this.typeName(), (Object)shard, (Object)from);
        this.rebalanceInProgress_$eq((scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>>)((scala.collection.immutable.Map)this.rebalanceInProgress().updated((Object)shard, (Object)((SetOps)this.rebalanceInProgress().apply((Object)shard)).$plus((Object)from))));
    }

    public void org$apache$pekko$cluster$sharding$ShardCoordinator$$informAboutCurrentShards(ActorRef ref) {
        int batchSize = 500;
        if (this.state().shards().isEmpty()) {
            return;
        }
        this.log().debug("{}: Informing [{}] about (up to) [{}] shards in batches of [{}]", (Object)this.typeName(), (Object)ref, (Object)BoxesRunTime.boxToInteger((int)this.state().shards().size()), (Object)BoxesRunTime.boxToInteger((int)batchSize));
        this.state().regions().iterator().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef regionRef = (ActorRef)tuple2._1();
                Vector shards = (Vector)tuple2._2();
                scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>> map = this.rebalanceInProgress();
                return (Vector)((StrictOptimizedIterableOps)shards.filterNot((Function1 & Serializable)key -> map.contains(key))).map((Function1 & Serializable)shard -> {
                    ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)regionRef);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, shard);
                });
            }
            throw new MatchError((Object)tuple2);
        }).grouped(batchSize).take(10).foreach((Function1)(JProcedure1 & Serializable)regions -> {
            scala.collection.immutable.Map shardsSubMap = (scala.collection.immutable.Map)regions.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
                    if (tuple22 != null) {
                        ActorRef regionRef = (ActorRef)tuple22._1();
                        String shardId = (String)tuple22._2();
                        if (map.contains((Object)regionRef)) {
                            return (scala.collection.immutable.Map)map.updated((Object)regionRef, (Object)((List)map.apply((Object)regionRef)).$colon$colon((Object)shardId));
                        }
                        return (scala.collection.immutable.Map)map.updated((Object)regionRef, (Object)scala.package$.MODULE$.Nil().$colon$colon((Object)shardId));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            ref.$bang((Object)ShardCoordinator$Internal$ShardHomes$.MODULE$.apply((scala.collection.immutable.Map<ActorRef, Seq<String>>)shardsSubMap), this.self());
        });
    }

    public boolean handleGetShardHome(String shard) {
        if (this.rebalanceInProgress().contains((Object)shard)) {
            this.deferGetShardHomeRequest(shard, this.sender());
            this.unstashOneGetShardHomeRequest();
            return true;
        }
        if (!this.hasAllRegionsRegistered()) {
            this.log().debug("{}: GetShardHome [{}] request from [{}] ignored, because not all regions have registered yet.", (Object)this.typeName(), (Object)shard, (Object)this.sender());
            return true;
        }
        Option option = this.state().shards().get((Object)shard);
        if (option instanceof Some) {
            ActorRef shardRegionRef = (ActorRef)((Some)option).value();
            if (this.regionTerminationInProgress().apply((Object)shardRegionRef)) {
                this.log().debug("{}: GetShardHome [{}] request ignored, due to region [{}] termination in progress.", (Object)this.typeName(), (Object)shard, (Object)shardRegionRef);
            } else {
                this.sender().$bang((Object)ShardCoordinator$Internal$ShardHome$.MODULE$.apply(shard, shardRegionRef), this.self());
            }
            this.unstashOneGetShardHomeRequest();
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public PartialFunction<Object, BoxedUnit> receiveTerminated() {
        return new Serializable(this){
            private final /* synthetic */ ShardCoordinator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = (Terminated)object;
                    Terminated terminated2 = Terminated$.MODULE$.unapply(terminated);
                    ActorRef ref = actorRef = terminated2._1();
                    Terminated t = terminated;
                    return true;
                }
                if (object instanceof Internal.RegionStopped) {
                    ActorRef actorRef;
                    Internal.RegionStopped regionStopped = ShardCoordinator$Internal$RegionStopped$.MODULE$.unapply((Internal.RegionStopped)object);
                    ActorRef ref = actorRef = regionStopped._1();
                    return true;
                }
                if (object instanceof DelayedShardRegionTerminated) {
                    ActorRef actorRef;
                    DelayedShardRegionTerminated delayedShardRegionTerminated = ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.unapply((DelayedShardRegionTerminated)object);
                    ActorRef ref = actorRef = delayedShardRegionTerminated._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = (Terminated)object;
                    Terminated terminated2 = Terminated$.MODULE$.unapply(terminated);
                    ActorRef ref = actorRef = terminated2._1();
                    Terminated t = terminated;
                    if (this.$outer.state().regions().contains((Object)ref)) {
                        FiniteDuration finiteDuration = this.$outer.removalMargin();
                        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                        if ((finiteDuration == null ? finiteDuration2 != null : !finiteDuration.equals(finiteDuration2)) && t.addressTerminated() && this.$outer.aliveRegions().apply((Object)ref)) {
                            this.$outer.context().system().scheduler().scheduleOnce(this.$outer.removalMargin(), this.$outer.self(), (Object)ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.apply(ref), (ExecutionContext)this.$outer.context().dispatcher(), this.$outer.self());
                            this.$outer.regionTerminationInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.$outer.regionTerminationInProgress().$plus((Object)ref)));
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.regionTerminated(ref);
                        return BoxedUnit.UNIT;
                    }
                    if (this.$outer.state().regionProxies().contains((Object)ref)) {
                        this.$outer.regionProxyTerminated(ref);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.RegionStopped) {
                    ActorRef actorRef;
                    Internal.RegionStopped regionStopped = ShardCoordinator$Internal$RegionStopped$.MODULE$.unapply((Internal.RegionStopped)object);
                    ActorRef ref = actorRef = regionStopped._1();
                    this.$outer.log().debug("{}: ShardRegion stopped: [{}]", (Object)this.$outer.typeName(), (Object)ref);
                    this.$outer.regionTerminated(ref);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof DelayedShardRegionTerminated) {
                    ActorRef actorRef;
                    DelayedShardRegionTerminated delayedShardRegionTerminated = ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.unapply((DelayedShardRegionTerminated)object);
                    ActorRef ref = actorRef = delayedShardRegionTerminated._1();
                    this.$outer.regionTerminated(ref);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public abstract <E extends Internal.DomainEvent> void update(E var1, Function1<E, BoxedUnit> var2);

    public void watchStateActors() {
        SortedSet nodes = (SortedSet)this.cluster().state().members().map((Function1 & Serializable)_$7 -> _$7.address(), Address$.MODULE$.addressOrdering());
        this.state().regions().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef ref = (ActorRef)tuple2._1();
                Address a = ref.path().address();
                if (a.hasLocalScope() || nodes.apply((Object)a)) {
                    return this.context().watch(ref);
                }
                this.regionTerminated(ref);
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        this.state().regionProxies().foreach((Function1 & Serializable)ref -> {
            Address a = ref.path().address();
            if (a.hasLocalScope() || nodes.apply((Object)a)) {
                return this.context().watch(ref);
            }
            this.regionProxyTerminated((ActorRef)ref);
            return BoxedUnit.UNIT;
        });
        this.context().system().scheduler().scheduleOnce(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(500)).millis(), this.self(), (Object)ShardCoordinator$Internal$StateInitialized$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
    }

    public void stateInitialized() {
        this.state().shards().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String a = (String)tuple2._1();
                ActorRef r = (ActorRef)tuple2._2();
                this.sendHostShardMsg(a, r);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.allocateShardHomesForRememberEntities();
    }

    public boolean hasAllRegionsRegistered() {
        if (this.allRegionsRegistered()) {
            return true;
        }
        this.allRegionsRegistered_$eq(this.aliveRegions().size() >= this.minMembers());
        return this.allRegionsRegistered();
    }

    public void regionTerminated(ActorRef ref) {
        this.rebalanceWorkers().foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.$bang((Object)ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.apply(ref), this.self()));
        if (this.state().regions().contains((Object)ref)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("{}: ShardRegion terminated{}: [{}] {}", (Object)this.typeName(), (Object)(this.gracefulShutdownInProgress().contains((Object)ref) ? " (gracefully)" : ""), (Object)ref);
            }
            this.regionTerminationInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.regionTerminationInProgress().$plus((Object)ref)));
            ((Vector)this.state().regions().apply((Object)ref)).foreach((Function1)(JProcedure1 & Serializable)s -> this.self().tell((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply((String)s), this.org$apache$pekko$cluster$sharding$ShardCoordinator$$ignoreRef));
            this.update((Internal.DomainEvent)ShardCoordinator$Internal$ShardRegionTerminated$.MODULE$.apply(ref), (Function1)(JProcedure1 & Serializable)evt -> {
                this.state_$eq(this.state().updated((Internal.DomainEvent)evt));
                this.gracefulShutdownInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.gracefulShutdownInProgress().$minus((Object)ref)));
                this.regionTerminationInProgress_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.regionTerminationInProgress().$minus((Object)ref)));
                this.aliveRegions_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.aliveRegions().$minus((Object)ref)));
                this.allocateShardHomesForRememberEntities();
                if (ref.path().address().hasLocalScope() && this.waitingForLocalRegionToTerminate()) {
                    this.log().debug("{}: Local region stopped, terminating coordinator", (Object)this.typeName());
                    this.org$apache$pekko$cluster$sharding$ShardCoordinator$$terminate();
                    return;
                }
            });
            return;
        }
    }

    public void regionProxyTerminated(ActorRef ref) {
        this.rebalanceWorkers().foreach((Function1)(JProcedure1 & Serializable)_$9 -> _$9.$bang((Object)ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.apply(ref), this.self()));
        if (this.state().regionProxies().contains((Object)ref)) {
            this.log().debug("{}: ShardRegion proxy terminated: [{}]", (Object)this.typeName(), (Object)ref);
            this.update((Internal.DomainEvent)ShardCoordinator$Internal$ShardRegionProxyTerminated$.MODULE$.apply(ref), (Function1)(JProcedure1 & Serializable)evt -> this.state_$eq(this.state().updated((Internal.DomainEvent)evt)));
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> shuttingDown() {
        return new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                return BoxedUnit.UNIT;
            }
        };
    }

    public void sendHostShardMsg(String shard, ActorRef region) {
        region.$bang((Object)ShardCoordinator$Internal$HostShard$.MODULE$.apply(shard), this.self());
        Cancellable cancel = this.context().system().scheduler().scheduleOnce(this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.tuningParameters().shardStartTimeout(), this.self(), (Object)ShardCoordinator$ResendShardHost$.MODULE$.apply(shard, region), (ExecutionContext)this.context().dispatcher(), this.self());
        this.unAckedHostShards_$eq((scala.collection.immutable.Map<String, Cancellable>)((scala.collection.immutable.Map)this.unAckedHostShards().updated((Object)shard, (Object)cancel)));
    }

    public void allocateShardHomesForRememberEntities() {
        if (this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.rememberEntities() && this.state().unallocatedShards().nonEmpty()) {
            this.state().unallocatedShards().foreach((Function1)(JProcedure1 & Serializable)shard -> this.self().tell((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply((String)shard), this.org$apache$pekko$cluster$sharding$ShardCoordinator$$ignoreRef));
            return;
        }
    }

    public void continueGetShardHome(String shard, ActorRef region, ActorRef getShardHomeSender) {
        if (this.rebalanceInProgress().contains((Object)shard)) {
            this.deferGetShardHomeRequest(shard, getShardHomeSender);
            return;
        }
        Option option = this.state().shards().get((Object)shard);
        if (option instanceof Some) {
            ActorRef ref = (ActorRef)((Some)option).value();
            getShardHomeSender.$bang((Object)ShardCoordinator$Internal$ShardHome$.MODULE$.apply(shard, ref), this.self());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.state().regions().contains((Object)region) && !this.gracefulShutdownInProgress().apply((Object)region) && !this.regionTerminationInProgress().contains((Object)region)) {
                this.update((Internal.DomainEvent)ShardCoordinator$Internal$ShardHomeAllocated$.MODULE$.apply(shard, region), (Function1)(JProcedure1 & Serializable)evt -> {
                    this.state_$eq(this.state().updated((Internal.DomainEvent)evt));
                    this.log().debug(ShardingLogMarker$.MODULE$.shardAllocated(this.typeName(), shard, this.regionAddress(region)), "{}: Shard [{}] allocated at [{}]", (Object)this.typeName(), (Object)evt.shard(), (Object)evt.region());
                    this.sendHostShardMsg(evt.shard(), evt.region());
                    getShardHomeSender.$bang((Object)ShardCoordinator$Internal$ShardHome$.MODULE$.apply(evt.shard(), evt.region()), this.self());
                });
                return;
            }
            if (this.org$apache$pekko$cluster$sharding$ShardCoordinator$$verboseDebug) {
                this.log().debug("{}: Allocated region [{}] for shard [{}] is not (any longer) one of the registered regions: {}", (Object)this.typeName(), (Object)region, (Object)shard, (Object)this.state());
                return;
            }
            this.log().debug("{}: Allocated region [{}] for shard [{}] is not (any longer) one of the registered regions.", (Object)this.typeName(), (Object)region, (Object)shard);
            return;
        }
        throw new MatchError((Object)option);
    }

    public abstract void unstashOneGetShardHomeRequest();

    private Address regionAddress(ActorRef region) {
        if (region.path().address().host().isEmpty()) {
            return this.cluster().selfAddress();
        }
        return region.path().address();
    }

    private void startShardRebalanceIfNeeded(String shard, ActorRef from, FiniteDuration handOffTimeout, boolean isRebalance) {
        if (!this.rebalanceInProgress().contains((Object)shard)) {
            this.rebalanceInProgress_$eq((scala.collection.immutable.Map<String, scala.collection.immutable.Set<ActorRef>>)((scala.collection.immutable.Map)this.rebalanceInProgress().updated((Object)shard, (Object)Predef$.MODULE$.Set().empty())));
            this.rebalanceWorkers_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.rebalanceWorkers().$plus((Object)this.context().actorOf(ShardCoordinator$.MODULE$.rebalanceWorkerProps(this.typeName(), shard, from, handOffTimeout, (scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.state().regions().keySet().union(this.state().regionProxies())), isRebalance).withDispatcher(this.context().props().dispatcher())))));
            return;
        }
    }

    public void continueRebalance(scala.collection.immutable.Set<String> shards) {
        if (this.log().isInfoEnabled() && (shards.nonEmpty() || this.rebalanceInProgress().nonEmpty())) {
            this.log().info("{}: Starting rebalance for shards [{}]. Current shards rebalancing: [{}]", (Object)this.typeName(), (Object)shards.mkString(","), (Object)this.rebalanceInProgress().keySet().mkString(","));
        }
        shards.foreach((Function1)(JProcedure1 & Serializable)shard -> {
            if (!this.rebalanceInProgress().contains(shard)) {
                Option option = this.state().shards().get(shard);
                if (option instanceof Some) {
                    ActorRef rebalanceFromRegion = (ActorRef)((Some)option).value();
                    this.log().debug("{}: Rebalance shard [{}] from [{}]", (Object)this.typeName(), shard, (Object)rebalanceFromRegion);
                    this.startShardRebalanceIfNeeded((String)shard, rebalanceFromRegion, this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.tuningParameters().handOffTimeout(), true);
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().debug("{}: Rebalance of non-existing shard [{}] is ignored", (Object)this.typeName(), shard);
                    return;
                }
                throw new MatchError((Object)option);
            }
        });
    }

    public void shutdownShards(ActorRef shuttingDownRegion, scala.collection.immutable.Set<String> shards) {
        if (this.log().isInfoEnabled() && shards.nonEmpty()) {
            this.log().info("{}: Starting shutting down shards [{}] due to region shutting down.", (Object)this.typeName(), (Object)shards.mkString(","));
        }
        shards.foreach((Function1)(JProcedure1 & Serializable)shard -> this.startShardRebalanceIfNeeded((String)shard, shuttingDownRegion, this.org$apache$pekko$cluster$sharding$ShardCoordinator$$settings.tuningParameters().handOffTimeout(), false));
    }

    private static final int $init$$$anonfun$1() {
        return 1;
    }

    public static final /* synthetic */ AllocateShardResult org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$3(String shard$1, ActorRef getShardHomeSender$1, ActorRef region) {
        return ShardCoordinator$AllocateShardResult$.MODULE$.apply(shard$1, (Option<ActorRef>)Some$.MODULE$.apply((Object)region), getShardHomeSender$1);
    }

    public static final /* synthetic */ RebalanceResult org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$4(scala.collection.immutable.Set shards) {
        return ShardCoordinator$RebalanceResult$.MODULE$.apply((scala.collection.immutable.Set<String>)shards);
    }

    public static final /* synthetic */ Tuple2 org$apache$pekko$cluster$sharding$ShardCoordinator$$anon$1$$_$applyOrElse$$anonfun$7$$anonfun$1(ActorRef regionActor$1, ShardRegion.ShardRegionStats stats) {
        ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)regionActor$1);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, (Object)stats);
    }

    public static abstract class AbstractShardAllocationStrategy
    implements ShardAllocationStrategy {
        @Override
        public final Future<ActorRef> allocateShard(ActorRef requester, String shardId, scala.collection.immutable.Map<ActorRef, IndexedSeq<String>> currentShardAllocations) {
            return this.allocateShard(requester, shardId, package.JavaConverters$.MODULE$.MapHasAsJava(currentShardAllocations).asJava());
        }

        @Override
        public final Future<scala.collection.immutable.Set<String>> rebalance(scala.collection.immutable.Map<ActorRef, IndexedSeq<String>> currentShardAllocations, scala.collection.immutable.Set<String> rebalanceInProgress) {
            ExecutionContext ec = ExecutionContexts$.MODULE$.parasitic();
            return this.rebalance(package.JavaConverters$.MODULE$.MapHasAsJava(currentShardAllocations).asJava(), package.JavaConverters$.MODULE$.SetHasAsJava(rebalanceInProgress).asJava()).map((Function1 & Serializable)_$1 -> package.JavaConverters$.MODULE$.SetHasAsScala(_$1).asScala().toSet(), ec);
        }

        public abstract Future<ActorRef> allocateShard(ActorRef var1, String var2, Map<ActorRef, IndexedSeq<String>> var3);

        public abstract Future<Set<String>> rebalance(Map<ActorRef, IndexedSeq<String>> var1, Set<String> var2);
    }

    @InternalApi
    public static interface ActorSystemDependentAllocationStrategy
    extends ShardAllocationStrategy {
        public void start(ActorSystem var1);
    }

    public static final class AllocateShardResult
    implements Product,
    Serializable {
        private final String shard;
        private final Option shardRegion;
        private final ActorRef getShardHomeSender;

        public static AllocateShardResult apply(String string, Option<ActorRef> option, ActorRef actorRef) {
            return ShardCoordinator$AllocateShardResult$.MODULE$.apply(string, option, actorRef);
        }

        public static AllocateShardResult fromProduct(Product product) {
            return ShardCoordinator$AllocateShardResult$.MODULE$.fromProduct(product);
        }

        public static AllocateShardResult unapply(AllocateShardResult allocateShardResult) {
            return ShardCoordinator$AllocateShardResult$.MODULE$.unapply(allocateShardResult);
        }

        public AllocateShardResult(String shard, Option<ActorRef> shardRegion, ActorRef getShardHomeSender) {
            this.shard = shard;
            this.shardRegion = shardRegion;
            this.getShardHomeSender = getShardHomeSender;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AllocateShardResult)) return false;
            AllocateShardResult allocateShardResult = (AllocateShardResult)object;
            String string = this.shard();
            String string2 = allocateShardResult.shard();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<ActorRef> option = this.shardRegion();
            Option<ActorRef> option2 = allocateShardResult.shardRegion();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            ActorRef actorRef = this.getShardHomeSender();
            ActorRef actorRef2 = allocateShardResult.getShardHomeSender();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AllocateShardResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AllocateShardResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "shard";
                }
                case 1: {
                    return "shardRegion";
                }
                case 2: {
                    return "getShardHomeSender";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shard() {
            return this.shard;
        }

        public Option<ActorRef> shardRegion() {
            return this.shardRegion;
        }

        public ActorRef getShardHomeSender() {
            return this.getShardHomeSender;
        }

        public AllocateShardResult copy(String shard, Option<ActorRef> shardRegion, ActorRef getShardHomeSender) {
            return new AllocateShardResult(shard, shardRegion, getShardHomeSender);
        }

        public String copy$default$1() {
            return this.shard();
        }

        public Option<ActorRef> copy$default$2() {
            return this.shardRegion();
        }

        public ActorRef copy$default$3() {
            return this.getShardHomeSender();
        }

        public String _1() {
            return this.shard();
        }

        public Option<ActorRef> _2() {
            return this.shardRegion();
        }

        public ActorRef _3() {
            return this.getShardHomeSender();
        }
    }

    public static final class DelayedShardRegionTerminated
    implements Product,
    Serializable {
        private final ActorRef region;

        public static DelayedShardRegionTerminated apply(ActorRef actorRef) {
            return ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.apply(actorRef);
        }

        public static DelayedShardRegionTerminated fromProduct(Product product) {
            return ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.fromProduct(product);
        }

        public static DelayedShardRegionTerminated unapply(DelayedShardRegionTerminated delayedShardRegionTerminated) {
            return ShardCoordinator$DelayedShardRegionTerminated$.MODULE$.unapply(delayedShardRegionTerminated);
        }

        public DelayedShardRegionTerminated(ActorRef region) {
            this.region = region;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DelayedShardRegionTerminated)) return false;
            DelayedShardRegionTerminated delayedShardRegionTerminated = (DelayedShardRegionTerminated)object;
            ActorRef actorRef = this.region();
            ActorRef actorRef2 = delayedShardRegionTerminated.region();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DelayedShardRegionTerminated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DelayedShardRegionTerminated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "region";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef region() {
            return this.region;
        }

        public DelayedShardRegionTerminated copy(ActorRef region) {
            return new DelayedShardRegionTerminated(region);
        }

        public ActorRef copy$default$1() {
            return this.region();
        }

        public ActorRef _1() {
            return this.region();
        }
    }

    @DoNotInherit
    public static class LeastShardAllocationStrategy
    extends AbstractLeastShardAllocationStrategy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int rebalanceThreshold;
        private final int maxSimultaneousRebalance;

        public LeastShardAllocationStrategy(int rebalanceThreshold, int maxSimultaneousRebalance) {
            this.rebalanceThreshold = rebalanceThreshold;
            this.maxSimultaneousRebalance = maxSimultaneousRebalance;
        }

        @Override
        public Future<scala.collection.immutable.Set<String>> rebalance(scala.collection.immutable.Map<ActorRef, IndexedSeq<String>> currentShardAllocations, scala.collection.immutable.Set<String> rebalanceInProgress) {
            if (rebalanceInProgress.size() < this.maxSimultaneousRebalance) {
                Vector sortedRegionEntries = (Vector)this.regionEntriesFor(currentShardAllocations).toVector().sorted((Ordering)AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$.MODULE$);
                if (this.isAGoodTimeToRebalance((Iterable<AbstractLeastShardAllocationStrategy.RegionEntry>)sortedRegionEntries)) {
                    Tuple2<ActorRef, IndexedSeq<String>> tuple2 = this.mostSuitableRegion((Iterable<AbstractLeastShardAllocationStrategy.RegionEntry>)sortedRegionEntries);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    IndexedSeq leastShards = (IndexedSeq)tuple2._2();
                    IndexedSeq leastShards2 = leastShards;
                    IndexedSeq mostShards = (IndexedSeq)((IterableOnceOps)sortedRegionEntries.collect((PartialFunction)new Serializable(rebalanceInProgress){
                        private final scala.collection.immutable.Set rebalanceInProgress$1;
                        {
                            this.rebalanceInProgress$1 = rebalanceInProgress$2;
                        }

                        public final boolean isDefinedAt(AbstractLeastShardAllocationStrategy.RegionEntry x) {
                            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x;
                            if (regionEntry != null) {
                                IndexedSeq<String> indexedSeq;
                                AbstractLeastShardAllocationStrategy.RegionEntry regionEntry2 = AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.unapply(regionEntry);
                                ActorRef actorRef = regionEntry2._1();
                                Member member = regionEntry2._2();
                                IndexedSeq<String> shardIds = indexedSeq = regionEntry2._3();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(AbstractLeastShardAllocationStrategy.RegionEntry x, Function1 function1) {
                            AbstractLeastShardAllocationStrategy.RegionEntry regionEntry = x;
                            if (regionEntry != null) {
                                IndexedSeq<String> indexedSeq;
                                AbstractLeastShardAllocationStrategy.RegionEntry regionEntry2 = AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.unapply(regionEntry);
                                ActorRef actorRef = regionEntry2._1();
                                Member member = regionEntry2._2();
                                IndexedSeq<String> shardIds = indexedSeq = regionEntry2._3();
                                return shardIds.filterNot((Function1 & Serializable)id -> this.rebalanceInProgress$1.apply(id));
                            }
                            return function1.apply((Object)x);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$9(java.lang.String )}, serializedLambda);
                        }
                    })).maxBy((Function1 & Serializable)_$2 -> _$2.size(), (Ordering)Ordering.Int$.MODULE$);
                    int difference = mostShards.size() - leastShards2.size();
                    if (difference > this.rebalanceThreshold) {
                        int n = package$.MODULE$.min(package$.MODULE$.min(difference - this.rebalanceThreshold, this.rebalanceThreshold), this.maxSimultaneousRebalance - rebalanceInProgress.size());
                        return Future$.MODULE$.successful((Object)((IterableOnceOps)((IndexedSeqOps)mostShards.sorted((Ordering)Ordering.String$.MODULE$)).take(n)).toSet());
                    }
                    return ShardCoordinator$.org$apache$pekko$cluster$sharding$ShardCoordinator$$$emptyRebalanceResult;
                }
                return ShardCoordinator$.org$apache$pekko$cluster$sharding$ShardCoordinator$$$emptyRebalanceResult;
            }
            return ShardCoordinator$.org$apache$pekko$cluster$sharding$ShardCoordinator$$$emptyRebalanceResult;
        }
    }

    public static final class RebalanceDone
    implements Product,
    Serializable {
        private final String shard;
        private final boolean ok;

        public static RebalanceDone apply(String string, boolean bl) {
            return ShardCoordinator$RebalanceDone$.MODULE$.apply(string, bl);
        }

        public static RebalanceDone fromProduct(Product product) {
            return ShardCoordinator$RebalanceDone$.MODULE$.fromProduct(product);
        }

        public static RebalanceDone unapply(RebalanceDone rebalanceDone) {
            return ShardCoordinator$RebalanceDone$.MODULE$.unapply(rebalanceDone);
        }

        public RebalanceDone(String shard, boolean ok) {
            this.shard = shard;
            this.ok = ok;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shard()));
            n = Statics.mix((int)n, (int)(this.ok() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RebalanceDone)) return false;
            RebalanceDone rebalanceDone = (RebalanceDone)object;
            if (this.ok() != rebalanceDone.ok()) return false;
            String string = this.shard();
            String string2 = rebalanceDone.shard();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RebalanceDone;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RebalanceDone";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shard";
            }
            if (1 == n2) {
                return "ok";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shard() {
            return this.shard;
        }

        public boolean ok() {
            return this.ok;
        }

        public RebalanceDone copy(String shard, boolean ok) {
            return new RebalanceDone(shard, ok);
        }

        public String copy$default$1() {
            return this.shard();
        }

        public boolean copy$default$2() {
            return this.ok();
        }

        public String _1() {
            return this.shard();
        }

        public boolean _2() {
            return this.ok();
        }
    }

    public static final class RebalanceResult
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set shards;

        public static RebalanceResult apply(scala.collection.immutable.Set<String> set) {
            return ShardCoordinator$RebalanceResult$.MODULE$.apply(set);
        }

        public static RebalanceResult fromProduct(Product product) {
            return ShardCoordinator$RebalanceResult$.MODULE$.fromProduct(product);
        }

        public static RebalanceResult unapply(RebalanceResult rebalanceResult) {
            return ShardCoordinator$RebalanceResult$.MODULE$.unapply(rebalanceResult);
        }

        public RebalanceResult(scala.collection.immutable.Set<String> shards) {
            this.shards = shards;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RebalanceResult)) return false;
            RebalanceResult rebalanceResult = (RebalanceResult)object;
            scala.collection.immutable.Set<String> set = this.shards();
            scala.collection.immutable.Set<String> set2 = rebalanceResult.shards();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RebalanceResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RebalanceResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shards";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Set<String> shards() {
            return this.shards;
        }

        public RebalanceResult copy(scala.collection.immutable.Set<String> shards) {
            return new RebalanceResult(shards);
        }

        public scala.collection.immutable.Set<String> copy$default$1() {
            return this.shards();
        }

        public scala.collection.immutable.Set<String> _1() {
            return this.shards();
        }
    }

    public static class RebalanceWorker
    implements Actor,
    ActorLogging,
    Timers {
        private ActorContext context;
        private ActorRef self;
        private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
        private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
        public final String org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName;
        public final String org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard;
        public final ActorRef org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom;
        public final boolean org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$isRebalance;
        private scala.collection.immutable.Set remaining;

        public RebalanceWorker(String typeName, String shard, ActorRef shardRegionFrom, FiniteDuration handOffTimeout, scala.collection.immutable.Set<ActorRef> regions, boolean isRebalance) {
            this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName = typeName;
            this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard = shard;
            this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom = shardRegionFrom;
            this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$isRebalance = isRebalance;
            Actor.$init$((Actor)this);
            ActorLogging.$init$((ActorLogging)this);
            Timers.$init$((Timers)this);
            regions.foreach((Function1)(JProcedure1 & Serializable)region -> region.$bang((Object)ShardCoordinator$Internal$BeginHandOff$.MODULE$.apply(shard), this.self()));
            this.remaining = regions;
            if (isRebalance) {
                this.log().debug("{}: Rebalance [{}] from [{}] regions", (Object)typeName, (Object)shard, (Object)BoxesRunTime.boxToInteger((int)regions.size()));
            } else {
                this.log().debug("{}: Shutting down shard [{}] from region [{}]. Asking [{}] region(s) to hand-off shard", (Object)typeName, (Object)shard, (Object)shardRegionFrom, (Object)BoxesRunTime.boxToInteger((int)regions.size()));
            }
            this.timers().startSingleTimer((Object)"hand-off-timeout", (Object)ReceiveTimeout$.MODULE$, handOffTimeout);
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
            return this.org$apache$pekko$actor$ActorLogging$$_log;
        }

        public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
            this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
        }

        public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
            return this.org$apache$pekko$actor$Timers$$_timers;
        }

        public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
            this.org$apache$pekko$actor$Timers$$_timers = x$0;
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
            Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
        }

        public scala.collection.immutable.Set<ActorRef> remaining() {
            return this.remaining;
        }

        public void remaining_$eq(scala.collection.immutable.Set<ActorRef> x$1) {
            this.remaining = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ RebalanceWorker $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Internal.BeginHandOffAck) {
                        Internal.BeginHandOffAck beginHandOffAck = ShardCoordinator$Internal$BeginHandOffAck$.MODULE$.unapply((Internal.BeginHandOffAck)object);
                        String string = beginHandOffAck._1();
                        String string2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            return true;
                        }
                    }
                    if (object instanceof ShardRegionTerminated) {
                        ActorRef actorRef;
                        ShardRegionTerminated shardRegionTerminated = ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.unapply((ShardRegionTerminated)object);
                        ActorRef shardRegion = actorRef = shardRegionTerminated._1();
                        return true;
                    }
                    return ReceiveTimeout$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Internal.BeginHandOffAck) {
                        Internal.BeginHandOffAck beginHandOffAck = ShardCoordinator$Internal$BeginHandOffAck$.MODULE$.unapply((Internal.BeginHandOffAck)object);
                        String string = beginHandOffAck._1();
                        String string2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            this.$outer.log().debug("{}: BeginHandOffAck for shard [{}] received from [{}].", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard, (Object)this.$outer.sender());
                            this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$acked(this.$outer.sender());
                            return BoxedUnit.UNIT;
                        }
                    }
                    if (object instanceof ShardRegionTerminated) {
                        ActorRef actorRef;
                        ShardRegionTerminated shardRegionTerminated = ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.unapply((ShardRegionTerminated)object);
                        ActorRef shardRegion = actorRef = shardRegionTerminated._1();
                        if (this.$outer.remaining().contains((Object)shardRegion)) {
                            this.$outer.log().debug("{}: ShardRegion [{}] terminated while waiting for BeginHandOffAck for shard [{}].", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)shardRegion, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard);
                            this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$acked(shardRegion);
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (ReceiveTimeout$.MODULE$.equals(object)) {
                        if (this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$isRebalance) {
                            this.$outer.log().debug("{}: Rebalance of [{}] from [{}] timed out", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom);
                        } else {
                            this.$outer.log().debug("{}: Shutting down [{}] shard from [{}] timed out", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom);
                        }
                        this.$outer.done(false);
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }
            };
        }

        public void org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$acked(ActorRef shardRegion) {
            this.remaining_$eq((scala.collection.immutable.Set<ActorRef>)((scala.collection.immutable.Set)this.remaining().$minus((Object)shardRegion)));
            if (this.remaining().isEmpty()) {
                this.log().debug("{}: All shard regions acked, handing off shard [{}].", (Object)this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard);
                this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom.$bang((Object)ShardCoordinator$Internal$HandOff$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard), this.self());
                this.context().become(this.stoppingShard(), true);
                return;
            }
            this.log().debug("{}: Remaining shard regions for shard [{}]: {}", (Object)this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard, (Object)BoxesRunTime.boxToInteger((int)this.remaining().size()));
        }

        public PartialFunction<Object, BoxedUnit> stoppingShard() {
            return new Serializable(this){
                private final /* synthetic */ RebalanceWorker $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Internal.ShardStopped) {
                        Internal.ShardStopped shardStopped = ShardCoordinator$Internal$ShardStopped$.MODULE$.unapply((Internal.ShardStopped)object);
                        String string = shardStopped._1();
                        String string2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            return true;
                        }
                    }
                    if (ReceiveTimeout$.MODULE$.equals(object)) {
                        return true;
                    }
                    if (object instanceof ShardRegionTerminated) {
                        ShardRegionTerminated shardRegionTerminated = ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.unapply((ShardRegionTerminated)object);
                        ActorRef actorRef = shardRegionTerminated._1();
                        ActorRef actorRef2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom;
                        ActorRef actorRef3 = actorRef;
                        if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Internal.ShardStopped) {
                        Internal.ShardStopped shardStopped = ShardCoordinator$Internal$ShardStopped$.MODULE$.unapply((Internal.ShardStopped)object);
                        String string = shardStopped._1();
                        String string2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard;
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            this.$outer.done(true);
                            return BoxedUnit.UNIT;
                        }
                    }
                    if (ReceiveTimeout$.MODULE$.equals(object)) {
                        this.$outer.done(false);
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof ShardRegionTerminated) {
                        ShardRegionTerminated shardRegionTerminated = ShardCoordinator$RebalanceWorker$ShardRegionTerminated$.MODULE$.unapply((ShardRegionTerminated)object);
                        ActorRef actorRef = shardRegionTerminated._1();
                        ActorRef actorRef2 = this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom;
                        ActorRef actorRef3 = actorRef;
                        if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                            this.$outer.log().debug("{}: ShardRegion [{}] terminated while waiting for ShardStopped for shard [{}].", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$typeName, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shardRegionFrom, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard);
                            this.$outer.done(true);
                            return BoxedUnit.UNIT;
                        }
                    }
                    return function1.apply(x);
                }
            };
        }

        public void done(boolean ok) {
            this.context().parent().$bang((Object)ShardCoordinator$RebalanceDone$.MODULE$.apply(this.org$apache$pekko$cluster$sharding$ShardCoordinator$RebalanceWorker$$shard, ok), this.self());
            this.context().stop(this.self());
        }
    }

    public static final class ResendShardHost
    implements Product,
    Serializable {
        private final String shard;
        private final ActorRef region;

        public static ResendShardHost apply(String string, ActorRef actorRef) {
            return ShardCoordinator$ResendShardHost$.MODULE$.apply(string, actorRef);
        }

        public static ResendShardHost fromProduct(Product product) {
            return ShardCoordinator$ResendShardHost$.MODULE$.fromProduct(product);
        }

        public static ResendShardHost unapply(ResendShardHost resendShardHost) {
            return ShardCoordinator$ResendShardHost$.MODULE$.unapply(resendShardHost);
        }

        public ResendShardHost(String shard, ActorRef region) {
            this.shard = shard;
            this.region = region;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResendShardHost)) return false;
            ResendShardHost resendShardHost = (ResendShardHost)object;
            String string = this.shard();
            String string2 = resendShardHost.shard();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ActorRef actorRef = this.region();
            ActorRef actorRef2 = resendShardHost.region();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ResendShardHost;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ResendShardHost";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shard";
            }
            if (1 == n2) {
                return "region";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shard() {
            return this.shard;
        }

        public ActorRef region() {
            return this.region;
        }

        public ResendShardHost copy(String shard, ActorRef region) {
            return new ResendShardHost(shard, region);
        }

        public String copy$default$1() {
            return this.shard();
        }

        public ActorRef copy$default$2() {
            return this.region();
        }

        public String _1() {
            return this.shard();
        }

        public ActorRef _2() {
            return this.region();
        }
    }

    public static interface ShardAllocationStrategy
    extends NoSerializationVerificationNeeded {
        public static ShardAllocationStrategy leastShardAllocationStrategy(int n, double d) {
            return ShardCoordinator$ShardAllocationStrategy$.MODULE$.leastShardAllocationStrategy(n, d);
        }

        public Future<ActorRef> allocateShard(ActorRef var1, String var2, scala.collection.immutable.Map<ActorRef, IndexedSeq<String>> var3);

        public Future<scala.collection.immutable.Set<String>> rebalance(scala.collection.immutable.Map<ActorRef, IndexedSeq<String>> var1, scala.collection.immutable.Set<String> var2);
    }

    public static interface StartableAllocationStrategy
    extends ShardAllocationStrategy {
        public void start();
    }
}

