/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URLEncoder;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.RootActorPath$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterSettings$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sharding.ClusterShardingSerializable;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$NoPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategy$;
import org.apache.pekko.cluster.sharding.Shard;
import org.apache.pekko.cluster.sharding.Shard$;
import org.apache.pekko.cluster.sharding.Shard$GetCurrentShardState$;
import org.apache.pekko.cluster.sharding.Shard$GetShardStats$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$BeginHandOff$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$BeginHandOffAck$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$GetShardHome$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$GracefulShutdownReq$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$HandOff$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$HostShard$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegionStopped$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$Register$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegisterAck$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$RegisterProxy$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHome$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardHomes$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardStarted$;
import org.apache.pekko.cluster.sharding.ShardCoordinator$Internal$ShardStopped$;
import org.apache.pekko.cluster.sharding.ShardRegion$;
import org.apache.pekko.cluster.sharding.ShardRegion$ClusterShardingStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$CurrentRegions$;
import org.apache.pekko.cluster.sharding.ShardRegion$CurrentShardRegionState$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetClusterShardingStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetCurrentRegions$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetShardRegionState$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetShardRegionStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$GetShardRegionStatus$;
import org.apache.pekko.cluster.sharding.ShardRegion$GracefulShutdown$;
import org.apache.pekko.cluster.sharding.ShardRegion$GracefulShutdownTimeout$;
import org.apache.pekko.cluster.sharding.ShardRegion$HandOffStopper$;
import org.apache.pekko.cluster.sharding.ShardRegion$HandOffStopper$StopTimeout$;
import org.apache.pekko.cluster.sharding.ShardRegion$HandOffStopper$StopTimeoutWarning$;
import org.apache.pekko.cluster.sharding.ShardRegion$HashCodeMessageExtractor$;
import org.apache.pekko.cluster.sharding.ShardRegion$Passivate$;
import org.apache.pekko.cluster.sharding.ShardRegion$RegisterRetry$;
import org.apache.pekko.cluster.sharding.ShardRegion$RestartShard$;
import org.apache.pekko.cluster.sharding.ShardRegion$Retry$;
import org.apache.pekko.cluster.sharding.ShardRegion$SetActiveEntityLimit$;
import org.apache.pekko.cluster.sharding.ShardRegion$ShardInitialized$;
import org.apache.pekko.cluster.sharding.ShardRegion$ShardRegionStats$;
import org.apache.pekko.cluster.sharding.ShardRegion$ShardState$;
import org.apache.pekko.cluster.sharding.ShardRegion$ShardsUpdated$;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntity$;
import org.apache.pekko.cluster.sharding.ShardRegion$StartEntityAck$;
import org.apache.pekko.cluster.sharding.ShardingLogMarker$;
import org.apache.pekko.cluster.sharding.ShardingQueries;
import org.apache.pekko.cluster.sharding.ShardingQueries$ShardsQueryResult$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.util.MessageBuffer;
import org.apache.pekko.util.MessageBufferMap;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

@InternalStableApi
public class ShardRegion
implements Actor,
Timers {
    private ActorContext context;
    private ActorRef self;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    public final String org$apache$pekko$cluster$sharding$ShardRegion$$typeName;
    private final Option<Function1<String, Props>> entityProps;
    private final ClusterShardingSettings settings;
    private final String coordinatorPath;
    public final PartialFunction<Object, Tuple2<String, Object>> org$apache$pekko$cluster$sharding$ShardRegion$$extractEntityId;
    private final Function1<Object, String> extractShardId;
    private final Object handOffStopMessage;
    private final Option<RememberEntitiesProvider> rememberEntitiesProvider;
    private final MarkerLoggingAdapter log;
    private final Cluster cluster;
    private final boolean verboseDebug;
    private final Ordering ageOrdering;
    private SortedSet membersByAge;
    private final Set<MemberStatus> memberStatusOfInterest;
    private scala.collection.immutable.Map regions;
    private scala.collection.immutable.Map regionByShard;
    private MessageBufferMap shardBuffers;
    private boolean loggedFullBufferWarning;
    private scala.collection.immutable.Map shards;
    private scala.collection.immutable.Map shardsByRef;
    private Set startingShards;
    private Set handingOff;
    private boolean gracefulShutdownInProgress;
    private boolean preparingForShutdown;
    private int retryCount;
    private final FiniteDuration initRegistrationDelay;
    private FiniteDuration nextRegistrationDelay;
    private final Promise gracefulShutdownProgress;
    private final String targetDcRole;
    private Option coordinator;

    public static ShardRegion$GetCurrentRegions$ getCurrentRegionsInstance() {
        return ShardRegion$.MODULE$.getCurrentRegionsInstance();
    }

    public static ShardRegion$GetShardRegionStats$ getRegionStatsInstance() {
        return ShardRegion$.MODULE$.getRegionStatsInstance();
    }

    public static ShardRegion$GetShardRegionState$ getShardRegionStateInstance() {
        return ShardRegion$.MODULE$.getShardRegionStateInstance();
    }

    public static ShardRegion$GracefulShutdown$ gracefulShutdownInstance() {
        return ShardRegion$.MODULE$.gracefulShutdownInstance();
    }

    public static Props props(String string, Function1<String, Props> function1, ClusterShardingSettings clusterShardingSettings, String string2, PartialFunction<Object, Tuple2<String, Object>> partialFunction, Function1<Object, String> function12, Object object, Option<RememberEntitiesProvider> option) {
        return ShardRegion$.MODULE$.props(string, function1, clusterShardingSettings, string2, partialFunction, function12, object, option);
    }

    public static Props proxyProps(String string, Option<String> option, ClusterShardingSettings clusterShardingSettings, String string2, PartialFunction<Object, Tuple2<String, Object>> partialFunction, Function1<Object, String> function1) {
        return ShardRegion$.MODULE$.proxyProps(string, option, clusterShardingSettings, string2, partialFunction, function1);
    }

    public ShardRegion(String typeName, Option<Function1<String, Props>> entityProps, Option<String> dataCenter, ClusterShardingSettings settings, String coordinatorPath, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, Object handOffStopMessage, Option<RememberEntitiesProvider> rememberEntitiesProvider) {
        String string;
        this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName = typeName;
        this.entityProps = entityProps;
        this.settings = settings;
        this.coordinatorPath = coordinatorPath;
        this.org$apache$pekko$cluster$sharding$ShardRegion$$extractEntityId = extractEntityId;
        this.extractShardId = extractShardId;
        this.handOffStopMessage = handOffStopMessage;
        this.rememberEntitiesProvider = rememberEntitiesProvider;
        Actor.$init$((Actor)this);
        Timers.$init$((Timers)this);
        this.log = Logging$.MODULE$.withMarker(this.context().system(), (Object)this, LogSource$.MODULE$.fromActor());
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.verboseDebug = this.context().system().settings().config().getBoolean("pekko.cluster.sharding.verbose-debug-logging");
        this.ageOrdering = Member$.MODULE$.ageOrdering();
        this.membersByAge = (SortedSet)SortedSet$.MODULE$.empty(this.ageOrdering());
        this.memberStatusOfInterest = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemberStatus[]{MemberStatus.Up$.MODULE$, MemberStatus.Leaving$.MODULE$, MemberStatus.Exiting$.MODULE$}));
        this.regions = Predef$.MODULE$.Map().empty();
        this.regionByShard = Predef$.MODULE$.Map().empty();
        this.shardBuffers = new MessageBufferMap();
        this.loggedFullBufferWarning = false;
        this.shards = Predef$.MODULE$.Map().empty();
        this.shardsByRef = Predef$.MODULE$.Map().empty();
        this.startingShards = Predef$.MODULE$.Set().empty();
        this.handingOff = Predef$.MODULE$.Set().empty();
        this.gracefulShutdownInProgress = false;
        this.preparingForShutdown = false;
        this.retryCount = 0;
        this.initRegistrationDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis().max(settings.tuningParameters().retryInterval().$div(2L).$div(2L).$div(2L));
        this.nextRegistrationDelay = this.initRegistrationDelay();
        this.gracefulShutdownProgress = Promise$.MODULE$.apply();
        ((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system())).addTask(CoordinatedShutdown$.MODULE$.PhaseClusterShardingShutdownRegion(), "region-shutdown", (Function0 & Serializable)() -> {
            block3: {
                block2: {
                    if (this.cluster().isTerminated()) break block2;
                    MemberStatus memberStatus = this.cluster().selfMember().status();
                    MemberStatus.Down$ down$ = MemberStatus.Down$.MODULE$;
                    if (memberStatus != null ? !memberStatus.equals(down$) : down$ != null) break block3;
                }
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            this.self().$bang((Object)ShardRegion$GracefulShutdown$.MODULE$, this.self());
            return this.gracefulShutdownProgress().future();
        });
        Option<String> option = dataCenter;
        if (option instanceof Some) {
            String t = (String)((Some)option).value();
            string = new StringBuilder(0).append(ClusterSettings$.MODULE$.DcRolePrefix()).append(t).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(0).append(ClusterSettings$.MODULE$.DcRolePrefix()).append(this.cluster().settings().SelfDataCenter()).toString();
        } else {
            throw new MatchError(option);
        }
        this.targetDcRole = string;
        this.coordinator = None$.MODULE$;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public MarkerLoggingAdapter log() {
        return this.log;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Ordering<Member> ageOrdering() {
        return this.ageOrdering;
    }

    public SortedSet<Member> membersByAge() {
        return this.membersByAge;
    }

    public void membersByAge_$eq(SortedSet<Member> x$1) {
        this.membersByAge = x$1;
    }

    public scala.collection.immutable.Map<ActorRef, Set<String>> regions() {
        return this.regions;
    }

    public void regions_$eq(scala.collection.immutable.Map<ActorRef, Set<String>> x$1) {
        this.regions = x$1;
    }

    public scala.collection.immutable.Map<String, ActorRef> regionByShard() {
        return this.regionByShard;
    }

    public void regionByShard_$eq(scala.collection.immutable.Map<String, ActorRef> x$1) {
        this.regionByShard = x$1;
    }

    public MessageBufferMap<String> shardBuffers() {
        return this.shardBuffers;
    }

    public void shardBuffers_$eq(MessageBufferMap<String> x$1) {
        this.shardBuffers = x$1;
    }

    public boolean loggedFullBufferWarning() {
        return this.loggedFullBufferWarning;
    }

    public void loggedFullBufferWarning_$eq(boolean x$1) {
        this.loggedFullBufferWarning = x$1;
    }

    public scala.collection.immutable.Map<String, ActorRef> shards() {
        return this.shards;
    }

    public void shards_$eq(scala.collection.immutable.Map<String, ActorRef> x$1) {
        this.shards = x$1;
    }

    public scala.collection.immutable.Map<ActorRef, String> shardsByRef() {
        return this.shardsByRef;
    }

    public void shardsByRef_$eq(scala.collection.immutable.Map<ActorRef, String> x$1) {
        this.shardsByRef = x$1;
    }

    public Set<String> startingShards() {
        return this.startingShards;
    }

    public void startingShards_$eq(Set<String> x$1) {
        this.startingShards = x$1;
    }

    public Set<ActorRef> handingOff() {
        return this.handingOff;
    }

    public void handingOff_$eq(Set<ActorRef> x$1) {
        this.handingOff = x$1;
    }

    public boolean gracefulShutdownInProgress() {
        return this.gracefulShutdownInProgress;
    }

    public void gracefulShutdownInProgress_$eq(boolean x$1) {
        this.gracefulShutdownInProgress = x$1;
    }

    public boolean preparingForShutdown() {
        return this.preparingForShutdown;
    }

    public void preparingForShutdown_$eq(boolean x$1) {
        this.preparingForShutdown = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    public FiniteDuration initRegistrationDelay() {
        return this.initRegistrationDelay;
    }

    public FiniteDuration nextRegistrationDelay() {
        return this.nextRegistrationDelay;
    }

    public void nextRegistrationDelay_$eq(FiniteDuration x$1) {
        this.nextRegistrationDelay = x$1;
    }

    public Promise<Done> gracefulShutdownProgress() {
        return this.gracefulShutdownProgress;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class}));
        this.timers().startTimerWithFixedDelay((Object)ShardRegion$Retry$.MODULE$, (Object)ShardRegion$Retry$.MODULE$, this.settings.tuningParameters().retryInterval());
        this.startRegistration();
        this.logPassivationStrategy();
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.log().debug("{}: Region stopped", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
        this.coordinator().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.$bang((Object)ShardCoordinator$Internal$RegionStopped$.MODULE$.apply(this.context().self()), this.self()));
        this.cluster().unsubscribe(this.self());
        this.gracefulShutdownProgress().trySuccess((Object)Done$.MODULE$);
    }

    private void logPassivationStrategy() {
        if (this.settings.passivationStrategySettings().oldSettingUsed()) {
            this.log().warning("The `pekko.cluster.sharding.passivate-idle-entity-after` setting and associated methods are deprecated. Use the `pekko.cluster.sharding.passivation.default-idle-strategy.idle-entity.timeout` setting instead. See the documentation and reference config for more information on automatic passivation strategies.");
        }
        if (this.settings.rememberEntities()) {
            this.log().debug("{}: Entities will not be passivated automatically because 'rememberEntities' is enabled.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
            return;
        }
        this.log().info("{}: Automatic entity passivation: {}", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)ClusterShardingSettings$PassivationStrategy$.MODULE$.describe(this.settings.passivationStrategy()));
    }

    public boolean matchingRole(Member member) {
        return member.hasRole(this.targetDcRole) && this.settings.role().forall((Function1 & Serializable)role -> member.hasRole(role));
    }

    public List<ActorSelection> coordinatorSelection() {
        return ShardRegion.select$1((List)package$.MODULE$.Nil(), this.membersByAge()).map((Function1 & Serializable)m -> this.context().actorSelection(new StringBuilder(0).append(RootActorPath$.MODULE$.apply(m.address(), RootActorPath$.MODULE$.$lessinit$greater$default$2()).toString()).append(this.coordinatorPath).toString()));
    }

    public Option<ActorRef> coordinator() {
        return this.coordinator;
    }

    public void coordinator_$eq(Option<ActorRef> x$1) {
        this.coordinator = x$1;
    }

    public void changeMembers(SortedSet<Member> newMembers) {
        Option before = this.membersByAge().headOption();
        Option after = newMembers.headOption();
        this.membersByAge_$eq(newMembers);
        Option option = before;
        Option option2 = after;
        if (option == null ? option2 != null : !option.equals(option2)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("{}: Coordinator moved from [{}] to [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, before.map((Function1 & Serializable)_$2 -> _$2.address()).getOrElse(ShardRegion::changeMembers$$anonfun$2), after.map((Function1 & Serializable)_$3 -> _$3.address()).getOrElse(ShardRegion::changeMembers$$anonfun$4));
            }
            this.coordinator_$eq((Option<ActorRef>)None$.MODULE$);
            this.startRegistration();
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ShardRegion $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof ShardInitialized) {
                    String string;
                    ShardInitialized shardInitialized = ShardRegion$ShardInitialized$.MODULE$.unapply((ShardInitialized)object);
                    String shardId = string = shardInitialized._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ClusterDomainEvent) {
                    ClusterEvent.ClusterDomainEvent evt = (ClusterEvent.ClusterDomainEvent)object;
                    return true;
                }
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    return true;
                }
                if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                    ShardCoordinator.Internal.CoordinatorMessage msg = (ShardCoordinator.Internal.CoordinatorMessage)object;
                    return true;
                }
                if (object instanceof ShardRegionCommand) {
                    ShardRegionCommand cmd = (ShardRegionCommand)object;
                    return true;
                }
                if (object instanceof ShardRegionQuery) {
                    ShardRegionQuery query = (ShardRegionQuery)object;
                    return true;
                }
                if (object instanceof RestartShard) {
                    RestartShard msg = (RestartShard)object;
                    return true;
                }
                if (object instanceof StartEntity) {
                    StartEntity msg = (StartEntity)object;
                    return true;
                }
                if (object instanceof SetActiveEntityLimit) {
                    SetActiveEntityLimit msg = (SetActiveEntityLimit)object;
                    return true;
                }
                Object msg = object;
                if (this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$$extractEntityId.isDefinedAt(msg)) {
                    return true;
                }
                Object unknownMsg = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    this.$outer.receiveTerminated(ref);
                } else if (object instanceof ShardInitialized) {
                    String string;
                    ShardInitialized shardInitialized = ShardRegion$ShardInitialized$.MODULE$.unapply((ShardInitialized)object);
                    String shardId = string = shardInitialized._1();
                    this.$outer.initializeShard(shardId, this.$outer.sender());
                } else if (object instanceof ClusterEvent.ClusterDomainEvent) {
                    ClusterEvent.ClusterDomainEvent evt = (ClusterEvent.ClusterDomainEvent)object;
                    this.$outer.receiveClusterEvent(evt);
                } else if (object instanceof ClusterEvent.CurrentClusterState) {
                    ClusterEvent.CurrentClusterState state = (ClusterEvent.CurrentClusterState)object;
                    this.$outer.receiveClusterState(state);
                } else if (object instanceof ShardCoordinator.Internal.CoordinatorMessage) {
                    ShardCoordinator.Internal.CoordinatorMessage msg = (ShardCoordinator.Internal.CoordinatorMessage)object;
                    this.$outer.receiveCoordinatorMessage(msg);
                } else if (object instanceof ShardRegionCommand) {
                    ShardRegionCommand cmd = (ShardRegionCommand)object;
                    this.$outer.receiveCommand(cmd);
                } else if (object instanceof ShardRegionQuery) {
                    ShardRegionQuery query = (ShardRegionQuery)object;
                    this.$outer.receiveQuery(query);
                } else if (object instanceof RestartShard) {
                    RestartShard msg = (RestartShard)object;
                    this.$outer.deliverMessage(msg, this.$outer.sender());
                } else if (object instanceof StartEntity) {
                    StartEntity msg = (StartEntity)object;
                    this.$outer.deliverStartEntity(msg, this.$outer.sender());
                } else if (object instanceof SetActiveEntityLimit) {
                    SetActiveEntityLimit msg = (SetActiveEntityLimit)object;
                    this.$outer.deliverToAllShards(msg, this.$outer.sender());
                } else {
                    Object msg = object;
                    if (this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$$extractEntityId.isDefinedAt(msg)) {
                        this.$outer.deliverMessage(msg, this.$outer.sender());
                    } else {
                        Object unknownMsg = object;
                        this.$outer.log().warning("{}: Message does not have an extractor defined in shard so it was ignored: {}", (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, unknownMsg);
                    }
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void receiveClusterState(ClusterEvent.CurrentClusterState state) {
        this.changeMembers((SortedSet<Member>)((SortedSet)((scala.collection.SetOps)SortedSet$.MODULE$.empty(this.ageOrdering())).union((scala.collection.Set)state.members().filter((Function1 & Serializable)m -> this.memberStatusOfInterest.apply((Object)m.status()) && this.matchingRole((Member)m)))));
    }

    public void receiveClusterEvent(ClusterEvent.ClusterDomainEvent evt) {
        ClusterEvent.ClusterDomainEvent clusterDomainEvent = evt;
        if (clusterDomainEvent instanceof ClusterEvent.MemberUp) {
            Member member;
            ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)clusterDomainEvent);
            Member m = member = memberUp._1();
            this.addMember(m);
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberLeft) {
            Member member;
            ClusterEvent.MemberLeft memberLeft = ClusterEvent.MemberLeft$.MODULE$.unapply((ClusterEvent.MemberLeft)clusterDomainEvent);
            Member m = member = memberLeft._1();
            this.addMember(m);
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberExited) {
            Member member;
            ClusterEvent.MemberExited memberExited = ClusterEvent.MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)clusterDomainEvent);
            Member m = member = memberExited._1();
            this.addMember(m);
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberRemoved) {
            ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)clusterDomainEvent);
            Member member = memberRemoved._1();
            MemberStatus memberStatus = memberRemoved._2();
            Member m = member;
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
                return;
            }
            if (this.matchingRole(m)) {
                this.changeMembers((SortedSet<Member>)((SortedSet)this.membersByAge().filterNot((Function1 & Serializable)_$4 -> {
                    UniqueAddress uniqueAddress = _$4.uniqueAddress();
                    UniqueAddress uniqueAddress2 = m.uniqueAddress();
                    return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
                })));
                return;
            }
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberDowned) {
            Member member;
            ClusterEvent.MemberDowned memberDowned = ClusterEvent.MemberDowned$.MODULE$.unapply((ClusterEvent.MemberDowned)clusterDomainEvent);
            Member m = member = memberDowned._1();
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress3 = this.cluster().selfUniqueAddress();
            if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress3) : uniqueAddress3 != null)) {
                this.log().info("{}: Self downed, stopping ShardRegion [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)this.self().path());
                this.context().stop(this.self());
                return;
            }
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberReadyForShutdown || clusterDomainEvent instanceof ClusterEvent.MemberPreparingForShutdown) {
            if (!this.preparingForShutdown()) {
                this.log().info("{}. preparing for shutdown", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
            }
            this.preparingForShutdown_$eq(true);
            return;
        }
        if (clusterDomainEvent instanceof ClusterEvent.MemberEvent) {
            return;
        }
        this.unhandled(evt);
    }

    private void addMember(Member m) {
        if (this.matchingRole(m) && this.memberStatusOfInterest.apply((Object)m.status())) {
            this.changeMembers((SortedSet<Member>)((SortedSet)((SetOps)this.membersByAge().filterNot((Function1 & Serializable)_$5 -> {
                UniqueAddress uniqueAddress = _$5.uniqueAddress();
                UniqueAddress uniqueAddress2 = m.uniqueAddress();
                return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
            })).$plus((Object)m)));
            return;
        }
    }

    public void receiveCoordinatorMessage(ShardCoordinator.Internal.CoordinatorMessage msg) {
        ShardCoordinator.Internal.CoordinatorMessage coordinatorMessage = msg;
        if (coordinatorMessage instanceof ShardCoordinator.Internal.HostShard) {
            String string;
            ShardCoordinator.Internal.HostShard hostShard = ShardCoordinator$Internal$HostShard$.MODULE$.unapply((ShardCoordinator.Internal.HostShard)coordinatorMessage);
            String shard = string = hostShard._1();
            if (this.gracefulShutdownInProgress()) {
                this.log().debug("{}: Ignoring Host Shard request for [{}] as region is shutting down", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard);
                this.sendGracefulShutdownToCoordinatorIfInProgress();
                return;
            }
            this.log().debug("{}: Host Shard [{}] ", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard);
            this.regionByShard_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.regionByShard().updated((Object)shard, (Object)this.self())));
            this.regions_$eq((scala.collection.immutable.Map<ActorRef, Set<String>>)((scala.collection.immutable.Map)this.regions().updated((Object)this.self(), (Object)((SetOps)this.regions().getOrElse((Object)this.self(), ShardRegion::receiveCoordinatorMessage$$anonfun$1)).$plus((Object)shard))));
            this.getShard(shard);
            this.sender().$bang((Object)ShardCoordinator$Internal$ShardStarted$.MODULE$.apply(shard), this.self());
            return;
        }
        if (coordinatorMessage instanceof ShardCoordinator.Internal.ShardHome) {
            ShardCoordinator.Internal.ShardHome shardHome = ShardCoordinator$Internal$ShardHome$.MODULE$.unapply((ShardCoordinator.Internal.ShardHome)coordinatorMessage);
            String string = shardHome._1();
            ActorRef actorRef = shardHome._2();
            String shard = string;
            ActorRef shardRegionRef = actorRef;
            this.receiveShardHome(shard, shardRegionRef);
            return;
        }
        if (coordinatorMessage instanceof ShardCoordinator.Internal.ShardHomes) {
            scala.collection.immutable.Map<ActorRef, Seq<String>> map;
            ShardCoordinator.Internal.ShardHomes shardHomes = ShardCoordinator$Internal$ShardHomes$.MODULE$.unapply((ShardCoordinator.Internal.ShardHomes)coordinatorMessage);
            scala.collection.immutable.Map<ActorRef, Seq<String>> homes = map = shardHomes._1();
            if (this.log().isDebugEnabled()) {
                this.log().debug("Got shard homes for regions [{}]", (Object)homes.keySet().mkString(", "));
            }
            homes.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ActorRef shardRegionRef = (ActorRef)tuple2._1();
                    Seq shards = (Seq)tuple2._2();
                    shards.foreach((Function1)(JProcedure1 & Serializable)shardId -> this.receiveShardHome((String)shardId, shardRegionRef));
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        if (coordinatorMessage instanceof ShardCoordinator.Internal.RegisterAck) {
            ActorRef actorRef;
            ShardCoordinator.Internal.RegisterAck registerAck = ShardCoordinator$Internal$RegisterAck$.MODULE$.unapply((ShardCoordinator.Internal.RegisterAck)coordinatorMessage);
            ActorRef coord = actorRef = registerAck._1();
            this.context().watch(coord);
            this.coordinator_$eq((Option<ActorRef>)Some$.MODULE$.apply((Object)coord));
            this.finishRegistration();
            this.tryRequestShardBufferHomes();
            return;
        }
        if (coordinatorMessage instanceof ShardCoordinator.Internal.BeginHandOff) {
            String string;
            ShardCoordinator.Internal.BeginHandOff beginHandOff = ShardCoordinator$Internal$BeginHandOff$.MODULE$.unapply((ShardCoordinator.Internal.BeginHandOff)coordinatorMessage);
            String shard = string = beginHandOff._1();
            this.log().debug("{}: BeginHandOff shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard);
            if (!this.preparingForShutdown()) {
                if (this.regionByShard().contains((Object)shard)) {
                    ActorRef regionRef = (ActorRef)this.regionByShard().apply((Object)shard);
                    Set updatedShards = (Set)((SetOps)this.regions().apply((Object)regionRef)).$minus((Object)shard);
                    if (updatedShards.isEmpty()) {
                        this.regions_$eq((scala.collection.immutable.Map<ActorRef, Set<String>>)((scala.collection.immutable.Map)this.regions().$minus((Object)regionRef)));
                    } else {
                        this.regions_$eq((scala.collection.immutable.Map<ActorRef, Set<String>>)((scala.collection.immutable.Map)this.regions().updated((Object)regionRef, (Object)updatedShards)));
                    }
                    this.regionByShard_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.regionByShard().$minus((Object)shard)));
                }
                this.sender().$bang((Object)ShardCoordinator$Internal$BeginHandOffAck$.MODULE$.apply(shard), this.self());
                return;
            }
            this.log().debug("{}: Ignoring begin handoff of shard [{}] as preparing to shutdown", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard);
            return;
        }
        if (coordinatorMessage instanceof ShardCoordinator.Internal.HandOff) {
            String string;
            ShardCoordinator.Internal.HandOff handOff = (ShardCoordinator.Internal.HandOff)coordinatorMessage;
            ShardCoordinator.Internal.HandOff handOff2 = ShardCoordinator$Internal$HandOff$.MODULE$.unapply(handOff);
            String shard = string = handOff2._1();
            ShardCoordinator.Internal.HandOff msg2 = handOff;
            this.log().debug("{}: HandOff shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard);
            if (this.shardBuffers().contains((Object)shard)) {
                int dropped = this.shardBuffers().drop((Object)shard, "Avoiding reordering of buffered messages at shard handoff", this.context().system().deadLetters());
                if (dropped > 0) {
                    this.log().warning("{}: Dropping [{}] buffered messages to shard [{}] during hand off to avoid re-ordering", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)BoxesRunTime.boxToInteger((int)dropped), (Object)shard);
                }
                this.loggedFullBufferWarning_$eq(false);
            }
            if (this.shards().contains((Object)shard)) {
                this.handingOff_$eq((Set<ActorRef>)((Set)this.handingOff().$plus(this.shards().apply((Object)shard))));
                ((ActorRef)this.shards().apply((Object)shard)).forward((Object)msg2, this.context());
                return;
            }
            this.sender().$bang((Object)ShardCoordinator$Internal$ShardStopped$.MODULE$.apply(shard), this.self());
            return;
        }
        this.unhandled(msg);
    }

    public void receiveCommand(ShardRegionCommand cmd) {
        ShardRegionCommand shardRegionCommand = cmd;
        if (ShardRegion$Retry$.MODULE$.equals(shardRegionCommand)) {
            if (this.shardBuffers().nonEmpty()) {
                this.retryCount_$eq(this.retryCount() + 1);
            }
            if (this.coordinator().isEmpty()) {
                this.register();
            } else {
                this.tryRequestShardBufferHomes();
            }
            this.sendGracefulShutdownToCoordinatorIfInProgress();
            this.tryCompleteGracefulShutdownIfInProgress();
            return;
        }
        if (ShardRegion$RegisterRetry$.MODULE$.equals(shardRegionCommand)) {
            if (this.coordinator().isEmpty()) {
                this.register();
                this.scheduleNextRegistration();
                return;
            }
            return;
        }
        if (ShardRegion$GracefulShutdown$.MODULE$.equals(shardRegionCommand)) {
            FiniteDuration timeout;
            if (this.preparingForShutdown()) {
                this.log().debug("{}: Skipping graceful shutdown of region and all its shards as cluster is preparing for shutdown", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
                this.gracefulShutdownProgress().trySuccess((Object)Done$.MODULE$);
                this.context().stop(this.self());
                return;
            }
            this.log().debug("{}: Starting graceful shutdown of region and all its shards", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
            CoordinatedShutdown coordShutdown = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context().system());
            if (coordShutdown.getShutdownReason().isPresent() && (timeout = coordShutdown.timeout(CoordinatedShutdown$.MODULE$.PhaseClusterShardingShutdownRegion()).$minus(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second())).$greater((Object)Duration$.MODULE$.Zero())) {
                this.timers().startSingleTimer((Object)ShardRegion$GracefulShutdownTimeout$.MODULE$, (Object)ShardRegion$GracefulShutdownTimeout$.MODULE$, timeout);
            }
            this.gracefulShutdownInProgress_$eq(true);
            this.sendGracefulShutdownToCoordinatorIfInProgress();
            this.tryCompleteGracefulShutdownIfInProgress();
            return;
        }
        if (ShardRegion$GracefulShutdownTimeout$.MODULE$.equals(shardRegionCommand)) {
            this.log().warning("{}: Graceful shutdown of shard region timed out, region will be stopped. Remaining shards [{}], remaining buffered messages [{}].", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)this.shards().keysIterator().mkString(","), (Object)BoxesRunTime.boxToInteger((int)this.shardBuffers().totalSize()));
            this.context().stop(this.self());
            return;
        }
        this.unhandled(cmd);
    }

    public void receiveQuery(ShardRegionQuery query) {
        ShardRegionQuery shardRegionQuery = query;
        if (ShardRegion$GetCurrentRegions$.MODULE$.equals(shardRegionQuery)) {
            Option<ActorRef> option = this.coordinator();
            if (option instanceof Some) {
                ActorRef c = (ActorRef)((Some)option).value();
                c.forward((Object)ShardRegion$GetCurrentRegions$.MODULE$, this.context());
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.sender().$bang((Object)ShardRegion$CurrentRegions$.MODULE$.apply((Set<Address>)Predef$.MODULE$.Set().empty()), this.self());
                return;
            }
            throw new MatchError(option);
        }
        if (shardRegionQuery instanceof GetClusterShardingStats) {
            GetClusterShardingStats msg = (GetClusterShardingStats)shardRegionQuery;
            this.coordinator().fold((Function0 & Serializable)() -> {
                this.receiveQuery$$anonfun$1();
                return BoxedUnit.UNIT;
            }, (Function1)(JProcedure1 & Serializable)_$6 -> _$6.forward((Object)msg, this.context()));
            return;
        }
        if (ShardRegion$GetShardRegionState$.MODULE$.equals(shardRegionQuery)) {
            this.replyToRegionStateQuery(this.sender());
            return;
        }
        if (ShardRegion$GetShardRegionStats$.MODULE$.equals(shardRegionQuery)) {
            this.replyToRegionStatsQuery(this.sender());
            return;
        }
        if (ShardRegion$GetShardRegionStatus$.MODULE$.equals(shardRegionQuery)) {
            this.sender().$bang((Object)new ShardRegionStatus(this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, this.coordinator().isDefined()), this.self());
            return;
        }
        if (shardRegionQuery == null) {
            this.unhandled(query);
            return;
        }
        throw new MatchError((Object)shardRegionQuery);
    }

    public void receiveTerminated(ActorRef ref) {
        if (this.coordinator().contains((Object)ref)) {
            this.coordinator_$eq((Option<ActorRef>)None$.MODULE$);
            this.startRegistration();
            return;
        }
        if (this.regions().contains((Object)ref)) {
            Set shards = (Set)this.regions().apply((Object)ref);
            this.regionByShard_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.regionByShard().$minus$minus((IterableOnce)shards)));
            this.regions_$eq((scala.collection.immutable.Map<ActorRef, Set<String>>)((scala.collection.immutable.Map)this.regions().$minus((Object)ref)));
            if (this.log().isDebugEnabled()) {
                if (this.verboseDebug) {
                    this.log().debug("{}: Region [{}] terminated with [{}] shards [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)ref, (Object)BoxesRunTime.boxToInteger((int)shards.size()), (Object)shards.mkString(", "));
                    return;
                }
                this.log().debug("{}: Region [{}] terminated with [{}] shards", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)ref, (Object)BoxesRunTime.boxToInteger((int)shards.size()));
                return;
            }
            return;
        }
        if (this.shardsByRef().contains((Object)ref)) {
            String shardId = (String)this.shardsByRef().apply((Object)ref);
            this.shardsByRef_$eq((scala.collection.immutable.Map<ActorRef, String>)((scala.collection.immutable.Map)this.shardsByRef().$minus((Object)ref)));
            this.shards_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.shards().$minus((Object)shardId)));
            this.startingShards_$eq((Set<String>)((Set)this.startingShards().$minus((Object)shardId)));
            ClusterShardingSettings.PassivationStrategy passivationStrategy = this.settings.passivationStrategy();
            ClusterShardingSettings$NoPassivationStrategy$ clusterShardingSettings$NoPassivationStrategy$ = ClusterShardingSettings$NoPassivationStrategy$.MODULE$;
            if (passivationStrategy == null ? clusterShardingSettings$NoPassivationStrategy$ != null : !passivationStrategy.equals(clusterShardingSettings$NoPassivationStrategy$)) {
                this.shards().values().foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.$bang((Object)ShardRegion$ShardsUpdated$.MODULE$.apply(this.shards().size()), this.self()));
            }
            if (this.handingOff().contains((Object)ref)) {
                this.handingOff_$eq((Set<ActorRef>)((Set)this.handingOff().$minus((Object)ref)));
                this.log().debug("{}: Shard [{}] handoff complete", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId);
            } else {
                this.log().debug("{}: Shard [{}]  terminated while not being handed off", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId);
                if (this.settings.rememberEntities()) {
                    this.context().system().scheduler().scheduleOnce(this.settings.tuningParameters().shardFailureBackoff(), this.self(), (Object)ShardRegion$RestartShard$.MODULE$.apply(shardId), (ExecutionContext)this.context().dispatcher(), this.self());
                }
            }
            this.tryCompleteGracefulShutdownIfInProgress();
            return;
        }
    }

    public void receiveShardHome(String shard, ActorRef shardRegionRef) {
        this.log().debug("{}: Shard [{}] located at [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard, (Object)shardRegionRef);
        Option option = this.regionByShard().get((Object)shard);
        if (option instanceof Some) {
            ActorRef r;
            ActorRef actorRef = r = (ActorRef)((Some)option).value();
            ActorRef actorRef2 = this.self();
            if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                ActorRef actorRef3 = shardRegionRef;
                ActorRef actorRef4 = this.self();
                if (actorRef3 == null ? actorRef4 != null : !actorRef3.equals(actorRef4)) {
                    throw new IllegalStateException(new StringBuilder(47).append(this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName).append(": Unexpected change of shard [").append(shard).append("] from self to [").append(shardRegionRef).append("]").toString());
                }
            }
        }
        this.regionByShard_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.regionByShard().updated((Object)shard, (Object)shardRegionRef)));
        this.regions_$eq((scala.collection.immutable.Map<ActorRef, Set<String>>)((scala.collection.immutable.Map)this.regions().updated((Object)shardRegionRef, (Object)((SetOps)this.regions().getOrElse((Object)shardRegionRef, ShardRegion::receiveShardHome$$anonfun$1)).$plus((Object)shard))));
        ActorRef actorRef = shardRegionRef;
        ActorRef actorRef5 = this.self();
        if (actorRef == null ? actorRef5 != null : !actorRef.equals(actorRef5)) {
            this.context().watch(shardRegionRef);
        }
        ActorRef actorRef6 = shardRegionRef;
        ActorRef actorRef7 = this.self();
        if (!(actorRef6 != null ? !actorRef6.equals(actorRef7) : actorRef7 != null)) {
            this.getShard(shard).foreach((Function1)(JProcedure1 & Serializable)_$8 -> this.deliverBufferedMessages(shard, (ActorRef)_$8));
            return;
        }
        this.deliverBufferedMessages(shard, shardRegionRef);
    }

    public void replyToRegionStateQuery(ActorRef ref) {
        org.apache.pekko.pattern.package$.MODULE$.pipe(this.queryShards(this.shards(), Shard$GetCurrentShardState$.MODULE$, ClassTag$.MODULE$.apply(Shard.CurrentShardState.class)).map((Function1 & Serializable)qr -> ShardRegion$CurrentShardRegionState$.MODULE$.apply((Set<ShardState>)((IterableOnceOps)qr.responses().map((Function1 & Serializable)state -> ShardRegion$ShardState$.MODULE$.apply(state.shardId(), state.entityIds()))).toSet(), qr.failed()), (ExecutionContext)this.context().dispatcher()), (ExecutionContext)this.context().dispatcher()).pipeTo(ref, this.self());
    }

    public void replyToRegionStatsQuery(ActorRef ref) {
        org.apache.pekko.pattern.package$.MODULE$.pipe(this.queryShards(this.shards(), Shard$GetShardStats$.MODULE$, ClassTag$.MODULE$.apply(Shard.ShardStats.class)).map((Function1 & Serializable)qr -> ShardRegion$ShardRegionStats$.MODULE$.apply((scala.collection.immutable.Map<String, Object>)((IterableOnceOps)qr.responses().map((Function1 & Serializable)stats -> Tuple2$.MODULE$.apply((Object)stats.shardId(), (Object)BoxesRunTime.boxToInteger((int)stats.entityCount())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), qr.failed()), (ExecutionContext)this.context().dispatcher()), (ExecutionContext)this.context().dispatcher()).pipeTo(ref, this.self());
    }

    public <T> Future<ShardingQueries.ShardsQueryResult<T>> queryShards(scala.collection.immutable.Map<String, ActorRef> shards, Object msg, ClassTag<T> evidence$1) {
        Timeout timeout = Timeout$.MODULE$.durationToTimeout(this.settings.shardRegionQueryTimeout());
        return Future$.MODULE$.traverse((IterableOnce)shards.toSeq(), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String shardId = (String)tuple2._1();
                ActorRef shard = (ActorRef)tuple2._2();
                return this.askOne(shard, msg, shardId, evidence$1, timeout);
            }
            throw new MatchError((Object)tuple2);
        }, BuildFrom$.MODULE$.buildFromIterableOps(), (ExecutionContext)this.context().dispatcher()).map((Function1 & Serializable)ps -> {
            ShardingQueries.ShardsQueryResult qr = ShardingQueries$ShardsQueryResult$.MODULE$.apply(ps, this.shards().size(), timeout.duration());
            if (qr.failed().nonEmpty()) {
                this.log().warning(new StringBuilder(4).append("{}: ").append(qr).toString(), (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
            }
            return qr;
        }, (ExecutionContext)this.context().dispatcher());
    }

    private <T> Future<Either<String, T>> askOne(ActorRef shard, Object msg, String shardId, ClassTag<T> evidence$2, Timeout timeout) {
        return AskableActorRef$.MODULE$.$qmark$extension(org.apache.pekko.pattern.package$.MODULE$.ask(shard), msg, timeout, this.self()).mapTo(evidence$2).transform((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object t = ((Success)try_).value();
                return Success$.MODULE$.apply((Object)package$.MODULE$.Right().apply(t));
            }
            if (try_ instanceof Failure) {
                return Success$.MODULE$.apply((Object)package$.MODULE$.Left().apply((Object)shardId));
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.context().dispatcher());
    }

    private void tryCompleteGracefulShutdownIfInProgress() {
        if (this.gracefulShutdownInProgress() && this.shards().isEmpty() && this.shardBuffers().isEmpty()) {
            this.log().debug("{}: Completed graceful shutdown of region.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
            this.context().stop(this.self());
            return;
        }
    }

    public void startRegistration() {
        this.nextRegistrationDelay_$eq(this.initRegistrationDelay());
        this.register();
        this.scheduleNextRegistration();
    }

    public void scheduleNextRegistration() {
        if (this.nextRegistrationDelay().$less((Object)this.settings.tuningParameters().retryInterval())) {
            this.timers().startSingleTimer((Object)ShardRegion$RegisterRetry$.MODULE$, (Object)ShardRegion$RegisterRetry$.MODULE$, this.nextRegistrationDelay());
            this.nextRegistrationDelay_$eq(this.nextRegistrationDelay().$times(2L));
            return;
        }
    }

    public void finishRegistration() {
        this.timers().cancel((Object)ShardRegion$RegisterRetry$.MODULE$);
    }

    public void register() {
        List<ActorSelection> actorSelections = this.coordinatorSelection();
        actorSelections.foreach((Function1)(JProcedure1 & Serializable)_$9 -> ActorSelection$.MODULE$.toScala(_$9).$bang(this.registrationMessage(), this.self()));
        if (this.shardBuffers().nonEmpty() && this.retryCount() >= 5) {
            if (actorSelections.nonEmpty()) {
                String coordinatorMessage = this.cluster().state().unreachable().apply(this.membersByAge().head()) ? new StringBuilder(30).append("Coordinator [").append(this.membersByAge().head()).append("] is unreachable.").toString() : new StringBuilder(28).append("Coordinator [").append(this.membersByAge().head()).append("] is reachable.").toString();
                int bufferSize = this.shardBuffers().totalSize();
                if (bufferSize > 0) {
                    if (this.log().isWarningEnabled()) {
                        this.log().warning("{}: Trying to register to coordinator at [{}], but no acknowledgement. Total [{}] buffered messages. [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)actorSelections.mkString(", "), (Object)BoxesRunTime.boxToInteger((int)bufferSize), (Object)coordinatorMessage);
                        return;
                    }
                    return;
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug("{}: Trying to register to coordinator at [{}], but no acknowledgement. No buffered messages yet. [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)actorSelections.mkString(", "), (Object)coordinatorMessage);
                    return;
                }
                return;
            }
            MemberStatus memberStatus = this.cluster().selfMember().status();
            MemberStatus.Removed$ removed$ = MemberStatus.Removed$.MODULE$;
            boolean partOfCluster = memberStatus == null ? removed$ != null : !memberStatus.equals(removed$);
            String possibleReason = partOfCluster ? "Has Cluster Sharding been started on every node and nodes been configured with the correct role(s)?" : "Probably, no seed-nodes configured and manual cluster or bootstrap join not performed?";
            int bufferSize = this.shardBuffers().totalSize();
            if (bufferSize > 0) {
                this.log().warning("{}: No coordinator found to register. {} Total [{}] buffered messages.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)possibleReason, (Object)BoxesRunTime.boxToInteger((int)bufferSize));
                return;
            }
            this.log().debug("{}: No coordinator found to register. {} No buffered messages yet.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)possibleReason);
            return;
        }
    }

    public Object registrationMessage() {
        if (this.entityProps.isDefined()) {
            return ShardCoordinator$Internal$Register$.MODULE$.apply(this.self());
        }
        return ShardCoordinator$Internal$RegisterProxy$.MODULE$.apply(this.self());
    }

    public void tryRequestShardBufferHomes() {
        this.coordinator().foreach((Function1)(JProcedure1 & Serializable)coord -> {
            IntRef totalBuffered = IntRef.create((int)0);
            ObjectRef shards = ObjectRef.create((Object)package$.MODULE$.List().empty());
            this.shardBuffers().foreach((Function2)(JProcedure2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    int n;
                    String shard = (String)tuple2._1();
                    MessageBuffer buf = (MessageBuffer)tuple2._2();
                    totalBuffered$1.elem = n = totalBuffered$1.elem + buf.size();
                    List list = ((List)shards$1.elem).$colon$colon((Object)shard);
                    shards$1.elem = list;
                    list = null;
                    this.log().debug("{}: Requesting shard home for [{}] from coordinator at [{}]. [{}] buffered messages.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shard, coord, (Object)BoxesRunTime.boxToInteger((int)buf.size()));
                    coord.$bang((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply(shard), this.self());
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            if (this.retryCount() >= 5 && this.retryCount() % 5 == 0 && this.log().isWarningEnabled()) {
                this.log().warning("{}: Requested shard homes [{}] from coordinator at [{}]. [{}] total buffered messages.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)((IterableOnceOps)((List)shards.elem).sorted((Ordering)Ordering.String$.MODULE$)).mkString(","), coord, (Object)BoxesRunTime.boxToInteger((int)totalBuffered.elem));
                return;
            }
        });
    }

    public void initializeShard(String id, ActorRef shard) {
        this.log().debug("{}: Shard was initialized [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)id);
        this.startingShards_$eq((Set<String>)((Set)this.startingShards().$minus((Object)id)));
        this.deliverBufferedMessages(id, shard);
    }

    public void bufferMessage(String shardId, Object msg, ActorRef snd) {
        int totBufSize = this.shardBuffers().totalSize();
        if (totBufSize >= this.settings.tuningParameters().bufferSize()) {
            if (this.loggedFullBufferWarning()) {
                this.log().debug("{}: Buffer is full, dropping message for shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId);
            } else {
                this.log().warning("{}: Buffer is full, dropping message for shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId);
                this.loggedFullBufferWarning_$eq(true);
            }
            this.context().system().deadLetters().$bang(msg, this.self());
            return;
        }
        this.shardBuffers().append((Object)shardId, msg, snd);
        int tot = totBufSize + 1;
        if (tot % (this.settings.tuningParameters().bufferSize() / 10) == 0) {
            String logMsg = new StringBuilder(51).append(this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName).append(": ShardRegion is using [").append(100.0 * (double)tot / (double)this.settings.tuningParameters().bufferSize()).append(" %] of its buffer capacity.").toString();
            if (tot <= this.settings.tuningParameters().bufferSize() / 2) {
                this.log().info(logMsg);
                return;
            }
            this.log().warning(new StringBuilder(91).append(logMsg).append(" The coordinator might not be available. You might want to check cluster membership status.").toString());
            return;
        }
    }

    public void deliverBufferedMessages(String shardId, ActorRef receiver) {
        if (this.shardBuffers().contains((Object)shardId)) {
            MessageBuffer buf = this.shardBuffers().getOrEmpty((Object)shardId);
            this.log().debug("{}: Deliver [{}] buffered messages for shard [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)BoxesRunTime.boxToInteger((int)buf.size()), (Object)shardId);
            buf.foreach((Function2)(JProcedure2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Object msg = tuple2._1();
                    ActorRef snd = (ActorRef)tuple2._2();
                    Object object = msg;
                    if (object instanceof RestartShard) {
                        RestartShard restartShard = ShardRegion$RestartShard$.MODULE$.unapply((RestartShard)object);
                        String string = restartShard._1();
                        RestartShard msg2 = (RestartShard)object;
                        ActorRef actorRef = receiver;
                        ActorRef actorRef2 = this.self();
                        if (actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2)) {
                            this.log().debug("{}: Dropping buffered message {}, these are only processed by a local ShardRegion.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)msg2);
                            return;
                        }
                    }
                    receiver.tell(msg, snd);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.shardBuffers().remove((Object)shardId);
        }
        this.loggedFullBufferWarning_$eq(false);
        this.retryCount_$eq(0);
    }

    public void deliverStartEntity(StartEntity msg, ActorRef snd) {
        try {
            this.deliverMessage(msg, snd);
        }
        catch (MatchError ex) {
            this.log().error((Throwable)ex, "{}: When using remember-entities the shard id extractor must handle ShardRegion.StartEntity(id).", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName);
        }
    }

    public void deliverToAllShards(Object msg, ActorRef snd) {
        this.shards().values().foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.tell(msg, snd));
    }

    public void deliverMessage(Object msg, ActorRef snd) {
        Option option;
        block15: {
            String shardId;
            block17: {
                block16: {
                    Object object = msg;
                    if (object instanceof RestartShard) {
                        String string;
                        RestartShard restartShard = ShardRegion$RestartShard$.MODULE$.unapply((RestartShard)object);
                        String shardId2 = string = restartShard._1();
                        Option option2 = this.regionByShard().get((Object)shardId2);
                        if (option2 instanceof Some) {
                            ActorRef ref;
                            ActorRef actorRef = ref = (ActorRef)((Some)option2).value();
                            ActorRef actorRef2 = this.self();
                            if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                                this.getShard(shardId2);
                                return;
                            }
                            return;
                        }
                        if (None$.MODULE$.equals(option2)) {
                            if (!this.shardBuffers().contains((Object)shardId2)) {
                                this.log().debug("{}: Request shard [{}] home. Coordinator [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId2, this.coordinator());
                                this.coordinator().foreach((Function1)(JProcedure1 & Serializable)_$11 -> _$11.$bang((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply(shardId2), this.self()));
                            }
                            MessageBuffer buf = this.shardBuffers().getOrEmpty((Object)shardId2);
                            this.log().debug("{}: Buffer message for shard [{}]. Total [{}] buffered messages.", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId2, (Object)BoxesRunTime.boxToInteger((int)(buf.size() + 1)));
                            this.shardBuffers().append((Object)shardId2, msg, snd);
                            return;
                        }
                        throw new MatchError((Object)option2);
                    }
                    shardId = (String)this.extractShardId.apply(msg);
                    option = this.regionByShard().get((Object)shardId);
                    if (option instanceof Some) {
                        ActorRef actorRef;
                        ActorRef shardRegionRef;
                        ActorRef actorRef3 = shardRegionRef = (actorRef = (ActorRef)((Some)option).value());
                        ActorRef actorRef4 = this.self();
                        if (!(actorRef3 != null ? !actorRef3.equals(actorRef4) : actorRef4 != null)) {
                            Option<ActorRef> option3 = this.getShard(shardId);
                            if (option3 instanceof Some) {
                                ActorRef shard = (ActorRef)((Some)option3).value();
                                if (this.shardBuffers().contains((Object)shardId)) {
                                    this.bufferMessage(shardId, msg, snd);
                                    this.deliverBufferedMessages(shardId, shard);
                                    return;
                                }
                                shard.tell(msg, snd);
                                return;
                            }
                            if (None$.MODULE$.equals(option3)) {
                                this.bufferMessage(shardId, msg, snd);
                                return;
                            }
                            throw new MatchError(option3);
                        }
                        ActorRef shardRegionRef2 = actorRef;
                        if (this.verboseDebug) {
                            this.log().debug("{}: Forwarding message for shard [{}] to [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId, (Object)shardRegionRef2);
                        }
                        shardRegionRef2.tell(msg, snd);
                        return;
                    }
                    if (!None$.MODULE$.equals(option)) break block15;
                    if (shardId == null) break block16;
                    String string = shardId;
                    String string2 = "";
                    if (string != null ? !string.equals(string2) : string2 != null) break block17;
                }
                this.log().warning("{}: Shard must not be empty, dropping message [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)msg.getClass().getName());
                this.context().system().deadLetters().$bang(msg, this.self());
                return;
            }
            if (!this.shardBuffers().contains((Object)shardId)) {
                this.log().debug("{}: Request shard [{}] home. Coordinator [{}]", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)shardId, this.coordinator());
                this.coordinator().foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.$bang((Object)ShardCoordinator$Internal$GetShardHome$.MODULE$.apply(shardId), this.self()));
            }
            this.bufferMessage(shardId, msg, snd);
            return;
        }
        throw new MatchError((Object)option);
    }

    public Option<ActorRef> getShard(String id) {
        if (this.startingShards().contains((Object)id)) {
            return None$.MODULE$;
        }
        return this.shards().get((Object)id).orElse(() -> this.getShard$$anonfun$1(id));
    }

    public void sendGracefulShutdownToCoordinatorIfInProgress() {
        if (this.gracefulShutdownInProgress()) {
            List<ActorSelection> actorSelections = this.coordinatorSelection();
            this.log().debug("{}: Sending graceful shutdown to {}", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, actorSelections);
            actorSelections.foreach((Function1)(JProcedure1 & Serializable)_$15 -> ActorSelection$.MODULE$.toScala(_$15).$bang((Object)ShardCoordinator$Internal$GracefulShutdownReq$.MODULE$.apply(this.self()), this.self()));
            return;
        }
    }

    private static final List select$1(List result, SortedSet remaining) {
        while (!remaining.isEmpty()) {
            Member m = (Member)remaining.head();
            MemberStatus memberStatus = m.status();
            MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
            if (!(memberStatus != null ? !memberStatus.equals(up$) : up$ != null)) {
                return result.$colon$colon((Object)m);
            }
            List list = result.$colon$colon((Object)m);
            SortedSet sortedSet = (SortedSet)remaining.tail();
            result = list;
            remaining = sortedSet;
        }
        return result;
    }

    private static final Serializable changeMembers$$anonfun$2() {
        return "";
    }

    private static final Serializable changeMembers$$anonfun$4() {
        return "";
    }

    private static final Set receiveCoordinatorMessage$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final void receiveQuery$$anonfun$1() {
        this.sender().$bang((Object)ShardRegion$ClusterShardingStats$.MODULE$.apply((scala.collection.immutable.Map<Address, ShardRegionStats>)Predef$.MODULE$.Map().empty()), this.self());
    }

    private static final Set receiveShardHome$$anonfun$1() {
        return Predef$.MODULE$.Set().empty();
    }

    private final Option getShard$$anonfun$1(String id$1) {
        Option<Function1<String, Props>> option = this.entityProps;
        if (option instanceof Some) {
            Function1 props = (Function1)((Some)option).value();
            if (!this.shardsByRef().values().exists((Function1 & Serializable)_$13 -> {
                String string = _$13;
                String string2 = id$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) {
                this.log().debug(ShardingLogMarker$.MODULE$.shardStarted(this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, id$1), "{}: Starting shard [{}] in region", (Object)this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, (Object)id$1);
                String name = URLEncoder.encode(id$1, "utf-8");
                ActorRef shard = this.context().watch(this.context().actorOf(Shard$.MODULE$.props(this.org$apache$pekko$cluster$sharding$ShardRegion$$typeName, id$1, (Function1<String, Props>)props, this.settings, this.org$apache$pekko$cluster$sharding$ShardRegion$$extractEntityId, this.extractShardId, this.handOffStopMessage, this.rememberEntitiesProvider).withDispatcher(this.context().props().dispatcher()), name));
                this.shardsByRef_$eq((scala.collection.immutable.Map<ActorRef, String>)((scala.collection.immutable.Map)this.shardsByRef().updated((Object)shard, (Object)id$1)));
                this.shards_$eq((scala.collection.immutable.Map<String, ActorRef>)((scala.collection.immutable.Map)this.shards().updated((Object)id$1, (Object)shard)));
                this.startingShards_$eq((Set<String>)((Set)this.startingShards().$plus((Object)id$1)));
                ClusterShardingSettings.PassivationStrategy passivationStrategy = this.settings.passivationStrategy();
                ClusterShardingSettings$NoPassivationStrategy$ clusterShardingSettings$NoPassivationStrategy$ = ClusterShardingSettings$NoPassivationStrategy$.MODULE$;
                if (passivationStrategy == null ? clusterShardingSettings$NoPassivationStrategy$ != null : !passivationStrategy.equals(clusterShardingSettings$NoPassivationStrategy$)) {
                    this.shards().values().foreach((Function1)(JProcedure1 & Serializable)_$14 -> _$14.$bang((Object)ShardRegion$ShardsUpdated$.MODULE$.apply(this.shards().size()), this.self()));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Shard must not be allocated to a proxy only ShardRegion");
        }
        throw new MatchError(option);
    }

    public static final class ClusterShardingStats
    implements ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final scala.collection.immutable.Map regions;

        public static ClusterShardingStats apply(scala.collection.immutable.Map<Address, ShardRegionStats> map) {
            return ShardRegion$ClusterShardingStats$.MODULE$.apply(map);
        }

        public static ClusterShardingStats fromProduct(Product product) {
            return ShardRegion$ClusterShardingStats$.MODULE$.fromProduct(product);
        }

        public static ClusterShardingStats unapply(ClusterShardingStats clusterShardingStats) {
            return ShardRegion$ClusterShardingStats$.MODULE$.unapply(clusterShardingStats);
        }

        public ClusterShardingStats(scala.collection.immutable.Map<Address, ShardRegionStats> regions) {
            this.regions = regions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClusterShardingStats)) return false;
            ClusterShardingStats clusterShardingStats = (ClusterShardingStats)object;
            scala.collection.immutable.Map<Address, ShardRegionStats> map = this.regions();
            scala.collection.immutable.Map<Address, ShardRegionStats> map2 = clusterShardingStats.regions();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClusterShardingStats;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ClusterShardingStats";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "regions";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Map<Address, ShardRegionStats> regions() {
            return this.regions;
        }

        public Map<Address, ShardRegionStats> getRegions() {
            return package.JavaConverters$.MODULE$.MapHasAsJava(this.regions()).asJava();
        }

        public ClusterShardingStats copy(scala.collection.immutable.Map<Address, ShardRegionStats> regions) {
            return new ClusterShardingStats(regions);
        }

        public scala.collection.immutable.Map<Address, ShardRegionStats> copy$default$1() {
            return this.regions();
        }

        public scala.collection.immutable.Map<Address, ShardRegionStats> _1() {
            return this.regions();
        }
    }

    public static final class CurrentRegions
    implements ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final Set regions;

        public static CurrentRegions apply(Set<Address> set) {
            return ShardRegion$CurrentRegions$.MODULE$.apply(set);
        }

        public static CurrentRegions fromProduct(Product product) {
            return ShardRegion$CurrentRegions$.MODULE$.fromProduct(product);
        }

        public static CurrentRegions unapply(CurrentRegions currentRegions) {
            return ShardRegion$CurrentRegions$.MODULE$.unapply(currentRegions);
        }

        public CurrentRegions(Set<Address> regions) {
            this.regions = regions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentRegions)) return false;
            CurrentRegions currentRegions = (CurrentRegions)object;
            Set<Address> set = this.regions();
            Set<Address> set2 = currentRegions.regions();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CurrentRegions;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CurrentRegions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "regions";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Address> regions() {
            return this.regions;
        }

        public java.util.Set<Address> getRegions() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.regions()).asJava();
        }

        public CurrentRegions copy(Set<Address> regions) {
            return new CurrentRegions(regions);
        }

        public Set<Address> copy$default$1() {
            return this.regions();
        }

        public Set<Address> _1() {
            return this.regions();
        }
    }

    public static final class CurrentShardRegionState
    implements ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final Set shards;
        private final Set failed;

        public static <A> Function1<Set<ShardState>, A> andThen(Function1<CurrentShardRegionState, A> function1) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.andThen(function1);
        }

        public static CurrentShardRegionState apply(Set<ShardState> set) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply(set);
        }

        public static CurrentShardRegionState apply(Set<ShardState> set, Set<String> set2) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply(set, set2);
        }

        public static double apply$mcDD$sp(double d) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcDD$sp(d);
        }

        public static double apply$mcDF$sp(float f) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcDF$sp(f);
        }

        public static double apply$mcDI$sp(int n) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcDI$sp(n);
        }

        public static double apply$mcDJ$sp(long l) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcDJ$sp(l);
        }

        public static float apply$mcFD$sp(double d) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcFD$sp(d);
        }

        public static float apply$mcFF$sp(float f) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcFF$sp(f);
        }

        public static float apply$mcFI$sp(int n) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcFI$sp(n);
        }

        public static float apply$mcFJ$sp(long l) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcFJ$sp(l);
        }

        public static int apply$mcID$sp(double d) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcID$sp(d);
        }

        public static int apply$mcIF$sp(float f) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcIF$sp(f);
        }

        public static int apply$mcII$sp(int n) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcII$sp(n);
        }

        public static int apply$mcIJ$sp(long l) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcIJ$sp(l);
        }

        public static long apply$mcJD$sp(double d) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcJD$sp(d);
        }

        public static long apply$mcJF$sp(float f) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcJF$sp(f);
        }

        public static long apply$mcJI$sp(int n) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcJI$sp(n);
        }

        public static long apply$mcJJ$sp(long l) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcJJ$sp(l);
        }

        public static void apply$mcVD$sp(double d) {
            ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcVD$sp(d);
        }

        public static void apply$mcVF$sp(float f) {
            ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcVF$sp(f);
        }

        public static void apply$mcVI$sp(int n) {
            ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcVI$sp(n);
        }

        public static void apply$mcVJ$sp(long l) {
            ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcVJ$sp(l);
        }

        public static boolean apply$mcZD$sp(double d) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcZD$sp(d);
        }

        public static boolean apply$mcZF$sp(float f) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcZF$sp(f);
        }

        public static boolean apply$mcZI$sp(int n) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcZI$sp(n);
        }

        public static boolean apply$mcZJ$sp(long l) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.apply$mcZJ$sp(l);
        }

        public static <A> Function1<A, CurrentShardRegionState> compose(Function1<A, Set<ShardState>> function1) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.compose(function1);
        }

        public static Option<Set<ShardState>> unapply(CurrentShardRegionState currentShardRegionState) {
            return ShardRegion$CurrentShardRegionState$.MODULE$.unapply(currentShardRegionState);
        }

        public CurrentShardRegionState(Set<ShardState> shards, Set<String> failed) {
            this.shards = shards;
            this.failed = failed;
        }

        public Set<ShardState> shards() {
            return this.shards;
        }

        public Set<String> failed() {
            return this.failed;
        }

        public java.util.Set<ShardState> getShards() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.shards()).asJava();
        }

        public java.util.Set<String> getFailed() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.failed()).asJava();
        }

        public CurrentShardRegionState(Set<ShardState> shards) {
            this(shards, (Set<String>)Predef$.MODULE$.Set().empty());
        }

        public CurrentShardRegionState copy(Set<ShardState> shards) {
            return new CurrentShardRegionState(shards, this.failed());
        }

        public Set<ShardState> copy$default$1() {
            return this.shards();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof CurrentShardRegionState)) return false;
            CurrentShardRegionState o = (CurrentShardRegionState)object;
            Set<ShardState> set = o.shards();
            Set<ShardState> set2 = this.shards();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Set<String> set3 = o.failed();
            Set<String> set4 = this.failed();
            if (set3 == null) {
                if (set4 == null) return true;
                return false;
            } else {
                if (!set3.equals(set4)) return false;
                return true;
            }
        }

        public int hashCode() {
            return Statics.anyHash(this.shards()) + Statics.anyHash(this.failed());
        }

        public String toString() {
            return new StringBuilder(41).append("CurrentShardRegionState[shards=").append(this.shards()).append(", failed=").append(this.failed()).append("]").toString();
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            if (n == 0) {
                return this.shards();
            }
            if (n == 1) {
                return this.failed();
            }
            throw new NoSuchElementException();
        }

        public boolean canEqual(Object o) {
            return o instanceof CurrentShardRegionState;
        }
    }

    public static class GetClusterShardingStats
    implements ShardRegionQuery,
    ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final FiniteDuration timeout;

        public static GetClusterShardingStats apply(FiniteDuration finiteDuration) {
            return ShardRegion$GetClusterShardingStats$.MODULE$.apply(finiteDuration);
        }

        public static GetClusterShardingStats fromProduct(Product product) {
            return ShardRegion$GetClusterShardingStats$.MODULE$.fromProduct(product);
        }

        public static GetClusterShardingStats unapply(GetClusterShardingStats getClusterShardingStats) {
            return ShardRegion$GetClusterShardingStats$.MODULE$.unapply(getClusterShardingStats);
        }

        public GetClusterShardingStats(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetClusterShardingStats)) return false;
            GetClusterShardingStats getClusterShardingStats = (GetClusterShardingStats)object;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = getClusterShardingStats.timeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            if (!getClusterShardingStats.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetClusterShardingStats;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GetClusterShardingStats";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public GetClusterShardingStats copy(FiniteDuration timeout) {
            return new GetClusterShardingStats(timeout);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }
    }

    @InternalApi
    public static class HandOffStopper
    implements Actor,
    ActorLogging,
    Timers {
        private ActorContext context;
        private ActorRef self;
        private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
        private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
        public final String org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$typeName;
        public final String org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$shard;
        public final ActorRef org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$replyTo;
        public final Object org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$stopMessage;
        public final FiniteDuration org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$handoffTimeout;
        private Set remaining;

        public static Props props(String string, String string2, ActorRef actorRef, Set<ActorRef> set, Object object, FiniteDuration finiteDuration) {
            return ShardRegion$HandOffStopper$.MODULE$.props(string, string2, actorRef, set, object, finiteDuration);
        }

        public HandOffStopper(String typeName, String shard, ActorRef replyTo, Set<ActorRef> entities, Object stopMessage, FiniteDuration handoffTimeout) {
            this.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$typeName = typeName;
            this.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$shard = shard;
            this.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$replyTo = replyTo;
            this.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$stopMessage = stopMessage;
            this.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$handoffTimeout = handoffTimeout;
            Actor.$init$((Actor)this);
            ActorLogging.$init$((ActorLogging)this);
            Timers.$init$((Timers)this);
            this.timers().startSingleTimer((Object)ShardRegion$HandOffStopper$StopTimeoutWarning$.MODULE$, (Object)ShardRegion$HandOffStopper$StopTimeoutWarning$.MODULE$, ShardRegion$HandOffStopper$.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$$StopTimeoutWarningAfter);
            this.timers().startSingleTimer((Object)ShardRegion$HandOffStopper$StopTimeout$.MODULE$, (Object)ShardRegion$HandOffStopper$StopTimeout$.MODULE$, handoffTimeout);
            entities.foreach((Function1)(JProcedure1 & Serializable)a -> {
                this.context().watch(a);
                a.$bang(stopMessage, this.self());
            });
            this.remaining = entities;
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
            return this.org$apache$pekko$actor$ActorLogging$$_log;
        }

        public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
            this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
        }

        public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
            return this.org$apache$pekko$actor$Timers$$_timers;
        }

        public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
            this.org$apache$pekko$actor$Timers$$_timers = x$0;
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
            Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
            Actor.aroundPostStop$((Actor)this);
        }

        public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
            Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
        }

        public Set<ActorRef> remaining() {
            return this.remaining;
        }

        public void remaining_$eq(Set<ActorRef> x$1) {
            this.remaining = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ HandOffStopper $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Terminated) {
                        ActorRef actorRef;
                        Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                        ActorRef ref = actorRef = terminated._1();
                        return true;
                    }
                    if (ShardRegion$HandOffStopper$StopTimeoutWarning$.MODULE$.equals(object)) {
                        return true;
                    }
                    return ShardRegion$HandOffStopper$StopTimeout$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Terminated) {
                        ActorRef actorRef;
                        Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                        ActorRef ref2 = actorRef = terminated._1();
                        this.$outer.remaining_$eq((Set<ActorRef>)((Set)this.$outer.remaining().$minus((Object)ref2)));
                        if (this.$outer.remaining().isEmpty()) {
                            this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$replyTo.$bang((Object)ShardCoordinator$Internal$ShardStopped$.MODULE$.apply(this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$shard), this.$outer.self());
                            this.$outer.context().stop(this.$outer.self());
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    if (ShardRegion$HandOffStopper$StopTimeoutWarning$.MODULE$.equals(object)) {
                        this.$outer.log().warning(new StringBuilder(111).append(this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$typeName).append(": [").append(this.$outer.remaining().size()).append("] of the entities in shard [{}] not stopped after [{}]. ").append("Maybe the handOffStopMessage [{}] is not handled? {}").toString(), (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$shard, (Object)ShardRegion$HandOffStopper$.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$$StopTimeoutWarningAfter.toCoarsest(), (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$stopMessage.getClass().getName(), (Object)(((CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.$outer.context().system())).getShutdownReason().isPresent() ? "" : new StringBuilder(61).append("Waiting additional [").append(this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$handoffTimeout.toCoarsest()).append("] before stopping the remaining entities.").toString()));
                        return BoxedUnit.UNIT;
                    }
                    if (ShardRegion$HandOffStopper$StopTimeout$.MODULE$.equals(object)) {
                        this.$outer.log().warning(new StringBuilder(128).append(this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$typeName).append(": HandOffStopMessage [{}] is not handled by some of the entities in shard [{}] after [{}], ").append("stopping the remaining [{}] entities.").toString(), (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$stopMessage.getClass().getName(), (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$shard, (Object)this.$outer.org$apache$pekko$cluster$sharding$ShardRegion$HandOffStopper$$handoffTimeout.toCoarsest(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.remaining().size()));
                        this.$outer.remaining().foreach((Function1)(JProcedure1 & Serializable)ref -> this.$outer.context().stop(ref));
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(org.apache.pekko.actor.ActorRef )}, serializedLambda);
                }
            };
        }
    }

    public static abstract class HashCodeMessageExtractor
    implements MessageExtractor {
        private final int maxNumberOfShards;

        public HashCodeMessageExtractor(int maxNumberOfShards) {
            this.maxNumberOfShards = maxNumberOfShards;
        }

        @Override
        public Object entityMessage(Object message) {
            return message;
        }

        @Override
        public String shardId(Object message) {
            String string;
            Object object = message;
            if (object instanceof StartEntity) {
                String string2;
                String entityId;
                StartEntity startEntity = ShardRegion$StartEntity$.MODULE$.unapply((StartEntity)object);
                string = entityId = (string2 = startEntity._1());
            } else {
                string = this.entityId(message);
            }
            String id = string;
            return ShardRegion$HashCodeMessageExtractor$.MODULE$.shardId(id, this.maxNumberOfShards);
        }
    }

    public static interface MessageExtractor {
        public String entityId(Object var1);

        public Object entityMessage(Object var1);

        public String shardId(Object var1);
    }

    public static final class Passivate
    implements ShardRegionCommand,
    Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Object stopMessage;

        public static Passivate apply(Object object) {
            return ShardRegion$Passivate$.MODULE$.apply(object);
        }

        public static Passivate fromProduct(Product product) {
            return ShardRegion$Passivate$.MODULE$.fromProduct(product);
        }

        public static Passivate unapply(Passivate passivate) {
            return ShardRegion$Passivate$.MODULE$.unapply(passivate);
        }

        public Passivate(Object stopMessage) {
            this.stopMessage = stopMessage;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Passivate)) return false;
            Passivate passivate = (Passivate)object;
            if (!BoxesRunTime.equals((Object)this.stopMessage(), (Object)passivate.stopMessage())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Passivate;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Passivate";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "stopMessage";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object stopMessage() {
            return this.stopMessage;
        }

        public Passivate copy(Object stopMessage) {
            return new Passivate(stopMessage);
        }

        public Object copy$default$1() {
            return this.stopMessage();
        }

        public Object _1() {
            return this.stopMessage();
        }
    }

    public static final class RestartShard
    implements Product,
    Serializable {
        private final String shardId;

        public static RestartShard apply(String string) {
            return ShardRegion$RestartShard$.MODULE$.apply(string);
        }

        public static RestartShard fromProduct(Product product) {
            return ShardRegion$RestartShard$.MODULE$.fromProduct(product);
        }

        public static RestartShard unapply(RestartShard restartShard) {
            return ShardRegion$RestartShard$.MODULE$.unapply(restartShard);
        }

        public RestartShard(String shardId) {
            this.shardId = shardId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RestartShard)) return false;
            RestartShard restartShard = (RestartShard)object;
            String string = this.shardId();
            String string2 = restartShard.shardId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RestartShard;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RestartShard";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public RestartShard copy(String shardId) {
            return new RestartShard(shardId);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public String _1() {
            return this.shardId();
        }
    }

    @ApiMayChange
    public static final class SetActiveEntityLimit
    implements Product,
    Serializable {
        private final int perRegionLimit;

        public static SetActiveEntityLimit apply(int n) {
            return ShardRegion$SetActiveEntityLimit$.MODULE$.apply(n);
        }

        public static SetActiveEntityLimit fromProduct(Product product) {
            return ShardRegion$SetActiveEntityLimit$.MODULE$.fromProduct(product);
        }

        public static SetActiveEntityLimit unapply(SetActiveEntityLimit setActiveEntityLimit) {
            return ShardRegion$SetActiveEntityLimit$.MODULE$.unapply(setActiveEntityLimit);
        }

        public SetActiveEntityLimit(int perRegionLimit) {
            this.perRegionLimit = perRegionLimit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.perRegionLimit());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SetActiveEntityLimit)) return false;
            SetActiveEntityLimit setActiveEntityLimit = (SetActiveEntityLimit)object;
            if (this.perRegionLimit() != setActiveEntityLimit.perRegionLimit()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SetActiveEntityLimit;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SetActiveEntityLimit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "perRegionLimit";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int perRegionLimit() {
            return this.perRegionLimit;
        }

        public SetActiveEntityLimit copy(int perRegionLimit) {
            return new SetActiveEntityLimit(perRegionLimit);
        }

        public int copy$default$1() {
            return this.perRegionLimit();
        }

        public int _1() {
            return this.perRegionLimit();
        }
    }

    public static final class ShardInitialized
    implements Product,
    Serializable {
        private final String shardId;

        public static ShardInitialized apply(String string) {
            return ShardRegion$ShardInitialized$.MODULE$.apply(string);
        }

        public static ShardInitialized fromProduct(Product product) {
            return ShardRegion$ShardInitialized$.MODULE$.fromProduct(product);
        }

        public static ShardInitialized unapply(ShardInitialized shardInitialized) {
            return ShardRegion$ShardInitialized$.MODULE$.unapply(shardInitialized);
        }

        public ShardInitialized(String shardId) {
            this.shardId = shardId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardInitialized)) return false;
            ShardInitialized shardInitialized = (ShardInitialized)object;
            String string = this.shardId();
            String string2 = shardInitialized.shardId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardInitialized;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ShardInitialized";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public ShardInitialized copy(String shardId) {
            return new ShardInitialized(shardId);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public String _1() {
            return this.shardId();
        }
    }

    public static interface ShardRegionCommand {
    }

    public static interface ShardRegionQuery {
    }

    public static final class ShardRegionStats
    implements ClusterShardingSerializable,
    Product {
        private static final long serialVersionUID = 1L;
        private final scala.collection.immutable.Map stats;
        private final Set failed;

        public static <A> Function1<scala.collection.immutable.Map<String, Object>, A> andThen(Function1<ShardRegionStats, A> function1) {
            return ShardRegion$ShardRegionStats$.MODULE$.andThen(function1);
        }

        public static ShardRegionStats apply(scala.collection.immutable.Map<String, Object> map) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply(map);
        }

        public static ShardRegionStats apply(scala.collection.immutable.Map<String, Object> map, Set<String> set) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply(map, set);
        }

        public static double apply$mcDD$sp(double d) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcDD$sp(d);
        }

        public static double apply$mcDF$sp(float f) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcDF$sp(f);
        }

        public static double apply$mcDI$sp(int n) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcDI$sp(n);
        }

        public static double apply$mcDJ$sp(long l) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcDJ$sp(l);
        }

        public static float apply$mcFD$sp(double d) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcFD$sp(d);
        }

        public static float apply$mcFF$sp(float f) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcFF$sp(f);
        }

        public static float apply$mcFI$sp(int n) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcFI$sp(n);
        }

        public static float apply$mcFJ$sp(long l) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcFJ$sp(l);
        }

        public static int apply$mcID$sp(double d) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcID$sp(d);
        }

        public static int apply$mcIF$sp(float f) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcIF$sp(f);
        }

        public static int apply$mcII$sp(int n) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcII$sp(n);
        }

        public static int apply$mcIJ$sp(long l) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcIJ$sp(l);
        }

        public static long apply$mcJD$sp(double d) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcJD$sp(d);
        }

        public static long apply$mcJF$sp(float f) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcJF$sp(f);
        }

        public static long apply$mcJI$sp(int n) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcJI$sp(n);
        }

        public static long apply$mcJJ$sp(long l) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcJJ$sp(l);
        }

        public static void apply$mcVD$sp(double d) {
            ShardRegion$ShardRegionStats$.MODULE$.apply$mcVD$sp(d);
        }

        public static void apply$mcVF$sp(float f) {
            ShardRegion$ShardRegionStats$.MODULE$.apply$mcVF$sp(f);
        }

        public static void apply$mcVI$sp(int n) {
            ShardRegion$ShardRegionStats$.MODULE$.apply$mcVI$sp(n);
        }

        public static void apply$mcVJ$sp(long l) {
            ShardRegion$ShardRegionStats$.MODULE$.apply$mcVJ$sp(l);
        }

        public static boolean apply$mcZD$sp(double d) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcZD$sp(d);
        }

        public static boolean apply$mcZF$sp(float f) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcZF$sp(f);
        }

        public static boolean apply$mcZI$sp(int n) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcZI$sp(n);
        }

        public static boolean apply$mcZJ$sp(long l) {
            return ShardRegion$ShardRegionStats$.MODULE$.apply$mcZJ$sp(l);
        }

        public static <A> Function1<A, ShardRegionStats> compose(Function1<A, scala.collection.immutable.Map<String, Object>> function1) {
            return ShardRegion$ShardRegionStats$.MODULE$.compose(function1);
        }

        public static Option<scala.collection.immutable.Map<String, Object>> unapply(ShardRegionStats shardRegionStats) {
            return ShardRegion$ShardRegionStats$.MODULE$.unapply(shardRegionStats);
        }

        public ShardRegionStats(scala.collection.immutable.Map<String, Object> stats, Set<String> failed) {
            this.stats = stats;
            this.failed = failed;
        }

        public scala.collection.immutable.Map<String, Object> stats() {
            return this.stats;
        }

        public Set<String> failed() {
            return this.failed;
        }

        public Map<String, Object> getStats() {
            return package.JavaConverters$.MODULE$.MapHasAsJava(this.stats()).asJava();
        }

        public java.util.Set<String> getFailed() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.failed()).asJava();
        }

        public ShardRegionStats(scala.collection.immutable.Map<String, Object> stats) {
            this(stats, (Set<String>)Predef$.MODULE$.Set().empty());
        }

        public ShardRegionStats copy(scala.collection.immutable.Map<String, Object> stats) {
            return new ShardRegionStats(stats, this.failed());
        }

        public scala.collection.immutable.Map<String, Object> copy$default$1() {
            return this.stats();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof ShardRegionStats)) return false;
            ShardRegionStats o = (ShardRegionStats)object;
            scala.collection.immutable.Map<String, Object> map = o.stats();
            scala.collection.immutable.Map<String, Object> map2 = this.stats();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Set<String> set = o.failed();
            Set<String> set2 = this.failed();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public int hashCode() {
            return Statics.anyHash(this.stats()) + Statics.anyHash(this.failed());
        }

        public String toString() {
            return new StringBuilder(33).append("ShardRegionStats[stats=").append(this.stats()).append(", failed=").append(this.failed()).append("]").toString();
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            if (n == 0) {
                return this.stats();
            }
            if (n == 1) {
                return this.failed();
            }
            throw new NoSuchElementException();
        }

        public boolean canEqual(Object o) {
            return o instanceof ShardRegionStats;
        }
    }

    @InternalApi
    public static final class ShardRegionStatus {
        private final String typeName;
        private final boolean registeredWithCoordinator;

        public ShardRegionStatus(String typeName, boolean registeredWithCoordinator) {
            this.typeName = typeName;
            this.registeredWithCoordinator = registeredWithCoordinator;
        }

        public String typeName() {
            return this.typeName;
        }

        public boolean registeredWithCoordinator() {
            return this.registeredWithCoordinator;
        }
    }

    public static final class ShardState
    implements Product,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String shardId;
        private final Set entityIds;

        public static ShardState apply(String string, Set<String> set) {
            return ShardRegion$ShardState$.MODULE$.apply(string, set);
        }

        public static ShardState fromProduct(Product product) {
            return ShardRegion$ShardState$.MODULE$.fromProduct(product);
        }

        public static ShardState unapply(ShardState shardState) {
            return ShardRegion$ShardState$.MODULE$.unapply(shardState);
        }

        public ShardState(String shardId, Set<String> entityIds) {
            this.shardId = shardId;
            this.entityIds = entityIds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardState)) return false;
            ShardState shardState = (ShardState)object;
            String string = this.shardId();
            String string2 = shardState.shardId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Set<String> set = this.entityIds();
            Set<String> set2 = shardState.entityIds();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ShardState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shardId";
            }
            if (1 == n2) {
                return "entityIds";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shardId() {
            return this.shardId;
        }

        public Set<String> entityIds() {
            return this.entityIds;
        }

        public java.util.Set<String> getEntityIds() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.entityIds()).asJava();
        }

        public ShardState copy(String shardId, Set<String> entityIds) {
            return new ShardState(shardId, entityIds);
        }

        public String copy$default$1() {
            return this.shardId();
        }

        public Set<String> copy$default$2() {
            return this.entityIds();
        }

        public String _1() {
            return this.shardId();
        }

        public Set<String> _2() {
            return this.entityIds();
        }
    }

    @InternalApi
    public static final class ShardsUpdated
    implements DeadLetterSuppression,
    Product,
    Serializable {
        private final int activeShards;

        public static ShardsUpdated apply(int n) {
            return ShardRegion$ShardsUpdated$.MODULE$.apply(n);
        }

        public static ShardsUpdated fromProduct(Product product) {
            return ShardRegion$ShardsUpdated$.MODULE$.fromProduct(product);
        }

        public static ShardsUpdated unapply(ShardsUpdated shardsUpdated) {
            return ShardRegion$ShardsUpdated$.MODULE$.unapply(shardsUpdated);
        }

        public ShardsUpdated(int activeShards) {
            this.activeShards = activeShards;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.activeShards());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardsUpdated)) return false;
            ShardsUpdated shardsUpdated = (ShardsUpdated)object;
            if (this.activeShards() != shardsUpdated.activeShards()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardsUpdated;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ShardsUpdated";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "activeShards";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int activeShards() {
            return this.activeShards;
        }

        public ShardsUpdated copy(int activeShards) {
            return new ShardsUpdated(activeShards);
        }

        public int copy$default$1() {
            return this.activeShards();
        }

        public int _1() {
            return this.activeShards();
        }
    }

    public static final class StartEntity
    implements ClusterShardingSerializable,
    Product {
        private final String entityId;

        public static StartEntity apply(String string) {
            return ShardRegion$StartEntity$.MODULE$.apply(string);
        }

        public static StartEntity fromProduct(Product product) {
            return ShardRegion$StartEntity$.MODULE$.fromProduct(product);
        }

        public static StartEntity unapply(StartEntity startEntity) {
            return ShardRegion$StartEntity$.MODULE$.unapply(startEntity);
        }

        public StartEntity(String entityId) {
            this.entityId = entityId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StartEntity)) return false;
            StartEntity startEntity = (StartEntity)object;
            String string = this.entityId();
            String string2 = startEntity.entityId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StartEntity;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StartEntity";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "entityId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String entityId() {
            return this.entityId;
        }

        public StartEntity copy(String entityId) {
            return new StartEntity(entityId);
        }

        public String copy$default$1() {
            return this.entityId();
        }

        public String _1() {
            return this.entityId();
        }
    }

    public static final class StartEntityAck
    implements ClusterShardingSerializable,
    DeadLetterSuppression,
    Product {
        private final String entityId;
        private final String shardId;

        public static StartEntityAck apply(String string, String string2) {
            return ShardRegion$StartEntityAck$.MODULE$.apply(string, string2);
        }

        public static StartEntityAck fromProduct(Product product) {
            return ShardRegion$StartEntityAck$.MODULE$.fromProduct(product);
        }

        public static StartEntityAck unapply(StartEntityAck startEntityAck) {
            return ShardRegion$StartEntityAck$.MODULE$.unapply(startEntityAck);
        }

        public StartEntityAck(String entityId, String shardId) {
            this.entityId = entityId;
            this.shardId = shardId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StartEntityAck)) return false;
            StartEntityAck startEntityAck = (StartEntityAck)object;
            String string = this.entityId();
            String string2 = startEntityAck.entityId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.shardId();
            String string4 = startEntityAck.shardId();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StartEntityAck;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StartEntityAck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "entityId";
            }
            if (1 == n2) {
                return "shardId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String entityId() {
            return this.entityId;
        }

        public String shardId() {
            return this.shardId;
        }

        public StartEntityAck copy(String entityId, String shardId) {
            return new StartEntityAck(entityId, shardId);
        }

        public String copy$default$1() {
            return this.entityId();
        }

        public String copy$default$2() {
            return this.shardId();
        }

        public String _1() {
            return this.entityId();
        }

        public String _2() {
            return this.shardId();
        }
    }
}

