/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ShardingQueries$ShardsQueryResult$;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;

@InternalApi
public final class ShardingQueries {

    public static final class ShardsQueryResult<B>
    implements Product,
    Serializable {
        private final Set failed;
        private final Seq responses;
        private final int total;
        private final FiniteDuration timeout;
        private final int queried;
        private final String toString;

        public static <B> ShardsQueryResult<B> apply(Seq<Either<String, B>> seq, int n, FiniteDuration finiteDuration) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.apply(seq, n, finiteDuration);
        }

        public static <B> ShardsQueryResult<B> apply(Set<String> set, Seq<B> seq, int n, FiniteDuration finiteDuration) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.apply(set, seq, n, finiteDuration);
        }

        public static ShardsQueryResult<?> fromProduct(Product product) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.fromProduct(product);
        }

        public static <T, A, B> Tuple2<Seq<A>, Seq<B>> partition(Seq<T> seq, Function1<T, Either<A, B>> function1) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.partition(seq, function1);
        }

        public static <A, B> Tuple2<Seq<A>, Seq<B>> prepend(Tuple2<Seq<A>, Seq<B>> tuple2, Either<A, B> either) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.prepend(tuple2, either);
        }

        public static <B> ShardsQueryResult<B> unapply(ShardsQueryResult<B> shardsQueryResult) {
            return ShardingQueries$ShardsQueryResult$.MODULE$.unapply(shardsQueryResult);
        }

        public ShardsQueryResult(Set<String> failed, Seq<B> responses, int total, FiniteDuration timeout) {
            String string;
            this.failed = failed;
            this.responses = responses;
            this.total = total;
            this.timeout = timeout;
            this.queried = failed.size() + responses.size();
            if (total == 0) {
                string = "Shard region had zero shards to gather metadata from.";
            } else {
                String shardsOf = this.queried() < total ? new StringBuilder(13).append("shards of [").append(total).append("]:").toString() : "shards:";
                string = new StringBuilder(44).append("Queried [").append(this.queried()).append("] ").append(shardsOf).append(" [").append(responses.size()).append("] responsive, [").append(failed.size()).append("] failed after ").append(timeout).append(".").toString();
            }
            this.toString = string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.failed()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.responses()));
            n = Statics.mix((int)n, (int)this.total());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardsQueryResult)) return false;
            ShardsQueryResult shardsQueryResult = (ShardsQueryResult)object;
            if (this.total() != shardsQueryResult.total()) return false;
            Set<String> set = this.failed();
            Set<String> set2 = shardsQueryResult.failed();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Seq<B> seq = this.responses();
            Seq<B> seq2 = shardsQueryResult.responses();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = shardsQueryResult.timeout();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardsQueryResult;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ShardsQueryResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "failed";
                }
                case 1: {
                    return "responses";
                }
                case 2: {
                    return "total";
                }
                case 3: {
                    return "timeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> failed() {
            return this.failed;
        }

        public Seq<B> responses() {
            return this.responses;
        }

        public int total() {
            return this.total;
        }

        public FiniteDuration timeout() {
            return this.timeout;
        }

        public int queried() {
            return this.queried;
        }

        public String toString() {
            return this.toString;
        }

        public <B> ShardsQueryResult<B> copy(Set<String> failed, Seq<B> responses, int total, FiniteDuration timeout) {
            return new ShardsQueryResult<B>(failed, responses, total, timeout);
        }

        public <B> Set<String> copy$default$1() {
            return this.failed();
        }

        public <B> Seq<B> copy$default$2() {
            return this.responses();
        }

        public int copy$default$3() {
            return this.total();
        }

        public <B> FiniteDuration copy$default$4() {
            return this.timeout();
        }

        public Set<String> _1() {
            return this.failed();
        }

        public Seq<B> _2() {
            return this.responses();
        }

        public int _3() {
            return this.total();
        }

        public FiniteDuration _4() {
            return this.timeout();
        }
    }
}

