/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.external;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.DistributedData;
import org.apache.pekko.cluster.ddata.DistributedData$;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.LWWMap;
import org.apache.pekko.cluster.ddata.LWWMapKey;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$DDataStateActor$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$GetShardLocation$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$GetShardLocationResponse$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$GetShardLocations$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$GetShardLocationsResponse$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$ShardLocation$;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ExternalShardAllocationStrategy
implements ShardCoordinator.StartableAllocationStrategy {
    private final String typeName;
    private final Timeout timeout;
    private final ActorSystem system;
    public final LoggingAdapter org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log;
    private ActorRef shardState;
    private final Cluster cluster;

    public static LWWMapKey<String, String> ddataKey(String string) {
        return ExternalShardAllocationStrategy$.MODULE$.ddataKey(string);
    }

    public static Timeout $lessinit$greater$default$3(ClassicActorSystemProvider classicActorSystemProvider, String string) {
        return ExternalShardAllocationStrategy$.MODULE$.$lessinit$greater$default$3(classicActorSystemProvider, string);
    }

    public ExternalShardAllocationStrategy(ClassicActorSystemProvider systemProvider, String typeName, Timeout timeout) {
        this.typeName = typeName;
        this.timeout = timeout;
        this.system = systemProvider.classicSystem();
        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log = Logging$.MODULE$.apply(this.system, ExternalShardAllocationStrategy.class, LogSource$.MODULE$.fromAnyClass());
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.system);
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public ActorRef createShardStateActor() {
        return ((ExtendedActorSystem)this.system).systemActorOf(ExternalShardAllocationStrategy$DDataStateActor$.MODULE$.props(this.typeName), new StringBuilder(26).append("external-allocation-state-").append(this.typeName).toString());
    }

    @Override
    public void start() {
        this.shardState = this.createShardStateActor();
    }

    @Override
    public Future<ActorRef> allocateShard(ActorRef requester, String shardId, Map<ActorRef, IndexedSeq<String>> currentShardAllocations) {
        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("allocateShard [{}] [{}] [{}]", (Object)shardId, (Object)requester, currentShardAllocations);
        ActorRef actorRef = package$.MODULE$.ask(this.shardState);
        GetShardLocation getShardLocation = ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.apply(shardId);
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)getShardLocation, this.timeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)getShardLocation)).mapTo(ClassTag$.MODULE$.apply(GetShardLocationResponse.class)).map((Function1 & Serializable)x$1 -> {
            GetShardLocationResponse getShardLocationResponse = x$1;
            if (getShardLocationResponse != null) {
                GetShardLocationResponse getShardLocationResponse2 = ExternalShardAllocationStrategy$GetShardLocationResponse$.MODULE$.unapply(getShardLocationResponse);
                Option<Address> option = getShardLocationResponse2._1();
                if (None$.MODULE$.equals(option)) {
                    this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("No specific location for shard [{}]. Allocating to requester [{}]", (Object)shardId, (Object)requester);
                    return requester;
                }
                if (option instanceof Some) {
                    Address address;
                    Address address2 = address = (Address)((Some)option).value();
                    Address address3 = this.cluster.selfAddress();
                    if (!(address2 != null ? !address2.equals(address3) : address3 != null)) {
                        Option option2 = currentShardAllocations.keys().find((Function1 & Serializable)_$3 -> _$3.path().address().hasLocalScope());
                        if (None$.MODULE$.equals(option2)) {
                            this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("unable to find local shard in currentShardAllocation. Using requester");
                            return requester;
                        }
                        if (option2 instanceof Some) {
                            ActorRef localShardRegion = (ActorRef)((Some)option2).value();
                            this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("allocating to local shard");
                            return localShardRegion;
                        }
                        throw new MatchError((Object)option2);
                    }
                    Option option3 = currentShardAllocations.keys().find((Function1 & Serializable)_$4 -> {
                        Address address = _$4.path().address();
                        Address address2 = address;
                        return !(address != null ? !address.equals(address2) : address2 != null);
                    });
                    if (None$.MODULE$.equals(option3)) {
                        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("External shard location [{}] for shard [{}] not found in members [{}]", (Object)address, (Object)shardId, (Object)currentShardAllocations.keys().mkString(","));
                        return requester;
                    }
                    if (option3 instanceof Some) {
                        ActorRef location = (ActorRef)((Some)option3).value();
                        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("Allocating shard to location [{}]", (Object)location);
                        return location;
                    }
                    throw new MatchError((Object)option3);
                }
            }
            throw new MatchError((Object)getShardLocationResponse);
        }, (ExecutionContext)this.system.dispatcher()).recover((PartialFunction)new Serializable(requester, shardId, this){
            private final ActorRef requester$2;
            private final String shardId$2;
            private final /* synthetic */ ExternalShardAllocationStrategy $outer;
            {
                this.requester$2 = requester$3;
                this.shardId$2 = shardId$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof AskTimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof AskTimeoutException) {
                    this.$outer.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.warning("allocate timed out waiting for shard allocation state [{}]. Allocating to requester [{}]", (Object)this.shardId$2, (Object)this.requester$2);
                    return this.requester$2;
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    @Override
    public Future<Set<String>> rebalance(Map<ActorRef, IndexedSeq<String>> currentShardAllocations, Set<String> rebalanceInProgress) {
        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("rebalance [{}] [{}]", currentShardAllocations, rebalanceInProgress);
        Map currentAllocationByAddress = (Map)currentShardAllocations.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef actorRef = (ActorRef)tuple2._1();
                IndexedSeq indexedSeq = (IndexedSeq)tuple2._2();
                if (actorRef instanceof ActorRefScope) {
                    ActorRef ref = (ActorRef)((ActorRefScope)actorRef);
                    IndexedSeq value = indexedSeq;
                    if (((ActorRefScope)ref).isLocal()) {
                        return Tuple2$.MODULE$.apply((Object)this.cluster.selfAddress(), (Object)value);
                    }
                }
                ActorRef key = actorRef;
                IndexedSeq value = indexedSeq;
                return Tuple2$.MODULE$.apply((Object)key.path().address(), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
        Set currentlyAllocatedShards = (Set)currentShardAllocations.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Set acc = (Set)tuple2._1();
                Tuple2 next = (Tuple2)tuple2._2();
                return (Set)acc.$plus$plus((IterableOnce)((IterableOnceOps)next._2()).toSet());
            }
            throw new MatchError((Object)tuple2);
        });
        this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("Current allocations by address: [{}]", (Object)currentAllocationByAddress);
        ActorRef actorRef = package$.MODULE$.ask(this.shardState);
        Future shardsThatNeedRebalanced = AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)ExternalShardAllocationStrategy$GetShardLocations$.MODULE$, this.timeout(), AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)ExternalShardAllocationStrategy$GetShardLocations$.MODULE$)).mapTo(ClassTag$.MODULE$.apply(GetShardLocationsResponse.class)).map((Function1 & Serializable)desiredMappings -> {
            this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("desired allocations: [{}]", desiredMappings.desiredAllocations());
            return ((MapOps)desiredMappings.desiredAllocations().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String string;
                    String shardId = string = (String)tuple2._1();
                    Address expectedLocation = (Address)tuple2._2();
                    if (currentlyAllocatedShards.contains((Object)shardId)) {
                        Option option = currentAllocationByAddress.get((Object)expectedLocation);
                        if (None$.MODULE$.equals(option)) {
                            this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("Shard [{}] desired location [{}] is not part of the cluster, not rebalancing", (Object)shardId, (Object)expectedLocation);
                            return false;
                        }
                        if (option instanceof Some) {
                            IndexedSeq shards = (IndexedSeq)((Some)option).value();
                            boolean inCorrectLocation = shards.contains((Object)shardId);
                            return !inCorrectLocation;
                        }
                        throw new MatchError((Object)option);
                    }
                    String shardId2 = string;
                    this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("Shard [{}] not currently allocated so not rebalancing to desired location", (Object)shardId2);
                    return false;
                }
                throw new MatchError((Object)tuple2);
            })).keys().toSet();
        }, (ExecutionContext)this.system.dispatcher());
        return shardsThatNeedRebalanced.map((Function1 & Serializable)done -> {
            if (done.nonEmpty()) {
                this.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.debug("Shards not currently in their desired location [{}]", done);
            }
            return done;
        }, (ExecutionContext)this.system.dispatcher()).recover((PartialFunction)new Serializable(this){
            private final /* synthetic */ ExternalShardAllocationStrategy $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof AskTimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof AskTimeoutException) {
                    this.$outer.org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$$log.warning("rebalance timed out waiting for shard allocation state. Keeping existing allocations");
                    return Predef$.MODULE$.Set().empty();
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)this.system.dispatcher());
    }

    public static class DDataStateActor
    implements Actor,
    ActorLogging,
    StashSupport,
    UnrestrictedStash,
    Stash {
        private ActorContext context;
        private ActorRef self;
        private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
        private Vector org$apache$pekko$actor$StashSupport$$theStash;
        private int org$apache$pekko$actor$StashSupport$$capacity;
        private DequeBasedMessageQueueSemantics mailbox;
        private final String typeName;
        private final ActorRef replicator;
        private final LWWMapKey<String, String> Key;
        private Map currentLocations;

        public static Props props(String string) {
            return ExternalShardAllocationStrategy$DDataStateActor$.MODULE$.props(string);
        }

        public DDataStateActor(String typeName) {
            this.typeName = typeName;
            Actor.$init$((Actor)this);
            ActorLogging.$init$((ActorLogging)this);
            StashSupport.$init$((StashSupport)this);
            this.replicator = ((DistributedData)DistributedData$.MODULE$.apply(this.context().system())).replicator();
            this.Key = ExternalShardAllocationStrategy$.MODULE$.ddataKey(typeName);
            this.currentLocations = Predef$.MODULE$.Map().empty();
            Statics.releaseFence();
        }

        public ActorContext context() {
            return this.context;
        }

        public final ActorRef self() {
            return this.self;
        }

        public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
            this.context = x$0;
        }

        public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
            this.self = x$0;
        }

        public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
            return this.org$apache$pekko$actor$ActorLogging$$_log;
        }

        public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
            this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
        }

        public Vector org$apache$pekko$actor$StashSupport$$theStash() {
            return this.org$apache$pekko$actor$StashSupport$$theStash;
        }

        public int org$apache$pekko$actor$StashSupport$$capacity() {
            return this.org$apache$pekko$actor$StashSupport$$capacity;
        }

        public DequeBasedMessageQueueSemantics mailbox() {
            return this.mailbox;
        }

        public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
            this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
        }

        public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
            this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
        }

        public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
            this.mailbox = x$0;
        }

        public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
            Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
        }

        public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
            Actor.postStop$((Actor)this);
        }

        public void preStart() {
            this.log().debug("Starting ddata state actor for [{}]", (Object)this.typeName);
            this.replicator.$bang((Object)Replicator.Subscribe$.MODULE$.apply(this.Key, this.self()), this.self());
        }

        public Map<String, String> currentLocations() {
            return this.currentLocations;
        }

        public void currentLocations_$eq(Map<String, String> x$1) {
            this.currentLocations = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                private final /* synthetic */ DDataStateActor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Object x) {
                    Replicator.Changed changed;
                    Replicator.Changed changed2;
                    Key key;
                    Object object = x;
                    if (object instanceof Replicator.Changed && (key = (changed2 = Replicator.Changed$.MODULE$.unapply(changed = (Replicator.Changed)object))._1()) instanceof LWWMapKey) {
                        LWWMapKey key2 = (LWWMapKey)key;
                        Replicator.Changed c = changed;
                        return true;
                    }
                    if (object instanceof GetShardLocation) {
                        String string;
                        GetShardLocation getShardLocation = ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.unapply((GetShardLocation)object);
                        String shard = string = getShardLocation._1();
                        return true;
                    }
                    return ExternalShardAllocationStrategy$GetShardLocations$.MODULE$.equals(object);
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Replicator.Changed changed;
                    Replicator.Changed changed2;
                    Key key;
                    Object object = x;
                    if (object instanceof Replicator.Changed && (key = (changed2 = Replicator.Changed$.MODULE$.unapply(changed = (Replicator.Changed)object))._1()) instanceof LWWMapKey) {
                        LWWMapKey key2 = (LWWMapKey)key;
                        Replicator.Changed c = changed;
                        Map newLocations = ((LWWMap)c.get((Key)key2)).entries();
                        this.$outer.currentLocations_$eq((Map<String, String>)((Map)this.$outer.currentLocations().$plus$plus((IterableOnce)newLocations)));
                        this.$outer.log().debug("Received updated shard locations [{}] all locations are now [{}]", (Object)newLocations, this.$outer.currentLocations());
                        return BoxedUnit.UNIT;
                    }
                    if (object instanceof GetShardLocation) {
                        String string;
                        GetShardLocation getShardLocation = ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.unapply((GetShardLocation)object);
                        String shard = string = getShardLocation._1();
                        this.$outer.log().debug("GetShardLocation [{}]", (Object)shard);
                        Option shardLocation = this.$outer.currentLocations().get((Object)shard).map(ExternalShardAllocationStrategy$::org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$DDataStateActor$$anon$3$$_$_$$anonfun$4);
                        this.$outer.sender().$bang((Object)ExternalShardAllocationStrategy$GetShardLocationResponse$.MODULE$.apply((Option<Address>)shardLocation), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    if (ExternalShardAllocationStrategy$GetShardLocations$.MODULE$.equals(object)) {
                        this.$outer.log().debug("GetShardLocations");
                        this.$outer.sender().$bang((Object)ExternalShardAllocationStrategy$GetShardLocationsResponse$.MODULE$.apply((Map<String, Address>)((Map)this.$outer.currentLocations().transform(ExternalShardAllocationStrategy$::org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$DDataStateActor$$anon$3$$_$applyOrElse$$anonfun$1))), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply(x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$DDataStateActor$$anon$3$$_$_$$anonfun$4(java.lang.String ), org$apache$pekko$cluster$sharding$external$ExternalShardAllocationStrategy$DDataStateActor$$anon$3$$_$applyOrElse$$anonfun$1(java.lang.String java.lang.String )}, serializedLambda);
                }
            };
        }
    }

    public static final class GetShardLocation
    implements Product,
    Serializable {
        private final String shard;

        public static GetShardLocation apply(String string) {
            return ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.apply(string);
        }

        public static GetShardLocation fromProduct(Product product) {
            return ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.fromProduct(product);
        }

        public static GetShardLocation unapply(GetShardLocation getShardLocation) {
            return ExternalShardAllocationStrategy$GetShardLocation$.MODULE$.unapply(getShardLocation);
        }

        public GetShardLocation(String shard) {
            this.shard = shard;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetShardLocation)) return false;
            GetShardLocation getShardLocation = (GetShardLocation)object;
            String string = this.shard();
            String string2 = getShardLocation.shard();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetShardLocation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GetShardLocation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "shard";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String shard() {
            return this.shard;
        }

        public GetShardLocation copy(String shard) {
            return new GetShardLocation(shard);
        }

        public String copy$default$1() {
            return this.shard();
        }

        public String _1() {
            return this.shard();
        }
    }

    public static final class GetShardLocationResponse
    implements Product,
    Serializable {
        private final Option address;

        public static GetShardLocationResponse apply(Option<Address> option) {
            return ExternalShardAllocationStrategy$GetShardLocationResponse$.MODULE$.apply(option);
        }

        public static GetShardLocationResponse fromProduct(Product product) {
            return ExternalShardAllocationStrategy$GetShardLocationResponse$.MODULE$.fromProduct(product);
        }

        public static GetShardLocationResponse unapply(GetShardLocationResponse getShardLocationResponse) {
            return ExternalShardAllocationStrategy$GetShardLocationResponse$.MODULE$.unapply(getShardLocationResponse);
        }

        public GetShardLocationResponse(Option<Address> address) {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetShardLocationResponse)) return false;
            GetShardLocationResponse getShardLocationResponse = (GetShardLocationResponse)object;
            Option<Address> option = this.address();
            Option<Address> option2 = getShardLocationResponse.address();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetShardLocationResponse;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GetShardLocationResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Address> address() {
            return this.address;
        }

        public GetShardLocationResponse copy(Option<Address> address) {
            return new GetShardLocationResponse(address);
        }

        public Option<Address> copy$default$1() {
            return this.address();
        }

        public Option<Address> _1() {
            return this.address();
        }
    }

    public static final class GetShardLocationsResponse
    implements Product,
    Serializable {
        private final Map desiredAllocations;

        public static GetShardLocationsResponse apply(Map<String, Address> map) {
            return ExternalShardAllocationStrategy$GetShardLocationsResponse$.MODULE$.apply(map);
        }

        public static GetShardLocationsResponse fromProduct(Product product) {
            return ExternalShardAllocationStrategy$GetShardLocationsResponse$.MODULE$.fromProduct(product);
        }

        public static GetShardLocationsResponse unapply(GetShardLocationsResponse getShardLocationsResponse) {
            return ExternalShardAllocationStrategy$GetShardLocationsResponse$.MODULE$.unapply(getShardLocationsResponse);
        }

        public GetShardLocationsResponse(Map<String, Address> desiredAllocations) {
            this.desiredAllocations = desiredAllocations;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetShardLocationsResponse)) return false;
            GetShardLocationsResponse getShardLocationsResponse = (GetShardLocationsResponse)object;
            Map<String, Address> map = this.desiredAllocations();
            Map<String, Address> map2 = getShardLocationsResponse.desiredAllocations();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetShardLocationsResponse;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GetShardLocationsResponse";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "desiredAllocations";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<String, Address> desiredAllocations() {
            return this.desiredAllocations;
        }

        public GetShardLocationsResponse copy(Map<String, Address> desiredAllocations) {
            return new GetShardLocationsResponse(desiredAllocations);
        }

        public Map<String, Address> copy$default$1() {
            return this.desiredAllocations();
        }

        public Map<String, Address> _1() {
            return this.desiredAllocations();
        }
    }

    public static final class ShardLocation
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Address address;

        public static ShardLocation apply(Address address) {
            return ExternalShardAllocationStrategy$ShardLocation$.MODULE$.apply(address);
        }

        public static ShardLocation fromProduct(Product product) {
            return ExternalShardAllocationStrategy$ShardLocation$.MODULE$.fromProduct(product);
        }

        public static ShardLocation unapply(ShardLocation shardLocation) {
            return ExternalShardAllocationStrategy$ShardLocation$.MODULE$.unapply(shardLocation);
        }

        public ShardLocation(Address address) {
            this.address = address;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ShardLocation)) return false;
            ShardLocation shardLocation = (ShardLocation)object;
            Address address = this.address();
            Address address2 = shardLocation.address();
            if (address != null) {
                if (!address.equals(address2)) return false;
                return true;
            }
            if (address2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ShardLocation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ShardLocation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "address";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Address address() {
            return this.address;
        }

        public ShardLocation copy(Address address) {
            return new ShardLocation(address);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public Address _1() {
            return this.address();
        }
    }
}

