/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.external.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.AddressFromURIString$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ddata.DistributedData;
import org.apache.pekko.cluster.ddata.DistributedData$;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.LWWMap;
import org.apache.pekko.cluster.ddata.LWWMap$;
import org.apache.pekko.cluster.ddata.LWWMapKey;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.cluster.sharding.external.ClientTimeoutException;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.external.ExternalShardAllocationStrategy$ShardLocation$;
import org.apache.pekko.cluster.sharding.external.ShardLocations;
import org.apache.pekko.cluster.sharding.external.scaladsl.ExternalShardAllocationClient;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class ExternalShardAllocationClientImpl
implements ExternalShardAllocationClient,
org.apache.pekko.cluster.sharding.external.javadsl.ExternalShardAllocationClient {
    private final LoggingAdapter log;
    private final ActorRef replicator;
    private final SelfUniqueAddress self;
    private final FiniteDuration timeout;
    private final Timeout askTimeout;
    private final MessageDispatcher ec;
    private final LWWMapKey<String, String> Key;

    public ExternalShardAllocationClientImpl(ActorSystem system, String typeName) {
        this.log = Logging$.MODULE$.apply(system, ExternalShardAllocationClientImpl.class, LogSource$.MODULE$.fromAnyClass());
        this.replicator = ((DistributedData)DistributedData$.MODULE$.apply(system)).replicator();
        this.self = ((DistributedData)DistributedData$.MODULE$.apply(system)).selfUniqueAddress();
        this.timeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(system.settings().config().getDuration("pekko.cluster.sharding.external-shard-allocation-strategy.client-timeout")));
        this.askTimeout = Timeout$.MODULE$.apply(this.timeout.$times(2L));
        this.ec = system.dispatchers().internalDispatcher();
        this.Key = ExternalShardAllocationStrategy$.MODULE$.ddataKey(typeName);
    }

    @Override
    public Future<Done> updateShardLocation(String shard, Address location) {
        this.log.debug("updateShardLocation {} {} key {}", (Object)shard, (Object)location, this.Key);
        ActorRef actorRef = package$.MODULE$.ask(this.replicator);
        Replicator.Update update = Replicator.Update$.MODULE$.apply(this.Key, (ReplicatedData)LWWMap$.MODULE$.empty(), (Replicator.WriteConsistency)Replicator.WriteLocal$.MODULE$, (Option)None$.MODULE$, (Function1 & Serializable)existing -> existing.put(this.self, (Object)shard, (Object)location.toString()));
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)update, this.askTimeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)update)).flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Replicator.UpdateSuccess) {
                Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                Key key = updateSuccess._1();
                Option option = updateSuccess._2();
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            if (Replicator.UpdateTimeout$.MODULE$.equals(object)) {
                return Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(38).append("Unable to update shard location after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout)))).toString()));
            }
            throw new IllegalArgumentException();
        }, (ExecutionContext)this.ec);
    }

    @Override
    public CompletionStage<Done> setShardLocation(String shard, Address location) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.updateShardLocation(shard, location));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    @Override
    public Future<ShardLocations> shardLocations() {
        ActorRef actorRef = package$.MODULE$.ask(this.replicator);
        Replicator.Get get = Replicator.Get$.MODULE$.apply(this.Key, (Replicator.ReadConsistency)Replicator.ReadMajority$.MODULE$.apply(this.timeout, Replicator.ReadMajority$.MODULE$.$lessinit$greater$default$2()), Replicator.Get$.MODULE$.$lessinit$greater$default$3());
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)get, this.askTimeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)get)).flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Replicator.GetSuccess) {
                Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                Replicator.GetSuccess getSuccess2 = Replicator.GetSuccess$.MODULE$.unapply(getSuccess);
                Key key = getSuccess2._1();
                Option option = getSuccess2._2();
                LWWMapKey<String, String> lWWMapKey = this.Key;
                Key key2 = key;
                if (!(lWWMapKey != null ? !lWWMapKey.equals((Object)key2) : key2 != null)) {
                    Replicator.GetSuccess success = getSuccess;
                    return Future$.MODULE$.successful((Object)((LWWMap)success.get(this.Key)).entries().transform((Function2 & Serializable)(_$1, asStr) -> ExternalShardAllocationStrategy$ShardLocation$.MODULE$.apply(AddressFromURIString$.MODULE$.apply(asStr))));
                }
            }
            if (object instanceof Replicator.NotFound) {
                Replicator.NotFound notFound = Replicator.NotFound$.MODULE$.unapply((Replicator.NotFound)object);
                Key key = notFound._1();
                Option option = notFound._2();
                return Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().empty());
            }
            if (object instanceof Replicator.GetFailure) {
                Replicator.GetFailure getFailure = Replicator.GetFailure$.MODULE$.unapply((Replicator.GetFailure)object);
                Key key = getFailure._1();
                Option option = getFailure._2();
                return Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(36).append("Unable to get shard locations after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout)))).toString()));
            }
            throw new IllegalArgumentException();
        }, (ExecutionContext)this.ec).map((Function1 & Serializable)locations -> new ShardLocations((scala.collection.immutable.Map<String, ExternalShardAllocationStrategy.ShardLocation>)locations), (ExecutionContext)this.ec);
    }

    @Override
    public CompletionStage<ShardLocations> getShardLocations() {
        Future future = FutureConverters$.MODULE$.FutureOps(this.shardLocations());
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    @Override
    public Future<Done> updateShardLocations(scala.collection.immutable.Map<String, Address> locations) {
        this.log.debug("updateShardLocations {} for {}", locations, this.Key);
        ActorRef actorRef = package$.MODULE$.ask(this.replicator);
        Replicator.Update update = Replicator.Update$.MODULE$.apply(this.Key, (ReplicatedData)LWWMap$.MODULE$.empty(), (Replicator.WriteConsistency)Replicator.WriteLocal$.MODULE$, (Option)None$.MODULE$, (Function1 & Serializable)existing -> (LWWMap)locations.foldLeft(existing, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                LWWMap acc = (LWWMap)tuple2._1();
                if (tuple22 != null) {
                    String shardId = (String)tuple22._1();
                    Address address = (Address)tuple22._2();
                    return acc.put(this.self, (Object)shardId, (Object)address.toString());
                }
            }
            throw new MatchError((Object)tuple2);
        }));
        return AskableActorRef$.MODULE$.$qmark$extension(actorRef, (Object)update, this.askTimeout, AskableActorRef$.MODULE$.$qmark$default$3$extension(actorRef, (Object)update)).flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Replicator.UpdateSuccess) {
                Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                Key key = updateSuccess._1();
                Option option = updateSuccess._2();
                return Future$.MODULE$.successful((Object)Done$.MODULE$);
            }
            if (Replicator.UpdateTimeout$.MODULE$.equals(object)) {
                return Future$.MODULE$.failed((Throwable)new ClientTimeoutException(new StringBuilder(38).append("Unable to update shard location after ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout)))).toString()));
            }
            throw new IllegalArgumentException();
        }, (ExecutionContext)this.ec);
    }

    @Override
    public CompletionStage<Done> setShardLocations(Map<String, Address> locations) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.updateShardLocations((scala.collection.immutable.Map<String, Address>)package.JavaConverters$.MODULE$.MapHasAsScala(locations).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }
}

