/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$RegionEntry$;
import org.apache.pekko.cluster.sharding.internal.AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Version;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public abstract class AbstractLeastShardAllocationStrategy
implements ShardCoordinator.ActorSystemDependentAllocationStrategy {
    private volatile ActorSystem system;
    private volatile Cluster cluster;

    @Override
    public void start(ActorSystem system) {
        this.system = system;
        this.cluster = (Cluster)Cluster$.MODULE$.apply(system);
    }

    public ClusterEvent.CurrentClusterState clusterState() {
        return this.cluster.state();
    }

    public Member selfMember() {
        return this.cluster.selfMember();
    }

    @Override
    public Future<ActorRef> allocateShard(ActorRef requester, String shardId, Map<ActorRef, IndexedSeq<String>> currentShardAllocations) {
        Iterable<RegionEntry> regionEntries = this.regionEntriesFor(currentShardAllocations);
        if (regionEntries.isEmpty()) {
            return package$.MODULE$.after(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis(), () -> this.allocateShard$$anonfun$1(requester, shardId, currentShardAllocations), (ClassicActorSystemProvider)this.system);
        }
        Tuple2<ActorRef, IndexedSeq<String>> tuple2 = this.mostSuitableRegion(regionEntries);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ActorRef region = (ActorRef)tuple2._1();
        ActorRef region2 = region;
        return Future$.MODULE$.successful((Object)region2);
    }

    public final boolean isAGoodTimeToRebalance(Iterable<RegionEntry> regionEntries) {
        Option option = regionEntries.headOption();
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            RegionEntry firstRegion = (RegionEntry)((Some)option).value();
            return AbstractLeastShardAllocationStrategy.allNodesSameVersion$1(regionEntries, firstRegion) && this.neededMembersReachable$1() && !this.membersInProgressOfJoining$1();
        }
        throw new MatchError((Object)option);
    }

    public final Tuple2<ActorRef, IndexedSeq<String>> mostSuitableRegion(Iterable<RegionEntry> regionEntries) {
        RegionEntry mostSuitableEntry = (RegionEntry)regionEntries.min((Ordering)AbstractLeastShardAllocationStrategy$ShardSuitabilityOrdering$.MODULE$);
        ActorRef actorRef = (ActorRef)Predef$.MODULE$.ArrowAssoc((Object)mostSuitableEntry.region());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)actorRef, mostSuitableEntry.shardIds());
    }

    public final Iterable<RegionEntry> regionEntriesFor(Map<ActorRef, IndexedSeq<String>> currentShardAllocations) {
        Map addressToMember = this.clusterState().members().iterator().map((Function1 & Serializable)m -> {
            Address address = (Address)Predef$.MODULE$.ArrowAssoc((Object)m.address());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)address, m);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return (Iterable)currentShardAllocations.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef region = (ActorRef)tuple2._1();
                IndexedSeq shardIds = (IndexedSeq)tuple2._2();
                Address regionAddress = region.path().address().hasLocalScope() ? this.selfMember().address() : region.path().address();
                Option memberForRegion = addressToMember.get((Object)regionAddress);
                return memberForRegion.map((Function1 & Serializable)member -> AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.apply(region, (Member)member, (IndexedSeq<String>)shardIds));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Future allocateShard$$anonfun$1(ActorRef requester$1, String shardId$1, Map currentShardAllocations$1) {
        return this.allocateShard(requester$1, shardId$1, (Map<ActorRef, IndexedSeq<String>>)currentShardAllocations$1);
    }

    private static final boolean allNodesSameVersion$1(Iterable regionEntries$1, RegionEntry firstRegion$1) {
        return regionEntries$1.forall((Function1 & Serializable)_$3 -> {
            Version version = _$3.member().appVersion();
            Version version2 = firstRegion$1.member().appVersion();
            return !(version != null ? !version.equals(version2) : version2 != null);
        });
    }

    private final boolean neededMembersReachable$1() {
        return !this.clusterState().members().exists((Function1 & Serializable)m -> {
            String string = m.dataCenter();
            String string2 = this.selfMember().dataCenter();
            return !(string != null ? !string.equals(string2) : string2 != null) && this.clusterState().unreachable().apply(m);
        });
    }

    private final boolean membersInProgressOfJoining$1() {
        return this.clusterState().members().exists((Function1 & Serializable)m -> {
            String string = m.dataCenter();
            String string2 = this.selfMember().dataCenter();
            return !(string != null ? !string.equals(string2) : string2 != null) && AbstractLeastShardAllocationStrategy$.org$apache$pekko$cluster$sharding$internal$AbstractLeastShardAllocationStrategy$$$JoiningCluster.apply((Object)m.status());
        });
    }

    public static final class RegionEntry
    implements Product,
    Serializable {
        private final ActorRef region;
        private final Member member;
        private final IndexedSeq shardIds;

        public static RegionEntry apply(ActorRef actorRef, Member member, IndexedSeq<String> indexedSeq) {
            return AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.apply(actorRef, member, indexedSeq);
        }

        public static RegionEntry fromProduct(Product product) {
            return AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.fromProduct(product);
        }

        public static RegionEntry unapply(RegionEntry regionEntry) {
            return AbstractLeastShardAllocationStrategy$RegionEntry$.MODULE$.unapply(regionEntry);
        }

        public RegionEntry(ActorRef region, Member member, IndexedSeq<String> shardIds) {
            this.region = region;
            this.member = member;
            this.shardIds = shardIds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegionEntry)) return false;
            RegionEntry regionEntry = (RegionEntry)object;
            ActorRef actorRef = this.region();
            ActorRef actorRef2 = regionEntry.region();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Member member = this.member();
            Member member2 = regionEntry.member();
            if (member == null) {
                if (member2 != null) {
                    return false;
                }
            } else if (!member.equals(member2)) return false;
            IndexedSeq<String> indexedSeq = this.shardIds();
            IndexedSeq<String> indexedSeq2 = regionEntry.shardIds();
            if (indexedSeq == null) {
                if (indexedSeq2 == null) return true;
                return false;
            } else {
                if (!indexedSeq.equals(indexedSeq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RegionEntry;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RegionEntry";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "region";
                }
                case 1: {
                    return "member";
                }
                case 2: {
                    return "shardIds";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ActorRef region() {
            return this.region;
        }

        public Member member() {
            return this.member;
        }

        public IndexedSeq<String> shardIds() {
            return this.shardIds;
        }

        public RegionEntry copy(ActorRef region, Member member, IndexedSeq<String> shardIds) {
            return new RegionEntry(region, member, shardIds);
        }

        public ActorRef copy$default$1() {
            return this.region();
        }

        public Member copy$default$2() {
            return this.member();
        }

        public IndexedSeq<String> copy$default$3() {
            return this.shardIds();
        }

        public ActorRef _1() {
            return this.region();
        }

        public Member _2() {
            return this.member();
        }

        public IndexedSeq<String> _3() {
            return this.shardIds();
        }
    }
}

