/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.cluster.sharding.internal.AdmissionOptimizer;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.LimitBasedEntityPassivationStrategy;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class CompositeEntityPassivationStrategy
extends LimitBasedEntityPassivationStrategy {
    private final ActiveEntities window;
    private final double minimumWindowProportion;
    private final double maximumWindowProportion;
    private final AdmissionOptimizer windowOptimizer;
    private final AdmissionFilter admissionFilter;
    private final ActiveEntities main;
    private final Option<IdleCheck> idleCheck;
    private double windowProportion;
    private int windowLimit;
    private int mainLimit;

    public CompositeEntityPassivationStrategy(int initialLimit, ActiveEntities window, double initialWindowProportion, double minimumWindowProportion, double maximumWindowProportion, AdmissionOptimizer windowOptimizer, AdmissionFilter admissionFilter, ActiveEntities main, Option<IdleCheck> idleCheck) {
        this.window = window;
        this.minimumWindowProportion = minimumWindowProportion;
        this.maximumWindowProportion = maximumWindowProportion;
        this.windowOptimizer = windowOptimizer;
        this.admissionFilter = admissionFilter;
        this.main = main;
        this.idleCheck = idleCheck;
        super(initialLimit);
        this.windowProportion = initialWindowProportion;
        this.windowLimit = 0;
        this.mainLimit = 0;
        this.calculateLimits();
        window.updateLimit(this.windowLimit);
        main.updateLimit(this.mainLimit);
    }

    private void calculateLimits() {
        this.windowLimit = (int)(this.windowProportion * (double)this.perShardLimit());
        this.mainLimit = this.perShardLimit() - this.windowLimit;
    }

    @Override
    public Seq<String> entityTouched(String id) {
        Seq<String> seq;
        this.admissionFilter.update(id);
        if (this.window.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.window.update(id);
        } else if (this.main.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.main.update(id);
        } else {
            this.windowOptimizer.recordPassive();
            seq = this.maybeAdmitToMain(this.window.update(id));
        }
        Seq<String> passivated = seq;
        this.adaptWindow();
        return passivated;
    }

    @Override
    public void entityTerminated(String id) {
        this.window.remove(id);
        this.main.remove(id);
    }

    @Override
    public Seq<String> passivateEntitiesOnLimitUpdate() {
        this.calculateLimits();
        this.windowOptimizer.updateLimit(this.perShardLimit());
        this.admissionFilter.updateCapacity(this.perShardLimit());
        return (Seq)this.maybeAdmitToMain(this.window.updateLimit(this.windowLimit)).$plus$plus(this.main.updateLimit(this.mainLimit));
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.idleCheck.map((Function1 & Serializable)_$5 -> _$5.interval());
    }

    @Override
    public Seq<String> intervalPassed() {
        return (Seq)this.idleCheck.fold(CompositeEntityPassivationStrategy::intervalPassed$$anonfun$9, (Function1 & Serializable)idle -> (Seq)this.window.removeIdle(idle.timeout()).$plus$plus(this.main.removeIdle(idle.timeout())));
    }

    private Seq<String> maybeAdmitToMain(Seq<String> candidates) {
        if (candidates.nonEmpty()) {
            ObjectRef passivated = ObjectRef.create(EntityPassivationStrategy$PassivateEntities$.MODULE$.none());
            candidates.foreach((Function1)(JProcedure1 & Serializable)candidate -> {
                if (this.main.size() >= this.mainLimit) {
                    String string = this.main.select();
                    String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
                        String string3 = (String)OptionVal$.MODULE$.get$extension((Object)string2);
                        String selected = string3;
                        if (this.admissionFilter.admit((String)candidate, selected)) {
                            Seq seq = (Seq)((Seq)passivated$1.elem).$plus$plus(this.main.update((String)candidate));
                            passivated$1.elem = seq;
                            seq = null;
                            return;
                        }
                        Seq seq = (Seq)((Seq)passivated$1.elem).$colon$plus(candidate);
                        passivated$1.elem = seq;
                        seq = null;
                        return;
                    }
                    Seq seq = (Seq)((Seq)passivated$1.elem).$plus$plus(this.main.update((String)candidate));
                    passivated$1.elem = seq;
                    seq = null;
                    return;
                }
                Seq seq = (Seq)((Seq)passivated$1.elem).$plus$plus(this.main.update((String)candidate));
                passivated$1.elem = seq;
                seq = null;
            });
            return (Seq)passivated.elem;
        }
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    private void adaptWindow() {
        double adjustment = this.windowOptimizer.calculateAdjustment();
        if (adjustment != 0.0) {
            this.windowProportion = package$.MODULE$.max(this.minimumWindowProportion, package$.MODULE$.min(this.maximumWindowProportion, this.windowProportion + adjustment));
            this.calculateLimits();
            if (adjustment > 0.0) {
                this.window.updateLimit(this.windowLimit);
                this.main.updateLimit(this.mainLimit).foreach((Function1 & Serializable)id -> this.window.update((String)id));
                return;
            }
            this.main.updateLimit(this.mainLimit);
            this.window.updateLimit(this.windowLimit).foreach((Function1 & Serializable)id -> this.main.update((String)id));
            return;
        }
    }

    private static final Seq intervalPassed$$anonfun$9() {
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }
}

