/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesProvider;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

@InternalApi
public final class CustomStateStoreModeProvider
implements RememberEntitiesProvider {
    private final RememberEntitiesProvider customStore;

    public CustomStateStoreModeProvider(String typeName, ActorSystem system, ClusterShardingSettings settings) {
        LoggingAdapter log = Logging$.MODULE$.apply(system, CustomStateStoreModeProvider.class, LogSource$.MODULE$.fromAnyClass());
        log.warning("Using custom remember entities store for [{}], not intended for production use.", (Object)typeName);
        if (!system.settings().config().hasPath("pekko.cluster.sharding.remember-entities-custom-store")) {
            log.error("Missing custom store class configuration for CustomStateStoreModeProvider");
            throw new RuntimeException("Missing custom store class configuration");
        }
        String customClassName = system.settings().config().getString("pekko.cluster.sharding.remember-entities-custom-store");
        Try store = ((ExtendedActorSystem)system).dynamicAccess().createInstanceFor(customClassName, (Seq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply(ClusterShardingSettings.class, (Object)settings), Tuple2$.MODULE$.apply(String.class, (Object)typeName)})), ClassTag$.MODULE$.apply(RememberEntitiesProvider.class));
        log.debug("Will use custom remember entities store provider [{}]", (Object)store);
        this.customStore = (RememberEntitiesProvider)store.get();
    }

    public RememberEntitiesProvider customStore() {
        return this.customStore;
    }

    @Override
    public Props shardStoreProps(String shardId) {
        return this.customStore().shardStoreProps(shardId);
    }

    @Override
    public Props coordinatorStoreProps() {
        return this.customStore().coordinatorStoreProps();
    }
}

