/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.ORSet;
import org.apache.pekko.cluster.ddata.ORSet$;
import org.apache.pekko.cluster.ddata.ORSetKey;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.DDataRememberEntitiesShardStore$;
import org.apache.pekko.cluster.sharding.internal.DDataRememberEntitiesShardStore$Started$;
import org.apache.pekko.cluster.sharding.internal.DDataRememberEntitiesShardStore$Stopped$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$GetEntities$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$RememberedEntities$;
import org.apache.pekko.cluster.sharding.internal.RememberEntitiesShardStore$UpdateDone$;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class DDataRememberEntitiesShardStore
implements Actor,
StashSupport,
UnrestrictedStash,
Stash,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final ActorRef org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$replicator;
    private final ExecutionContext ec;
    private final Cluster node;
    private final SelfUniqueAddress selfUniqueAddress;
    public final Replicator.ReadMajority org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$readMajority;
    public final Replicator.WriteMajority org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$writeMajority;
    public final int org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$maxUpdateAttempts;
    public final ORSetKey<String>[] org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$keys;

    public static Props props(String string, String string2, ClusterShardingSettings clusterShardingSettings, ActorRef actorRef, int n) {
        return DDataRememberEntitiesShardStore$.MODULE$.props(string, string2, clusterShardingSettings, actorRef, n);
    }

    public DDataRememberEntitiesShardStore(String shardId, String typeName, ClusterShardingSettings settings, ActorRef replicator, int majorityMinCap) {
        this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$replicator = replicator;
        Actor.$init$((Actor)this);
        StashSupport.$init$((StashSupport)this);
        ActorLogging.$init$((ActorLogging)this);
        this.ec = this.context().dispatcher();
        this.node = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfUniqueAddress = SelfUniqueAddress$.MODULE$.apply(this.node().selfUniqueAddress());
        this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$readMajority = Replicator.ReadMajority$.MODULE$.apply(settings.tuningParameters().waitingForStateTimeout(), majorityMinCap);
        this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$writeMajority = Replicator.WriteMajority$.MODULE$.apply(settings.tuningParameters().updatingStateTimeout().$div(4L), majorityMinCap);
        this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$maxUpdateAttempts = 3;
        this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$keys = DDataRememberEntitiesShardStore$.MODULE$.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$$stateKeys(typeName, shardId);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Starting up DDataRememberEntitiesStore, read timeout: [{}], write timeout: [{}], majority min cap: [{}]", (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)settings.tuningParameters().waitingForStateTimeout())), (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)settings.tuningParameters().updatingStateTimeout())), (Object)BoxesRunTime.boxToInteger((int)majorityMinCap));
        }
        this.loadAllEntities();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public Cluster node() {
        return this.node;
    }

    public SelfUniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    private ORSetKey<String> key(String entityId) {
        int i = package$.MODULE$.abs(entityId.hashCode() % DDataRememberEntitiesShardStore$.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$$numberOfKeys);
        return this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$keys[i];
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.waitingForAllEntityIds((scala.collection.immutable.Set<Object>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), (Option<ActorRef>)None$.MODULE$);
    }

    public PartialFunction<Object, BoxedUnit> idle() {
        return new Serializable(this){
            private final /* synthetic */ DDataRememberEntitiesShardStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (RememberEntitiesShardStore$GetEntities$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (RememberEntitiesShardStore$GetEntities$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Another get entities request after responding to one, not expected/supported, ignoring");
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$onUpdate(update);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> waitingForAllEntityIds(scala.collection.immutable.Set<Object> gotKeys, scala.collection.immutable.Set<String> ids, Option<ActorRef> shardWaiting) {
        return new Serializable(gotKeys, ids, shardWaiting, this){
            private final scala.collection.immutable.Set gotKeys$2;
            private final scala.collection.immutable.Set ids$2;
            private final Option shardWaiting$2;
            private final /* synthetic */ DDataRememberEntitiesShardStore $outer;
            {
                this.gotKeys$2 = gotKeys$3;
                this.ids$2 = ids$3;
                this.shardWaiting$2 = shardWaiting$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Replicator.GetSuccess) {
                    Object object2;
                    Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                    Replicator.GetSuccess getSuccess2 = Replicator.GetSuccess$.MODULE$.unapply(getSuccess);
                    Key key = getSuccess2._1();
                    Option option = getSuccess2._2();
                    if (option instanceof Some && (object2 = ((Some)option).value()) instanceof Integer) {
                        int i = BoxesRunTime.unboxToInt((Object)object2);
                        Replicator.GetSuccess g = getSuccess;
                        return true;
                    }
                }
                if (object instanceof Replicator.NotFound) {
                    Object object3;
                    Replicator.NotFound notFound = Replicator.NotFound$.MODULE$.unapply((Replicator.NotFound)object);
                    Key key = notFound._1();
                    Option option = notFound._2();
                    if (option instanceof Some && (object3 = ((Some)option).value()) instanceof Integer) {
                        int i = BoxesRunTime.unboxToInt((Object)object3);
                        return true;
                    }
                }
                if (object instanceof Replicator.GetFailure) {
                    Replicator.GetFailure getFailure = Replicator.GetFailure$.MODULE$.unapply((Replicator.GetFailure)object);
                    Key key = getFailure._1();
                    Option option = getFailure._2();
                    Key key2 = key;
                    return true;
                }
                if (object instanceof Replicator.GetDataDeleted) {
                    Replicator.GetDataDeleted getDataDeleted = Replicator.GetDataDeleted$.MODULE$.unapply((Replicator.GetDataDeleted)object);
                    Key key = getDataDeleted._1();
                    Option option = getDataDeleted._2();
                    return true;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    return true;
                }
                if (RememberEntitiesShardStore$GetEntities$.MODULE$.equals(object)) {
                    return true;
                }
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Replicator.GetSuccess) {
                    Object object2;
                    Replicator.GetSuccess getSuccess = (Replicator.GetSuccess)object;
                    Replicator.GetSuccess getSuccess2 = Replicator.GetSuccess$.MODULE$.unapply(getSuccess);
                    Key key = getSuccess2._1();
                    Option option = getSuccess2._2();
                    if (option instanceof Some && (object2 = ((Some)option).value()) instanceof Integer) {
                        int i = BoxesRunTime.unboxToInt((Object)object2);
                        Replicator.GetSuccess g = getSuccess;
                        ORSetKey<String> key2 = this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$keys[i];
                        scala.collection.immutable.Set ids = ((ORSet)g.get(key2)).elements();
                        this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$receiveOne$1(this.gotKeys$2, this.ids$2, this.shardWaiting$2, i, ids);
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.NotFound) {
                    Object object3;
                    Replicator.NotFound notFound = Replicator.NotFound$.MODULE$.unapply((Replicator.NotFound)object);
                    Key key = notFound._1();
                    Option option = notFound._2();
                    if (option instanceof Some && (object3 = ((Some)option).value()) instanceof Integer) {
                        int i = BoxesRunTime.unboxToInt((Object)object3);
                        this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$receiveOne$1(this.gotKeys$2, this.ids$2, this.shardWaiting$2, i, Predef$.MODULE$.Set().empty());
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.GetFailure) {
                    Replicator.GetFailure getFailure = Replicator.GetFailure$.MODULE$.unapply((Replicator.GetFailure)object);
                    Key key = getFailure._1();
                    Option option = getFailure._2();
                    Key key3 = key;
                    this.$outer.log().error("Unable to get an initial state within 'waiting-for-state-timeout': [{}] using [{}] (key [{}])", (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$readMajority.timeout())), (Object)this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$readMajority, (Object)key3);
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Replicator.GetDataDeleted) {
                    Replicator.GetDataDeleted getDataDeleted = Replicator.GetDataDeleted$.MODULE$.unapply((Replicator.GetDataDeleted)object);
                    Key key = getDataDeleted._1();
                    Option option = getDataDeleted._2();
                    this.$outer.log().error("Unable to get an initial state because it was deleted");
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    this.$outer.log().warning("Got an update before load of initial entities completed, dropping update: [{}]", (Object)update);
                    return BoxedUnit.UNIT;
                }
                if (!RememberEntitiesShardStore$GetEntities$.MODULE$.equals(object)) {
                    this.$outer.stash();
                    return BoxedUnit.UNIT;
                }
                if (this.gotKeys$2.size() == DDataRememberEntitiesShardStore$.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$$numberOfKeys) {
                    this.$outer.log().debug("Got request from shard, sending remembered entities");
                    this.$outer.sender().$bang((Object)RememberEntitiesShardStore$RememberedEntities$.MODULE$.apply((scala.collection.immutable.Set<String>)this.ids$2), this.$outer.self());
                    this.$outer.context().become(this.$outer.idle());
                    this.$outer.unstashAll();
                    return BoxedUnit.UNIT;
                }
                this.$outer.log().debug("Got request from shard, waiting for all remembered entities to arrive");
                this.$outer.context().become(this.$outer.waitingForAllEntityIds((scala.collection.immutable.Set<Object>)this.gotKeys$2, (scala.collection.immutable.Set<String>)this.ids$2, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender())));
                return BoxedUnit.UNIT;
            }
        };
    }

    public void org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$onUpdate(RememberEntitiesShardStore.Update update) {
        scala.collection.immutable.Set allEvts = (scala.collection.immutable.Set)((SetOps)update.started().map((Function1 & Serializable)_$1 -> DDataRememberEntitiesShardStore$Started$.MODULE$.apply((String)_$1))).union((Set)update.stopped().map((Function1 & Serializable)_$2 -> DDataRememberEntitiesShardStore$Stopped$.MODULE$.apply((String)_$2)));
        Map ddataUpdates = (Map)allEvts.groupBy((Function1 & Serializable)evt -> this.key(evt.id())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ORSetKey key = (ORSetKey)tuple2._1();
                scala.collection.immutable.Set evts = (scala.collection.immutable.Set)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)evts, (Object)Tuple2$.MODULE$.apply((Object)Replicator.Update$.MODULE$.apply((Key)key, (ReplicatedData)ORSet$.MODULE$.empty(), (Replicator.WriteConsistency)this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$writeMajority, (Option)Some$.MODULE$.apply((Object)evts), (Function1 & Serializable)existing -> (ORSet)evts.foldLeft(existing, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        ORSet oRSet = (ORSet)tuple2._1();
                        Evt evt = (Evt)tuple2._2();
                        ORSet acc = oRSet;
                        if (evt instanceof Started) {
                            String string;
                            Started started = DDataRememberEntitiesShardStore$Started$.MODULE$.unapply((Started)evt);
                            String id = string = started._1();
                            return acc.$colon$plus((Object)id, this.selfUniqueAddress());
                        }
                        ORSet acc2 = oRSet;
                        if (evt instanceof Stopped) {
                            String string;
                            Stopped stopped = DDataRememberEntitiesShardStore$Stopped$.MODULE$.unapply((Stopped)evt);
                            String id = string = stopped._1();
                            return acc2.remove((Object)id, this.selfUniqueAddress());
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })), (Object)BoxesRunTime.boxToInteger((int)this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$maxUpdateAttempts)));
            }
            throw new MatchError((Object)tuple2);
        });
        ddataUpdates.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Replicator.Update update = (Replicator.Update)tuple2._1();
                this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$replicator.$bang((Object)update, this.self());
                return;
            }
            throw new MatchError((Object)tuple22);
        });
        this.context().become(this.waitingForUpdates(this.sender(), update, (Map<scala.collection.immutable.Set<Evt>, Tuple2<Replicator.Update<ORSet<String>>, Object>>)ddataUpdates));
    }

    private PartialFunction<Object, BoxedUnit> waitingForUpdates(ActorRef requestor, RememberEntitiesShardStore.Update update, Map<scala.collection.immutable.Set<Evt>, Tuple2<Replicator.Update<ORSet<String>>, Object>> allUpdates) {
        return this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$next$1(requestor, update, allUpdates);
    }

    private void loadAllEntities() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), DDataRememberEntitiesShardStore$.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$$numberOfKeys).toSet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ORSetKey<String> key = this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$keys[i];
            this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$replicator.$bang((Object)Replicator.Get$.MODULE$.apply(key, (Replicator.ReadConsistency)this.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$readMajority, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i))), this.self());
        });
    }

    public final void org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$receiveOne$1(scala.collection.immutable.Set gotKeys$1, scala.collection.immutable.Set ids$1, Option shardWaiting$1, int i, scala.collection.immutable.Set idsForKey) {
        scala.collection.immutable.Set newGotKeys = (scala.collection.immutable.Set)gotKeys$1.$plus((Object)BoxesRunTime.boxToInteger((int)i));
        scala.collection.immutable.Set newIds = (scala.collection.immutable.Set)ids$1.union((Set)idsForKey);
        if (newGotKeys.size() == DDataRememberEntitiesShardStore$.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$$numberOfKeys) {
            Option option = shardWaiting$1;
            if (option instanceof Some) {
                ActorRef shard = (ActorRef)((Some)option).value();
                this.log().debug("Shard waiting for remembered entities, sending remembered and going idle");
                shard.$bang((Object)RememberEntitiesShardStore$RememberedEntities$.MODULE$.apply((scala.collection.immutable.Set<String>)newIds), this.self());
                this.context().become(this.idle());
                this.unstashAll();
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.log().debug("Got remembered entities, waiting for shard to request them");
                this.context().become(this.waitingForAllEntityIds((scala.collection.immutable.Set<Object>)newGotKeys, (scala.collection.immutable.Set<String>)newIds, (Option<ActorRef>)None$.MODULE$));
                return;
            }
            throw new MatchError((Object)option);
        }
        this.context().become(this.waitingForAllEntityIds((scala.collection.immutable.Set<Object>)newGotKeys, (scala.collection.immutable.Set<String>)newIds, (Option<ActorRef>)shardWaiting$1));
    }

    public final PartialFunction org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$next$1(ActorRef requestor$2, RememberEntitiesShardStore.Update update$2, Map updatesLeft) {
        return new Serializable(requestor$2, update$2, updatesLeft, this){
            private final ActorRef requestor$1;
            private final RememberEntitiesShardStore.Update update$1;
            private final Map updatesLeft$1;
            private final /* synthetic */ DDataRememberEntitiesShardStore $outer;
            {
                this.requestor$1 = requestor$3;
                this.update$1 = update$3;
                this.updatesLeft$1 = updatesLeft$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Replicator.UpdateSuccess) {
                    Object object2;
                    Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                    Key key = updateSuccess._1();
                    Option option = updateSuccess._2();
                    if (option instanceof Some && (object2 = ((Some)option).value()) instanceof scala.collection.immutable.Set) {
                        scala.collection.immutable.Set evts = (scala.collection.immutable.Set)object2;
                        return true;
                    }
                }
                if (object instanceof Replicator.UpdateTimeout) {
                    Object object3;
                    Replicator.UpdateTimeout updateTimeout = Replicator.UpdateTimeout$.MODULE$.unapply((Replicator.UpdateTimeout)object);
                    Key key = updateTimeout._1();
                    Option option = updateTimeout._2();
                    if (option instanceof Some && (object3 = ((Some)option).value()) instanceof scala.collection.immutable.Set) {
                        scala.collection.immutable.Set evts = (scala.collection.immutable.Set)object3;
                        return true;
                    }
                }
                if (object instanceof Replicator.StoreFailure) {
                    Replicator.StoreFailure storeFailure = Replicator.StoreFailure$.MODULE$.unapply((Replicator.StoreFailure)object);
                    Key key = storeFailure._1();
                    Option option = storeFailure._2();
                    return true;
                }
                if (object instanceof Replicator.ModifyFailure) {
                    Replicator.ModifyFailure modifyFailure = Replicator.ModifyFailure$.MODULE$.unapply((Replicator.ModifyFailure)object);
                    Key key = modifyFailure._1();
                    String string = modifyFailure._2();
                    Throwable throwable = modifyFailure._3();
                    Option option = modifyFailure._4();
                    String error = string;
                    Throwable cause = throwable;
                    return true;
                }
                if (object instanceof Replicator.UpdateDataDeleted) {
                    Replicator.UpdateDataDeleted updateDataDeleted = Replicator.UpdateDataDeleted$.MODULE$.unapply((Replicator.UpdateDataDeleted)object);
                    Key key = updateDataDeleted._1();
                    Option option = updateDataDeleted._2();
                    return true;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Replicator.UpdateSuccess) {
                    Object object2;
                    Replicator.UpdateSuccess updateSuccess = Replicator.UpdateSuccess$.MODULE$.unapply((Replicator.UpdateSuccess)object);
                    Key key = updateSuccess._1();
                    Option option = updateSuccess._2();
                    if (option instanceof Some && (object2 = ((Some)option).value()) instanceof scala.collection.immutable.Set) {
                        scala.collection.immutable.Set evts = (scala.collection.immutable.Set)object2;
                        this.$outer.log().debug("The DDataShard state was successfully updated for [{}]", (Object)evts);
                        Map remainingAfterThis = (Map)this.updatesLeft$1.$minus((Object)evts);
                        if (remainingAfterThis.isEmpty()) {
                            this.requestor$1.$bang((Object)RememberEntitiesShardStore$UpdateDone$.MODULE$.apply(this.update$1.started(), this.update$1.stopped()), this.$outer.self());
                            this.$outer.context().become(this.$outer.idle());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.context().become(this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$next$1(this.requestor$1, this.update$1, remainingAfterThis));
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.UpdateTimeout) {
                    Object object3;
                    Replicator.UpdateTimeout updateTimeout = Replicator.UpdateTimeout$.MODULE$.unapply((Replicator.UpdateTimeout)object);
                    Key key = updateTimeout._1();
                    Option option = updateTimeout._2();
                    if (option instanceof Some && (object3 = ((Some)option).value()) instanceof scala.collection.immutable.Set) {
                        scala.collection.immutable.Set evts = (scala.collection.immutable.Set)object3;
                        Tuple2 tuple2 = (Tuple2)this.updatesLeft$1.apply((Object)evts);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Replicator.Update updateForEvts = (Replicator.Update)tuple2._1();
                        int retriesLeft = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)updateForEvts, (Object)BoxesRunTime.boxToInteger((int)retriesLeft));
                        Replicator.Update updateForEvts2 = (Replicator.Update)tuple22._1();
                        int retriesLeft2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        if (retriesLeft2 > 0) {
                            this.$outer.log().debug("Retrying update because of write timeout, tries left [{}]", (Object)BoxesRunTime.boxToInteger((int)retriesLeft2));
                            this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$replicator.$bang((Object)updateForEvts2, this.$outer.self());
                            this.$outer.context().become(this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$_$next$1(this.requestor$1, this.update$1, (Map)this.updatesLeft$1.updated((Object)evts, (Object)Tuple2$.MODULE$.apply((Object)updateForEvts2, (Object)BoxesRunTime.boxToInteger((int)(retriesLeft2 - 1))))));
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.log().error("Unable to update state, within 'updating-state-timeout'= [{}], gave up after [{}] retries", (Object)PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$writeMajority.timeout())), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$pekko$cluster$sharding$internal$DDataRememberEntitiesShardStore$$maxUpdateAttempts));
                        this.$outer.context().stop(this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Replicator.StoreFailure) {
                    Replicator.StoreFailure storeFailure = Replicator.StoreFailure$.MODULE$.unapply((Replicator.StoreFailure)object);
                    Key key = storeFailure._1();
                    Option option = storeFailure._2();
                    this.$outer.log().error("Unable to update state, due to store failure");
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Replicator.ModifyFailure) {
                    Replicator.ModifyFailure modifyFailure = Replicator.ModifyFailure$.MODULE$.unapply((Replicator.ModifyFailure)object);
                    Key key = modifyFailure._1();
                    String string = modifyFailure._2();
                    Throwable throwable = modifyFailure._3();
                    Option option = modifyFailure._4();
                    String error = string;
                    Throwable cause = throwable;
                    this.$outer.log().error(cause, "Unable to update state, due to modify failure: {}", (Object)error);
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Replicator.UpdateDataDeleted) {
                    Replicator.UpdateDataDeleted updateDataDeleted = Replicator.UpdateDataDeleted$.MODULE$.unapply((Replicator.UpdateDataDeleted)object);
                    Key key = updateDataDeleted._1();
                    Option option = updateDataDeleted._2();
                    this.$outer.log().error("Unable to update state, due to delete");
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof RememberEntitiesShardStore.Update) {
                    RememberEntitiesShardStore.Update update = (RememberEntitiesShardStore.Update)object;
                    this.$outer.log().warning("Got a new update before write of previous completed, dropping update: [{}]", (Object)update);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public static interface Evt {
        public String id();
    }

    public static class Started
    implements Evt,
    Product,
    Serializable {
        private final String id;

        public static Started apply(String string) {
            return DDataRememberEntitiesShardStore$Started$.MODULE$.apply(string);
        }

        public static Started fromProduct(Product product) {
            return DDataRememberEntitiesShardStore$Started$.MODULE$.fromProduct(product);
        }

        public static Started unapply(Started started) {
            return DDataRememberEntitiesShardStore$Started$.MODULE$.unapply(started);
        }

        public Started(String id) {
            this.id = id;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Started)) return false;
            Started started = (Started)object;
            String string = this.id();
            String string2 = started.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!started.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Started;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Started";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String id() {
            return this.id;
        }

        public Started copy(String id) {
            return new Started(id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String _1() {
            return this.id();
        }
    }

    public static class Stopped
    implements Evt,
    Product,
    Serializable {
        private final String id;

        public static Stopped apply(String string) {
            return DDataRememberEntitiesShardStore$Stopped$.MODULE$.apply(string);
        }

        public static Stopped fromProduct(Product product) {
            return DDataRememberEntitiesShardStore$Stopped$.MODULE$.fromProduct(product);
        }

        public static Stopped unapply(Stopped stopped) {
            return DDataRememberEntitiesShardStore$Stopped$.MODULE$.unapply(stopped);
        }

        public Stopped(String id) {
            this.id = id;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stopped)) return false;
            Stopped stopped = (Stopped)object;
            String string = this.id();
            String string2 = stopped.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!stopped.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Stopped;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Stopped";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "id";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String id() {
            return this.id;
        }

        public Stopped copy(String id) {
            return new Stopped(id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String _1() {
            return this.id();
        }
    }
}

