/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$IdlePassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter$;
import org.apache.pekko.cluster.sharding.internal.AdmissionOptimizer$;
import org.apache.pekko.cluster.sharding.internal.CompositeEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.DisabledEntityPassivationStrategy$;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.IdleEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.LeastFrequentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.LeastRecentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.MostRecentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.NoActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.NoAdmissionOptimizer$;
import org.apache.pekko.cluster.sharding.internal.SegmentedLeastRecentlyUsedEntityPassivationStrategy;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class EntityPassivationStrategy$
implements Serializable {
    public static final EntityPassivationStrategy$PassivateEntities$ PassivateEntities;
    public static final EntityPassivationStrategy$ MODULE$;

    private EntityPassivationStrategy$() {
    }

    static {
        MODULE$ = new EntityPassivationStrategy$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EntityPassivationStrategy$.class);
    }

    public EntityPassivationStrategy apply(ClusterShardingSettings settings) {
        ClusterShardingSettings.PassivationStrategy passivationStrategy = settings.passivationStrategy();
        if (passivationStrategy instanceof ClusterShardingSettings.IdlePassivationStrategy) {
            ClusterShardingSettings.IdlePassivationStrategy idlePassivationStrategy = ClusterShardingSettings$IdlePassivationStrategy$.MODULE$.unapply((ClusterShardingSettings.IdlePassivationStrategy)passivationStrategy);
            FiniteDuration finiteDuration = idlePassivationStrategy._1();
            FiniteDuration finiteDuration2 = idlePassivationStrategy._2();
            FiniteDuration timeout = finiteDuration;
            FiniteDuration interval = finiteDuration2;
            return new IdleEntityPassivationStrategy(new IdleCheck(timeout, interval));
        }
        if (passivationStrategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = ClusterShardingSettings$LeastRecentlyUsedPassivationStrategy$.MODULE$.unapply((ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)passivationStrategy);
            int n = leastRecentlyUsedPassivationStrategy._1();
            Seq<Object> seq = leastRecentlyUsedPassivationStrategy._2();
            Option<ClusterShardingSettings.IdlePassivationStrategy> option = leastRecentlyUsedPassivationStrategy._3();
            int limit = n;
            Seq<Object> segmented = seq;
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle2 = option;
            Option idleCheck = idle2.map((Function1 & Serializable)idle -> new IdleCheck(idle.timeout(), idle.interval()));
            if (segmented.isEmpty()) {
                return new LeastRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck);
            }
            return new SegmentedLeastRecentlyUsedEntityPassivationStrategy(limit, segmented, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.MostRecentlyUsedPassivationStrategy mostRecentlyUsedPassivationStrategy = ClusterShardingSettings$MostRecentlyUsedPassivationStrategy$.MODULE$.unapply((ClusterShardingSettings.MostRecentlyUsedPassivationStrategy)passivationStrategy);
            int n = mostRecentlyUsedPassivationStrategy._1();
            Option<ClusterShardingSettings.IdlePassivationStrategy> option = mostRecentlyUsedPassivationStrategy._2();
            int limit = n;
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle3 = option;
            Option idleCheck = idle3.map((Function1 & Serializable)idle -> new IdleCheck(idle.timeout(), idle.interval()));
            return new MostRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = ClusterShardingSettings$LeastFrequentlyUsedPassivationStrategy$.MODULE$.unapply((ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)passivationStrategy);
            int n = leastFrequentlyUsedPassivationStrategy._1();
            boolean bl = leastFrequentlyUsedPassivationStrategy._2();
            Option<ClusterShardingSettings.IdlePassivationStrategy> option = leastFrequentlyUsedPassivationStrategy._3();
            int limit = n;
            boolean dynamicAging = bl;
            Option<ClusterShardingSettings.IdlePassivationStrategy> idle4 = option;
            Option idleCheck = idle4.map((Function1 & Serializable)idle -> new IdleCheck(idle.timeout(), idle.interval()));
            return new LeastFrequentlyUsedEntityPassivationStrategy(limit, dynamicAging, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.CompositePassivationStrategy) {
            ClusterShardingSettings.CompositePassivationStrategy composite = (ClusterShardingSettings.CompositePassivationStrategy)passivationStrategy;
            ActiveEntities main = ActiveEntities$.MODULE$.apply(composite.mainStrategy(), composite.idle().isDefined());
            if (main == NoActiveEntities$.MODULE$) {
                return DisabledEntityPassivationStrategy$.MODULE$;
            }
            int initialLimit = composite.limit();
            ActiveEntities window = ActiveEntities$.MODULE$.apply(composite.windowStrategy(), composite.idle().isDefined());
            double initialWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : composite.initialWindowProportion();
            double minimumWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : composite.minimumWindowProportion();
            double maximumWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : composite.maximumWindowProportion();
            NoAdmissionOptimizer$ windowOptimizer = window == NoActiveEntities$.MODULE$ ? NoAdmissionOptimizer$.MODULE$ : AdmissionOptimizer$.MODULE$.apply(composite.limit(), composite.windowOptimizer());
            AdmissionFilter admissionFilter = AdmissionFilter$.MODULE$.apply(composite.limit(), composite.admissionFilter());
            Option idleCheck = composite.idle().map((Function1 & Serializable)idle -> new IdleCheck(idle.timeout(), idle.interval()));
            return new CompositeEntityPassivationStrategy(initialLimit, window, initialWindowProportion, minimumWindowProportion, maximumWindowProportion, windowOptimizer, admissionFilter, main, (Option<IdleCheck>)idleCheck);
        }
        return DisabledEntityPassivationStrategy$.MODULE$;
    }
}

