/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.util.FastFrequencySketch;
import org.apache.pekko.util.FastFrequencySketch$;

@InternalApi
public final class FastFrequencySketchAdmissionFilter
extends AdmissionFilter {
    private final int widthMultiplier;
    private final double resetMultiplier;
    private FastFrequencySketch<String> frequencySketch;

    public FastFrequencySketchAdmissionFilter(int initialCapacity, int widthMultiplier, double resetMultiplier) {
        this.widthMultiplier = widthMultiplier;
        this.resetMultiplier = resetMultiplier;
        this.frequencySketch = this.createSketch(initialCapacity);
    }

    private FastFrequencySketch<String> createSketch(int capacity) {
        return FastFrequencySketch$.MODULE$.apply(capacity, this.widthMultiplier, this.resetMultiplier);
    }

    @Override
    public void updateCapacity(int newCapacity) {
        this.frequencySketch = this.createSketch(newCapacity);
    }

    @Override
    public void update(String id) {
        this.frequencySketch.increment((Object)id);
    }

    @Override
    public boolean admit(String candidate, String selected) {
        return this.frequencySketch.frequency((Object)candidate) > this.frequencySketch.frequency((Object)selected);
    }
}

