/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.cluster.sharding.internal.FrequencySketchAdmissionFilter$;
import org.apache.pekko.util.FrequencySketch;
import org.apache.pekko.util.FrequencySketch$;

@InternalApi
public final class FrequencySketchAdmissionFilter
extends AdmissionFilter {
    private final int widthMultiplier;
    private final double resetMultiplier;
    private final int depth;
    private final int counterBits;
    private FrequencySketch<String> frequencySketch;

    public static AdmissionFilter apply(int n, int n2, double d, int n3, int n4) {
        return FrequencySketchAdmissionFilter$.MODULE$.apply(n, n2, d, n3, n4);
    }

    public FrequencySketchAdmissionFilter(int initialCapacity, int widthMultiplier, double resetMultiplier, int depth, int counterBits) {
        this.widthMultiplier = widthMultiplier;
        this.resetMultiplier = resetMultiplier;
        this.depth = depth;
        this.counterBits = counterBits;
        this.frequencySketch = this.createSketch(initialCapacity);
    }

    private FrequencySketch<String> createSketch(int capacity) {
        return FrequencySketch$.MODULE$.apply(capacity, this.widthMultiplier, this.resetMultiplier, this.depth, this.counterBits, (FrequencySketch.Hasher)FrequencySketch.Hasher$.MODULE$.StringHasher());
    }

    @Override
    public void updateCapacity(int newCapacity) {
        this.frequencySketch = this.createSketch(newCapacity);
    }

    @Override
    public void update(String id) {
        this.frequencySketch.increment((Object)id);
    }

    @Override
    public boolean admit(String candidate, String selected) {
        return this.frequencySketch.frequency((Object)candidate) > this.frequencySketch.frequency((Object)selected);
    }
}

