/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.AdmissionOptimizer;
import scala.math.package$;

@InternalApi
public final class HillClimbingAdmissionOptimizer
extends AdmissionOptimizer {
    private final double adjustMultiplier;
    private final double initialStep;
    private final double restartThreshold;
    private final double stepDecay;
    private double adjustSize;
    private int accesses;
    private int activeAccesses;
    private double previousActiveRate;
    private double nextStep;

    public HillClimbingAdmissionOptimizer(int initialLimit, double adjustMultiplier, double initialStep, double restartThreshold, double stepDecay) {
        this.adjustMultiplier = adjustMultiplier;
        this.initialStep = initialStep;
        this.restartThreshold = restartThreshold;
        this.stepDecay = stepDecay;
        this.adjustSize = adjustMultiplier * (double)initialLimit;
        this.accesses = 0;
        this.activeAccesses = 0;
        this.previousActiveRate = 0.0;
        this.nextStep = -initialStep;
    }

    @Override
    public void recordActive() {
        ++this.accesses;
        ++this.activeAccesses;
    }

    @Override
    public void recordPassive() {
        ++this.accesses;
    }

    @Override
    public void updateLimit(int newLimit) {
        this.adjustSize = this.adjustMultiplier * (double)newLimit;
    }

    @Override
    public double calculateAdjustment() {
        if ((double)this.accesses >= this.adjustSize) {
            double activeRate = (double)this.activeAccesses / (double)this.accesses;
            double delta = activeRate - this.previousActiveRate;
            double adjustment = delta >= 0.0 ? this.nextStep : -this.nextStep;
            int direction = adjustment >= 0.0 ? 1 : -1;
            boolean restart = package$.MODULE$.abs(delta) >= this.restartThreshold;
            this.nextStep = restart ? this.initialStep * (double)direction : adjustment * this.stepDecay;
            this.previousActiveRate = activeRate;
            this.accesses = 0;
            this.activeAccesses = 0;
            return adjustment;
        }
        return 0.0;
    }
}

