/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.util.RecencyList;
import org.apache.pekko.util.RecencyList$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class IdleEntityPassivationStrategy
extends EntityPassivationStrategy {
    private final IdleCheck idleCheck;
    private final RecencyList<String> recencyList;
    private final Option scheduledInterval;

    public IdleEntityPassivationStrategy(IdleCheck idleCheck) {
        this.idleCheck = idleCheck;
        this.recencyList = RecencyList$.MODULE$.empty();
        this.scheduledInterval = Some$.MODULE$.apply((Object)idleCheck.interval());
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.scheduledInterval;
    }

    @Override
    public Seq<String> limitUpdated(int newLimit) {
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    @Override
    public Seq<String> shardsUpdated(int activeShards) {
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    @Override
    public Seq<String> entityTouched(String id) {
        this.recencyList.update((Object)id);
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    @Override
    public void entityTerminated(String id) {
        this.recencyList.remove((Object)id);
    }

    @Override
    public Seq<String> intervalPassed() {
        return this.recencyList.removeLeastRecentOutside(this.idleCheck.timeout());
    }
}

