/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.util.FrequencyList;
import org.apache.pekko.util.FrequencyList$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class LeastFrequentlyUsedReplacementPolicy
extends ActiveEntities {
    private int limit;
    private final FrequencyList<String> frequencyList;

    public LeastFrequentlyUsedReplacementPolicy(int initialLimit, boolean dynamicAging, boolean idleEnabled) {
        this.limit = initialLimit;
        this.frequencyList = idleEnabled ? FrequencyList.withOverallRecency$.MODULE$.empty(dynamicAging) : FrequencyList$.MODULE$.empty(dynamicAging);
    }

    @Override
    public int size() {
        return this.frequencyList.size();
    }

    @Override
    public boolean isActive(String id) {
        return this.frequencyList.contains((Object)id);
    }

    @Override
    public Seq<String> updateLimit(int newLimit) {
        this.limit = newLimit;
        return this.removeExcess(this.removeExcess$default$1());
    }

    @Override
    public Seq<String> update(String id) {
        int adjustment = this.frequencyList.contains((Object)id) ? 0 : 1;
        Seq<String> passivated = this.removeExcess(adjustment);
        this.frequencyList.update((Object)id);
        return passivated;
    }

    @Override
    public String select() {
        return (String)this.frequencyList.leastFrequent();
    }

    @Override
    public void remove(String id) {
        this.frequencyList.remove((Object)id);
    }

    @Override
    public Seq<String> removeIdle(FiniteDuration timeout) {
        return this.frequencyList.removeOverallLeastRecentOutside(timeout);
    }

    private Seq<String> removeExcess(int adjustment) {
        int excess = this.frequencyList.size() - this.limit + adjustment;
        if (excess > 0) {
            return this.frequencyList.removeLeastFrequent(excess);
        }
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    private int removeExcess$default$1() {
        return 0;
    }
}

