/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.LeastRecentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.LimitBasedEntityPassivationStrategy;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

public final class LeastRecentlyUsedEntityPassivationStrategy
extends LimitBasedEntityPassivationStrategy {
    private final Option<IdleCheck> idleCheck;
    private final LeastRecentlyUsedReplacementPolicy active;

    public LeastRecentlyUsedEntityPassivationStrategy(int initialLimit, Option<IdleCheck> idleCheck) {
        this.idleCheck = idleCheck;
        super(initialLimit);
        this.active = new LeastRecentlyUsedReplacementPolicy(initialLimit);
    }

    public LeastRecentlyUsedReplacementPolicy active() {
        return this.active;
    }

    @Override
    public Seq<String> passivateEntitiesOnLimitUpdate() {
        return this.active().updateLimit(this.perShardLimit());
    }

    @Override
    public Seq<String> entityTouched(String id) {
        return this.active().update(id);
    }

    @Override
    public void entityTerminated(String id) {
        this.active().remove(id);
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.idleCheck.map((Function1 & Serializable)_$1 -> _$1.interval());
    }

    @Override
    public Seq<String> intervalPassed() {
        return (Seq)this.idleCheck.fold(LeastRecentlyUsedEntityPassivationStrategy::intervalPassed$$anonfun$1, (Function1 & Serializable)idle -> this.active().removeIdle(idle.timeout()));
    }

    private static final Seq intervalPassed$$anonfun$1() {
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }
}

