/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.util.RecencyList;
import org.apache.pekko.util.RecencyList$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class LeastRecentlyUsedReplacementPolicy
extends ActiveEntities {
    private int limit;
    private final RecencyList<String> recencyList;

    public LeastRecentlyUsedReplacementPolicy(int initialLimit) {
        this.limit = initialLimit;
        this.recencyList = RecencyList$.MODULE$.empty();
    }

    @Override
    public int size() {
        return this.recencyList.size();
    }

    @Override
    public boolean isActive(String id) {
        return this.recencyList.contains((Object)id);
    }

    @Override
    public Seq<String> updateLimit(int newLimit) {
        this.limit = newLimit;
        return this.removeExcess();
    }

    @Override
    public Seq<String> update(String id) {
        this.recencyList.update((Object)id);
        return this.removeExcess();
    }

    @Override
    public String select() {
        return (String)this.recencyList.leastRecent();
    }

    @Override
    public void remove(String id) {
        this.recencyList.remove((Object)id);
    }

    @Override
    public Seq<String> removeIdle(FiniteDuration timeout) {
        return this.recencyList.removeLeastRecentOutside(timeout);
    }

    private Seq<String> removeExcess() {
        int excess = this.recencyList.size() - this.limit;
        if (excess > 0) {
            return this.recencyList.removeLeastRecent(excess);
        }
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }
}

